/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javafx.scene.control.TextField;
import ui.CreateDirectory;
import ui.EstimatedConcentrationDialog;
import ui.EstimatedConcentrationDialogData;
import ui.Repository;
import ui.WrappedRadioButton;
import util.FileLogger;
import util.NameConstants;
import util.Stripper;

public class WriteTemplateFile {
    private NameConstants nc = new NameConstants();
    private Repository repository;
    private TextField tfProjectName;
    private double dHydrocarbonAliphatic;
    private double dHydrocarbonAromatic;
    private String sSampleType = "";

    public void createTemplate(ArrayList<WrappedRadioButton> alWRBSelected, String sDirectoryName, String sProjectName) throws IOException {
        CreateDirectory cd = new CreateDirectory();
        cd.setRepository(this.repository);
        String sTemplateDirectory = String.valueOf(new File(".").getCanonicalPath()) + "\\projects\\" + sDirectoryName;
        cd.createDirectory(sTemplateDirectory);
        this.repository.setSpecifiedFile(true);
        this.repository.setSpecifiedDirectoryStem(sDirectoryName);
        this.repository.setSpecifiedDirectryFullPath(sTemplateDirectory);
        cd.checkFileForPrevious(sTemplateDirectory, sProjectName);
        sProjectName = this.repository.getSpecifiedFileStem();
        this.tfProjectName.setText(sProjectName);
        FileLogger fl = new FileLogger();
        fl.setFileExtension("pvi");
        fl.setShortFileName(String.valueOf(sTemplateDirectory) + "\\" + sProjectName);
        fl.useCalendarInName(false);
        fl.assembleOutputFile();
        fl.openOverWriteFile();
        fl.logMessageOverWrite("Control,Begin");
        fl.logMessageOverWrite("Control,Site, ");
        fl.logMessageOverWrite("Control,SiteLocation, ");
        fl.logMessageOverWrite("Control,City, ");
        fl.logMessageOverWrite("Control,State, ");
        fl.logMessageOverWrite("Control,Analyst, ");
        fl.logMessageOverWrite("Control,Affiliation, ");
        fl.logMessageOverWrite("Control,ExternalScreeningLevels," + this.setScreeningLevelType(alWRBSelected));
        fl.logMessageOverWrite("Control,TargetCancerRisk,1e-6");
        fl.logMessageOverWrite("Control,TargetHazardQuotient,1.0");
        fl.logMessageOverWrite("Control,GroundWaterConcentrationFactor," + this.setGroundWaterConcentrationFactor(alWRBSelected));
        fl.logMessageOverWrite("Control,Oil Distribution,none");
        fl.logMessageOverWrite("Control,End");
        fl.logMessageOverWrite("Building,Begin");
        fl.logMessageOverWrite("Building,dirt floor,no");
        fl.logMessageOverWrite("Building,Building Type," + this.getBuildingType(alWRBSelected));
        fl.logMessageOverWrite("Building,Width,Constant,0.0,ft,1");
        fl.logMessageOverWrite("Building,Length,Constant,0.0,ft,1");
        fl.logMessageOverWrite("Building,MixingZone/CeilingHeight,Constant,0.0,ft,1");
        fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,0.0,in,1");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,0.0,in,0");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,0.0,in,1");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
        this.writeAirExchangeInputs(fl, alWRBSelected);
        fl.logMessageOverWrite("Building,End");
        fl.logMessageOverWrite("VadoseZone,Begin");
        fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,0.0,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,0.0,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,0.0,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,0.0,ft,1");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.0,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.0,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.0,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.0,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.0,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.0,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
        fl.logMessageOverWrite("VadoseZone,End");
        fl.logMessageOverWrite("Aquifer,Begin");
        fl.logMessageOverWrite("Aquifer,End");
        fl.logMessageOverWrite("OilLens,Begin");
        fl.logMessageOverWrite("OilLens,End");
        fl.logMessageOverWrite("Chemical,Begin");
        this.writeChemicalInputs(fl, alWRBSelected);
        fl.logMessageOverWrite("Chemical,End");
        this.writeScreeningLevelInputs(fl, alWRBSelected);
        fl.closeOverWriteFile();
    }

    private String getBuildingType(ArrayList<WrappedRadioButton> alWRBSelected) {
        Stripper s = new Stripper();
        String sBuildingType = "Commercial";
        for (WrappedRadioButton wrb : alWRBSelected) {
            if (!s.areTheyEqual(wrb.getGroupName(), this.nc.s_RadioGNBuilding)) continue;
            String string = wrb.getName();
            this.nc.getClass();
            if (!s.areTheyEqual(string, "Residential")) continue;
            sBuildingType = "Residential";
        }
        return sBuildingType;
    }

    private void writeAirExchangeInputs(FileLogger fl, ArrayList<WrappedRadioButton> alWRBSelected) {
        String sAERLow = "";
        String sAERHigh = "";
        Stripper s = new Stripper();
        boolean bResidential = false;
        for (WrappedRadioButton wrb : alWRBSelected) {
            if (!s.areTheyEqual(wrb.getGroupName(), this.nc.s_RadioGNBuilding)) continue;
            String string = wrb.getName();
            this.nc.getClass();
            if (!s.areTheyEqual(string, "Residential")) continue;
            bResidential = true;
        }
        for (WrappedRadioButton wrb : alWRBSelected) {
            if (!s.areTheyEqual(wrb.getGroupName(), this.nc.s_RadioGNAirExchange)) continue;
            if (bResidential) {
                if (s.areTheyEqual(wrb.getName(), this.nc.s_RadioAERFull)) {
                    sAERLow = "0.1";
                    sAERHigh = "1.5";
                    continue;
                }
                if (s.areTheyEqual(wrb.getName(), this.nc.s_RadioAERDrafty)) {
                    sAERLow = "0.8";
                    sAERHigh = "1.5";
                    continue;
                }
                if (!s.areTheyEqual(wrb.getName(), this.nc.s_RadioAERTight)) continue;
                sAERLow = "0.1";
                sAERHigh = "0.8";
                continue;
            }
            if (s.areTheyEqual(wrb.getName(), this.nc.s_RadioAERFull)) {
                sAERLow = "3.0";
                sAERHigh = "10.0";
                continue;
            }
            if (s.areTheyEqual(wrb.getName(), this.nc.s_RadioAERDrafty)) {
                sAERLow = "6.5";
                sAERHigh = "10.0";
                continue;
            }
            if (!s.areTheyEqual(wrb.getName(), this.nc.s_RadioAERTight)) continue;
            sAERLow = "3.0";
            sAERHigh = "6.5";
        }
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable," + sAERLow + ",1/hr,0");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable," + sAERHigh + ",1/hr,1");
    }

    private void writeChemicalInputs(FileLogger fl, ArrayList<WrappedRadioButton> alWRBSelected) throws IOException {
        Stripper s = new Stripper();
        for (WrappedRadioButton wrb : alWRBSelected) {
            if (!s.areTheyEqual(wrb.getGroupName(), this.nc.s_RadioGNConc)) continue;
            this.repository.setInputEstimationType(wrb.getName());
            if (s.areTheyEqual(wrb.getName(), this.nc.s_RadioEnterTPH)) {
                fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,benzene,0.0,mg/l,1");
                fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,toluene,0.0,mg/l,1");
                fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,ethylbenzene,0.0,mg/l,1");
                fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,xylenes,0.0,mg/l,1");
                fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,naphthalene,0.0,mg/l,1");
                fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,MTBE,0.0,mg/l,1");
                fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,TPH-GRO,0.0,mg/l,1");
                fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,TPH-DRO,0.0,mg/l,1");
                continue;
            }
            if (!s.areTheyEqual(wrb.getName(), this.nc.s_RadioEstimatedTPH)) continue;
            EstimatedConcentrationDialog ecd = new EstimatedConcentrationDialog();
            ecd.displayDialog();
            EstimatedConcentrationDialogData ecdd = ecd.getResult();
            String sSampleType = ecdd.getSampleType();
            String sUnit = ecdd.getUnit();
            ArrayList<String> alChemicalName = ecdd.getChemicalName();
            ArrayList<String> alStringValue = ecdd.getStringValue();
            int i = 0;
            while (i < alChemicalName.size()) {
                String sChemicalName = alChemicalName.get(i);
                String sValue = alStringValue.get(i);
                if (s.areTheyEqual(sValue, "")) {
                    sValue = "0.0";
                }
                fl.logMessageOverWrite("Chemical," + sSampleType + " Concentration," + "Constant," + sChemicalName + "," + sValue + "," + sUnit + "," + "1");
                ++i;
            }
            this.estimateTPH(ecdd);
            fl.logMessageOverWrite("Chemical," + sSampleType + " Concentration" + "," + "Constant" + "," + "Hydrocarbons Aliphatic" + "," + this.dHydrocarbonAliphatic + "," + sUnit + "," + "1");
            fl.logMessageOverWrite("Chemical," + sSampleType + " Concentration" + "," + "Constant" + "," + "Hydrocarbons Aromatic" + "," + this.dHydrocarbonAromatic + "," + sUnit + "," + "1");
        }
    }

    private void estimateTPH(EstimatedConcentrationDialogData ecdd) {
        double dXylene;
        double dEthylBenzene;
        double dToluene;
        double dBenzene;
        boolean bBenzene = false;
        boolean bToluene = false;
        boolean bEthylBenzene = false;
        boolean bXylene = false;
        boolean bFresh = false;
        double dCalculationValue = 0.0;
        double dAromaticConstant = 0.0;
        double dAliphaticConstant = 0.0;
        try {
            dBenzene = Double.parseDouble(ecdd.getChemicalValue("Benzene"));
        }
        catch (Exception e) {
            dBenzene = 0.0;
            e.printStackTrace();
        }
        try {
            dToluene = Double.parseDouble(ecdd.getChemicalValue("Toluene"));
        }
        catch (Exception e) {
            dToluene = 0.0;
            e.printStackTrace();
        }
        try {
            dEthylBenzene = Double.parseDouble(ecdd.getChemicalValue("EthylBenzene"));
        }
        catch (Exception e) {
            dEthylBenzene = 0.0;
            e.printStackTrace();
        }
        try {
            dXylene = Double.parseDouble(ecdd.getChemicalValue("Xylenes"));
        }
        catch (Exception e) {
            dXylene = 0.0;
            e.printStackTrace();
        }
        if (dBenzene > 0.0) {
            bBenzene = true;
        }
        if (dToluene > 0.0) {
            bToluene = true;
        }
        if (dEthylBenzene > 0.0) {
            bEthylBenzene = true;
        }
        if (dXylene > 0.0) {
            bXylene = true;
        }
        bFresh = ecdd.getIsItFreshNAPL();
        this.sSampleType = ecdd.getSampleType();
        if (bBenzene && !bToluene && !bEthylBenzene && !bXylene) {
            dCalculationValue = dBenzene;
            if (bFresh) {
                dAromaticConstant = 0.65;
                dAliphaticConstant = 430.0;
            } else {
                dAromaticConstant = 0.47;
                dAliphaticConstant = 57.0;
            }
        }
        if (bBenzene && bToluene && bEthylBenzene && bXylene) {
            dCalculationValue = dBenzene + dToluene + dEthylBenzene + dXylene;
            if (bFresh) {
                dAromaticConstant = 0.15;
                dAliphaticConstant = 99.0;
            } else {
                dAromaticConstant = 0.09;
                dAliphaticConstant = 11.0;
            }
        }
        this.dHydrocarbonAliphatic = dCalculationValue * dAliphaticConstant;
        this.dHydrocarbonAromatic = dCalculationValue * dAromaticConstant;
    }

    private void writeScreeningLevelInputs(FileLogger fl, ArrayList<WrappedRadioButton> alWRBSelected) {
        Stripper s = new Stripper();
        for (WrappedRadioButton wrb : alWRBSelected) {
            if (!s.areTheyEqual(wrb.getGroupName(), this.nc.s_RadioGNRisk)) continue;
            if (s.areTheyEqual(wrb.getName(), this.nc.s_RadioScreeningLevel)) {
                fl.logMessageOverWrite("ScreeningLevel,Begin");
                fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,benzene,0.0,ug/m3,1.0");
                fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,toluene,0.0,ug/m3,1.0");
                fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,ethylbenzene,0.0,ug/m3,1.0");
                fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,xylenes,0.0,ug/m3,1.0");
                fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,naphthalene,0.0,ug/m3,1.0");
                fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,MTBE,0.0,ug/m3,1.0");
                fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,TPH-GRO,0.0,ug/m3,1.0");
                fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,TPH-DRO,0.0,ug/m3,1.0");
                fl.logMessageOverWrite("ScreeningLevel,End");
                continue;
            }
            if (!s.areTheyEqual(wrb.getName(), this.nc.s_RadioEPARSL)) continue;
            fl.logMessageOverWrite("ScreeningLevel,Begin");
            fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,benzene," + this.getEPA_RSL("benzene") + ",ug/m3,1.0");
            fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,toluene," + this.getEPA_RSL("toluene") + ",ug/m3,1.0");
            fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,ethylbenzene," + this.getEPA_RSL("ethylbenezene") + ",ug/m3,1.0");
            fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,xylenes," + this.getEPA_RSL("xylenes") + ",ug/m3,1.0");
            fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,naphthalene," + this.getEPA_RSL("naphthalene") + ",ug/m3,1.0");
            fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,MTBE," + this.getEPA_RSL("MTBE") + ",ug/m3,1.0");
            fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,TPH-GRO," + this.getEPA_RSL("TPH-GRO") + ",ug/m3,1.0");
            fl.logMessageOverWrite("ScreeningLevel,IndoorAirConcentration,Constant,TPH-DRO," + this.getEPA_RSL("TPH-DRO") + ",ug/m3,1.0");
            fl.logMessageOverWrite("ScreeningLevel,End");
        }
    }

    private String getEPA_RSL(String sName) {
        return "0.5";
    }

    private String setScreeningLevelType(ArrayList<WrappedRadioButton> alWRBSelected) {
        Stripper s = new Stripper();
        boolean bCapillary = false;
        String sType = "No";
        for (WrappedRadioButton wrb : alWRBSelected) {
            if (!s.areTheyEqual(wrb.getGroupName(), this.nc.s_RadioGNRisk) || !s.areTheyEqual(wrb.getName(), this.nc.s_RadioScreeningLevel)) continue;
            sType = "Yes";
            break;
        }
        return sType;
    }

    private String setGroundWaterConcentrationFactor(ArrayList<WrappedRadioButton> alWRBSelected) {
        Stripper s = new Stripper();
        boolean bCapillary = false;
        String sFactor = "1.0";
        for (WrappedRadioButton wrb : alWRBSelected) {
            if (!s.areTheyEqual(wrb.getGroupName(), this.nc.s_RadioGNCapillary) || !s.areTheyEqual(wrb.getName(), this.nc.s_RadioCapillaryYes)) continue;
            bCapillary = true;
        }
        if (bCapillary) {
            for (WrappedRadioButton wrb : alWRBSelected) {
                if (!s.areTheyEqual(wrb.getGroupName(), this.nc.s_RadioGNSource) || !s.areTheyEqual(wrb.getName(), this.nc.s_RadioDissolved)) continue;
                sFactor = "0.1";
            }
        }
        return sFactor;
    }

    public void writeOilLensExample(String sTemplateDirectory) {
        FileLogger fl = new FileLogger();
        fl.setFileExtension("pvi");
        fl.setShortFileName(String.valueOf(sTemplateDirectory) + "\\" + "SampleOilLensInput");
        fl.useCalendarInName(false);
        fl.assembleOutputFile();
        fl.openOverWriteFile();
        fl.logMessageOverWrite("Control,Begin");
        fl.logMessageOverWrite("Control,Site,");
        fl.logMessageOverWrite("Control,SiteLocation,");
        fl.logMessageOverWrite("Control,City,");
        fl.logMessageOverWrite("Control,State,");
        fl.logMessageOverWrite("Control,Analyst,");
        fl.logMessageOverWrite("Control,Affiliation,");
        fl.logMessageOverWrite("Control,Risk Level,1.00E-06");
        fl.logMessageOverWrite("Control,HazardQuotient,1");
        fl.logMessageOverWrite("Control,Oil Distribution,capillary");
        fl.logMessageOverWrite("Control,End");
        fl.logMessageOverWrite("Building,Begin");
        fl.logMessageOverWrite("Building,dirt floor,no");
        fl.logMessageOverWrite("Building,Width,Constant,10,m,1");
        fl.logMessageOverWrite("Building,Length,Constant,10,m,1");
        fl.logMessageOverWrite("Building,MixingZone/CeilingHeight,Constant,9,ft,1");
        fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,2,m,1");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,10,cm,0");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,20,cm,1");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable,0.1,1/hr,0");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable,1.5,1/hr,1");
        fl.logMessageOverWrite("Building,End");
        fl.logMessageOverWrite("VadoseZone,Begin");
        fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,5.048,m,1");
        fl.logMessageOverWrite("Vadose Zone,Depth To Sample,Constant,5.048,m,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,5.048,m,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,6.048,m,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,10,m,1");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.049,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.2127,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.35,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.35,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,7.50E-04,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.00125,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
        fl.logMessageOverWrite("Vadose Zone,AirEntryHead,Constant,60,cm,1");
        fl.logMessageOverWrite("Vadose Zone,ResidualWaterSaturation,Variable,0.029,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,ResidualWaterSaturation,Variable,0.049,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,WaterSurfaceTension,Constant,72,dyne/cm,1");
        fl.logMessageOverWrite("Vadose Zone,Lambda,Variable,0.2,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,Lambda,Variable,0.2,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,TrappedAirSaturation,Variable,0.1,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,TrappedAirSaturation,Variable,0.2,dimensionless,1");
        fl.logMessageOverWrite("VadoseZone,End");
        fl.logMessageOverWrite("Aquifer,Begin");
        fl.logMessageOverWrite("Aquifer,HydraulicConductivity,Variable,100,ft/d,0");
        fl.logMessageOverWrite("Aquifer,HydraulicConductivity,Variable,100,ft/d,1");
        fl.logMessageOverWrite("Aquifer,Gradient,Variable,0.001,dimensionless,0");
        fl.logMessageOverWrite("Aquifer,Gradient,Variable,0.001,dimensionless,1");
        fl.logMessageOverWrite("Aquifer,End");
        fl.logMessageOverWrite("OilLens,Begin");
        fl.logMessageOverWrite("Oil Lens,FuelVolume,Variable,500,gal,0");
        fl.logMessageOverWrite("Oil Lens,FuelVolume,Variable,500,gal,1");
        fl.logMessageOverWrite("Oil Lens,LensLength,Variable,20,ft,0");
        fl.logMessageOverWrite("Oil Lens,LensLength,Variable,20,ft,1");
        fl.logMessageOverWrite("Oil Lens,LensWidth,Variable,30,ft,0");
        fl.logMessageOverWrite("Oil Lens,LensWidth,Variable,30,ft,1");
        fl.logMessageOverWrite("Oil Lens,MaxOilSaturation,Variable,0.15,dimensionless,0");
        fl.logMessageOverWrite("Oil Lens,MaxOilSaturation,Variable,0.15,dimensionless,1");
        fl.logMessageOverWrite("Oil Lens,ResidualOilSaturation,Variable,0.01,dimensionless,0");
        fl.logMessageOverWrite("Oil Lens,ResidualOilSaturation,Variable,0.05,dimensionless,1");
        fl.logMessageOverWrite("Oil Lens,OilWaterInterfacialTension,Variable,25,dyne/cm,0");
        fl.logMessageOverWrite("Oil Lens,OilWaterInterfacialTension,Variable,35,dyne/cm,1");
        fl.logMessageOverWrite("Oil Lens,OilDensity,Variable,0.72,g/mL,0");
        fl.logMessageOverWrite("Oil Lens,OilDensity,Variable,0.78,g/mL,1");
        fl.logMessageOverWrite("Oil Lens,OilMolecularWeight,Variable,105,g/mole,0");
        fl.logMessageOverWrite("Oil Lens,OilMolecularWeight,Variable,105,g/mole,1");
        fl.logMessageOverWrite("OilLens,End");
        fl.logMessageOverWrite("Chemical,Begin");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,benzene,6.02E-06,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,toluene,0.01243,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,ethylbenzene,0.009463,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,xylenes,0.04454,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C8ToC9Aromatic,0.003047,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C9ToC10Aromatic,0.06796,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C10toC11Aromatic,0.003607,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C5ToC6Aliphatic,0.2478,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C6ToC7Aliphatic,0.1571,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C7ToC8Aliphatic,0.0933,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C8ToC9Aliphatic,0.07359,cm3/cm3,1");
        fl.logMessageOverWrite("Chemical,End");
        fl.closeOverWriteFile();
    }

    public void writeSoilGasExample(String sTemplateDirectory) {
        FileLogger fl = new FileLogger();
        fl.setFileExtension("pvi");
        fl.setShortFileName(String.valueOf(sTemplateDirectory) + "\\" + "SampleSoilGasInput-Commercial");
        fl.useCalendarInName(false);
        fl.assembleOutputFile();
        fl.openOverWriteFile();
        fl.logMessageOverWrite("Control,Begin");
        fl.logMessageOverWrite("Control,Site, ");
        fl.logMessageOverWrite("Control,SiteLocation, ");
        fl.logMessageOverWrite("Control,City, ");
        fl.logMessageOverWrite("Control,State, ");
        fl.logMessageOverWrite("Control,Analyst, ");
        fl.logMessageOverWrite("Control,Affiliation, ");
        fl.logMessageOverWrite("Control,GroundWaterConcentrationFactor,0.1");
        fl.logMessageOverWrite("Control,Oil Distribution,none");
        fl.logMessageOverWrite("Control,End");
        fl.logMessageOverWrite("Building,Begin");
        fl.logMessageOverWrite("Building,dirt floor,no");
        fl.logMessageOverWrite("Building,Width,Constant,60,ft,1");
        fl.logMessageOverWrite("Building,Length,Constant,80,ft,1");
        fl.logMessageOverWrite("Building,MixingZone/CeilingHeight,Constant,9,ft,1");
        fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,6,in,1");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,10,cm,0");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,20,cm,1");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable,3,1/hr,0");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable,10,1/hr,1");
        fl.logMessageOverWrite("Building,End");
        fl.logMessageOverWrite("VadoseZone,Begin");
        fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,3,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,7.5,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,7.5,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,20,ft,1");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.049,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.2127,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.29,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.484,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,7.50E-04,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.00125,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
        fl.logMessageOverWrite("VadoseZone,End");
        fl.logMessageOverWrite("Aquifer,Begin");
        fl.logMessageOverWrite("Aquifer,End");
        fl.logMessageOverWrite("OilLens,Begin");
        fl.logMessageOverWrite("OilLens,End");
        fl.logMessageOverWrite("Chemical,Begin");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,benzene,1.6,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,toluene,10,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,ethylbenzene,2.2,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,xylenes,41,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,naphthalene,2.85,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,MTBE,1.8,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,TPH-GRO,210,ug/m3,1");
        fl.logMessageOverWrite("Chemical,End");
        fl.logMessageOverWrite("Risk,Begin");
        fl.logMessageOverWrite("Risk,End");
        fl.logMessageOverWrite("ScreeningLevel,Begin");
        fl.logMessageOverWrite("ScreeningLevel,benzene,Constant,0.5,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,toluene,Constant,7310,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,ethylbenzene,Constant,1480,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,xylenes,Constant,148,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,naphthalene,Constant,4.39,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,MTBE,Constant,4380,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,TPH-GRO,Constant,307,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,End");
        fl.closeOverWriteFile();
    }

    public void writeSoilGasExampleResidential(String sTemplateDirectory) {
        FileLogger fl = new FileLogger();
        fl.setFileExtension("pvi");
        fl.setShortFileName(String.valueOf(sTemplateDirectory) + "\\" + "SampleSoilGasInput-Residential");
        fl.useCalendarInName(false);
        fl.assembleOutputFile();
        fl.openOverWriteFile();
        fl.logMessageOverWrite("Control,Begin");
        fl.logMessageOverWrite("Control,Site, ");
        fl.logMessageOverWrite("Control,SiteLocation, ");
        fl.logMessageOverWrite("Control,City, ");
        fl.logMessageOverWrite("Control,State, ");
        fl.logMessageOverWrite("Control,Analyst, ");
        fl.logMessageOverWrite("Control,Affiliation, ");
        fl.logMessageOverWrite("Control,GroundWaterConcentrationFactor,0.1");
        fl.logMessageOverWrite("Control,Oil Distribution,none");
        fl.logMessageOverWrite("Control,End");
        fl.logMessageOverWrite("Building,Begin");
        fl.logMessageOverWrite("Building,dirt floor,no");
        fl.logMessageOverWrite("Building,Width,Constant,60,ft,1");
        fl.logMessageOverWrite("Building,Length,Constant,80,ft,1");
        fl.logMessageOverWrite("Building,MixingZone/CeilingHeight,Constant,9,ft,1");
        fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,6,in,1");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,10,cm,0");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,20,cm,1");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable,0.5,1/hr,0");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable,1.5,1/hr,1");
        fl.logMessageOverWrite("Building,End");
        fl.logMessageOverWrite("VadoseZone,Begin");
        fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,3,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,7.5,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,7.5,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,20,ft,1");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.049,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.2127,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.29,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.484,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,7.50E-04,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.00125,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
        fl.logMessageOverWrite("VadoseZone,End");
        fl.logMessageOverWrite("Aquifer,Begin");
        fl.logMessageOverWrite("Aquifer,End");
        fl.logMessageOverWrite("OilLens,Begin");
        fl.logMessageOverWrite("OilLens,End");
        fl.logMessageOverWrite("Chemical,Begin");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,benzene,1.6,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,toluene,10,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,ethylbenzene,2.2,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,xylenes,41,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,naphthalene,2.85,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,MTBE,1.8,ug/m3,1");
        fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,TPH-GRO,210,ug/m3,1");
        fl.logMessageOverWrite("Chemical,End");
        fl.logMessageOverWrite("Risk,Begin");
        fl.logMessageOverWrite("Risk,End");
        fl.logMessageOverWrite("ScreeningLevel,Begin");
        fl.logMessageOverWrite("ScreeningLevel,benzene,Constant,0.5,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,toluene,Constant,7310,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,ethylbenzene,Constant,1480,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,xylenes,Constant,148,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,naphthalene,Constant,4.39,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,MTBE,Constant,4380,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,TPH-GRO,Constant,307,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,End");
        fl.closeOverWriteFile();
    }

    public void writeGroundWaterExample(String sTemplateDirectory) {
        FileLogger fl = new FileLogger();
        fl.setFileExtension("pvi");
        fl.setShortFileName(String.valueOf(sTemplateDirectory) + "\\" + "SampleGroundWaterInput-Commercial");
        fl.useCalendarInName(false);
        fl.assembleOutputFile();
        fl.openOverWriteFile();
        fl.logMessageOverWrite("Control,Begin");
        fl.logMessageOverWrite("Control,Site, ");
        fl.logMessageOverWrite("Control,SiteLocation, ");
        fl.logMessageOverWrite("Control,City, ");
        fl.logMessageOverWrite("Control,State, ");
        fl.logMessageOverWrite("Control,Analyst, ");
        fl.logMessageOverWrite("Control,Affiliation, ");
        fl.logMessageOverWrite("Control,GroundWaterConcentrationFactor,0.1");
        fl.logMessageOverWrite("Control,Oil Distribution,none");
        fl.logMessageOverWrite("Control,End");
        fl.logMessageOverWrite("Building,Begin");
        fl.logMessageOverWrite("Building,dirt floor,no");
        fl.logMessageOverWrite("Building,Width,Constant,60,ft,1");
        fl.logMessageOverWrite("Building,Length,Constant,80,ft,1");
        fl.logMessageOverWrite("Building,MixingZone/CeilingHeight,Constant,9,ft,1");
        fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,6,in,1");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,6,in,0");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,6,cm,1");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable,3,1/hr,0");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable,10,1/hr,1");
        fl.logMessageOverWrite("Building,End");
        fl.logMessageOverWrite("VadoseZone,Begin");
        fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,6.9,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,6.9,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,6.9,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,20,ft,1");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.049,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.2127,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.29,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.484,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,7.50E-04,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.00125,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
        fl.logMessageOverWrite("VadoseZone,End");
        fl.logMessageOverWrite("Aquifer,Begin");
        fl.logMessageOverWrite("Aquifer,End");
        fl.logMessageOverWrite("OilLens,Begin");
        fl.logMessageOverWrite("OilLens,End");
        fl.logMessageOverWrite("Chemical,Begin");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,benzene,0.033,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,toluene,0.001,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,ethylbenzene,0.001,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,xylenes,0.001,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,naphthalene,0.001,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,MTBE,0.001,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,TPH-GRO,0.14,mg/l,1");
        fl.logMessageOverWrite("Chemical,End");
        fl.logMessageOverWrite("Risk,Begin");
        fl.logMessageOverWrite("Risk,End");
        fl.logMessageOverWrite("ScreeningLevel,Begin");
        fl.logMessageOverWrite("ScreeningLevel,benzene,Constant,0.5,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,toluene,Constant,7310,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,ethylbenzene,Constant,1480,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,xylenes,Constant,148,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,naphthalene,Constant,4.39,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,MTBE,Constant,4380,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,TPH-GRO,Constant,307,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,End");
        fl.closeOverWriteFile();
    }

    public void writeGroundWaterExampleResidential(String sTemplateDirectory) {
        FileLogger fl = new FileLogger();
        fl.setFileExtension("pvi");
        fl.setShortFileName(String.valueOf(sTemplateDirectory) + "\\" + "SampleGroundWaterInput-Residential");
        fl.useCalendarInName(false);
        fl.assembleOutputFile();
        fl.openOverWriteFile();
        fl.logMessageOverWrite("Control,Begin");
        fl.logMessageOverWrite("Control,Site, ");
        fl.logMessageOverWrite("Control,SiteLocation, ");
        fl.logMessageOverWrite("Control,City, ");
        fl.logMessageOverWrite("Control,State, ");
        fl.logMessageOverWrite("Control,Analyst, ");
        fl.logMessageOverWrite("Control,Affiliation, ");
        fl.logMessageOverWrite("Control,GroundWaterConcentrationFactor,0.1");
        fl.logMessageOverWrite("Control,Oil Distribution,none");
        fl.logMessageOverWrite("Control,End");
        fl.logMessageOverWrite("Building,Begin");
        fl.logMessageOverWrite("Building,dirt floor,no");
        fl.logMessageOverWrite("Building,Width,Constant,60,ft,1");
        fl.logMessageOverWrite("Building,Length,Constant,80,ft,1");
        fl.logMessageOverWrite("Building,MixingZone/CeilingHeight,Constant,9,ft,1");
        fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,6,in,1");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,6,in,0");
        fl.logMessageOverWrite("Building,FoundationThickness,Variable,6,in,1");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
        fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable,0.5,1/hr,0");
        fl.logMessageOverWrite("Building,AirExchangeRate,Variable,1.5,1/hr,1");
        fl.logMessageOverWrite("Building,End");
        fl.logMessageOverWrite("VadoseZone,Begin");
        fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,6.9,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,6.9,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,6.9,ft,1");
        fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,20,ft,1");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.049,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.2127,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.29,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.484,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,7.50E-04,dimensionless,0");
        fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.00125,dimensionless,1");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
        fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
        fl.logMessageOverWrite("VadoseZone,End");
        fl.logMessageOverWrite("Aquifer,Begin");
        fl.logMessageOverWrite("Aquifer,End");
        fl.logMessageOverWrite("OilLens,Begin");
        fl.logMessageOverWrite("OilLens,End");
        fl.logMessageOverWrite("Chemical,Begin");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,benzene,0.033,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,toluene,0.001,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,ethylbenzene,0.001,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,xylenes,0.001,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,naphthalene,0.001,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,MTBE,0.001,mg/l,1");
        fl.logMessageOverWrite("Chemical,Ground Water Concentration,Constant,TPH-GRO,0.14,mg/l,1");
        fl.logMessageOverWrite("Chemical,End");
        fl.logMessageOverWrite("Risk,Begin");
        fl.logMessageOverWrite("Risk,End");
        fl.logMessageOverWrite("ScreeningLevel,Begin");
        fl.logMessageOverWrite("ScreeningLevel,benzene,Constant,0.5,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,toluene,Constant,7310,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,ethylbenzene,Constant,1480,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,xylenes,Constant,148,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,naphthalene,Constant,4.39,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,MTBE,Constant,4380,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,TPH-GRO,Constant,307,ug/m3");
        fl.logMessageOverWrite("ScreeningLevel,End");
        fl.closeOverWriteFile();
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setTextFieldProjectName(TextField tfProjectName) {
        this.tfProjectName = tfProjectName;
    }
}

