/*
 * Decompiled with CFR 0.152.
 */
package ui.controlMakers;

import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.VIControlData;
import ui.Repository;
import ui.controlMakers.InputControl;
import ui.handler.HandlerChemicalAdder;
import ui.handler.HandlerEdit;
import ui.handler.HandlerEditControl;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class InputControlChemicalManager
extends InputControl {
    private String sTabName;
    private String sDataGroup;
    private String sVariableName;
    private String sVariableName2;
    private String sUnitType;
    private int iIndex;
    private String sQualifier;
    private double dValue;
    private String sValueString;
    private String sUnitSelected;
    private String sDistributionType;
    private double dFrequency;
    private String sComment;
    private int iHeight;
    private String sInputType;
    private String sChangeToCome;
    private RawInputLine ril;
    private HBox hbox;
    private ArrayList<String> alUnitNames;
    private OutputDigits od;
    private HandlerChemicalAdder hca;
    private HandlerEditControl hec;
    private HandlerEditControl hec2;
    private HandlerEdit he;
    private Tab tab;
    private TabPane tp;
    private boolean bValueString;
    private Repository repository;
    private VIControlData viCD;
    private UnitConverter uc;
    private NameConstants nc;
    private TextField tfValue;
    private TextField tfFrequency;
    private TextField tfComment;
    private ObservableList<String> options;
    private ArrayList<Chemical> alChemicals;
    private ArrayList<String> alChemicalNames;
    private ObservableList<Node> olNodes;
    private final ComboBox comboBox = new ComboBox();

    public InputControlChemicalManager() {
        this.nc = new NameConstants();
    }

    private void blankEmAll() {
        this.sDataGroup = "";
        this.sVariableName = "";
        this.sVariableName2 = "";
        this.dValue = 0.0;
        this.iIndex = 0;
        this.iHeight = 20;
        this.sInputType = "";
        this.sUnitType = "";
        this.sChangeToCome = "keep";
    }

    public void makeInputControlForAll() {
        boolean bValueString = false;
        boolean bParameterNameVisible2 = false;
        Stripper s = new Stripper();
        this.viCD = this.repository.getVIControlData();
        this.iHeight = 20;
        this.bEditable = this.repository.getInputEditable();
        this.hbox = new HBox();
        this.hbox.getStyleClass().add((Object)"hbox");
        this.olNodes = FXCollections.observableArrayList();
        String sRawInputType = this.nc.s_CONTROLCHEMICALMANAGEMENT;
        this.sDataGroup = "Chemical";
        this.sVariableName = "Add or Remove Chemical";
        this.sVariableName2 = "ChemicalChoiceManagement";
        Label lTabName = new Label(this.sTabName);
        lTabName.setVisible(false);
        lTabName.setPrefSize(0.0, 0.0);
        Label lDataGroup = new Label(this.sDataGroup);
        lDataGroup.setVisible(false);
        lDataGroup.setPrefSize(0.0, 0.0);
        Label lCount = new Label();
        lCount.setText("" + this.iIndex);
        lCount.setVisible(false);
        lCount.setPrefSize(0.0, (double)this.iHeight);
        Label lInputType = new Label();
        lInputType.setText(sRawInputType);
        lInputType.setVisible(false);
        lInputType.setPrefSize(0.0, (double)this.iHeight);
        this.olNodes.add((Object)lInputType);
        this.olNodes.add((Object)lCount);
        Label lDescription = new Label(this.sVariableName);
        lDescription.setPrefSize(200.0, (double)this.iHeight);
        lDescription.setVisible(true);
        this.olNodes.add((Object)lDescription);
        this.alChemicals = this.viCD.getChemicals();
        this.alChemicalNames = new ArrayList();
        this.alChemicalNames.add("");
        for (Chemical chemical : this.alChemicals) {
            this.alChemicalNames.add(chemical.getName());
        }
        int iUnitIndex = 0;
        this.options = FXCollections.observableArrayList(this.alChemicalNames);
        ComboBox cbChemicals = new ComboBox(this.options);
        cbChemicals.setValue((Object)this.alChemicalNames.get(iUnitIndex));
        cbChemicals.setPrefSize(75.0, (double)this.iHeight);
        cbChemicals.setVisible(true);
        cbChemicals.setDisable(!this.bEditable);
        this.olNodes.add((Object)cbChemicals);
        Button bAddRemove = new Button("Add/Remove");
        bAddRemove.setVisible(true);
        bAddRemove.setDisable(!this.bEditable);
        this.hca = new HandlerChemicalAdder();
        this.hca.setRepository(this.repository);
        this.hca.setTabPane(this.tp);
        this.hca.setTab(this.tab);
        this.hca.setChemicalChoices((ComboBox<String>)cbChemicals);
        bAddRemove.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hca);
        this.olNodes.add((Object)bAddRemove);
        this.olNodes.add((Object)lTabName);
        this.olNodes.add((Object)lDataGroup);
        this.hbox.getChildren().addAll(this.olNodes);
        this.repository.addPriorControl(this.sDataGroup, this.sVariableName, this.sVariableName2);
    }

    private void addStackPane(HBox hb) {
        hb.getChildren().add((Object)this.addStackPane("?"));
    }

    public StackPane addStackPane(String sText) {
        StackPane stack = new StackPane();
        Rectangle helpIcon = new Rectangle(20.0, 20.0);
        helpIcon.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.web((String)"#4977A3")), new Stop(0.5, Color.web((String)"#B0C6DA")), new Stop(1.0, Color.web((String)"#9CB6CF"))}));
        helpIcon.setStroke((Paint)Color.web((String)"#D0E6FA"));
        helpIcon.setArcHeight(1.5);
        helpIcon.setArcWidth(3.5);
        Text helpText = new Text(sText);
        helpText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)16.0));
        helpText.setFill((Paint)Color.WHITE);
        helpText.setStroke((Paint)Color.web((String)"#7080A0"));
        stack.getChildren().addAll((Object[])new Node[]{helpIcon, helpText});
        stack.setAlignment(Pos.CENTER_RIGHT);
        StackPane.setMargin((Node)helpText, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        return stack;
    }

    public void setTabName(String sTabName) {
        this.sTabName = sTabName;
    }

    public void setName(String sName) {
        this.sDataGroup = sName;
    }

    public void setLabel(String sVariableName) {
        this.sVariableName = sVariableName;
    }

    public void setDistributionType(String s) {
        this.sDistributionType = s;
    }

    public void setQualifier(String sQualifier) {
        this.sQualifier = sQualifier;
    }

    public void setInputType(String sInputType) {
        this.sInputType = sInputType;
    }

    public void setUseStringValue(boolean b) {
        this.bValueString = b;
    }

    public void setValue(double dValue) {
        this.dValue = dValue;
    }

    public void setValueString(String sValueString) {
        this.sValueString = sValueString;
    }

    public void setUnitSelected(String sUnitSelected) {
        this.sUnitSelected = sUnitSelected;
    }

    public void setUnitType(String sUnitType) {
        this.sUnitType = sUnitType;
    }

    public void setFrequency(double dFrequency) {
        this.dFrequency = dFrequency;
    }

    public void setComment(String sComment) {
        this.sComment = sComment;
    }

    public void setUnitChoices(ArrayList<String> alUnitNames) {
        this.alUnitNames = alUnitNames;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setIndex(int iIndex) {
        this.iIndex = iIndex;
    }

    public void setHeight(int iHeight) {
        this.iHeight = iHeight;
    }

    public void setHandlerEdit(HandlerEdit he) {
        this.he = he;
    }

    public void setTabPane(TabPane tp) {
        this.tp = tp;
    }

    public void setTab(Tab tab) {
        this.tab = tab;
    }

    public void setChangeToCome(String sChangeToCome) {
        this.sChangeToCome = sChangeToCome;
    }

    public void setRawInputLine(RawInputLine ril) {
        this.ril = ril;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public String getTabName() {
        return this.sTabName;
    }

    public String getName() {
        return this.sDataGroup;
    }

    public String getLabel() {
        return this.sVariableName;
    }

    public String getDistributionType() {
        return this.sDistributionType;
    }

    public String getQualifier() {
        return this.sQualifier;
    }

    public String getInputType() {
        return this.sInputType;
    }

    public HBox getInputControl() {
        return this.hbox;
    }

    public double getValue() {
        return this.dValue;
    }

    public String getUnitSelected() {
        return this.sUnitSelected;
    }

    public String getUnitType() {
        return this.sUnitType;
    }

    public double getFrequency() {
        return this.dFrequency;
    }

    public String getComment() {
        return this.sComment;
    }

    public int getIndex() {
        return this.iIndex;
    }

    public int getHeight() {
        return this.iHeight;
    }

    public HandlerEdit getHandlerEdit() {
        return this.he;
    }

    public Tab getTab() {
        return this.tab;
    }
}

