/*
 * Decompiled with CFR 0.152.
 */
package ui.controlMakers;

import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import pviScreen.dataContainers.ParameterChoices;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.VIControlData;
import ui.Repository;
import ui.controlMakers.InputControlValue;
import ui.handler.HandlerEdit;
import ui.handler.HandlerEditComboBox;
import ui.handler.HandlerEditControl;
import ui.handler.HandlerEditNumber;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class InputControlChoice
extends InputControlValue {
    private String sTabName;
    private String sDataGroup;
    private String sVariableName;
    private String sVariableName2;
    private String sUnitType;
    private int iIndex;
    private String sQualifier;
    private double dValue;
    private String sValueString;
    private String sUnitSelected;
    private String sDistributionType;
    private double dFrequency;
    private String sComment;
    private int iHeight;
    private String sInputType;
    private String sChangeToCome;
    private RawInputLine ril;
    private HBox hbox;
    private ArrayList<String> alUnitNames;
    private OutputDigits od;
    private HandlerEditNumber hen;
    private HandlerEditComboBox hecb;
    private HandlerEdit he;
    private Tab tab;
    private TabPane tp;
    private boolean bValueString;
    private Repository repository;
    private VIControlData viCD;
    private UnitConverter uc;
    private ParameterChoices pc;
    private NameConstants nc;
    private TextField tfValue;
    private TextField tfFrequency;
    private TextField tfComment;
    private ObservableList<String> options;
    private ObservableList<Node> olNodes;
    private final ComboBox comboBox = new ComboBox();

    public InputControlChoice() {
        this.blankEmAll();
        this.nc = new NameConstants();
    }

    private void blankEmAll() {
        this.sDataGroup = "";
        this.sVariableName = "";
        this.sVariableName2 = "";
        this.dValue = 0.0;
        this.iIndex = 0;
        this.iHeight = 20;
        this.sInputType = "";
        this.sUnitType = "";
        this.sChangeToCome = "keep";
    }

    @Override
    public void makeInputControlForAll() {
        boolean bValueString = false;
        boolean bParameterNameVisible2 = false;
        Stripper s = new Stripper();
        this.viCD = this.repository.getVIControlData();
        this.pc = this.viCD.getParameterChoices();
        this.hbox = new HBox();
        this.hbox.getStyleClass().add((Object)"hbox");
        this.olNodes = FXCollections.observableArrayList();
        String sRawInputType = this.ril.getRawInputType();
        this.sVariableName = this.ril.getParameterName();
        bValueString = false;
        bParameterNameVisible2 = false;
        this.sUnitType = "none";
        if (s.areTheyEqual(this.nc.s_CONTROLSTRINGCHOICE, sRawInputType)) {
            this.sUnitType = "other";
        }
        Label lTabName = new Label(this.sTabName);
        lTabName.setVisible(false);
        lTabName.setPrefSize(0.0, 0.0);
        Label lDataGroup = new Label(this.sDataGroup);
        lDataGroup.setVisible(false);
        lDataGroup.setPrefSize(0.0, 0.0);
        Label lCount = new Label();
        lCount.setText("" + this.iIndex);
        lCount.setVisible(false);
        lCount.setPrefSize(0.0, (double)this.iHeight);
        Label lInputType = new Label();
        lInputType.setText(sRawInputType);
        lInputType.setVisible(false);
        lInputType.setPrefSize(0.0, (double)this.iHeight);
        this.olNodes.add((Object)lInputType);
        this.olNodes.add((Object)lCount);
        this.sVariableName = this.ril.getParameterName();
        Label lDescription = new Label(this.sVariableName);
        lDescription.setPrefSize(200.0, (double)this.iHeight);
        lDescription.setVisible(true);
        this.olNodes.add((Object)lDescription);
        Label lDescription2 = new Label(this.ril.getParameterName2());
        lDescription2.setPrefSize(0.0, (double)this.iHeight);
        lDescription2.setVisible(false);
        if (bParameterNameVisible2) {
            lDescription2.setPrefSize(200.0, (double)this.iHeight);
            lDescription2.setVisible(bParameterNameVisible2);
        }
        this.olNodes.add((Object)lDescription2);
        ArrayList<String> alChoices = this.pc.getValue(this.sVariableName, 1);
        this.sValueString = this.ril.getValueString();
        int iUnitIndex = 0;
        for (String sChoice : alChoices) {
            try {
                double dValueString = Double.parseDouble(this.sValueString);
                double dValueChoice = Double.parseDouble(sChoice);
                double dRelativeError = (dValueString - dValueChoice) / dValueChoice;
                if (!(Math.abs(dRelativeError) <= 1.0E-6)) continue;
                iUnitIndex = alChoices.indexOf(sChoice);
            }
            catch (Exception e) {
                if (!s.areTheyEqual(this.sValueString, sChoice)) continue;
                iUnitIndex = alChoices.indexOf(sChoice);
            }
        }
        this.options = FXCollections.observableArrayList(alChoices);
        ComboBox cbChoices = new ComboBox(this.options);
        cbChoices.setValue((Object)alChoices.get(iUnitIndex));
        cbChoices.setPrefSize(175.0, (double)this.iHeight);
        cbChoices.setVisible(true);
        if (s.areTheyTheSame(this.sVariableName, this.nc.sRiskESL)) {
            cbChoices.addEventHandler(ActionEvent.ACTION, (EventHandler)this.repository.getHandlerRiskChoice());
        } else {
            HandlerEditControl hec2 = new HandlerEditControl();
            hec2.setRepository(this.repository);
            cbChoices.addEventHandler(ActionEvent.ACTION, (EventHandler)hec2);
        }
        this.olNodes.add((Object)cbChoices);
        this.olNodes.add((Object)lTabName);
        this.olNodes.add((Object)lDataGroup);
        Label lOutputDestination = new Label();
        lOutputDestination.setText(this.ril.getOutputDestination());
        lOutputDestination.setVisible(false);
        this.olNodes.add((Object)lOutputDestination);
        this.hbox.getChildren().addAll(this.olNodes);
        this.repository.addPriorControl(this.sDataGroup, this.sVariableName, this.sVariableName2);
    }

    private void addStackPane(HBox hb) {
        hb.getChildren().add((Object)this.addStackPane("?"));
    }

    @Override
    public StackPane addStackPane(String sText) {
        StackPane stack = new StackPane();
        Rectangle helpIcon = new Rectangle(20.0, 20.0);
        helpIcon.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.web((String)"#4977A3")), new Stop(0.5, Color.web((String)"#B0C6DA")), new Stop(1.0, Color.web((String)"#9CB6CF"))}));
        helpIcon.setStroke((Paint)Color.web((String)"#D0E6FA"));
        helpIcon.setArcHeight(1.5);
        helpIcon.setArcWidth(3.5);
        Text helpText = new Text(sText);
        helpText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)16.0));
        helpText.setFill((Paint)Color.WHITE);
        helpText.setStroke((Paint)Color.web((String)"#7080A0"));
        stack.getChildren().addAll((Object[])new Node[]{helpIcon, helpText});
        stack.setAlignment(Pos.CENTER_RIGHT);
        StackPane.setMargin((Node)helpText, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        return stack;
    }

    @Override
    public void setTabName(String sTabName) {
        this.sTabName = sTabName;
    }

    @Override
    public void setName(String sName) {
        this.sDataGroup = sName;
    }

    @Override
    public void setLabel(String sVariableName) {
        this.sVariableName = sVariableName;
    }

    @Override
    public void setDistributionType(String s) {
        this.sDistributionType = s;
    }

    @Override
    public void setQualifier(String sQualifier) {
        this.sQualifier = sQualifier;
    }

    @Override
    public void setInputType(String sInputType) {
        this.sInputType = sInputType;
    }

    @Override
    public void setUseStringValue(boolean b) {
        this.bValueString = b;
    }

    @Override
    public void setValue(double dValue) {
        this.dValue = dValue;
    }

    @Override
    public void setValueString(String sValueString) {
        this.sValueString = sValueString;
    }

    @Override
    public void setUnitSelected(String sUnitSelected) {
        this.sUnitSelected = sUnitSelected;
    }

    @Override
    public void setUnitType(String sUnitType) {
        this.sUnitType = sUnitType;
    }

    @Override
    public void setFrequency(double dFrequency) {
        this.dFrequency = dFrequency;
    }

    @Override
    public void setComment(String sComment) {
        this.sComment = sComment;
    }

    @Override
    public void setUnitChoices(ArrayList<String> alUnitNames) {
        this.alUnitNames = alUnitNames;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public void setIndex(int iIndex) {
        this.iIndex = iIndex;
    }

    @Override
    public void setHeight(int iHeight) {
        this.iHeight = iHeight;
    }

    @Override
    public void setHandlerEdit(HandlerEdit he) {
        this.he = he;
    }

    @Override
    public void setTabPane(TabPane tp) {
        this.tp = tp;
    }

    @Override
    public void setTab(Tab tab) {
        this.tab = tab;
    }

    @Override
    public void setChangeToCome(String sChangeToCome) {
        this.sChangeToCome = sChangeToCome;
    }

    @Override
    public void setRawInputLine(RawInputLine ril) {
        this.ril = ril;
    }

    @Override
    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    @Override
    public RawInputLine getRawInputLine() {
        String sValue = "";
        String sFrequency = "";
        RawInputLine ril = new RawInputLine(this.viCD);
        this.dValue = Double.parseDouble(this.tfValue.getText());
        sValue = this.tfValue.getText();
        this.dFrequency = Double.parseDouble(this.tfFrequency.getText());
        sFrequency = this.tfFrequency.getText();
        this.sComment = this.tfComment.getText();
        String sUnitOutput = (String)this.comboBox.getValue();
        String[] sRawInput = new String[]{this.sDataGroup, this.sVariableName, this.sDistributionType, sValue, sUnitOutput, sFrequency, this.sComment};
        ril.setRawInputLine(this.nc.s_VALUEINPUT, sRawInput);
        return ril;
    }

    @Override
    public String getTabName() {
        return this.sTabName;
    }

    @Override
    public String getName() {
        return this.sDataGroup;
    }

    @Override
    public String getLabel() {
        return this.sVariableName;
    }

    @Override
    public String getDistributionType() {
        return this.sDistributionType;
    }

    @Override
    public String getQualifier() {
        return this.sQualifier;
    }

    @Override
    public String getInputType() {
        return this.sInputType;
    }

    @Override
    public HBox getInputControl() {
        return this.hbox;
    }

    @Override
    public double getValue() {
        return this.dValue;
    }

    @Override
    public String getUnitSelected() {
        return this.sUnitSelected;
    }

    @Override
    public String getUnitType() {
        return this.sUnitType;
    }

    @Override
    public double getFrequency() {
        return this.dFrequency;
    }

    @Override
    public String getComment() {
        return this.sComment;
    }

    @Override
    public int getIndex() {
        return this.iIndex;
    }

    @Override
    public int getHeight() {
        return this.iHeight;
    }

    @Override
    public HandlerEdit getHandlerEdit() {
        return this.he;
    }

    @Override
    public Tab getTab() {
        return this.tab;
    }
}

