/*
 * Decompiled with CFR 0.152.
 */
package ui.controlMakers;

import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.VIControlData;
import ui.Repository;
import ui.controlMakers.InputControl;
import ui.handler.HandlerChemicalSampleTypeChange;
import ui.handler.HandlerEdit;
import util.NameConstants;
import util.Stripper;
import util.UnitConverter;

public class InputControlInputEstimationManager
extends InputControl {
    private String sTabName;
    private String sDataGroup = "";
    private String sVariableName = "";
    private String sVariableName2 = "";
    private String sDistributionType;
    private String sQualifier;
    private String sInputType = "";
    private boolean bValueString;
    private double dValue = 0.0;
    private String sValueString;
    private String sUnitSelected;
    private String sUnitType = "";
    private double dFrequency;
    private String sComment;
    private ArrayList<String> alUnitNames;
    private Repository repository;
    private int iIndex = 0;
    private int iHeight = 20;
    private HandlerEdit he;
    private TabPane tp;
    private Tab tab;
    private String sChangeToCome = "keep";
    private RawInputLine ril;
    private UnitConverter uc;
    private HBox hbox;
    private VIControlData pvisCD;
    private NameConstants nc;
    private TextField tfValue;
    private TextField tfFrequency;
    private TextField tfComment;
    private ObservableList<String> options;
    private ArrayList<Chemical> alChemicals;
    private ArrayList<String> alSampleType;
    private ObservableList<Node> olNodes;
    private final ComboBox comboBox = new ComboBox();
    private HandlerChemicalSampleTypeChange hcstc;

    public InputControlInputEstimationManager() {
        this.nc = new NameConstants();
    }

    public void makeInputControlForAll() {
        boolean bValueString = false;
        boolean bParameterNameVisible2 = false;
        Stripper s = new Stripper();
        this.pvisCD = this.repository.getVIControlData();
        this.iHeight = 20;
        this.bEditable = this.repository.getInputEditable();
        this.hbox = new HBox();
        this.hbox.getStyleClass().add((Object)"hbox");
        this.olNodes = FXCollections.observableArrayList();
        String sRawInputType = this.nc.s_ControlChemicalSampleTypeManager;
        this.sDataGroup = "Chemical";
        this.sVariableName = this.nc.s_ControlCemicalInputEstimator;
        this.sVariableName2 = this.nc.s_ControlCemicalInputEstimator;
        Label lTabName = new Label(this.sTabName);
        lTabName.setVisible(false);
        lTabName.setPrefSize(0.0, 0.0);
        Label lDataGroup = new Label(this.sDataGroup);
        lDataGroup.setVisible(false);
        lDataGroup.setPrefSize(0.0, 0.0);
        Label lCount = new Label();
        lCount.setText("" + this.iIndex);
        lCount.setVisible(false);
        lCount.setPrefSize(0.0, (double)this.iHeight);
        Label lInputType = new Label();
        lInputType.setText(sRawInputType);
        lInputType.setVisible(false);
        lInputType.setPrefSize(0.0, (double)this.iHeight);
        this.olNodes.add((Object)lInputType);
        this.olNodes.add((Object)lCount);
        Label lDescription = new Label(this.sVariableName);
        lDescription.setPrefSize(200.0, (double)this.iHeight);
        lDescription.setVisible(true);
        this.olNodes.add((Object)lDescription);
        this.alSampleType = new ArrayList();
        this.alSampleType.add("");
        this.alSampleType.add("Soil Gas");
        this.alSampleType.add("Groundwater");
        int iUnitIndex = 0;
        this.options = FXCollections.observableArrayList(this.alSampleType);
        ComboBox cbSampleType = new ComboBox(this.options);
        cbSampleType.setValue((Object)this.alSampleType.get(iUnitIndex));
        cbSampleType.setPrefSize(75.0, (double)this.iHeight);
        cbSampleType.setVisible(false);
        this.olNodes.add((Object)cbSampleType);
        Button bAddingMissingData = new Button("Add Data");
        bAddingMissingData.setVisible(true);
        bAddingMissingData.setDisable(!this.bEditable);
        this.hcstc = new HandlerChemicalSampleTypeChange();
        this.hcstc.setRepository(this.repository);
        this.hcstc.setTabPane(this.tp);
        this.hcstc.setTab(this.tab);
        bAddingMissingData.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hcstc);
        this.olNodes.add((Object)bAddingMissingData);
        ToggleGroup group = new ToggleGroup();
        RadioButton rb0 = new RadioButton(this.nc.s_RadioEstimatedBenzene);
        if (s.areTheyEqual(this.repository.getInputEstimationType(), this.nc.s_RadioEstimatedBenzene)) {
            rb0.setSelected(true);
        }
        rb0.setToggleGroup(group);
        rb0.setDisable(!this.bEditable);
        RadioButton rb1 = new RadioButton(this.nc.s_RadioEstimatedTPH);
        if (s.areTheyEqual(this.repository.getInputEstimationType(), this.nc.s_RadioEstimatedTPH)) {
            rb1.setSelected(true);
        }
        rb1.setToggleGroup(group);
        rb1.setDisable(!this.bEditable);
        this.hcstc.setInputGroup(group);
        VBox vb = new VBox();
        vb.getChildren().addAll((Object[])new Node[]{rb1});
        vb.getChildren().addAll((Object[])new Node[]{rb0});
        this.olNodes.add((Object)vb);
        this.olNodes.add((Object)lTabName);
        this.olNodes.add((Object)lDataGroup);
        this.hbox.getChildren().addAll(this.olNodes);
        this.repository.addPriorControl(this.sDataGroup, this.sVariableName, this.sVariableName2);
    }

    private void addStackPane(HBox hb) {
        hb.getChildren().add((Object)this.addStackPane("?"));
    }

    public StackPane addStackPane(String sText) {
        StackPane stack = new StackPane();
        Rectangle helpIcon = new Rectangle(20.0, 20.0);
        helpIcon.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.web((String)"#4977A3")), new Stop(0.5, Color.web((String)"#B0C6DA")), new Stop(1.0, Color.web((String)"#9CB6CF"))}));
        helpIcon.setStroke((Paint)Color.web((String)"#D0E6FA"));
        helpIcon.setArcHeight(1.5);
        helpIcon.setArcWidth(3.5);
        Text helpText = new Text(sText);
        helpText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)16.0));
        helpText.setFill((Paint)Color.WHITE);
        helpText.setStroke((Paint)Color.web((String)"#7080A0"));
        stack.getChildren().addAll((Object[])new Node[]{helpIcon, helpText});
        stack.setAlignment(Pos.CENTER_RIGHT);
        StackPane.setMargin((Node)helpText, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        return stack;
    }

    public void setTabName(String sTabName) {
        this.sTabName = sTabName;
    }

    public void setName(String sName) {
        this.sDataGroup = sName;
    }

    public void setLabel(String sVariableName) {
        this.sVariableName = sVariableName;
    }

    public void setDistributionType(String s) {
        this.sDistributionType = s;
    }

    public void setQualifier(String sQualifier) {
        this.sQualifier = sQualifier;
    }

    public void setInputType(String sInputType) {
        this.sInputType = sInputType;
    }

    public void setUseStringValue(boolean b) {
        this.bValueString = b;
    }

    public void setValue(double dValue) {
        this.dValue = dValue;
    }

    public void setValueString(String sValueString) {
        this.sValueString = sValueString;
    }

    public void setUnitSelected(String sUnitSelected) {
        this.sUnitSelected = sUnitSelected;
    }

    public void setUnitType(String sUnitType) {
        this.sUnitType = sUnitType;
    }

    public void setFrequency(double dFrequency) {
        this.dFrequency = dFrequency;
    }

    public void setComment(String sComment) {
        this.sComment = sComment;
    }

    public void setUnitChoices(ArrayList<String> alUnitNames) {
        this.alUnitNames = alUnitNames;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setIndex(int iIndex) {
        this.iIndex = iIndex;
    }

    public void setHeight(int iHeight) {
        this.iHeight = iHeight;
    }

    public void setHandlerEdit(HandlerEdit he) {
        this.he = he;
    }

    public void setTabPane(TabPane tp) {
        this.tp = tp;
    }

    public void setTab(Tab tab) {
        this.tab = tab;
    }

    public void setChangeToCome(String sChangeToCome) {
        this.sChangeToCome = sChangeToCome;
    }

    public void setRawInputLine(RawInputLine ril) {
        this.ril = ril;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public String getTabName() {
        return this.sTabName;
    }

    public String getName() {
        return this.sDataGroup;
    }

    public String getLabel() {
        return this.sVariableName;
    }

    public String getDistributionType() {
        return this.sDistributionType;
    }

    public String getQualifier() {
        return this.sQualifier;
    }

    public String getInputType() {
        return this.sInputType;
    }

    public HBox getInputControl() {
        return this.hbox;
    }

    public double getValue() {
        return this.dValue;
    }

    public String getUnitSelected() {
        return this.sUnitSelected;
    }

    public String getUnitType() {
        return this.sUnitType;
    }

    public double getFrequency() {
        return this.dFrequency;
    }

    public String getComment() {
        return this.sComment;
    }

    public int getIndex() {
        return this.iIndex;
    }

    public int getHeight() {
        return this.iHeight;
    }

    public HandlerEdit getHandlerEdit() {
        return this.he;
    }

    public Tab getTab() {
        return this.tab;
    }
}

