/*
 * Decompiled with CFR 0.152.
 */
package ui.controlMakers;

import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.RawInput;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.VIControlData;
import ui.Repository;
import ui.controlMakers.InputControl;
import ui.handler.HandlerChemicalAdder;
import ui.handler.HandlerEdit;
import ui.handler.HandlerEditControl;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class InputControlScreeningLevel
extends InputControl {
    private String sTabName;
    private String sDataGroup;
    private String sVariableName;
    private String sVariableName2;
    private String sUnitType;
    private int iIndex;
    private String sQualifier;
    private double dValue;
    private String sValueString;
    private String sUnitSelected;
    private String sDistributionType;
    private double dFrequency;
    private String sComment;
    private int iHeight;
    private String sInputType;
    private String sChangeToCome;
    private RawInputLine ril;
    private HBox hbox;
    private ArrayList<String> alUnitNames;
    private OutputDigits od;
    private HandlerChemicalAdder hca;
    private HandlerEditControl hec;
    private HandlerEditControl hec2;
    private HandlerEditControl hec3;
    private int[] iHeadingLength;
    private HandlerEdit he;
    private Tab tab;
    private TabPane tp;
    private boolean bValueString;
    private Repository repository;
    private VIControlData pvisCD;
    private UnitConverter uc;
    private NameConstants nc;
    private TextField tfValue;
    private TextField tfFrequency;
    private TextField tfComment;
    private ObservableList<String> options;
    private ArrayList<Chemical> alChemicals;
    private ArrayList<String> alChemicalNames;
    private ObservableList<Node> olNodes;
    private final ComboBox comboBox = new ComboBox();

    public InputControlScreeningLevel() {
        this.nc = new NameConstants();
    }

    private void blankEmAll() {
        this.sDataGroup = "";
        this.sVariableName = "";
        this.sVariableName2 = "";
        this.dValue = 0.0;
        this.iIndex = 0;
        this.iHeight = this.nc.int_HEIGHT;
        this.sInputType = "";
        this.sUnitType = "";
        this.sChangeToCome = "keep";
    }

    public void makeInputControlForAll() {
        boolean bValueString = false;
        boolean bParameterNameVisible2 = false;
        Stripper s = new Stripper();
        this.pvisCD = this.repository.getVIControlData();
        RawInput ri = this.pvisCD.getRawInput();
        this.iHeight = this.nc.int_HEIGHT;
        this.hbox = new HBox();
        this.hbox.getStyleClass().add((Object)"hbox");
        this.olNodes = FXCollections.observableArrayList();
        String sRawInputType = this.nc.s_CONTROLRISKINPUT;
        ArrayList<RawInputLine> ril = ri.getAllRawInputLines();
        ArrayList<RawInputLine> riScreening = ri.getRawInputLines("ScreeningLevel", "IndoorAirConcentration");
        String[] sEntries = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8"};
        this.sDataGroup = "Risk";
        this.sVariableName = "Inhalation Risk";
        this.sVariableName2 = sEntries[2];
        Label lTabName = new Label(this.sTabName);
        lTabName.setVisible(false);
        lTabName.setPrefSize(0.0, 0.0);
        Label lDataGroup = new Label(sEntries[0]);
        lDataGroup.setVisible(false);
        lDataGroup.setPrefSize(0.0, 0.0);
        Label lCount = new Label();
        lCount.setText("" + this.iIndex);
        lCount.setVisible(false);
        lCount.setPrefSize(0.0, (double)this.iHeight);
        Label lInputType = new Label();
        lInputType.setText(sRawInputType);
        lInputType.setVisible(false);
        lInputType.setPrefSize(0.0, (double)this.iHeight);
        this.olNodes.add((Object)lInputType);
        this.olNodes.add((Object)lCount);
        Label lDescription = new Label(sEntries[2]);
        lDescription.setPrefSize((double)this.iHeadingLength[0], (double)this.iHeight);
        lDescription.setVisible(true);
        this.olNodes.add((Object)lDescription);
        TextField tfRiskLevel = new TextField();
        tfRiskLevel.setText(sEntries[3]);
        tfRiskLevel.setPrefSize((double)this.iHeadingLength[1], (double)this.iHeight);
        tfRiskLevel.setVisible(true);
        this.olNodes.add((Object)tfRiskLevel);
        TextField tfRiskConcentration = new TextField();
        tfRiskConcentration.setText(sEntries[4]);
        tfRiskConcentration.setPrefSize((double)this.iHeadingLength[2], (double)this.iHeight);
        tfRiskConcentration.setVisible(true);
        this.olNodes.add((Object)tfRiskConcentration);
        this.sUnitSelected = sEntries[5];
        int iUnitIndex = 0;
        this.alUnitNames = this.uc.getAllUnitNamesForAType("RiskConcentration");
        for (String sUnit : this.alUnitNames) {
            if (!s.areTheyEqual(this.sUnitSelected, sUnit)) continue;
            iUnitIndex = this.alUnitNames.indexOf(sUnit);
            break;
        }
        this.options = FXCollections.observableArrayList(this.alUnitNames);
        ComboBox cbRiskUnit = new ComboBox(this.options);
        cbRiskUnit.setValue((Object)this.alUnitNames.get(iUnitIndex));
        cbRiskUnit.setPrefSize((double)this.iHeadingLength[3], (double)this.iHeight);
        cbRiskUnit.setVisible(true);
        this.hec2 = new HandlerEditControl();
        this.hec2.setRepository(this.repository);
        cbRiskUnit.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hec2);
        this.olNodes.add((Object)cbRiskUnit);
        TextField tfHazardQuotient = new TextField();
        tfHazardQuotient.setText(sEntries[6]);
        tfHazardQuotient.setPrefSize((double)this.iHeadingLength[4], (double)this.iHeight);
        tfHazardQuotient.setVisible(true);
        this.olNodes.add((Object)tfHazardQuotient);
        TextField tfHQConcentration = new TextField();
        tfHQConcentration.setText(sEntries[7]);
        tfHQConcentration.setPrefSize((double)this.iHeadingLength[5], (double)this.iHeight);
        tfHQConcentration.setVisible(true);
        this.olNodes.add((Object)tfHQConcentration);
        this.sUnitSelected = sEntries[8];
        iUnitIndex = 0;
        for (String sUnit : this.alUnitNames) {
            if (!s.areTheyEqual(this.sUnitSelected, sUnit)) continue;
            iUnitIndex = this.alUnitNames.indexOf(sUnit);
            break;
        }
        this.options = FXCollections.observableArrayList(this.alUnitNames);
        ComboBox cbHQUnit = new ComboBox(this.options);
        cbHQUnit.setValue((Object)this.alUnitNames.get(iUnitIndex));
        cbHQUnit.setPrefSize((double)this.iHeadingLength[6], (double)this.iHeight);
        cbHQUnit.setVisible(true);
        this.hec3 = new HandlerEditControl();
        this.hec3.setRepository(this.repository);
        cbHQUnit.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hec2);
        this.olNodes.add((Object)cbHQUnit);
        this.olNodes.add((Object)lTabName);
        this.olNodes.add((Object)lDataGroup);
        Label lOutputDestination = new Label();
        lOutputDestination.setText("   ");
        this.olNodes.add((Object)lOutputDestination);
        this.hbox.getChildren().addAll(this.olNodes);
        this.repository.addPriorControl(this.sDataGroup, this.sVariableName, this.sVariableName2);
    }

    public void setTabName(String sTabName) {
        this.sTabName = sTabName;
    }

    public void setName(String sName) {
        this.sDataGroup = sName;
    }

    public void setLabel(String sVariableName) {
        this.sVariableName = sVariableName;
    }

    public void setDistributionType(String s) {
        this.sDistributionType = s;
    }

    public void setQualifier(String sQualifier) {
        this.sQualifier = sQualifier;
    }

    public void setInputType(String sInputType) {
        this.sInputType = sInputType;
    }

    public void setUseStringValue(boolean b) {
        this.bValueString = b;
    }

    public void setValue(double dValue) {
        this.dValue = dValue;
    }

    public void setValueString(String sValueString) {
        this.sValueString = sValueString;
    }

    public void setUnitSelected(String sUnitSelected) {
        this.sUnitSelected = sUnitSelected;
    }

    public void setUnitType(String sUnitType) {
        this.sUnitType = sUnitType;
    }

    public void setFrequency(double dFrequency) {
        this.dFrequency = dFrequency;
    }

    public void setComment(String sComment) {
        this.sComment = sComment;
    }

    public void setUnitChoices(ArrayList<String> alUnitNames) {
        this.alUnitNames = alUnitNames;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setIndex(int iIndex) {
        this.iIndex = iIndex;
    }

    public void setHeight(int iHeight) {
        this.iHeight = iHeight;
    }

    public void setHandlerEdit(HandlerEdit he) {
        this.he = he;
    }

    public void setTabPane(TabPane tp) {
        this.tp = tp;
    }

    public void setTab(Tab tab) {
        this.tab = tab;
    }

    public void setChangeToCome(String sChangeToCome) {
        this.sChangeToCome = sChangeToCome;
    }

    public void setRawInputLine(RawInputLine ril) {
        this.ril = ril;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setHeadingLength(int[] iHeadingLength) {
        this.iHeadingLength = iHeadingLength;
    }

    public String getTabName() {
        return this.sTabName;
    }

    public String getName() {
        return this.sDataGroup;
    }

    public String getLabel() {
        return this.sVariableName;
    }

    public String getDistributionType() {
        return this.sDistributionType;
    }

    public String getQualifier() {
        return this.sQualifier;
    }

    public String getInputType() {
        return this.sInputType;
    }

    public HBox getInputControl() {
        return this.hbox;
    }

    public double getValue() {
        return this.dValue;
    }

    public String getUnitSelected() {
        return this.sUnitSelected;
    }

    public String getUnitType() {
        return this.sUnitType;
    }

    public double getFrequency() {
        return this.dFrequency;
    }

    public String getComment() {
        return this.sComment;
    }

    public int getIndex() {
        return this.iIndex;
    }

    public int getHeight() {
        return this.iHeight;
    }

    public HandlerEdit getHandlerEdit() {
        return this.he;
    }

    public Tab getTab() {
        return this.tab;
    }
}

