/*
 * Decompiled with CFR 0.152.
 */
package ui.controlMakers;

import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.VIControlData;
import ui.Repository;
import ui.controlMakers.InputControl;
import ui.handler.HandlerEdit;
import ui.handler.HandlerEditComboBox;
import ui.handler.HandlerEditControl;
import ui.handler.HandlerEditNumber;
import ui.handler.HandlerRiskChoice;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class InputControlValue
extends InputControl {
    private String sTabName;
    private String sDataGroup;
    private String sVariableName;
    private String sVariableName2;
    private String sUnitType;
    private int iIndex;
    private String sQualifier;
    private double dValue;
    private String sValueString;
    private String sUnitSelected;
    private String sDistributionType;
    private double dFrequency;
    private String sComment;
    private int iHeight;
    private String sInputType;
    private String sChangeToCome;
    private RawInputLine ril;
    private HBox hbox;
    private ArrayList<String> alUnitNames;
    private OutputDigits od;
    private HandlerEditControl hec;
    private HandlerEditControl hec2;
    private HandlerEditControl hec3;
    private HandlerEditControl hec4;
    private HandlerEditControl hec5;
    private HandlerEditNumber hen;
    private HandlerEditComboBox hecb;
    private Repository repository;
    private HandlerEdit he;
    private Tab tab;
    private TabPane tp;
    private boolean bValueString;
    private UnitConverter uc;
    private NameConstants nc;
    private VIControlData viCD;
    private TextField tfValue;
    private TextField tfFrequency;
    private TextField tfComment;
    private ObservableList<String> options;
    private ObservableList<Node> olNodes;
    private final ComboBox comboBox = new ComboBox();

    public InputControlValue() {
        this.nc = new NameConstants();
        this.blankEmAll();
    }

    private void blankEmAll() {
        this.sDataGroup = "";
        this.sVariableName = "";
        this.sVariableName2 = "";
        this.sQualifier = "";
        this.sDistributionType = "";
        this.dValue = 0.0;
        this.dFrequency = 0.0;
        this.iIndex = 0;
        this.iHeight = this.nc.int_HEIGHT;
        this.sInputType = "";
        this.sUnitType = "";
        this.sChangeToCome = "keep";
    }

    public void makeInputControlForAll() {
        boolean bValueString = false;
        boolean bParameterNameVisible2 = false;
        Stripper s = new Stripper();
        this.hbox = new HBox();
        this.hbox.getStyleClass().add((Object)"hbox");
        this.olNodes = FXCollections.observableArrayList();
        String sRawInputType = this.ril.getRawInputType();
        this.sDistributionType = this.ril.getDistributionType();
        bValueString = false;
        bParameterNameVisible2 = false;
        this.sUnitType = "none";
        if (s.areTheyEqual(this.nc.s_CONTROL2STRING, sRawInputType)) {
            bValueString = true;
            this.sUnitType = "none";
        } else if (s.areTheyEqual(this.nc.s_CONTROLSTRINGVALUE, sRawInputType)) {
            this.sUnitType = "none";
        } else if (s.areTheyEqual(this.nc.s_CONTROL2STRINGVALUE, sRawInputType)) {
            bParameterNameVisible2 = true;
            this.sUnitType = "none";
        } else if (s.areTheyEqual(this.nc.s_CONTROL3STRING, sRawInputType)) {
            bValueString = true;
            bParameterNameVisible2 = true;
            this.sUnitType = "none";
        } else if (s.areTheyEqual(this.nc.s_VALUEINPUT, sRawInputType)) {
            bValueString = false;
            this.sUnitType = this.ril.getUnitType(this.ril.getParameterName(), this.uc);
            this.dFrequency = this.ril.getFrequency();
            this.sUnitSelected = this.ril.getUnit();
            this.alUnitNames = this.uc.getAllUnitNamesForAType(this.sUnitType);
        } else if (s.areTheyEqual(this.nc.s_CHEMICALINPUT, sRawInputType) || s.areTheyEqual(this.nc.s_CONTROLSCREENINGLEVELINPUT, sRawInputType)) {
            bValueString = false;
            bParameterNameVisible2 = true;
            this.sUnitType = this.ril.getUnitType(this.ril.getParameterName2(), this.uc);
            this.dFrequency = this.ril.getFrequency();
            this.sUnitSelected = this.ril.getUnit();
            this.alUnitNames = this.uc.getAllUnitNamesForAType(this.sUnitType);
        } else if (s.areTheyEqual(this.nc.s_CONTROLSTRINGCHOICE, sRawInputType)) {
            this.sUnitType = "other";
        }
        Label lFrequency = new Label();
        lFrequency.setVisible(false);
        lFrequency.setPrefSize(0.0, (double)this.iHeight);
        lFrequency.setText("" + this.dFrequency);
        Label lTabName = new Label(this.sTabName);
        lTabName.setVisible(false);
        lTabName.setPrefSize(0.0, 0.0);
        Label lDataGroup = new Label(this.sDataGroup);
        lDataGroup.setVisible(false);
        lDataGroup.setPrefSize(0.0, 0.0);
        Label lCount = new Label();
        lCount.setText("" + this.iIndex);
        lCount.setVisible(false);
        lCount.setPrefSize(0.0, (double)this.iHeight);
        Label lInputType = new Label();
        lInputType.setText(sRawInputType);
        lInputType.setVisible(false);
        lInputType.setPrefSize(0.0, (double)this.iHeight);
        Label lPreviousDistribution = new Label();
        lPreviousDistribution.setVisible(false);
        lPreviousDistribution.setPrefSize(0.0, (double)this.iHeight);
        Label lChangeToCome = new Label();
        lChangeToCome.setVisible(false);
        lChangeToCome.setPrefSize(0.0, (double)this.iHeight);
        lChangeToCome.setText(this.sChangeToCome);
        Label lUnitType = new Label();
        lUnitType.setVisible(false);
        lUnitType.setPrefSize(0.0, (double)this.iHeight);
        lUnitType.setText(this.sUnitType);
        this.olNodes.add((Object)lInputType);
        this.olNodes.add((Object)lCount);
        if (!this.sDistributionType.equalsIgnoreCase("none")) {
            this.sDataGroup = this.ril.getGroupName();
            this.sVariableName = this.ril.getParameterName();
            this.sVariableName2 = this.ril.getParameterName2();
            ObservableList opt = FXCollections.observableArrayList((Object[])new String[]{this.nc.dist_CONSTANT, this.nc.dist_UNIFORM});
            ComboBox cbDistribution = new ComboBox(opt);
            cbDistribution.setId("DistributionComboBox");
            cbDistribution.setPrefSize(100.0, (double)this.iHeight);
            boolean bPriorControl = s.areTheyEqual(this.nc.s_CHEMICALINPUT, sRawInputType) ? this.repository.checkForPreviousControl(this.sDataGroup, this.sVariableName2, this.sVariableName) : this.repository.checkForPreviousControl(this.sDataGroup, this.sVariableName, this.sVariableName2);
            if (bPriorControl) {
                cbDistribution.setVisible(false);
            } else {
                cbDistribution.setVisible(true);
            }
            cbDistribution.setDisable(!this.bEditable);
            this.hecb = new HandlerEditComboBox();
            this.hecb.setNames(this.sTabName, this.sDataGroup);
            this.hecb.setRepository(this.repository);
            this.hecb.setComboBox(cbDistribution);
            this.hecb.setTabPane(this.tp);
            this.hecb.setTab(this.tab);
            cbDistribution.setPrefWidth(105.0);
            if (this.sDistributionType.equalsIgnoreCase(this.nc.dist_DISTRIBUTION)) {
                this.sQualifier = "file";
                cbDistribution.setValue((Object)this.nc.dist_DISTRIBUTION);
                lPreviousDistribution.setText(this.nc.dist_DISTRIBUTION);
            } else if (this.sDistributionType.equalsIgnoreCase(this.nc.dist_CONSTANT)) {
                this.sQualifier = this.nc.qual_OneValue;
                cbDistribution.setValue((Object)this.nc.dist_CONSTANT);
                lPreviousDistribution.setText(this.nc.dist_CONSTANT);
            } else if (this.sDistributionType.equalsIgnoreCase(this.nc.dist_VARIABLE) || this.sDistributionType.equalsIgnoreCase(this.nc.dist_UNIFORM)) {
                this.sQualifier = this.dFrequency == 0.0 ? this.nc.qual_min : this.nc.qual_max;
                cbDistribution.setValue((Object)this.nc.dist_UNIFORM);
                lPreviousDistribution.setText(this.nc.dist_UNIFORM);
            }
            cbDistribution.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hecb);
            this.olNodes.add((Object)cbDistribution);
            Label lQualifier = new Label(this.sQualifier);
            lQualifier.setPrefSize(100.0, (double)this.iHeight);
            lQualifier.setVisible(true);
            this.olNodes.add((Object)lQualifier);
        }
        this.sVariableName = this.ril.getParameterName();
        Label lDescription = new Label(this.sVariableName);
        lDescription.setPrefSize(250.0, (double)this.iHeight);
        lDescription.setVisible(true);
        this.olNodes.add((Object)lDescription);
        Label lDescription2 = new Label(this.ril.getParameterName2());
        lDescription2.setPrefSize(0.0, (double)this.iHeight);
        lDescription2.setVisible(false);
        if (bParameterNameVisible2) {
            lDescription2.setPrefSize(200.0, (double)this.iHeight);
            lDescription2.setVisible(bParameterNameVisible2);
        }
        this.olNodes.add((Object)lDescription2);
        TextField tfValue = new TextField("");
        tfValue.setPrefSize(100.0, (double)this.iHeight);
        tfValue.setVisible(true);
        tfValue.setEditable(this.bEditable);
        if (bValueString) {
            tfValue.setText(this.ril.getValueString());
            this.hec = new HandlerEditControl();
            tfValue.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hec);
        } else {
            this.od = new OutputDigits();
            this.dValue = this.ril.getValue();
            if (this.dValue >= 0.0) {
                tfValue.setText(this.od.num2String(this.dValue));
            } else {
                tfValue.setText("");
            }
            this.hen = new HandlerEditNumber();
            this.hen.setRepository(this.repository);
            this.hen.setTextField(tfValue);
            tfValue.setOnAction((EventHandler)this.hen);
            tfValue.setOnMouseExited((EventHandler)this.hen);
            tfValue.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hen);
            System.out.println("sVariableName " + this.sVariableName + " sVariableName2 " + this.sVariableName2);
            if (s.areTheyTheSame(this.sVariableName, this.nc.sRiskTCR) || s.areTheyTheSame(this.sVariableName, this.nc.sRiskTHQ)) {
                HandlerRiskChoice hrc = this.repository.getHandlerRiskChoice();
                tfValue.setOnAction((EventHandler)hrc);
                tfValue.setOnMouseExited((EventHandler)hrc);
                tfValue.addEventHandler(ActionEvent.ACTION, (EventHandler)hrc);
                if (this.repository.getVIControlData().getDoesScreeningExist()) {
                    tfValue.setDisable(true);
                }
            }
        }
        this.olNodes.add((Object)tfValue);
        if (!this.sUnitType.equalsIgnoreCase("none")) {
            int iUnitIndex = 0;
            System.out.println("sUnitType " + this.sUnitType + " name " + this.getName() + " selected unit " + this.sUnitSelected);
            for (String sUnit : this.alUnitNames) {
                if (!s.areTheyEqual(this.sUnitSelected, sUnit)) continue;
                iUnitIndex = this.alUnitNames.indexOf(sUnit);
            }
            this.options = FXCollections.observableArrayList(this.alUnitNames);
            ComboBox cbUnit = new ComboBox(this.options);
            cbUnit.setValue((Object)this.alUnitNames.get(iUnitIndex));
            cbUnit.setPrefSize(100.0, (double)this.iHeight);
            cbUnit.setVisible(true);
            cbUnit.setDisable(!this.bEditable);
            this.hec2 = new HandlerEditControl();
            this.hec2.setRepository(this.repository);
            cbUnit.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hec2);
            this.olNodes.add((Object)cbUnit);
        } else if (s.areTheyEqual(this.sUnitType, "other") && !s.areTheyEqual("DirtFloor", this.sVariableName)) {
            s.areTheyEqual("OilDistribution", this.sVariableName);
        }
        this.tfComment = new TextField();
        this.tfComment.setPrefSize(300.0, (double)this.iHeight);
        this.tfComment.setVisible(true);
        this.tfComment.setText(this.sComment);
        this.hec5 = new HandlerEditControl();
        this.hec5.setRepository(this.repository);
        this.tfComment.addEventHandler(ActionEvent.ACTION, (EventHandler)this.hec5);
        this.olNodes.add((Object)lFrequency);
        this.olNodes.add((Object)lTabName);
        this.olNodes.add((Object)lDataGroup);
        this.olNodes.add((Object)lPreviousDistribution);
        this.olNodes.add((Object)lChangeToCome);
        this.olNodes.add((Object)lUnitType);
        Label lOutputDestination = new Label();
        lOutputDestination.setText(this.ril.getOutputDestination());
        lOutputDestination.setVisible(false);
        this.olNodes.add((Object)lOutputDestination);
        this.hbox.getChildren().addAll(this.olNodes);
        this.repository.addPriorControl(this.sDataGroup, this.sVariableName, this.sVariableName2);
    }

    private void addStackPane(HBox hb) {
        hb.getChildren().add((Object)this.addStackPane("?"));
    }

    public StackPane addStackPane(String sText) {
        StackPane stack = new StackPane();
        Rectangle helpIcon = new Rectangle(20.0, 20.0);
        helpIcon.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.web((String)"#4977A3")), new Stop(0.5, Color.web((String)"#B0C6DA")), new Stop(1.0, Color.web((String)"#9CB6CF"))}));
        helpIcon.setStroke((Paint)Color.web((String)"#D0E6FA"));
        helpIcon.setArcHeight(1.5);
        helpIcon.setArcWidth(3.5);
        Text helpText = new Text(sText);
        helpText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)16.0));
        helpText.setFill((Paint)Color.WHITE);
        helpText.setStroke((Paint)Color.web((String)"#7080A0"));
        stack.getChildren().addAll((Object[])new Node[]{helpIcon, helpText});
        stack.setAlignment(Pos.CENTER_RIGHT);
        StackPane.setMargin((Node)helpText, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        return stack;
    }

    public void setTabName(String sTabName) {
        this.sTabName = sTabName;
    }

    public void setName(String sName) {
        this.sDataGroup = sName;
    }

    public void setLabel(String sVariableName) {
        this.sVariableName = sVariableName;
    }

    public void setDistributionType(String s) {
        this.sDistributionType = s;
    }

    public void setQualifier(String sQualifier) {
        this.sQualifier = sQualifier;
    }

    public void setInputType(String sInputType) {
        this.sInputType = sInputType;
    }

    public void setUseStringValue(boolean b) {
        this.bValueString = b;
    }

    public void setValue(double dValue) {
        this.dValue = dValue;
    }

    public void setValueString(String sValueString) {
        this.sValueString = sValueString;
    }

    public void setUnitSelected(String sUnitSelected) {
        this.sUnitSelected = sUnitSelected;
    }

    public void setUnitType(String sUnitType) {
        this.sUnitType = sUnitType;
    }

    public void setFrequency(double dFrequency) {
        this.dFrequency = dFrequency;
    }

    public void setComment(String sComment) {
        this.sComment = sComment;
    }

    public void setUnitChoices(ArrayList<String> alUnitNames) {
        this.alUnitNames = alUnitNames;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setIndex(int iIndex) {
        this.iIndex = iIndex;
    }

    public void setHeight(int iHeight) {
        this.iHeight = iHeight;
    }

    public void setHandlerEdit(HandlerEdit he) {
        this.he = he;
    }

    public void setTabPane(TabPane tp) {
        this.tp = tp;
    }

    public void setTab(Tab tab) {
        this.tab = tab;
    }

    public void setChangeToCome(String sChangeToCome) {
        this.sChangeToCome = sChangeToCome;
    }

    public void setRawInputLine(RawInputLine ril) {
        this.ril = ril;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setVIControlData(VIControlData viCD) {
        this.viCD = viCD;
    }

    public RawInputLine getRawInputLine() {
        String sValue = "";
        String sFrequency = "";
        RawInputLine ril = new RawInputLine(this.viCD);
        this.dValue = Double.parseDouble(this.tfValue.getText());
        sValue = this.tfValue.getText();
        this.dFrequency = Double.parseDouble(this.tfFrequency.getText());
        sFrequency = this.tfFrequency.getText();
        this.sComment = this.tfComment.getText();
        String sUnitOutput = (String)this.comboBox.getValue();
        String[] sRawInput = new String[]{this.sDataGroup, this.sVariableName, this.sDistributionType, sValue, sUnitOutput, sFrequency, this.sComment};
        ril.setRawInputLine(this.nc.s_VALUEINPUT, sRawInput);
        return ril;
    }

    public String getTabName() {
        return this.sTabName;
    }

    public String getName() {
        return this.sDataGroup;
    }

    public String getLabel() {
        return this.sVariableName;
    }

    public String getDistributionType() {
        return this.sDistributionType;
    }

    public String getQualifier() {
        return this.sQualifier;
    }

    public String getInputType() {
        return this.sInputType;
    }

    public HBox getInputControl() {
        return this.hbox;
    }

    public double getValue() {
        return this.dValue;
    }

    public String getUnitSelected() {
        return this.sUnitSelected;
    }

    public String getUnitType() {
        return this.sUnitType;
    }

    public double getFrequency() {
        return this.dFrequency;
    }

    public String getComment() {
        return this.sComment;
    }

    public int getIndex() {
        return this.iIndex;
    }

    public int getHeight() {
        return this.iHeight;
    }

    public HandlerEdit getHandlerEdit() {
        return this.he;
    }

    public Tab getTab() {
        return this.tab;
    }
}

