/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.VIControlData;
import ui.Repository;
import ui.handler.HandlerEdit;
import ui.handler.HandlerEditControl;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class HandlerChemicalSampleTypeChange
extends HandlerEditControl
implements EventHandler {
    private static final String sHandlerName = "ChemicalSampleTypeChange";
    private Tab tab;
    private TabPane tp;
    private ComboBox cbChoices;
    private ToggleGroup group;
    private RadioButton rb;
    private ArrayList<RadioButton> alRadioButton = new ArrayList();
    private CheckBox chbxFringe;
    private HandlerEdit he;
    private VIControlData viCD;
    private UnitConverter uc;
    private ArrayList<HBox> alHBox;
    private Stripper s;
    private NameConstants nc;
    private ObservableList<String> options;
    private boolean bEditable;
    private int iCount;

    @Override
    public void handle(Event e) {
        block15: {
            ObservableList olNode;
            String sDescriptionNew;
            RadioButton rbChosen;
            String sUnitSelected;
            String sUnitType;
            block16: {
                super.handle(e);
                this.iCount = 0;
                this.he = this.repository.getHandlerEdit();
                this.viCD = this.repository.getVIControlData();
                this.uc = this.viCD.getUnitConverter();
                this.bEditable = this.viCD.getUIInputEditable();
                if (!this.bEditable) break block15;
                this.alHBox = this.repository.getHBoxList();
                this.s = new Stripper();
                this.nc = new NameConstants();
                sUnitType = "";
                sUnitSelected = "";
                String sSelectedChoice = (String)this.cbChoices.getValue();
                rbChosen = (RadioButton)this.group.getSelectedToggle();
                sDescriptionNew = "";
                if (this.s.areTheyTheSame(sSelectedChoice, "Soil Gas")) {
                    sDescriptionNew = "Soil Gas Concentration";
                    sUnitType = "ConcentrationAir";
                    sUnitSelected = "ug/m3";
                } else if (this.s.areTheyTheSame(sSelectedChoice, "Ground Water")) {
                    sDescriptionNew = "Ground Water Concentration";
                    sUnitType = "ConcentrationWater";
                    sUnitSelected = "mg/L";
                }
                ScrollPane sp = (ScrollPane)this.tab.getContent();
                GridPane gp = (GridPane)sp.getContent();
                olNode = gp.getChildren();
                if (!this.s.areTheyTheSame(rbChosen.getText(), this.nc.s_Radio_Blank)) break block16;
                for (Node node : olNode) {
                    HBox hbox = (HBox)node;
                    ObservableList olHBoxKids = hbox.getChildren();
                    String sInputType = ((Label)olHBoxKids.get(this.nc.int_INPUTTYPE)).getText();
                    if (!this.s.areTheyEqual(sInputType, this.nc.s_CHEMICALINPUT)) continue;
                    this.nc.getClass();
                    ((TextField)olHBoxKids.get(6)).setText("");
                    this.nc.getClass();
                    ((Label)olHBoxKids.get(5)).setText(sDescriptionNew);
                    ArrayList<Object> alUnitNames = new ArrayList();
                    alUnitNames = this.uc.getAllUnitNamesForAType(sUnitType);
                    int iUnitIndex = 0;
                    for (String string : alUnitNames) {
                        if (!this.s.areTheyEqual(sUnitSelected, string)) continue;
                        iUnitIndex = alUnitNames.indexOf(string);
                    }
                    this.options = FXCollections.observableArrayList(alUnitNames);
                    this.nc.getClass();
                    ((ComboBox)olHBoxKids.get(7)).setItems(this.options);
                    this.nc.getClass();
                    ((ComboBox)olHBoxKids.get(7)).setValue((Object)((String)alUnitNames.get(iUnitIndex)));
                }
                break block15;
            }
            if (!this.s.areTheyTheSame(rbChosen.getText(), this.nc.s_Radio_Convert)) break block15;
            double dCapillaryFactor = 1.0;
            if (this.chbxFringe.isSelected()) {
                dCapillaryFactor = this.viCD.getGroundWaterConcentrationAdjustmentFactor();
            }
            this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), String.valueOf(this.getClass().getName()) + " Capillary Adjustment Factor," + dCapillaryFactor);
            for (Node node : olNode) {
                HBox hbox = (HBox)node;
                ObservableList olHBoxKids = hbox.getChildren();
                String sInputType = ((Label)olHBoxKids.get(this.nc.int_INPUTTYPE)).getText();
                if (!this.s.areTheyEqual(sInputType, this.nc.s_CHEMICALINPUT)) continue;
                double d = 0.0;
                this.nc.getClass();
                String sChemical = ((Label)olHBoxKids.get(4)).getText();
                this.nc.getClass();
                String sCurrentDescription = ((Label)olHBoxKids.get(5)).getText();
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), String.valueOf(this.getClass().getName()) + " New Type," + sDescriptionNew);
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), String.valueOf(this.getClass().getName()) + " Current Type," + sCurrentDescription);
                this.nc.getClass();
                String sValue = ((TextField)olHBoxKids.get(6)).getText();
                try {
                    d = Double.parseDouble(sValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.nc.getClass();
                String sUCF = (String)((ComboBox)olHBoxKids.get(7)).getValue();
                ArrayList<Chemical> alChemical = this.viCD.getChemicals();
                double dConvertedValue = 0.0;
                String sTypeForOutput = "";
                for (Chemical chemical : alChemical) {
                    if (!this.s.areTheyEqual(sChemical, chemical.getName()) || !chemical.getIsUsedInSimulation()) continue;
                    double d2 = 1.0;
                    if (this.s.areTheyTheSame(sDescriptionNew, "Soil Gas Concentration") && this.s.areTheyTheSame(sCurrentDescription, "Ground Water Concentration")) {
                        d2 = this.uc.getUCF("ConcentrationWater", sUCF);
                        dConvertedValue = chemical.getSoilGasEquivalentFromGroundWaterSample(d2 * d) * dCapillaryFactor;
                        sTypeForOutput = "ConcentrationAir";
                    } else if (this.s.areTheyTheSame(sDescriptionNew, "Ground Water Concentration") && this.s.areTheyTheSame(sCurrentDescription, "Soil Gas Concentration")) {
                        d2 = this.uc.getUCF("ConcentrationAir", sUCF);
                        dConvertedValue = chemical.getGroundWaterEquivalentFromSoilGasSample(d2 * d) / dCapillaryFactor;
                        sTypeForOutput = "ConcentrationWater";
                    }
                    if (this.s.areTheyTheSame(sDescriptionNew, "Soil Gas Concentration") && this.s.areTheyTheSame(sCurrentDescription, "Soil Gas Concentration")) {
                        d2 = this.uc.getUCF("ConcentrationAir", sUCF);
                        dConvertedValue = d2 * d;
                        sTypeForOutput = "ConcentrationAir";
                        break;
                    }
                    if (!this.s.areTheyTheSame(sDescriptionNew, "Ground Water Concentration") || !this.s.areTheyTheSame(sCurrentDescription, "Ground Water Concentration")) break;
                    d2 = this.uc.getUCF("ConcentrationWater", sUCF);
                    dConvertedValue = d2 * d;
                    sTypeForOutput = "ConcentrationWater";
                    break;
                }
                this.nc.getClass();
                ((Label)olHBoxKids.get(5)).setText(sDescriptionNew);
                ArrayList<Object> alUnitNames = new ArrayList();
                alUnitNames = this.uc.getAllUnitNamesForAType(sUnitType);
                int iUnitIndex = 0;
                for (String string : alUnitNames) {
                    if (!this.s.areTheyEqual(sUnitSelected, string)) continue;
                    iUnitIndex = alUnitNames.indexOf(string);
                }
                this.options = FXCollections.observableArrayList(alUnitNames);
                this.nc.getClass();
                ((ComboBox)olHBoxKids.get(7)).setItems(this.options);
                this.nc.getClass();
                ((ComboBox)olHBoxKids.get(7)).setValue((Object)((String)alUnitNames.get(iUnitIndex)));
                OutputDigits outputDigits = new OutputDigits();
                this.nc.getClass();
                ((TextField)olHBoxKids.get(6)).setText(outputDigits.num2String(dConvertedValue /= this.uc.getUCF(sTypeForOutput, sUnitSelected)));
                ++this.iCount;
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), this + " chemical," + this.iCount + ',' + sChemical + " unit " + sUCF + " value " + dConvertedValue);
            }
        }
    }

    public void setTab(Tab tab) {
        this.tab = tab;
    }

    public void setTabPane(TabPane tp) {
        this.tp = tp;
    }

    public void setSampleChoices(ComboBox cbChoices) {
        this.cbChoices = cbChoices;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setInputGroup(ToggleGroup group) {
        this.group = group;
    }

    public void addRadioButton(RadioButton rb) {
        this.alRadioButton.add(rb);
    }

    public void setCheckBox(CheckBox chbxFringe) {
        this.chbxFringe = chbxFringe;
    }

    @Override
    public String getHandlerName() {
        return sHandlerName;
    }
}

