/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import pviScreen.dataContainers.VIControlData;
import ui.Repository;
import util.NameConstants;

public class HandlerCleanUp
implements EventHandler {
    private static final String sHandlerName = "CleanUp";
    private Stage stage;
    private Label lTopLabel;
    private Repository repository;
    private VIControlData viCD;
    private boolean bDeletedFile;
    private CheckBox cbPNG;
    private CheckBox cbInput;
    private CheckBox cbResult;
    private CheckBox cbMessage;
    private CheckBox cbHTML;
    private String sCurrentDirectory;
    private String sActiveDirectory;
    private String sInitialDirectory;
    private NameConstants nc;

    public HandlerCleanUp(Stage stage) {
        this.stage = stage;
        this.nc = new NameConstants();
    }

    public void handle(Event arg0) {
        ArrayList<CBoxWithName> alExtension = new ArrayList<CBoxWithName>();
        if (this.cbPNG.isSelected()) {
            alExtension.add(new CBoxWithName("PNG", this.nc.s_Extension_PNG_All, this.cbPNG));
        }
        if (this.cbMessage.isSelected()) {
            alExtension.add(new CBoxWithName("Message", this.nc.s_Extension_Results, this.cbMessage));
        }
        if (this.cbHTML.isSelected()) {
            alExtension.add(new CBoxWithName("Report", this.nc.s_Extension_HTML, this.cbHTML));
        }
        if (this.cbResult.isSelected()) {
            alExtension.add(new CBoxWithName("Result", this.nc.s_Extension_Results, this.cbResult));
        }
        if (this.cbInput.isSelected()) {
            alExtension.add(new CBoxWithName("Input", this.nc.s_Extension_Input, this.cbInput));
        }
        for (CBoxWithName cbwn : alExtension) {
            FileChooser fc = new FileChooser();
            fc.setTitle("Select Files to Delete");
            try {
                this.viCD = this.repository.getVIControlData();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sInitialDirectory = "projects";
                this.sCurrentDirectory = new File(".").getCanonicalPath();
                this.sActiveDirectory = this.repository.getDirectory();
                this.sCurrentDirectory = this.sActiveDirectory != "" ? this.sActiveDirectory : String.valueOf(this.sCurrentDirectory) + "\\" + this.sInitialDirectory;
                fc.setInitialDirectory(new File(this.sCurrentDirectory));
            }
            catch (Exception exception) {
                // empty catch block
            }
            fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(cbwn.getName(), new String[]{"*." + cbwn.getExtension()}));
            List list = fc.showOpenMultipleDialog((Window)this.stage);
            try {
                for (File file : list) {
                    this.bDeletedFile = this.deleteFile(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean deleteFile(File file) {
        if (file.delete()) {
            try {
                this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), String.valueOf(this.getClass().getName()) + " Deleted," + file.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        try {
            this.viCD.addToMessageOutput(this.viCD.getMessageOutput(), String.valueOf(this.getClass().getName()) + " Failed to Delete," + file.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setCheckBoxPNG(CheckBox cbPNG) {
        this.cbPNG = cbPNG;
    }

    public void setCheckBoxMessage(CheckBox cbMessage) {
        this.cbMessage = cbMessage;
    }

    public void setCheckBoxResult(CheckBox cbResult) {
        this.cbResult = cbResult;
    }

    public void setCheckBoxInput(CheckBox cbInput) {
        this.cbInput = cbInput;
    }

    public void setCheckBoxHTML(CheckBox cbHTML) {
        this.cbHTML = cbHTML;
    }

    public void setTopLabel(Label lTopLabel) {
        this.lTopLabel = lTopLabel;
    }

    public String getHandlerName() {
        return sHandlerName;
    }

    class CBoxWithName {
        private String sName = "";
        private String sExtension = "";
        private CheckBox cb = null;

        public CBoxWithName() {
        }

        public CBoxWithName(String sName, String sExtension, CheckBox cb) {
            this.setName(sName);
            this.setExtension(sExtension);
            this.setCheckBox(cb);
        }

        public void setName(String sName) {
            this.sName = sName;
        }

        public void setExtension(String sExtension) {
            this.sExtension = sExtension;
        }

        public void setCheckBox(CheckBox cb) {
            this.cb = cb;
        }

        public String getName() {
            return this.sName;
        }

        public String getExtension() {
            return this.sExtension;
        }

        public CheckBox getCheckBox() {
            return this.cb;
        }
    }
}

