/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.ExposureFactorData;
import pviScreen.dataContainers.RawInput;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.VIControlData;
import pviScreen.dataReaders.FillDataContainer;
import ui.DefaultNameRange;
import ui.Repository;
import ui.controlMakers.InputControlChemicalManager;
import ui.controlMakers.InputControlChemicalSampleTypeManager;
import ui.controlMakers.InputControlChoice;
import ui.controlMakers.InputControlInputEstimationManager;
import ui.controlMakers.InputControlScreeningLevel;
import ui.controlMakers.InputControlValue;
import ui.handler.HandlerDefaultNameRange;
import ui.handler.HandlerRiskChoice;
import ui.handler.WrappedEventHandler;
import util.FileLogger;
import util.NameConstants;
import util.Stripper;
import util.UnitConverter;

public class HandlerEdit
extends WrappedEventHandler {
    private static final String sHandlerName = "Edit";
    private Stage stage;
    private Scene scene;
    private Button buttonEdit;
    private Repository repository;
    private Label lTopLabel;
    private UnitConverter uc;
    private VIControlData viCD;
    private ExposureFactorData efd;
    private BorderPane border;
    private RawInput ri;
    private TabPane tp;
    private Tab tab;
    private boolean bAllPresent;
    private ArrayList<HBox> alHbox;
    private FillDataContainer fdc;
    private NameConstants nc;
    private Stripper s;
    private ObservableList<Button> olButton;
    private static final String constant_STRING = "Building";
    HBox hbox;

    public HandlerEdit(Stage stage) {
        this.stage = stage;
    }

    @Override
    public void handle(Event event) {
        this.redisplayData();
    }

    public void redisplayData() {
        this.alHbox = new ArrayList();
        this.nc = new NameConstants();
        this.viCD = this.repository.getVIControlData();
        this.repository.clearPreviousControlArrayList();
        this.repository.setHboxList(this.alHbox);
        this.uc = this.viCD.getUnitConverter();
        this.ri = this.viCD.getRawInput();
        this.border = this.repository.getBorder();
        this.efd = this.viCD.getExposureFactorData();
        this.repository.setInputFileFlagSet(true);
        this.alHbox = new ArrayList();
        this.bAllPresent = true;
        this.tp = new TabPane();
        this.olButton = this.repository.getButtonList();
        this.s = new Stripper();
        String sInputType = this.repository.getInputType();
        if (this.s.areTheyEqual(sInputType, this.nc.s_Radio_ExistingInput) || this.s.areTheyEqual(sInputType, this.nc.s_Radio_Template)) {
            this.viCD.setUIInputEditable(true);
            this.repository.setInputEditable(true);
            for (Button button : this.olButton) {
                String sButton = button.getText();
                if (this.s.equals(this.nc.s_ButtonEdit, sButton)) {
                    button.setDisable(false);
                    button.requestFocus();
                    button.setText(this.nc.s_ButtonEdit);
                }
                if (this.s.equals(this.nc.s_ButtonRun, sButton)) {
                    button.setDisable(true);
                    button.setStyle(this.nc.s_StyleDisable);
                }
                if (this.s.equals(this.nc.s_ButtonResults, sButton)) {
                    button.setDisable(true);
                    button.setStyle(this.nc.s_StyleDisable);
                }
                if (this.s.equals(this.nc.s_ButtonRun, sButton)) {
                    button.setDisable(true);
                    button.setStyle(this.nc.s_StyleDisable);
                }
                if (!this.s.equals(this.nc.s_ButtonReport, sButton)) continue;
                button.setDisable(true);
                button.setStyle(this.nc.s_StyleDisable);
            }
        } else if (this.s.areTheyEqual(sInputType, this.nc.s_Radio_PreviousResults)) {
            this.viCD.setUIInputEditable(false);
            this.repository.setInputEditable(false);
            for (Button button : this.olButton) {
                String sButton = button.getText();
                if (this.s.equals(this.nc.s_ButtonRun, sButton)) {
                    button.setDisable(true);
                    button.setStyle(this.nc.s_StyleDisable);
                    continue;
                }
                if (this.s.equals(this.nc.s_ButtonSave, sButton)) {
                    button.setDisable(true);
                    button.setStyle(this.nc.s_StyleDisable);
                    continue;
                }
                if (this.s.areTheyEqual(this.nc.s_ButtonEdit, sButton)) {
                    button.setDisable(false);
                    button.setStyle(this.nc.s_StyleEnable);
                    button.setText(this.nc.s_ButtonView);
                    continue;
                }
                if (this.s.equals(this.nc.s_ButtonResults, sButton)) {
                    button.setDisable(false);
                    button.setStyle(this.nc.s_StyleEnable);
                    continue;
                }
                if (!this.s.equals(this.nc.s_ButtonReport, sButton)) continue;
                button.setDisable(false);
                button.setStyle(this.nc.s_StyleEnable);
            }
            this.lTopLabel.setText("Here!");
        }
        if (this.ri.checkForInputName("Control")) {
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_IdentificationAndOptions);
            String[] sItem = new String[]{"Site", "SiteLocation", "City", "State", "Analyst", "Affiliation"};
            String[] sDataGroup = new String[]{"Control", "Control", "Control", "Control", "Control", "Control"};
            this.tab.setContent((Node)this.addPane("Identification", sDataGroup, sItem));
            this.tab.setClosable(false);
            this.tp.getTabs().add((Object)this.tab);
        } else {
            this.bAllPresent = false;
        }
        if (this.ri.checkForInputName(constant_STRING)) {
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_BuildingAndFoundation);
            this.tab.setContent((Node)this.addBuildingPane(this.nc.tab_BuildingAndFoundation));
            this.tab.setClosable(false);
            this.tp.getTabs().add((Object)this.tab);
        } else {
            this.bAllPresent = false;
        }
        if (this.ri.checkForInputName("Vadose Zone")) {
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_VadoseZone);
            this.tab.setContent((Node)this.addVadoseZoneOnePane(this.nc.tab_VadoseZone));
            this.tab.setClosable(false);
            this.tp.getTabs().add((Object)this.tab);
        } else {
            this.bAllPresent = false;
        }
        if (this.ri.checkForInputName("Oil Lens")) {
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_OilZone);
            this.tab.setContent((Node)this.addOilLensPane(this.nc.tab_OilZone));
            this.tab.setClosable(false);
            this.tp.getTabs().add((Object)this.tab);
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_OilZoneContinuer);
            this.tab.setContent((Node)this.addOilLensTwoPane(this.nc.tab_OilZoneContinuer));
            this.tab.setClosable(false);
            this.tp.getTabs().add((Object)this.tab);
        } else {
            this.bAllPresent = false;
        }
        if (this.ri.checkForInputName("Aquifer")) {
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_Aquifer);
            this.tab.setContent((Node)this.addAquiferPane(this.nc.tab_Aquifer));
            this.tab.setClosable(false);
            this.tp.getTabs().add((Object)this.tab);
        } else {
            this.bAllPresent = false;
        }
        if (this.ri.checkForInputName("Chemical")) {
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_Chemicals);
            this.tab.setContent((Node)this.addChemicalPane(this.nc.tab_Chemicals));
            this.tab.setClosable(false);
            this.tp.getTabs().add((Object)this.tab);
        } else {
            this.bAllPresent = false;
        }
        if (this.ri.checkForInputName("ScreeningLevel")) {
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_ScreeningLevel);
            this.tab.setContent((Node)this.addScreeningLevelPane(this.nc.tab_ScreeningLevel));
            this.tab.setClosable(false);
            this.repository.setScreeningTab(this.tab);
            this.tp.getTabs().add((Object)this.tab);
        }
        Tab tabSuggested = new Tab();
        tabSuggested.setText(this.nc.tab_SuggestedValues);
        tabSuggested.setClosable(false);
        TabPane tp2 = new TabPane();
        if (this.ri.checkForInputName(constant_STRING)) {
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_AirFlow);
            this.tab.setContent((Node)this.addFoundationPane(this.nc.tab_AirFlow));
            this.tab.setClosable(false);
            tp2.getTabs().add((Object)this.tab);
        }
        if (this.ri.checkForInputName("Control")) {
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_ConcentrationAdjustment);
            this.tab.setContent((Node)this.addConcentrationAdjustmentPane(this.nc.tab_ConcentrationAdjustment));
            this.tab.setClosable(false);
            tp2.getTabs().add((Object)this.tab);
            this.tab = new Tab();
            this.tab.setText(this.nc.tab_Control);
            this.tab.setContent((Node)this.addControlPane(this.nc.tab_Control));
            this.tab.setClosable(false);
            tp2.getTabs().add((Object)this.tab);
        } else {
            this.bAllPresent = false;
        }
        tabSuggested.setContent((Node)tp2);
        this.tp.getTabs().add((Object)tabSuggested);
        this.border.setCenter((Node)this.tp);
        this.repository.setBorder(this.border);
        this.repository.setHboxList(this.alHbox);
    }

    public int addRawInputsToScreenDisplay(GridPane grid, int iIndex, String sTabName, String sName, String sType, String sUnitType) {
        String sInputType = "typical";
        boolean iInvisible = false;
        ArrayList<RawInputLine> riLoad = this.ri.getRawInputLines(sName, sType);
        int iNumber = riLoad.size();
        int i = 0;
        while (i < iNumber) {
            VBox vBox = new VBox();
            RawInputLine ril = riLoad.get(i);
            HBox hBox = this.getInputControl(this.tp, this.tab, sTabName, sName, sType, iIndex, true, 20, ril);
            grid.add((Node)hBox, 0, iIndex);
            this.alHbox.add(hBox);
            ++iIndex;
            ++i;
        }
        return iIndex;
    }

    public ArrayList<RawInputLine> getAllInputs(TabPane tp) {
        ArrayList<RawInputLine> alRawOutputLine = new ArrayList<RawInputLine>();
        ObservableList olTabs = tp.getTabs();
        String sWrite = "";
        String sTabName = "";
        String sName = "";
        String sType = "";
        String sType2 = "";
        String sDistributionType = "";
        String sUnit = "";
        String sComment = "";
        String sHiddenIndex = "";
        String sQualifier = "";
        String sValue = "";
        String sFrequency = "";
        Stripper s = new Stripper();
        String sSuggestedValueOutputDestination = "";
        this.alHbox = this.repository.getHBoxList();
        for (HBox hb : this.alHbox) {
            String[] sRawInput;
            int iCount2 = 0;
            ++iCount2;
            RawInputLine ril = new RawInputLine(this.uc, this.viCD);
            ObservableList olHBoxKids = hb.getChildren();
            String sRawInputType = ((Label)olHBoxKids.get(this.nc.int_INPUTTYPE)).getText();
            try {
                sName = ((Label)olHBoxKids.get(this.nc.int_DATAGROUP)).getText();
                this.nc.getClass();
                sType2 = ((Label)olHBoxKids.get(4)).getText();
                this.nc.getClass();
                sType = ((Label)olHBoxKids.get(5)).getText();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (s.areTheyEqual(this.nc.s_CONTROL2STRING, sRawInputType)) {
                sName = ((Label)olHBoxKids.get(this.nc.int_DATAGROUP - 3)).getText();
                this.nc.getClass();
                sType = ((Label)olHBoxKids.get(4 - 2)).getText();
                this.nc.getClass();
                sValue = ((TextField)olHBoxKids.get(6 - 2)).getText();
                sSuggestedValueOutputDestination = ((Label)olHBoxKids.get(this.nc.int_OUTPUTDESTINATION - 3)).getText();
                sRawInput = new String[]{sName, sType, sValue};
                ril.setRawInputLine(this.nc.s_CONTROL2STRING, sRawInput);
                ril.setOutputDestination(sSuggestedValueOutputDestination);
                alRawOutputLine.add(ril);
            } else if (s.areTheyEqual(this.nc.s_CONTROLSTRINGVALUE, sRawInputType)) {
                sName = ((Label)olHBoxKids.get(this.nc.int_DATAGROUP - 3)).getText();
                this.nc.getClass();
                sType = ((Label)olHBoxKids.get(4 - 2)).getText();
                this.nc.getClass();
                sValue = ((TextField)olHBoxKids.get(6 - 2)).getText();
                sSuggestedValueOutputDestination = ((Label)olHBoxKids.get(this.nc.int_OUTPUTDESTINATION - 3)).getText();
                sRawInput = new String[]{sName, sType, sValue};
                ril.setRawInputLine(this.nc.s_CONTROLSTRINGVALUE, sRawInput);
                ril.setOutputDestination(sSuggestedValueOutputDestination);
                alRawOutputLine.add(ril);
            } else if (s.areTheyEqual(this.nc.s_CONTROL3STRING, sRawInputType)) {
                sName = ((Label)olHBoxKids.get(this.nc.int_DATAGROUP - 3)).getText();
                this.nc.getClass();
                sType = ((Label)olHBoxKids.get(4 - 2)).getText();
                this.nc.getClass();
                sType2 = ((Label)olHBoxKids.get(5 - 2)).getText();
                this.nc.getClass();
                sValue = ((TextField)olHBoxKids.get(6 - 2)).getText();
                sSuggestedValueOutputDestination = ((Label)olHBoxKids.get(this.nc.int_OUTPUTDESTINATION - 3)).getText();
                sRawInput = new String[]{sName, sType, sType2, sValue};
                ril.setRawInputLine(this.nc.s_CONTROL3STRING, sRawInput);
                ril.setOutputDestination(sSuggestedValueOutputDestination);
                alRawOutputLine.add(ril);
            } else if (s.areTheyEqual(this.nc.s_CONTROL2STRINGVALUE, sRawInputType)) {
                sName = ((Label)olHBoxKids.get(this.nc.int_DATAGROUP - 3)).getText();
                this.nc.getClass();
                sType = ((Label)olHBoxKids.get(4 - 2)).getText();
                this.nc.getClass();
                sType2 = ((Label)olHBoxKids.get(5 - 2)).getText();
                this.nc.getClass();
                sValue = ((TextField)olHBoxKids.get(6 - 2)).getText();
                sSuggestedValueOutputDestination = ((Label)olHBoxKids.get(this.nc.int_OUTPUTDESTINATION - 3)).getText();
                sRawInput = new String[]{sName, sType, sType2, sValue};
                ril.setRawInputLine(this.nc.s_CONTROL2STRINGVALUE, sRawInput);
                ril.setOutputDestination(sSuggestedValueOutputDestination);
                alRawOutputLine.add(ril);
            } else if (s.areTheyEqual(this.nc.s_CONTROLSTRINGCHOICE, sRawInputType)) {
                this.nc.getClass();
                sName = ((Label)olHBoxKids.get(6)).getText();
                this.nc.getClass();
                sType = ((Label)olHBoxKids.get(2)).getText();
                this.nc.getClass();
                ComboBox cbChoice = (ComboBox)olHBoxKids.get(4);
                String sChoice = (String)cbChoice.getValue();
                this.nc.getClass();
                sSuggestedValueOutputDestination = ((Label)olHBoxKids.get(8 - 1)).getText();
                String[] sRawInput2 = new String[]{sName, sType, sChoice};
                ril.setRawInputLine(this.nc.s_CONTROLSTRINGCHOICE, sRawInput2);
                ril.setOutputDestination(sSuggestedValueOutputDestination);
                alRawOutputLine.add(ril);
            } else if (!s.areTheyEqual(this.nc.s_CONTROLRISKINPUT, sRawInputType)) {
                ComboBox cbDistribution;
                ComboBox cbUnit;
                if (s.areTheyEqual(this.nc.s_VALUEINPUT, sRawInputType)) {
                    this.nc.getClass();
                    sQualifier = ((Label)olHBoxKids.get(3)).getText();
                    sName = ((Label)olHBoxKids.get(this.nc.int_DATAGROUP)).getText();
                    this.nc.getClass();
                    sType = ((Label)olHBoxKids.get(4)).getText();
                    this.nc.getClass();
                    cbUnit = (ComboBox)olHBoxKids.get(7);
                    sUnit = (String)cbUnit.getValue();
                    this.nc.getClass();
                    cbDistribution = (ComboBox)olHBoxKids.get(2);
                    sDistributionType = (String)cbDistribution.getValue();
                    this.nc.getClass();
                    sValue = ((TextField)olHBoxKids.get(6)).getText();
                    sSuggestedValueOutputDestination = ((Label)olHBoxKids.get(this.nc.int_OUTPUTDESTINATION)).getText();
                } else if (s.areTheyEqual(this.nc.s_CHEMICALINPUT, sRawInputType) || s.areTheyEqual(this.nc.s_CONTROLSCREENINGLEVELINPUT, sRawInputType)) {
                    this.nc.getClass();
                    sQualifier = ((Label)olHBoxKids.get(3)).getText();
                    sName = ((Label)olHBoxKids.get(this.nc.int_DATAGROUP)).getText();
                    this.nc.getClass();
                    sType2 = ((Label)olHBoxKids.get(4)).getText();
                    this.nc.getClass();
                    sType = ((Label)olHBoxKids.get(5)).getText();
                    this.nc.getClass();
                    cbUnit = (ComboBox)olHBoxKids.get(7);
                    sUnit = (String)cbUnit.getValue();
                    this.nc.getClass();
                    cbDistribution = (ComboBox)olHBoxKids.get(2);
                    sDistributionType = (String)cbDistribution.getValue();
                    this.nc.getClass();
                    sValue = ((TextField)olHBoxKids.get(6)).getText();
                    sSuggestedValueOutputDestination = ((Label)olHBoxKids.get(this.nc.int_OUTPUTDESTINATION)).getText();
                }
            }
            double dFrequency = 0.0;
            sFrequency = "0.0";
            if (s.areTheyEqual(this.nc.qual_OneValue, sQualifier)) {
                dFrequency = 1.0;
                sFrequency = "1.0";
                sDistributionType = "Constant";
            } else if (s.areTheyEqual(this.nc.qual_min, sQualifier)) {
                dFrequency = 0.0;
                sFrequency = "0.0";
                sDistributionType = "Variable";
            } else if (s.areTheyEqual(this.nc.qual_max, sQualifier)) {
                dFrequency = 1.0;
                sFrequency = "1.0";
                sDistributionType = "Variable";
            }
            if (s.areTheyEqual(this.nc.s_CHEMICALINPUT, sRawInputType)) {
                sRawInput = new String[]{sName, sType, sDistributionType, sType2, sValue, sUnit, sFrequency};
                ril.setRawInputLine(this.nc.s_CHEMICALINPUT, sRawInput);
                ril.setOutputDestination(sSuggestedValueOutputDestination);
                alRawOutputLine.add(ril);
                continue;
            }
            if (s.areTheyEqual(this.nc.s_CONTROLSCREENINGLEVELINPUT, sRawInputType)) {
                sRawInput = new String[]{sName, sType, sDistributionType, sType2, sValue, sUnit, sFrequency};
                ril.setRawInputLine(this.nc.s_CONTROLSCREENINGLEVELINPUT, sRawInput);
                ril.setOutputDestination(sSuggestedValueOutputDestination);
                alRawOutputLine.add(ril);
                continue;
            }
            if (!s.areTheyEqual(this.nc.s_VALUEINPUT, sRawInputType)) continue;
            sRawInput = new String[]{sName, sType, sDistributionType, sValue, sUnit, sFrequency};
            ril.setRawInputLine(this.nc.s_VALUEINPUT, sRawInput);
            ril.setOutputDestination(sSuggestedValueOutputDestination);
            alRawOutputLine.add(ril);
        }
        return alRawOutputLine;
    }

    public void writeDataFile(FileLogger fl, ArrayList<RawInputLine> alRawOutputLine) {
        ArrayList<String> alSuggestedValue = new ArrayList<String>();
        ArrayList<String> alInputData = new ArrayList<String>();
        String sOutput = "";
        String[] sGroup = new String[]{"Control", constant_STRING, "VadoseZone", "Aquifer", "OilLens", "Oxygen", "Chemical", "Risk", "ScreeningLevel"};
        int i = 0;
        while (i < sGroup.length) {
            int iCount = 0;
            for (RawInputLine ril : alRawOutputLine) {
                sOutput = ril.getOutputLine(sGroup[i]);
                if (sOutput == "") continue;
                ++iCount;
            }
            if (iCount > 0) {
                for (RawInputLine ril : alRawOutputLine) {
                    sOutput = ril.getOutputLine(sGroup[i]);
                    if (sOutput == "") continue;
                    if (this.s.areTheyEqual(this.nc.file_UserChosenFileForOutput, ril.getOutputDestination(), ' ')) {
                        alInputData.add(sOutput);
                        continue;
                    }
                    alSuggestedValue.add(sOutput);
                }
            }
            ++i;
        }
        String[] arrayList = new String[]{""};
        String[] sControl = new String[]{"Control", constant_STRING, "VadoseZone", "Aquifer", "OilLens", "Chemical", "Risk", "ScreeningLevel"};
        int i2 = 0;
        while (i2 < sControl.length) {
            fl.logMessageOverWrite(String.valueOf(sControl[i2]) + ",Begin");
            for (String sOut : alInputData) {
                arrayList = sOut.split(",");
                if (!this.s.areTheyEqual(arrayList[0], sControl[i2], ' ')) continue;
                fl.logMessageOverWrite(sOut);
            }
            fl.logMessageOverWrite(String.valueOf(sControl[i2]) + ",End");
            ++i2;
        }
        FileLogger flSystem = new FileLogger(this.viCD.getInputFileNames().getFile_SuggestedValues());
        flSystem.openOverWriteFile();
        flSystem.logMessageOverWrite("Suggested Value File");
        String[] sControl2 = new String[]{"Control", constant_STRING, "Oxygen", "VadoseZone"};
        int i3 = 0;
        while (i3 < sControl2.length) {
            flSystem.logMessageOverWrite(String.valueOf(sControl2[i3]) + ",Begin");
            for (String sOut : alSuggestedValue) {
                arrayList = sOut.split(",");
                if (!this.s.areTheyEqual(arrayList[0], sControl2[i3], ' ')) continue;
                flSystem.logMessageOverWrite(sOut);
            }
            flSystem.logMessageOverWrite(String.valueOf(sControl2[i3]) + ",End");
            ++i3;
        }
        flSystem.closeOverWriteFile();
    }

    public ScrollPane addBuildingPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        int iIndexBefore = 0;
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "Building Type");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "DirtFloor");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "Width", "Length");
        iIndexBefore = iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "Length", "Length");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "MixingZone/CeilingHeight", "Length");
        if (iIndexBefore == iIndex) {
            iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "CeilingHeight", "Length");
        }
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "FoundationDepthBelowGrade", "Length");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "FoundationThickness", "Length");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "CrackWidth", "Length");
        this.repository.removeAirExchangeRates();
        this.nc.getClass();
        this.nc.getClass();
        this.repository.addAirExchange("Full", "Residential", 0.1, 1.5);
        this.nc.getClass();
        this.nc.getClass();
        this.repository.addAirExchange("High (Drafty)", "Residential", 1.2, 1.5);
        this.nc.getClass();
        this.nc.getClass();
        this.repository.addAirExchange("Moderate", "Residential", 0.3, 1.3);
        this.nc.getClass();
        this.nc.getClass();
        this.repository.addAirExchange("Low (Tight)", "Residential", 0.1, 0.4);
        this.nc.getClass();
        this.nc.getClass();
        this.repository.addAirExchange("Full", "Commercial", 3.0, 10.0);
        this.nc.getClass();
        this.nc.getClass();
        this.repository.addAirExchange("High (Drafty)", "Commercial", 6.5, 10.0);
        this.nc.getClass();
        this.nc.getClass();
        this.repository.addAirExchange("Moderate", "Commercial", 5.0, 8.0);
        this.nc.getClass();
        this.nc.getClass();
        this.repository.addAirExchange("Low (Tight)", "Commercial", 3.0, 6.5);
        iIndex = this.addMultipleControlToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "AirExchangeRate", "AirExchangeRate");
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addFoundationPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "Qsoil", "Discharge");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, constant_STRING, "AirFlowBelowBuilding", "Discharge");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "SoilRespirationRate", "SoilRespirationRate");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oxygen", "DiffusionInAir", "DiffusionCoefficient");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oxygen", "DiffusionInWater", "DiffusionCoefficient");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oxygen", "SurfaceConcentration", "ConcentrationAir");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oxygen", "MinimumBiodegradationConcentration", "ConcentrationAir");
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addScreeningLevelPane(String sTabName) {
        HandlerRiskChoice hrc = new HandlerRiskChoice();
        hrc.setRepository(this.repository);
        this.repository.setHandlerRiskChoice(hrc);
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", this.nc.sRiskESL);
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", this.nc.sRiskTCR);
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", this.nc.sRiskTHQ);
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        for (Chemical c : alChemical) {
            iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "ScreeningLevel", c.getName());
        }
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addVadoseZoneOnePane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "DepthToSample", "Length");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "DepthToWater", "Length");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "DepthToHistoricWaterTable", "Length");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "DepthToBottom", "Length");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "MoistureContent", "MoistureContent");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "Porosity", "Porosity");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "FractionOrganicCarbon", "FractionOrganicCarbon");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "SoilTemperature", "Temperature");
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addVadoseZoneTwoPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "SoilRespirationRate", "SoilRespirationRate");
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addOilLensPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oil Lens", "FuelVolume", "Volume");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oil Lens", "LensLength", "Length");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oil Lens", "LensWidth", "Length");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oil Lens", "MaxOilSaturation", "Saturation");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oil Lens", "ResidualOilSaturation", "Saturation");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oil Lens", "OilWaterInterfacialTension", "InterfacialTension");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oil Lens", "OilDensity", "Density");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Oil Lens", "OilMolecularWeight", "MolecularWeight");
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addOilLensTwoPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "AirEntryHead", "Length");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "ResidualWaterSaturation", "Saturation");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "WaterSurfaceTension", "InterfacialTension");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "Lambda", "Lambda");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Vadose Zone", "TrappedAirSaturation", "Saturation");
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addAquiferPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Aquifer", "HydraulicConductivity", "HydraulicConductivity");
        iIndex = this.addRawInputsToScreenDisplay(gp, iIndex, sTabName, "Aquifer", "Gradient", "Gradient");
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addConcentrationAdjustmentPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "GroundwaterConcentrationFactor");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "SoilSampleConcentrationFactor");
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addControlPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "Bisection");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "OutputUnit");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "max Alpha");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "NumberOfSimulations");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "NumberOfFrequencyDistributionIntervals");
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addExposureFactors(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        boolean iIndex = false;
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addRiskSelection(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        sp.setContent((Node)gp);
        return sp;
    }

    private int addRiskSelectionManager(GridPane gp, int iIndex, String sTabName) {
        iIndex = 0;
        InputControlScreeningLevel icsl = new InputControlScreeningLevel();
        icsl.setInputType(this.nc.s_CONTROLCHEMICALMANAGEMENT);
        icsl.setRepository(this.repository);
        icsl.setTabPane(this.tp);
        icsl.setTab(this.tab);
        icsl.setTabName(sTabName);
        icsl.setIndex(iIndex);
        icsl.setChangeToCome("keep");
        icsl.makeInputControlForAll();
        HBox hBox = icsl.getInputControl();
        gp.add((Node)hBox, 0, iIndex);
        this.alHbox.add(hBox);
        return ++iIndex;
    }

    public int addControlInputsToScreenDisplay(GridPane grid, int iIndex, String sTabName, String sName, String sType) {
        String sInputType = "typical";
        boolean iInvisible = false;
        ArrayList<RawInputLine> riLoad = this.ri.getRawInputLines(sName, sType);
        int iNumber = riLoad.size();
        int i = 0;
        while (i < iNumber) {
            VBox vBox = new VBox();
            RawInputLine ril = riLoad.get(i);
            HBox hBox = this.getInputControl(this.tp, this.tab, sTabName, sName, sType, iIndex, true, this.nc.int_HEIGHT, ril);
            grid.add((Node)hBox, 0, iIndex);
            this.alHbox.add(hBox);
            ++iIndex;
            ++i;
        }
        return iIndex;
    }

    public int addMultipleControlToScreenDisplay(GridPane grid, int iIndex, String sTabName, String sName, String sType, String sUnit) {
        String sInputType = "typical";
        boolean iInvisible = false;
        ArrayList<RawInputLine> riLoad = this.ri.getRawInputLines(sName, sType);
        int iNumber = riLoad.size();
        int i = 0;
        while (i < iNumber) {
            VBox vBox = new VBox();
            RawInputLine ril = riLoad.get(i);
            HBox hBox = this.getInputControl(this.tp, this.tab, sTabName, sName, sType, iIndex, true, this.nc.int_HEIGHT, ril);
            grid.add((Node)hBox, 0, iIndex);
            this.alHbox.add(hBox);
            ++iIndex;
            ++i;
        }
        HBox hBox1 = new HBox();
        hBox1.getStyleClass().add((Object)"hbox");
        ObservableList olNodes = FXCollections.observableArrayList();
        ArrayList<DefaultNameRange> alAirExchange = this.repository.getAirExchange();
        ArrayList<DefaultNameRange> alAirExchangeSelected = new ArrayList<DefaultNameRange>();
        for (DefaultNameRange dnr : alAirExchange) {
            String string = dnr.getBuildingType();
            this.nc.getClass();
            if (!this.s.areTheyEqual(string, "Residential")) continue;
            alAirExchangeSelected.add(dnr);
        }
        olNodes.add((Object)new Text("Insert air exchange rate ranges:"));
        ToggleGroup group = new ToggleGroup();
        for (DefaultNameRange dnr : alAirExchangeSelected) {
            RadioButton b = new RadioButton(dnr.getName());
            b.setToggleGroup(group);
            HandlerDefaultNameRange hdnr = new HandlerDefaultNameRange(dnr.getName(), dnr.getMinimum(), dnr.getMaximum());
            hdnr.setRepository(this.repository);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)hdnr);
            olNodes.add((Object)b);
        }
        hBox1.getChildren().addAll((Collection)olNodes);
        grid.add((Node)hBox1, 0, iIndex);
        return ++iIndex;
    }

    private HBox getInputControl(TabPane tp, Tab tab, String sTabName, String sName, String sLabel, int iIndex, boolean bVisible, int iHeight, RawInputLine ril) {
        InputControlValue ic;
        this.s = new Stripper();
        if (this.s.areTheyEqual(this.nc.s_CONTROLSTRINGCHOICE, ril.getRawInputType())) {
            ic = new InputControlChoice();
        } else {
            ic = new InputControlValue();
            ic.setUnitConverter(this.uc);
        }
        ic.setRepository(this.repository);
        ic.setTabPane(this.tp);
        ic.setTab(this.tab);
        ic.setTabName(sTabName);
        ic.setName(sName);
        ic.setIndex(iIndex);
        ic.setLabel(sLabel);
        ic.setHeight(iHeight);
        ic.setRawInputLine(ril);
        ic.setChangeToCome("keep");
        ic.setUIInputEditable(this.viCD.getUIInputEditable());
        ic.makeInputControlForAll();
        return ic.getInputControl();
    }

    public ScrollPane addIDPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "Site");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "SiteLocation");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "City");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "State");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "Analyst");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "Affiliation");
        iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Control", "OilDistribution");
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addPane(String sTabName, String[] sDataGroup, String[] sItems) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        int iIndex = 0;
        int i = 0;
        while (i < sDataGroup.length) {
            iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, sDataGroup[i], sItems[i]);
            ++i;
        }
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addChemicalPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        int iIndex = 0;
        iIndex = this.addChemicalManager(gp, iIndex, sTabName);
        iIndex = this.addSampleTypeManager(gp, iIndex, sTabName);
        for (Chemical chemical : alChemical) {
            String sChemical = chemical.getName();
            iIndex = this.addControlInputsToScreenDisplay(gp, iIndex, sTabName, "Chemical", sChemical);
        }
        sp.setContent((Node)gp);
        return sp;
    }

    public ScrollPane addRiskPane(String sTabName) {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        int iIndex = 0;
        iIndex = this.addChemicalManager(gp, iIndex, sTabName);
        sp.setContent((Node)gp);
        return sp;
    }

    private int addRiskManager(GridPane gp, int iIndex, String sTabName) {
        InputControlChemicalManager iccm = new InputControlChemicalManager();
        iccm.setInputType(this.nc.s_CONTROLCHEMICALMANAGEMENT);
        iccm.setRepository(this.repository);
        iccm.setTabPane(this.tp);
        iccm.setTab(this.tab);
        iccm.setTabName(sTabName);
        iccm.setIndex(iIndex);
        iccm.setChangeToCome("keep");
        iccm.makeInputControlForAll();
        HBox hBox = iccm.getInputControl();
        gp.add((Node)hBox, 0, iIndex);
        this.alHbox.add(hBox);
        return ++iIndex;
    }

    private int addChemicalManager(GridPane gp, int iIndex, String sTabName) {
        InputControlChemicalManager iccm = new InputControlChemicalManager();
        iccm.setInputType(this.nc.s_CONTROLCHEMICALMANAGEMENT);
        iccm.setRepository(this.repository);
        iccm.setTabPane(this.tp);
        iccm.setTab(this.tab);
        iccm.setTabName(sTabName);
        iccm.setIndex(iIndex);
        iccm.setChangeToCome("keep");
        iccm.makeInputControlForAll();
        HBox hBox = iccm.getInputControl();
        gp.add((Node)hBox, 0, iIndex);
        this.alHbox.add(hBox);
        return ++iIndex;
    }

    private int addSampleTypeManager(GridPane gp, int iIndex, String sTabName) {
        InputControlChemicalSampleTypeManager iccstm = new InputControlChemicalSampleTypeManager();
        iccstm.setInputType(this.nc.s_ControlChemicalSampleTypeManager);
        iccstm.setRepository(this.repository);
        iccstm.setTabPane(this.tp);
        iccstm.setTab(this.tab);
        iccstm.setTabName(sTabName);
        iccstm.setIndex(iIndex);
        iccstm.setChangeToCome("keep");
        iccstm.makeInputControlForAll();
        HBox hBox = iccstm.getInputControl();
        gp.add((Node)hBox, 0, iIndex);
        this.alHbox.add(hBox);
        return ++iIndex;
    }

    private int addInputEstimation(GridPane gp, int iIndex, String sTabName) {
        InputControlInputEstimationManager iciem = new InputControlInputEstimationManager();
        iciem.setRepository(this.repository);
        iciem.setTabPane(this.tp);
        iciem.setTab(this.tab);
        iciem.setTabName(sTabName);
        iciem.setIndex(iIndex);
        iciem.setChangeToCome("keep");
        iciem.makeInputControlForAll();
        HBox hBox = iciem.getInputControl();
        gp.add((Node)hBox, 0, iIndex);
        this.alHbox.add(hBox);
        return ++iIndex;
    }

    public ScrollPane addDataNotPresentPane() {
        ScrollPane sp = new ScrollPane();
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"grid");
        sp.setContent((Node)gp);
        return sp;
    }

    public HBox getNavigationControl() {
        HBox hbo = new HBox();
        hbo.getStyleClass().add((Object)"hbox");
        Button bPrev = new Button("< Previous");
        bPrev.setPrefSize(100.0, 20.0);
        Button bSave = new Button("Save");
        bSave.setPrefSize(100.0, 20.0);
        bSave.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent ae) {
                FileLogger fl = new FileLogger("testOutputFileCreation.csv");
                ArrayList<RawInputLine> alRawOutputLine = new ArrayList();
                alRawOutputLine = HandlerEdit.this.getAllInputs(HandlerEdit.this.tp);
                HandlerEdit.this.writeDataFile(fl, alRawOutputLine);
            }
        });
        Button bNext = new Button("Next >");
        bNext.setPrefSize(100.0, 20.0);
        hbo.setAlignment(Pos.CENTER);
        hbo.getChildren().addAll((Object[])new Node[]{bPrev, bSave, bNext});
        return hbo;
    }

    public void removeTabs() {
        ObservableList olTabs = null;
        if (this.tp != null) {
            olTabs = this.tp.getTabs();
        }
        if (olTabs != null) {
            try {
                for (Tab tab : olTabs) {
                    this.tp.getTabs().remove((Object)tab);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setButton(Button buttonEdit) {
        this.buttonEdit = buttonEdit;
    }

    public void setHandlerRepository(Repository repository) {
        this.repository = repository;
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setTopLabel(Label lTopLabel) {
        this.lTopLabel = lTopLabel;
    }

    public TabPane getTabPane() {
        return this.tp;
    }

    public ArrayList<HBox> getAllHBox() {
        return this.alHbox;
    }

    @Override
    public String getHandlerName() {
        return sHandlerName;
    }
}

