/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import java.util.ArrayList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.stage.Stage;
import ui.Repository;
import ui.SelectATemplate;
import ui.WrappedRadioButton;
import ui.WriteTemplateFile;
import ui.handler.HandlerInput;
import util.ClipPathOrFile;
import util.NameConstants;

public class HandlerFetchTemplate
implements EventHandler {
    private static final String sHandlerName = "FetchTemplate";
    private Stage stage;
    private HandlerInput hi;
    private String sFileName;
    private String sDirectory;
    private ArrayList<WrappedRadioButton> alWRBSelected;
    private ArrayList<ToggleGroup> alToggleGroup;
    private Repository repository;
    private NameConstants nc;
    private WriteTemplateFile wtf;
    private SelectATemplate sat;
    private TextField tfProjectName;

    public HandlerFetchTemplate(Stage stage) {
        this.stage = stage;
        this.alWRBSelected = new ArrayList();
        this.wtf = new WriteTemplateFile();
        this.nc = new NameConstants();
    }

    public void handle(Event event) {
        for (ToggleGroup tg : this.alToggleGroup) {
            WrappedRadioButton rbSelected = new WrappedRadioButton();
            Toggle tSelected = tg.getSelectedToggle();
            try {
                rbSelected = (WrappedRadioButton)tSelected;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (rbSelected == null) continue;
            this.alWRBSelected.add(rbSelected);
        }
        this.repository.setSpecifiedDirectoryStem(this.sat.getDirectoryName());
        this.repository.setSpecifiedFileStem(new ClipPathOrFile().clipPathOrFile(this.sat.getProjectName(), "stem"));
        this.wtf.setRepository(this.repository);
        this.wtf.setTextFieldProjectName(this.tfProjectName);
        try {
            this.wtf.createTemplate(this.alWRBSelected, this.sat.getDirectoryName(), this.sat.getProjectName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hi.handle(event);
    }

    public void setSelectATemplate(SelectATemplate sat) {
        this.sat = sat;
    }

    public void setFileName(String sFileName) {
        this.sFileName = sFileName;
    }

    public void setDirectory(String sDirectory) {
        this.sDirectory = sDirectory;
    }

    public void setToggleGroup(ArrayList<ToggleGroup> alToggleGroup) {
        this.alToggleGroup = alToggleGroup;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setHandlerInput(HandlerInput hi) {
        this.hi = hi;
    }

    public void setTextFieldProjectName(TextField tfProjectName) {
        this.tfProjectName = tfProjectName;
    }

    public String getHandlerName() {
        return sHandlerName;
    }
}

