/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import java.io.IOException;
import javafx.event.Event;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.stage.Stage;
import ui.Repository;
import ui.SelectAFile;
import ui.SelectATemplate;
import ui.handler.WrappedEventHandler;
import util.NameConstants;
import util.Stripper;

public class HandlerInput
extends WrappedEventHandler {
    private static final String sHandlerName = "Input";
    private Stage stage;
    private Repository repository;
    private ComboBox cbChemical;
    private Label lTopLabel;
    private boolean bJustCreatedANewFile = false;
    private ToggleGroup tgRadioButton;

    public HandlerInput(Stage stage) {
        this.stage = stage;
    }

    @Override
    public void handle(Event event) {
        this.repository.setSelectAFile(this.isThereAnExistingFileToRead());
        if (this.repository.getSelectAFile() || this.bJustCreatedANewFile) {
            SelectAFile saf = new SelectAFile();
            saf.setChemicalComboBox(this.cbChemical);
            saf.setHandlerRepository(this.repository);
            saf.setTopLabel(this.lTopLabel);
            saf.handleSelectAFile(event);
            this.repository.setSelectAFile(false);
            this.bJustCreatedANewFile = false;
        } else {
            SelectATemplate sat = new SelectATemplate();
            sat.setChemicalComboBox(this.cbChemical);
            sat.setRepository(this.repository);
            sat.setTopLabel(this.lTopLabel);
            sat.setHandlerInput(this);
            try {
                sat.selectATemplate(this.stage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.bJustCreatedANewFile = true;
        }
    }

    private boolean isThereAnExistingFileToRead() {
        boolean bReturn = true;
        Stripper s = new Stripper();
        NameConstants nc = new NameConstants();
        RadioButton tgSelected = (RadioButton)this.tgRadioButton.getSelectedToggle();
        if (s.areTheyEqual(nc.s_Radio_Template, tgSelected.getText())) {
            bReturn = false;
        }
        return bReturn;
    }

    public void setHandlerRepository(Repository repository) {
        this.repository = repository;
    }

    public void setTopLabel(Label lTopLabel) {
        this.lTopLabel = lTopLabel;
    }

    public void setChemicalComboBox(ComboBox cbChemical) {
        this.cbChemical = cbChemical;
    }

    public void setRadioButtonToggleGroup(ToggleGroup tgRadioButton) {
        this.tgRadioButton = tgRadioButton;
    }

    @Override
    public String getHandlerName() {
        return sHandlerName;
    }
}

