/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import pviScreen.dataContainers.ParameterChoices;
import pviScreen.dataContainers.RawInputLine;
import pviScreen.dataContainers.VIControlData;
import ui.AddToTheGridPane;
import ui.Repository;
import ui.VIUIInputData;
import ui.handler.HandlerEdit;
import util.FileLogger;
import util.FileModifier;
import util.NameConstants;
import util.Stripper;

public class HandlerPrepareForRun
implements EventHandler {
    private static final String sHandlerName = "PrepareForRun";
    private Stage stage;
    private Button b;
    private Label lTopLabel;
    private Repository repository;
    private HandlerEdit he;
    private boolean bInputFileSet;
    private String sInputFile;
    private String sInputFileAndPath;
    private String sCurrentDirectory;
    private String sInitialDirectory;
    private String sActiveDirectory;
    private VIControlData viControlData;
    private ParameterChoices pc;
    private ObservableList<Button> olButton;
    private NameConstants nc;
    private Stripper s;

    public HandlerPrepareForRun(Stage stage) {
        this.stage = stage;
    }

    public void handle(Event arg0) {
        this.viControlData = this.repository.getVIControlData();
        this.viControlData.addToMessageOutput(this.viControlData.getMessageOutput(), String.valueOf(this.getClass().getName()) + " HandlerPrepareForRun");
        this.bInputFileSet = this.repository.getInputFileFlagSet();
        boolean bInputChanged = this.repository.getEditControlChanged();
        this.olButton = this.repository.getButtonList();
        this.nc = new NameConstants();
        this.s = new Stripper();
        this.pc = this.viControlData.getParameterChoices();
        this.lTopLabel.setText("Press " + this.nc.s_ButtonRun + " to run " + this.repository.getInputFileAndPath());
        if (bInputChanged) {
            this.sActiveDirectory = this.repository.getDirectory();
            FileChooser fc = new FileChooser();
            fc.setTitle("Save Changes To Input Data?");
            fc.setInitialFileName(this.repository.getInputFile());
            String sInputExtension = "*." + this.nc.s_Extension_Input;
            fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PVIScreen ", new String[]{sInputExtension}));
            if (this.sActiveDirectory == "") {
                this.sInitialDirectory = "projects";
                try {
                    ArrayList<String> alInitialDirectory = this.pc.getValue("Project Directory", 1);
                    this.sInitialDirectory = alInitialDirectory.get(0);
                }
                catch (Exception alInitialDirectory) {
                    // empty catch block
                }
                try {
                    this.sCurrentDirectory = new File(".").getCanonicalPath();
                    this.sCurrentDirectory = String.valueOf(this.sCurrentDirectory) + "//" + this.sInitialDirectory;
                }
                catch (Exception alInitialDirectory) {}
            } else {
                this.sCurrentDirectory = this.sActiveDirectory;
            }
            this.viControlData.addToMessageOutput(this.viControlData.getMessageOutput(), String.valueOf(this.getClass().getName()) + ",Found Path," + this.sCurrentDirectory);
            fc.setInitialDirectory(new File(this.sCurrentDirectory));
            File fInputFile = null;
            fInputFile = fc.showSaveDialog((Window)this.stage);
            if (fInputFile == null) {
                return;
            }
            this.sInputFile = fInputFile.getName();
            this.sInputFileAndPath = fInputFile.getPath();
            this.sActiveDirectory = fInputFile.getParent();
            this.repository.setDirectory(this.sActiveDirectory);
            FileLogger fl = new FileLogger(this.sInputFileAndPath);
            ArrayList<RawInputLine> alRawOutputLine = new ArrayList();
            TabPane tp = this.he.getTabPane();
            alRawOutputLine = this.he.getAllInputs(tp);
            fl.openOverWriteFile();
            this.he.writeDataFile(fl, alRawOutputLine);
            fl.closeOverWriteFile();
        } else {
            this.sInputFile = this.repository.getInputFile();
            this.sInputFileAndPath = this.repository.getInputFileAndPath();
            this.sActiveDirectory = this.repository.getDirectory();
        }
        FileModifier fm = new FileModifier();
        this.nc.getClass();
        this.sInputFile = fm.getOutputFileAndPathName(this.sInputFile, "", 1, this.nc.s_Extension_Input, false);
        this.nc.getClass();
        this.sInputFileAndPath = fm.getOutputFileAndPathName(this.sInputFileAndPath, "", 1, this.nc.s_Extension_Input, false);
        TabPane tp = this.he.getTabPane();
        this.viControlData.clearRiskLevels();
        this.viControlData.addToMessageOutput(this.viControlData.getMessageOutput(), String.valueOf(this.getClass().getName()) + "," + "Risk Levels Cleared");
        this.removeErrorTab(tp);
        this.viControlData.checkData();
        if (this.viControlData.getCanRunModel()) {
            this.repository.setInputFile(this.sInputFile);
            this.repository.setInputFileAndPath(this.sInputFileAndPath);
            VIUIInputData viUIInputData = this.repository.getPVIScreenUIInputData();
            viUIInputData.setFileAndPathName(this.sInputFileAndPath);
            try {
                viUIInputData.readInputData();
                this.repository.clearPreviousPVIScreenControlData();
                this.repository.setVIControlData(viUIInputData.getPVIScreenControlData());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.he.redisplayData();
            this.olButton = this.repository.getButtonList();
            this.s = new Stripper();
            for (Button button : this.olButton) {
                String sButton = button.getText();
                if (this.s.areTheyEqual(this.nc.s_ButtonSchematic, sButton)) {
                    button.fire();
                    button.requestFocus();
                }
                if (!this.s.areTheyEqual(this.nc.s_ButtonRun, sButton)) continue;
                button.setDisable(false);
                button.setStyle(this.nc.s_StyleEnable);
            }
        } else {
            this.addTabForErrors(this.viControlData.getKnownErrors(), tp);
        }
    }

    private void addTabForErrors(ArrayList<String> alKnownErrors, TabPane tp) {
        Tab tab = new Tab();
        tab.setText(this.nc.tab_InputError);
        AddToTheGridPane attgp = new AddToTheGridPane();
        GridPane gpTop = new GridPane();
        ScrollPane sp = new ScrollPane();
        int iCount = 0;
        int iSpacer = 10;
        iCount = attgp.addBlankLines(gpTop, 5, iCount, iSpacer);
        for (String sKnownError : alKnownErrors) {
            sKnownError = this.cleanErrorMessages(sKnownError);
            iCount = attgp.addTextLines(gpTop, sKnownError, new HBox(new Node[]{new Text("")}), iCount, iSpacer);
        }
        iCount = attgp.addBlankLines(gpTop, 5, iCount, iSpacer);
        sp.setContent((Node)gpTop);
        tab.setContent((Node)sp);
        tab.setClosable(false);
        tp.getTabs().add((Object)tab);
        tp.getSelectionModel().select((Object)tab);
    }

    private void addTabForMessages(String sMessages, TabPane tp) {
        Tab tab = new Tab();
        tab.setText(this.nc.tab_Message);
        sMessages = this.cleanErrorMessages(sMessages);
        tab.setContent((Node)this.addKnownError(sMessages));
        tab.setClosable(false);
        tp.getTabs().add((Object)tab);
        tp.getSelectionModel().select((Object)tab);
    }

    private String cleanErrorMessages(String sKnownErrors) {
        return sKnownErrors;
    }

    private ScrollPane addKnownError(String sKnownError) {
        AddToTheGridPane attgp = new AddToTheGridPane();
        GridPane gpTop = new GridPane();
        ScrollPane sp = new ScrollPane();
        int iCount = 0;
        int iSpacer = 10;
        iCount = attgp.addBlankLines(gpTop, 5, iCount, iSpacer);
        iCount = attgp.addTextLines(gpTop, sKnownError, new HBox(new Node[]{new Text("")}), iCount, iSpacer);
        iCount = attgp.addBlankLines(gpTop, 5, iCount, iSpacer);
        sp.setContent((Node)gpTop);
        return sp;
    }

    private void removeErrorTab(TabPane tp) {
        ObservableList olTab = tp.getTabs();
        for (Tab tab : olTab) {
            String sTabText = tab.getText();
            if (!this.s.areTheyEqual(this.nc.tab_InputError, sTabText)) continue;
            tp.getTabs().remove((Object)tab);
            break;
        }
    }

    public void setButton(Button b) {
        this.b = b;
    }

    public void setHandlerRepository(Repository repository) {
        this.repository = repository;
    }

    public void setHandlerEdit(HandlerEdit he) {
        this.he = he;
    }

    public void setTopLabel(Label lTopLabel) {
        this.lTopLabel = lTopLabel;
    }

    public String getHandlerName() {
        return sHandlerName;
    }
}

