/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import pviScreen.dataContainers.ParameterChoices;
import pviScreen.dataContainers.VIControlData;
import ui.ReportWriter;
import ui.Repository;
import ui.handler.HandlerSitePlot;
import ui.handler.WrappedEventHandler;
import util.FileLogger;
import util.NameConstants;
import util.Stripper;

public class HandlerReport
extends WrappedEventHandler {
    private FileLogger flReport;
    private Repository repository;
    private WebEngine we;
    private WebView wv;
    private BorderPane bp;
    private String sURL;
    private Label lTopLabel;
    private ReportWriter reportWriter;
    private boolean bInputFileSet;
    private boolean bInputTypeSetFlag;
    private String sOutputFileAndPath;
    private String sInputFileAndPath;
    private Task pviScreenReportWriter;
    private VIControlData viCD;
    private ParameterChoices pc;
    private HandlerSitePlot hSitePlot;
    private NameConstants nc;

    @Override
    public void handle(Event e) {
        this.sURL = "";
        this.reportWriter = new ReportWriter();
        this.nc = new NameConstants();
        Stripper s = new Stripper();
        this.viCD = this.repository.getVIControlData();
        this.pviScreenReportWriter = this.writePVIScreenReport();
        this.lTopLabel.setText(" ");
        this.pviScreenReportWriter.messageProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                HandlerReport.this.lTopLabel.setText("Writing Report");
            }
        });
        new Thread((Runnable)this.pviScreenReportWriter).start();
    }

    public Task writePVIScreenReport() {
        return new Task(){

            protected Object call() throws Exception {
                Stripper s = new Stripper();
                String sStatus = "Starting to Write Report";
                this.updateMessage(sStatus);
                HandlerReport.this.reportWriter = new ReportWriter();
                HandlerReport.this.reportWriter.setHandlerSitePlot(HandlerReport.this.hSitePlot);
                HandlerReport.this.reportWriter.setInputFileAndPath(HandlerReport.this.sInputFileAndPath);
                HandlerReport.this.reportWriter.setOutputFileAndPath(HandlerReport.this.sOutputFileAndPath);
                HandlerReport.this.reportWriter.setHandlerRepository(HandlerReport.this.repository);
                HandlerReport.this.reportWriter.prepareGraphics();
                HandlerReport.this.sInputFileAndPath = HandlerReport.this.repository.getInputFileAndPath();
                HandlerReport.this.sOutputFileAndPath = HandlerReport.this.repository.getFilePathAndNameResults();
                HandlerReport.this.viCD.addToMessageOutput(HandlerReport.this.viCD.getMessageOutput(), "Output File and Path: " + HandlerReport.this.sOutputFileAndPath);
                String sTemp = HandlerReport.this.reportWriter.getReportFileName(HandlerReport.this.sOutputFileAndPath);
                HandlerReport.this.repository.setFilePathAndNameHTML(sTemp);
                HandlerReport.this.flReport = new FileLogger(sTemp);
                HandlerReport.this.flReport.openOverWriteFile();
                HandlerReport.this.reportWriter.setFileLogger(HandlerReport.this.flReport);
                HandlerReport.this.reportWriter.startWritingReport();
                HandlerReport.this.reportWriter.writeReportHeadings();
                HandlerReport.this.reportWriter.writePVIScreenParagraph();
                HandlerReport.this.reportWriter.writeRunIdentification();
                HandlerReport.this.reportWriter.writeIOInformation();
                HandlerReport.this.reportWriter.writeSiteSchmatic();
                HandlerReport.this.reportWriter.writeSourceDefinition();
                HandlerReport.this.reportWriter.writeScreeningLevelTable();
                HandlerReport.this.reportWriter.writeStatisticsOfOutputParagraph();
                HandlerReport.this.reportWriter.generateHeadingsForStatistics();
                HandlerReport.this.reportWriter.writeStatisticsOfOutput("PVIScreen");
                HandlerReport.this.reportWriter.writeStatisticsOfOutput("JEM");
                HandlerReport.this.reportWriter.writeDifferenceBetweenPVIScreenAndJEM(false);
                HandlerReport.this.reportWriter.writeDifferenceBetweenPVIScreenAndJEM(true);
                HandlerReport.this.reportWriter.writeInputData();
                HandlerReport.this.reportWriter.writeChemicalInput();
                HandlerReport.this.reportWriter.writeChemicalData();
                HandlerReport.this.reportWriter.endReport();
                HandlerReport.this.flReport.closeOverWriteFile();
                sStatus = "PVIScreen Report Completed";
                this.updateMessage(sStatus);
                try {
                    HandlerReport.this.viCD = HandlerReport.this.repository.getVIControlData();
                    HandlerReport.this.pc = HandlerReport.this.viCD.getParameterChoices();
                    String sFileAndPath = HandlerReport.this.repository.getFilePathAndNameHTML();
                    String sBrowser = HandlerReport.this.viCD.getBrowserName();
                    ArrayList<String> alBrowser = HandlerReport.this.pc.getValue(((HandlerReport)HandlerReport.this).nc.s_BROWSER, 1);
                    ArrayList<String> alBrowserCommand = HandlerReport.this.pc.getValue(((HandlerReport)HandlerReport.this).nc.s_BROWSER, 2);
                    String sBrowserCommand = "";
                    sBrowserCommand = "\\Program Files (x86)\\Internet Explorer\\iexplore.exe";
                    int iSize = alBrowser.size();
                    int i = 0;
                    while (i < iSize) {
                        if (s.areTheyEqual(sBrowser, alBrowser.get(i))) {
                            sBrowserCommand = alBrowserCommand.get(i);
                            break;
                        }
                        ++i;
                    }
                    Process p = Runtime.getRuntime().exec(String.valueOf(sBrowserCommand) + " " + sFileAndPath);
                    p.waitFor();
                }
                catch (IOException e1) {
                    BorderPane border = HandlerReport.this.repository.getBorder();
                    double dCanvasWidth = 1000.0;
                    double dCanvasHeight = 400.0;
                    Canvas c = new Canvas(dCanvasWidth, dCanvasHeight);
                    GraphicsContext gc = c.getGraphicsContext2D();
                    gc.setStroke((Paint)Color.BLACK);
                    gc.setFill((Paint)Color.BLACK);
                    gc.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)14.0));
                    gc.fillText("PVIScreen cannot display your report in a browser.", 5.0, 20.0);
                    gc.fillText("Your report can be found at:", 5.0, 40.0);
                    gc.fillText(HandlerReport.this.repository.getFilePathAndNameHTML(), 5.0, 60.0);
                    gc.fillText("Include the browser path and name in file PVISCreen\\ui\\systemData\\05Preferences.csv", 5.0, 100.0);
                    border.setCenter((Node)c);
                    HandlerReport.this.stage.show();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    HandlerReport.this.openFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        };
    }

    private void openFile() throws IOException {
        String sInitialDirectory = "";
        FileChooser fc = this.repository.getFileChooser();
        fc = new FileChooser();
        this.viCD = this.repository.getVIControlData();
        this.pc = this.viCD.getParameterChoices();
        try {
            ArrayList<String> alInitialDirectory = this.pc.getValue("Project Directory", 1);
            sInitialDirectory = alInitialDirectory.get(0);
        }
        catch (Exception alInitialDirectory) {
            // empty catch block
        }
        fc.setTitle("PVIScreen File Input");
        try {
            String sCurrentDirectory = new File(".").getCanonicalPath();
            String sActiveDirectory = this.repository.getDirectory();
            sCurrentDirectory = sActiveDirectory != "" ? sActiveDirectory : String.valueOf(sCurrentDirectory) + "\\" + sInitialDirectory;
            fc.setInitialDirectory(new File(sCurrentDirectory));
        }
        catch (Exception exception) {
            // empty catch block
        }
        fc.setTitle("PVIScreen HTML Output");
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("HTML Results   ", new String[]{"*." + this.nc.s_Extension_HTML}));
        File fInputFile = fc.showOpenDialog((Window)this.stage);
    }

    public void setHandlerRepository(Repository repository) {
        this.repository = repository;
    }

    public void setURL(String sURL) {
        this.sURL = sURL;
    }

    public void setTopLabel(Label lTopLabel) {
        this.lTopLabel = lTopLabel;
    }

    public void setInputFileAndPath(String sInputFileAndPath) {
        this.sInputFileAndPath = sInputFileAndPath;
    }

    public void setOutputFileAndPath(String sOutputFileAndPath) {
        this.sOutputFileAndPath = sOutputFileAndPath;
    }

    public void setHandlerSitePlot(HandlerSitePlot hSitePlot) {
        this.hSitePlot = hSitePlot;
    }
}

