/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import jem.JEMMain;
import pviScreen.PVIScreenMain;
import pviScreen.VIModelController;
import pviScreen.dataContainers.VIControlData;
import ui.ProgressIndication;
import ui.Repository;
import util.NameConstants;
import util.Stripper;

public class HandlerRun
implements EventHandler {
    private static final String sHandlerName = "Run";
    private Stage stage;
    private String sFilePathAndNameResults;
    private String sFilePathAndNameStatistics;
    private String sStatus;
    private String sInputFile;
    private String sInputFileAndPath;
    private boolean bInputFileSet;
    private VIModelController viMC;
    private VIControlData viCD;
    private Repository repository;
    private Label lTopLabel;
    private NameConstants nc;
    private Stripper s;
    private ObservableList<Button> olButton;
    private ProgressIndication pi;
    private int iProgressCount;
    private int iProgressTotal;

    public HandlerRun(Stage stage) {
        this.stage = stage;
        this.bInputFileSet = false;
    }

    public void handle(Event event) {
        this.nc = new NameConstants();
        this.s = new Stripper();
        this.bInputFileSet = this.repository.getInputFileFlagSet();
        this.viCD = this.repository.getVIControlData();
        try {
            BorderPane border = this.repository.getBorder();
            GridPane grid = null;
            FileInputStream fis = new FileInputStream("src/systemData/PVIScreenSchematic.jpg");
            Image imagePVIS = new Image((InputStream)fis);
            ImageView iv = new ImageView(imagePVIS);
            HBox hbImage = new HBox();
            hbImage.setAlignment(Pos.CENTER);
            hbImage.getChildren().add((Object)iv);
            grid = new GridPane();
            this.pi = new ProgressIndication();
            grid.add((Node)this.pi.create(), 1, 4);
            grid.setAlignment(Pos.CENTER);
            grid.setPrefSize(this.nc.pref_WIDTH, this.nc.pref_HEIGHT);
            border.setCenter((Node)grid);
        }
        catch (Exception border) {
            // empty catch block
        }
        if (this.bInputFileSet) {
            this.iProgressCount = 0;
            this.iProgressTotal = 5;
            this.lTopLabel.setText("Running");
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    HandlerRun.this.olButton = HandlerRun.this.repository.getButtonList();
                    HandlerRun.this.sInputFile = HandlerRun.this.repository.getInputFile();
                    HandlerRun.this.sInputFileAndPath = HandlerRun.this.repository.getInputFileAndPath();
                    try {
                        HandlerRun.this.sStatus = "Updating Data";
                        HandlerRun handlerRun = HandlerRun.this;
                        int n = handlerRun.iProgressCount;
                        handlerRun.iProgressCount = n + 1;
                        this.updateProgress(n, HandlerRun.this.iProgressTotal);
                        this.updateMessage(HandlerRun.this.sStatus);
                        HandlerRun.this.viMC.readInputData(HandlerRun.this.sInputFileAndPath);
                        HBox hbox = new HBox();
                        HandlerRun.this.sStatus = "Updating Data Complete--" + HandlerRun.this.viCD.getNumberOfRuns() + " BioVapor Runs Beginning";
                        HandlerRun handlerRun2 = HandlerRun.this;
                        int n2 = handlerRun2.iProgressCount;
                        handlerRun2.iProgressCount = n2 + 1;
                        this.updateProgress(n2, HandlerRun.this.iProgressTotal);
                        this.updateMessage(HandlerRun.this.sStatus);
                        PVIScreenMain pvisMain = HandlerRun.this.viMC.getPVIScreenMain();
                        pvisMain.setVIControlData(HandlerRun.this.viMC.getVIControlData());
                        HandlerRun.this.viCD.addToMessageOutput(HandlerRun.this.viCD.getMessageOutput(), HandlerRun.this.sStatus);
                        for (Button button : HandlerRun.this.olButton) {
                            String sButton = button.getText();
                            if (!HandlerRun.this.s.areTheyEqual(((HandlerRun)HandlerRun.this).nc.s_ButtonRun, sButton)) continue;
                            button.setDisable(true);
                            button.setStyle(((HandlerRun)HandlerRun.this).nc.s_StyleExecuting);
                        }
                        this.updateMessage(HandlerRun.this.sStatus);
                        pvisMain.runAnInputSetFromGUI();
                        HandlerRun.this.sStatus = "BioVapor Calculation Complete";
                        HandlerRun handlerRun3 = HandlerRun.this;
                        int n3 = handlerRun3.iProgressCount;
                        handlerRun3.iProgressCount = n3 + 1;
                        this.updateProgress(n3, HandlerRun.this.iProgressTotal);
                        this.updateMessage(HandlerRun.this.sStatus);
                        pvisMain.requestOutputProcessing();
                        HandlerRun.this.sStatus = "BioVapor PostProcessing Complete";
                        HandlerRun handlerRun4 = HandlerRun.this;
                        int n4 = handlerRun4.iProgressCount;
                        handlerRun4.iProgressCount = n4 + 1;
                        this.updateProgress(n4, HandlerRun.this.iProgressTotal);
                        this.updateMessage(HandlerRun.this.sStatus);
                        HandlerRun.this.viCD.addToMessageOutput(HandlerRun.this.viCD.getMessageOutput(), HandlerRun.this.sStatus);
                        HandlerRun.this.sFilePathAndNameResults = pvisMain.getOutputFileName();
                        HandlerRun.this.repository.setFilePathAndNameResults(HandlerRun.this.sFilePathAndNameResults);
                        HandlerRun.this.repository.setFileResultsNameFlagSet(true);
                        HandlerRun.this.viCD.addToMessageOutput(HandlerRun.this.viCD.getMessageOutput(), "Output file time: " + pvisMain.getOutputFileTime());
                        HandlerRun.this.repository.getVIControlData().setOutputFileTimeStamp(pvisMain.getOutputFileTime());
                        HandlerRun.this.viCD.addToMessageOutput(HandlerRun.this.viCD.getMessageOutput(), HandlerRun.this.sStatus);
                        JEMMain jemMain = HandlerRun.this.viMC.getJEMMain();
                        jemMain.setVIControlData(HandlerRun.this.viMC.getVIControlData());
                        jemMain.runAnInputSetFromGUI(HandlerRun.this.sInputFileAndPath);
                        HandlerRun.this.sStatus = String.valueOf(HandlerRun.this.viCD.getNumberOfRuns()) + " JEM Model Runs Complete";
                        HandlerRun handlerRun5 = HandlerRun.this;
                        int n5 = handlerRun5.iProgressCount;
                        handlerRun5.iProgressCount = n5 + 1;
                        this.updateProgress(n5, HandlerRun.this.iProgressTotal);
                        this.updateMessage(HandlerRun.this.sStatus);
                        jemMain.requestOutputProcessing();
                        HandlerRun.this.sStatus = "JEM Post Processing Complete";
                        HandlerRun handlerRun6 = HandlerRun.this;
                        int n6 = handlerRun6.iProgressCount;
                        handlerRun6.iProgressCount = n6 + 1;
                        this.updateProgress(n6, HandlerRun.this.iProgressTotal);
                        this.updateMessage(HandlerRun.this.sStatus);
                        for (Button button : HandlerRun.this.olButton) {
                            String sButton = button.getText();
                            if (HandlerRun.this.s.areTheyEqual(((HandlerRun)HandlerRun.this).nc.s_ButtonRun, sButton)) {
                                button.setDisable(false);
                                button.setStyle(((HandlerRun)HandlerRun.this).nc.s_StyleEnable);
                            }
                            if (!HandlerRun.this.s.areTheyEqual(((HandlerRun)HandlerRun.this).nc.s_ButtonResults, sButton)) continue;
                            button.setDisable(false);
                            button.setStyle(((HandlerRun)HandlerRun.this).nc.s_StyleEnable);
                            button.fire();
                            button.requestFocus();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                }
            };
            task.setOnFailed(wse -> wse.getSource().getException().printStackTrace());
            task.setOnSucceeded(wse -> System.out.println("Done!"));
            this.pi.getProgressBar().progressProperty().bind((ObservableValue)task.progressProperty());
            this.pi.getProgressIndicator().progressProperty().bind((ObservableValue)task.progressProperty());
            this.pi.getProgressIndicationLabel().textProperty().bind((ObservableValue)task.messageProperty());
            new Thread((Runnable)task).start();
        }
        this.stage.show();
    }

    public void setVIModelController(VIModelController VIMC) {
        this.viMC = VIMC;
    }

    public void setInputDataSetFlag(boolean b) {
        this.bInputFileSet = b;
    }

    public void setInputFile(String sInputFile) {
        this.sInputFile = sInputFile;
    }

    public void setInputFileAndPath(String s) {
        this.sInputFileAndPath = s;
    }

    public void setHandlerRepository(Repository repository) {
        this.repository = repository;
    }

    public void setTopLabel(Label lTopLabel) {
        this.lTopLabel = lTopLabel;
    }

    public String getHandlerName() {
        return sHandlerName;
    }
}

