/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import util.Stripper;
import util.UnitConverter;

public class HandlerSampleTypeDialog
implements EventHandler {
    private static final String sHandlerName = "SampleTypeDialog";
    private String sUnitType;
    private UnitConverter uc;
    private ArrayList<String> alSampleType;
    private ComboBox cbUnit;
    private ComboBox cbSampleType;

    public void handle(Event arg0) {
        Stripper s = new Stripper();
        String sTypeSelected = (String)this.cbSampleType.getValue();
        String sUnitSelected = "";
        int iUnitIndexUnit = 0;
        if (s.areTheyEqual("Soil Gas", sTypeSelected)) {
            this.sUnitType = "ConcentrationAir";
            sUnitSelected = "ug/m3";
        } else if (s.areTheyEqual("Ground Water", sTypeSelected)) {
            this.sUnitType = "ConcentrationWater";
            sUnitSelected = "mg/l";
        }
        ArrayList<String> alUnitNames = this.uc.getAllUnitNamesForAType(this.sUnitType);
        for (String sUnit : alUnitNames) {
            if (!s.areTheyEqual(sUnitSelected, sUnit)) continue;
            iUnitIndexUnit = alUnitNames.indexOf(sUnit);
        }
        ObservableList optionsUnit = FXCollections.observableArrayList(alUnitNames);
        this.cbUnit.setItems(optionsUnit);
        this.cbUnit.setValue((Object)alUnitNames.get(iUnitIndexUnit));
    }

    public void setUnitConverter(UnitConverter uc) {
        this.uc = uc;
    }

    public void setAllSampleType(ArrayList<String> alSampleType) {
        this.alSampleType = alSampleType;
    }

    public void setSampleTypeComboBox(ComboBox cbSampleType) {
        this.cbSampleType = cbSampleType;
    }

    public void setUnitComboBox(ComboBox cbUnit) {
        this.cbUnit = cbUnit;
    }

    public String getHandlerName() {
        return sHandlerName;
    }
}

