/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Label;
import javafx.stage.Stage;
import pviScreen.dataContainers.VIControlData;
import ui.DrawSchematic;
import ui.Repository;
import util.FileModifier;
import util.NameConstants;

public class HandlerSitePlot
implements EventHandler {
    private static final String sHandlerName = "SitePlot";
    private Stage stage;
    private Label lTopLabel;
    private Repository repository;
    private VIControlData pvisCD;
    private NameConstants nc;

    public HandlerSitePlot(Stage stage) {
        this.stage = stage;
        this.nc = new NameConstants();
    }

    public void handle(Event e) {
        DrawSchematic ds = new DrawSchematic();
        ds.setStageGeometry(this.stage.getHeight(), this.stage.getWidth());
        ds.setStage(this.stage);
        ds.setRepository(this.repository);
        ds.drawSchematic();
        ds.displayTheScene(this.stage);
        FileModifier fm = new FileModifier();
        String sPNGFileName = fm.getOutputFileAndPathName(this.repository.getInputFileAndPath(), " " + this.repository.getVIControlData().getOutputFileTimeStamp(), 1, this.nc.s_Extension_PNG_Schematic, false);
        ds.writeTheImageToAFile(sPNGFileName);
    }

    public void setRepository(Repository r) {
        this.repository = r;
    }

    public void setTopLabel(Label lTopLabel) {
        this.lTopLabel = lTopLabel;
    }

    public String getHandlerName() {
        return sHandlerName;
    }
}

