/*
 * Decompiled with CFR 0.152.
 */
package ui.handler;

import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javax.imageio.ImageIO;
import pviScreen.dataContainers.Chemical;
import pviScreen.dataContainers.ParameterChoices;
import pviScreen.dataContainers.VIControlData;
import statistics.Histogram;
import statistics.Interval;
import statistics.RiskContainer;
import ui.ChartAnnotationOverlay;
import ui.LegendThatWorks;
import ui.ReadOutputForResults;
import ui.Repository;
import util.NameConstants;
import util.OutputFormatter;
import util.Stripper;
import util.UnitConverter;

public class HandlerStatisticsPlot
implements EventHandler {
    private static final String sHandlerName = "StatisticsPlot";
    private Stage stage;
    private TabPane tp;
    private Tab tab;
    private ScrollPane sp;
    private Repository repository;
    private VIControlData viCD;
    private UnitConverter uc;
    private RiskContainer rc;
    private ParameterChoices pc;
    private BorderPane border;
    private boolean bInputFileSet;
    private boolean bInputTypeSetFlag;
    private boolean bChosenChemicalSetFlag;
    private String sInputType;
    private String sInputFile;
    private String sInputPath;
    private String sFilePathAndNameStatistics;
    private String sChosenChemical;
    private Label lTopLabel;
    private LegendThatWorks ltw;
    private NameConstants nc;
    private Stripper s;
    private ObservableList<Button> olButton;
    private ChartAnnotationOverlay cao;
    private OutputFormatter ou;
    private String sOutputUnit;
    private static final String FILE_STATISTICS = "Statistics";
    private static final String C_EXTENSION = " Indoor Air Concentration";

    public HandlerStatisticsPlot(Stage stage) {
        this.stage = stage;
        this.bInputFileSet = false;
        this.s = new Stripper();
        this.ou = new OutputFormatter();
    }

    public void handle(Event event) {
        this.viCD = this.repository.getVIControlData();
        this.pc = this.viCD.getParameterChoices();
        this.uc = this.viCD.getUnitConverter();
        this.border = this.repository.getBorder();
        this.sp = new ScrollPane();
        this.tp = new TabPane();
        ArrayList<Chemical> alChemical = this.viCD.getChemicals();
        for (Chemical chemical : alChemical) {
            if (!chemical.getIsUsedInSimulation()) continue;
            Tab tab = new Tab();
            StackPane sp = new StackPane();
            GridPane gp = new GridPane();
            ColumnConstraints column1 = new ColumnConstraints(600.0);
            column1.setHgrow(Priority.ALWAYS);
            ColumnConstraints column2 = new ColumnConstraints(300.0);
            gp.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
            String sName = chemical.getName();
            tab.setText(sName);
            LineChart<Number, Number> lcStatistics = this.drawStatistics(chemical, sName, true, true, true);
            int iLegendPosition = 0;
            if (lcStatistics != null) {
                lcStatistics.setAnimated(false);
                lcStatistics.setMaxHeight(0.75 * this.stage.getHeight());
                lcStatistics.setMaxWidth(0.67 * this.stage.getWidth());
                sp.getChildren().addAll((Object[])new Node[]{lcStatistics, this.cao});
                gp.add((Node)sp, 0, 0);
                iLegendPosition = 1;
            }
            Canvas cLegend = this.getLegendCanvas();
            gp.add((Node)cLegend, iLegendPosition, 0);
            tab.setContent((Node)gp);
            Tab tabWrite = tab;
            try {
                WritableImage snapshot = tabWrite.getContent().snapshot(new SnapshotParameters(), null);
                String sFileName = this.repository.getFilePathAndNameResults();
                String sFilePNG = String.valueOf(sFileName) + "." + tabWrite.getText() + ".png";
                File outFile = new File(sFilePNG);
                try {
                    ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)snapshot, null), "png", outFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.repository.addOutputImage(snapshot);
                this.repository.addOutputImageName(tabWrite.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            tab.setClosable(false);
            this.tp.getTabs().add((Object)tab);
        }
        this.border = this.repository.getBorder();
        this.border.setCenter((Node)this.tp);
        this.repository.setStatisticsTabPane(this.tp);
        this.stage.show();
        this.olButton = this.repository.getButtonList();
        this.s = new Stripper();
        this.nc = new NameConstants();
        for (Button button : this.olButton) {
            String sButton = button.getText();
            if (!this.s.equals(this.nc.s_ButtonReport, sButton)) continue;
            button.setDisable(false);
            button.setStyle(this.nc.s_StyleEnable);
        }
    }

    public LineChart<Number, Number> drawStatistics(Chemical chemical, String sChosenChemical, boolean bDisplayGraphic, boolean bSaveRisk, boolean bSaveGraphic) {
        boolean bHistogramExist = false;
        LineChart<Number, Number> lcForReturn = null;
        this.rc = this.repository.getRiskContainer();
        this.sFilePathAndNameStatistics = this.repository.getFilePathAndNameResults();
        this.viCD = this.repository.getVIControlData();
        try {
            Histogram h = new Histogram();
            String sChemical = String.valueOf(sChosenChemical) + C_EXTENSION;
            h.readHistogram(this.sFilePathAndNameStatistics, sChemical, "Log Intervals");
            bHistogramExist = h.doesHistogramExist();
            if (bHistogramExist) {
                String sHistogramChemical = this.getHistogramChemical(h.getHistogramChemical());
                lcForReturn = this.createStatisticsOutput(chemical, this.sFilePathAndNameStatistics, sChosenChemical, h, this.rc, bDisplayGraphic, bSaveRisk, bSaveRisk);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lcForReturn;
    }

    public LineChart<Number, Number> createStatisticsOutput(Chemical chemical, String sFilePathAndName, String sChosenChemical, Histogram h, RiskContainer rc, boolean bDisplayGraphic, boolean bSaveRisk, boolean bSaveGraphic) throws IOException {
        boolean bAllResultsLessThanCancerRisk = false;
        boolean bAllResultsLessThanNonCancerRisk = false;
        boolean bAllResultsLessThanScreeningLevel = false;
        boolean bDrawChart = false;
        double dCancerLevelForSaving = 0.0;
        double dHazardLevelForSaving = 0.0;
        double dScreeningLevelForSaving = 0.0;
        int iColorForSaving = 0;
        boolean iSeriesForSaving = false;
        String sOutputUnit = null;
        int iCountSeries = 0;
        String[] sConcernColor = new String[]{"#333333", "#333333", "#333333"};
        double dMinXAxis = -5.0;
        double dMaxXAxis = 2.0;
        ParameterChoices pc = this.viCD.getParameterChoices();
        try {
            ArrayList<Object> alParameterChoices = new ArrayList();
            alParameterChoices = pc.getValue("MinimumXAxis", 1);
            dMinXAxis = Double.parseDouble((String)alParameterChoices.get(0));
            alParameterChoices = new ArrayList();
            alParameterChoices = pc.getValue("MaximumXAxis", 1);
            dMaxXAxis = Double.parseDouble((String)alParameterChoices.get(0));
        }
        catch (Exception e) {
            dMinXAxis = -5.0;
            dMaxXAxis = 2.0;
        }
        bDrawChart = false;
        for (Interval interval : h.getHistogramIntervals()) {
            double dConc = interval.getMidPointValue();
            if (!(dMinXAxis <= dConc) || !(dConc <= dMaxXAxis)) continue;
            bDrawChart = true;
        }
        String sName = h.getHistogramChemical();
        ScrollPane sp = new ScrollPane();
        this.ltw = new LegendThatWorks();
        ArrayList<Object> alInterval = new ArrayList();
        XYChart.Series xyDataRiskLevel = new XYChart.Series();
        XYChart.Series xyScreeningLevel = new XYChart.Series();
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        xAxis.setLabel("Log Indoor Air Concentration (Log10 " + h.getOutputUnit() + ")");
        yAxis.setLabel("Frequency");
        yAxis.setTickUnit(0.1);
        LineChart statisticsChart = new LineChart((Axis)xAxis, (Axis)yAxis);
        statisticsChart.setLegendVisible(false);
        statisticsChart.setCreateSymbols(false);
        statisticsChart.setTitle("PVIScreen Result for " + h.getHistogramTitle());
        this.ltw.setName(h.getHistogramChemical());
        XYChart.Series[] xyCumulative = new XYChart.Series[3];
        xyCumulative[0] = new XYChart.Series();
        xyCumulative[0].setName("");
        xyCumulative[1] = new XYChart.Series();
        xyCumulative[1].setName("");
        xyCumulative[2] = new XYChart.Series();
        xyCumulative[2].setName("");
        XYChart.Series xyDataDensity = new XYChart.Series();
        xyDataDensity.setName("Probability Density");
        this.ltw.addTextAnnotation(String.valueOf(h.getHistogramChemical()) + " risks/hazards", 0);
        double dHistogramColorChangeLevel = 1.0E308;
        double dCumulativeProbability = h.getCumulativeProbability(dHistogramColorChangeLevel, true);
        double[] dColorLow = new double[]{dCumulativeProbability, 0.0, 0.0};
        double[] dColorHigh = new double[]{1.0, dCumulativeProbability, 0.0};
        int iSize = alInterval.size();
        this.repository.setColorLow(dColorLow);
        this.repository.setColorHigh(dColorHigh);
        double dCFMax = -1.0;
        alInterval = h.getHistogramIntervals();
        int j = 0;
        while (j < dColorHigh.length) {
            iSize = alInterval.size();
            double dConc = h.getValueForCumulativeFrequency(dColorLow[j]);
            if (dMinXAxis <= dConc && dConc <= dMaxXAxis) {
                xyCumulative[j].getData().add((Object)new XYChart.Data((Object)dConc, (Object)dColorLow[j]));
            }
            int ii = 0;
            while (ii < iSize) {
                double dCF;
                Interval interval = (Interval)alInterval.get(ii);
                dConc = interval.getMidPointValue();
                if (dMinXAxis <= dConc && dConc <= dMaxXAxis && dColorLow[j] < (dCF = interval.getCumulativeFrequency()) && dCF <= dColorHigh[j]) {
                    if (dCF > dCFMax) {
                        dCFMax = dCF;
                        iColorForSaving = j;
                    }
                    xyCumulative[j].getData().add((Object)new XYChart.Data((Object)dConc, (Object)dCF));
                }
                ++ii;
            }
            dConc = h.getValueForCumulativeFrequency(dColorHigh[j]);
            if (dMinXAxis < dConc && dConc <= dMaxXAxis) {
                xyCumulative[j].getData().add((Object)new XYChart.Data((Object)dConc, (Object)dColorHigh[j]));
            }
            statisticsChart.getData().addAll((Object[])new XYChart.Series[]{xyCumulative[j]});
            this.setColor(statisticsChart, iCountSeries, sConcernColor[j]);
            if (xyCumulative[j].getName() != "") {
                this.ltw.addLegendItem(true, xyCumulative[j].getName(), sConcernColor[j], 4);
            }
            ++iCountSeries;
            ++j;
        }
        this.cao = new ChartAnnotationOverlay((LineChart<Number, Number>)statisticsChart);
        boolean iRiskCount = false;
        boolean bAddC = true;
        ArrayList<Double> alRiskLevel = this.viCD.getRiskLevels();
        if (chemical.getScreeningLevelSet()) {
            try {
                dScreeningLevelForSaving = chemical.getScreeningLevel();
                sOutputUnit = h.getOutputUnit();
                h.determineCumulativeProbabilityOfTheLevelOfConcern(dScreeningLevelForSaving /= this.uc.getUCF("ConcentrationAir", sOutputUnit));
                double dSelectedFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
                double dPerCentAboveRiskLevel = (1.0 - dSelectedFrequency) * 100.0;
                if (dPerCentAboveRiskLevel < 1.0E-4) {
                    dPerCentAboveRiskLevel = 0.0;
                }
                if (bSaveRisk) {
                    rc.addScreeningRisk(sName, true, dScreeningLevelForSaving, dPerCentAboveRiskLevel);
                }
                xyScreeningLevel = new XYChart.Series();
                xyScreeningLevel.setName(String.valueOf(this.ou.getFormattedString(dPerCentAboveRiskLevel)) + "% Exceed the Screening Level of " + this.ou.getFormattedString(dScreeningLevelForSaving) + " " + sOutputUnit);
                int iColor = 0;
                if (dMinXAxis <= Math.log10(dScreeningLevelForSaving) && Math.log10(dScreeningLevelForSaving) <= dMaxXAxis) {
                    xyScreeningLevel.getData().add((Object)new XYChart.Data((Object)Math.log10(dScreeningLevelForSaving), (Object)(dSelectedFrequency - 0.04)));
                    xyScreeningLevel.getData().add((Object)new XYChart.Data((Object)Math.log10(dScreeningLevelForSaving), (Object)dSelectedFrequency));
                    xyScreeningLevel.getData().add((Object)new XYChart.Data((Object)Math.log10(dScreeningLevelForSaving), (Object)(dSelectedFrequency + 0.04)));
                    statisticsChart.getData().addAll((Object[])new XYChart.Series[]{xyScreeningLevel});
                    int j2 = 0;
                    while (j2 < dColorHigh.length) {
                        if (dColorLow[j2] <= dSelectedFrequency && dSelectedFrequency <= dColorHigh[j2]) {
                            this.setColor(statisticsChart, iCountSeries, sConcernColor[j2]);
                            iColor = j2;
                            break;
                        }
                        ++j2;
                    }
                }
                this.ltw.addLegendItem(false, xyScreeningLevel.getName(), sConcernColor[iColor], 2);
                ++iCountSeries;
                iCountSeries = this.addSForScreening(statisticsChart, iCountSeries, "#000000", Math.log10(dScreeningLevelForSaving), dSelectedFrequency + 0.12, false);
            }
            catch (Exception iColor) {
                // empty catch block
            }
        }
        int iLength = alInterval.size();
        double[] dScreening = new double[]{dScreeningLevelForSaving, dCancerLevelForSaving, dHazardLevelForSaving};
        double dMaxLevel = -1.0;
        int i = 0;
        while (i < dScreening.length) {
            if (dMaxLevel < dScreening[i]) {
                dMaxLevel = dScreening[i];
            }
            ++i;
        }
        double dIntervalLevel = ((Interval)alInterval.get(iLength - 1)).getMidPointValue();
        if (dMinXAxis <= Math.log10(dMaxLevel) && Math.log10(dMaxLevel) <= dMaxXAxis && dIntervalLevel < Math.log10(dMaxLevel)) {
            XYChart.Series xyAdditional = new XYChart.Series();
            xyAdditional.getData().add((Object)new XYChart.Data((Object)dIntervalLevel, (Object)1.0));
            xyAdditional.getData().add((Object)new XYChart.Data((Object)Math.log10(dMaxLevel), (Object)1.0));
            statisticsChart.getData().addAll((Object[])new XYChart.Series[]{xyAdditional});
            this.setColor(statisticsChart, iCountSeries, sConcernColor[iColorForSaving]);
            ++iCountSeries;
        }
        String[] sOutputStatistics = new String[]{"Minimum", "5th Percentile", "First Quartile", "Median", "Third Quartile", "95th Percentile", "Maximum"};
        double[] dOutputStatistics = new double[sOutputStatistics.length];
        ReadOutputForResults rofr = new ReadOutputForResults();
        rofr.setFileAndPathName(sFilePathAndName);
        rofr.setModelName("PVIScreen");
        dOutputStatistics = rofr.getOutputStatisticsUsingStandardCategories(sChosenChemical);
        sOutputUnit = rofr.getOutputUnit();
        int k = 0;
        while (k < sOutputStatistics.length) {
            int kk = sOutputStatistics.length - 1 - k;
            this.ltw.addLegendItem(false, String.valueOf(sOutputStatistics[kk]) + " " + this.ou.getFormattedString(dOutputStatistics[kk]) + " " + sOutputUnit, "#999999", 5);
            ++k;
        }
        double dAveragedParameterResult = rofr.getSingleParameterResult(sChosenChemical, "AveragedParameterResult", sFilePathAndName);
        double dLogAPR = Math.log10(dAveragedParameterResult);
        h.determineCumulativeProbabilityOfTheLevelOfConcern(dAveragedParameterResult);
        double dAveragedCumulativeFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
        double dPerCentAboveAveragedParameterSolution = (1.0 - dAveragedCumulativeFrequency) * 100.0;
        if (dPerCentAboveAveragedParameterSolution < 1.0E-4) {
            dPerCentAboveAveragedParameterSolution = 0.0;
        }
        this.ltw.addLegendItem(false, "AveragedParameter Result: " + this.ou.getFormattedString(dAveragedParameterResult) + " " + h.getOutputUnit(), "#770077", 5);
        this.ltw.addLegendItem(false, "  (which is exceeded by " + this.ou.getFormattedString(dPerCentAboveAveragedParameterSolution) + " % of simulations)", "#999999", 5);
        statisticsChart.setAnimated(false);
        bSaveGraphic = false;
        if (bSaveGraphic) {
            WritableImage snapshot = statisticsChart.snapshot(new SnapshotParameters(), null);
            this.repository.addOutputImage(snapshot);
        }
        this.cao.update();
        if (!bDrawChart) {
            return null;
        }
        return statisticsChart;
    }

    private void setColor(LineChart lc, int iCountSeries, String sColor) {
        LineChart lc2 = lc;
        int iCountSeries2 = iCountSeries;
        String sColor2 = sColor;
        Set nodes = lc.lookupAll(".series" + iCountSeries);
        for (Node n : nodes) {
            StringBuilder style = new StringBuilder();
            style.append("-fx-stroke: " + sColor + "; -fx-background-color: " + sColor + ", " + sColor + "; ");
            n.setStyle(style.toString());
        }
    }

    private int addCForCancer(LineChart lc, int iCountSeries, String sColor, double dXCenter, double dYTop, boolean bAdd) {
        XYChart.Series xyCForCancer = new XYChart.Series();
        xyCForCancer = new XYChart.Series();
        xyCForCancer.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.09), (Object)dYTop));
        xyCForCancer.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.09), (Object)(dYTop - 0.05)));
        lc.getData().addAll(new Object[]{xyCForCancer});
        this.setColor(lc, iCountSeries, sColor);
        ++iCountSeries;
        xyCForCancer = new XYChart.Series();
        xyCForCancer.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.09), (Object)dYTop));
        xyCForCancer.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.09), (Object)dYTop));
        lc.getData().addAll(new Object[]{xyCForCancer});
        this.setColor(lc, iCountSeries, sColor);
        ++iCountSeries;
        xyCForCancer = new XYChart.Series();
        xyCForCancer.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.09), (Object)(dYTop - 0.05)));
        xyCForCancer.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.09), (Object)(dYTop - 0.05)));
        lc.getData().addAll(new Object[]{xyCForCancer});
        this.setColor(lc, iCountSeries, sColor);
        ++iCountSeries;
        xyCForCancer.setName("\"C\" indicates specified cancer risk level");
        if (bAdd) {
            this.ltw.addLegendItem(false, xyCForCancer.getName(), sColor, 1);
        }
        return iCountSeries;
    }

    private int addHForHazard(LineChart lc, int iCountSeries, String sColor, double dXCenter, double dYTop, boolean bAdd) {
        XYChart.Series xyHForHazard = new XYChart.Series();
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.09), (Object)(dYTop - 0.06)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.09), (Object)dYTop));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.08), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.07), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.06), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.05), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.04), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.03), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.02), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.01), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)dXCenter, (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.01), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.02), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.03), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.04), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.05), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.06), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.07), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.08), (Object)(dYTop - 0.03)));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.09), (Object)dYTop));
        xyHForHazard.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.09), (Object)(dYTop - 0.06)));
        xyHForHazard.setName("\"H\" indicates specified hazard quotient");
        lc.getData().addAll(new Object[]{xyHForHazard});
        this.setColor(lc, iCountSeries, sColor);
        ++iCountSeries;
        if (bAdd) {
            this.ltw.addLegendItem(false, xyHForHazard.getName(), sColor, 3);
        }
        return iCountSeries;
    }

    private int addSForScreening(LineChart lc, int iCountSeries, String sColor, double dXCenter, double dYTop, boolean bAdd) {
        XYChart.Series xySForScreening = new XYChart.Series();
        xySForScreening.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.09), (Object)dYTop));
        xySForScreening.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.09), (Object)dYTop));
        xySForScreening.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.09), (Object)(dYTop - 0.06)));
        xySForScreening.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.09), (Object)(dYTop - 0.06)));
        xySForScreening.setName("\"L\" indicates screening level");
        lc.getData().addAll(new Object[]{xySForScreening});
        this.setColor(lc, iCountSeries, sColor);
        ++iCountSeries;
        if (bAdd) {
            this.ltw.addLegendItem(false, xySForScreening.getName(), sColor, 3);
        }
        return iCountSeries;
    }

    private int addAForAveragedParameterSolution(LineChart lc, int iCountSeries, String sColor, double dXCenter, double dYTop, boolean bAdd) {
        XYChart.Series xyAForAveragedParameterSolution = new XYChart.Series();
        xyAForAveragedParameterSolution.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.09), (Object)dYTop));
        xyAForAveragedParameterSolution.getData().add((Object)new XYChart.Data((Object)dXCenter, (Object)(dYTop - 0.06)));
        xyAForAveragedParameterSolution.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.09), (Object)dYTop));
        lc.getData().addAll(new Object[]{xyAForAveragedParameterSolution});
        this.setColor(lc, iCountSeries, sColor);
        ++iCountSeries;
        xyAForAveragedParameterSolution.setName("\"V\" indicates averaged-parameter solution");
        Text text = new Text(dXCenter, dYTop, "D");
        text.setFont(new Font(20.0));
        if (bAdd) {
            this.ltw.addLegendItem(false, xyAForAveragedParameterSolution.getName(), sColor, 5);
        }
        return iCountSeries;
    }

    private int addMForMaximumProbabilityResult(LineChart lc, int iCountSeries, String sColor, double dXCenter, double dYTop, boolean bAdd) {
        XYChart.Series xyMForMaximumProbabilityResult = new XYChart.Series();
        xyMForMaximumProbabilityResult.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.15), (Object)dYTop));
        xyMForMaximumProbabilityResult.getData().add((Object)new XYChart.Data((Object)(dXCenter + 0.15), (Object)(dYTop - 0.05)));
        xyMForMaximumProbabilityResult.getData().add((Object)new XYChart.Data((Object)dXCenter, (Object)(dYTop - 0.03)));
        xyMForMaximumProbabilityResult.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.15), (Object)(dYTop - 0.05)));
        xyMForMaximumProbabilityResult.getData().add((Object)new XYChart.Data((Object)(dXCenter - 0.15), (Object)dYTop));
        xyMForMaximumProbabilityResult.setName("\"M\" indicates maximum probability result");
        lc.getData().addAll(new Object[]{xyMForMaximumProbabilityResult});
        this.setColor(lc, iCountSeries, sColor);
        if (bAdd) {
            this.ltw.addLegendItem(false, xyMForMaximumProbabilityResult.getName(), sColor, 5);
        }
        return ++iCountSeries;
    }

    private String getHistogramChemical(String sTitleString) {
        Stripper s = new Stripper();
        String sChemical = "";
        int iEnd = 0;
        int i = 0;
        while (i < sTitleString.length()) {
            if (sTitleString.charAt(i) == ' ' && i > 1) {
                iEnd = i;
                break;
            }
            ++i;
        }
        if (iEnd == 0) {
            iEnd = sTitleString.length();
        }
        i = 0;
        while (i < iEnd) {
            sChemical = String.valueOf(sChemical) + sTitleString.charAt(i);
            ++i;
        }
        sChemical = s.removeCharacter(' ', sChemical);
        return sChemical;
    }

    private Canvas getLegendCanvas() {
        double dCanvasWidth = 0.5 * this.stage.getWidth();
        double dCanvasHeight = 0.75 * this.stage.getHeight();
        Canvas cReturn = new Canvas(dCanvasWidth, dCanvasHeight);
        GraphicsContext gc = cReturn.getGraphicsContext2D();
        gc.setLineWidth(5.0);
        double dY = 25.0;
        double dX = 20.0;
        double dXHalf = 5.0;
        double dYHalf = 5.0;
        double dYStart = 20.0;
        double dXBar = 300.0;
        double dNoneMoreOpaque = 1.0;
        double dXLoc = 100.0;
        double dYLoc = dYStart;
        int iItems = this.ltw.getCount();
        int j = 0;
        while (j < this.ltw.getLevelMax() + 1) {
            String sOut1 = this.ltw.getTextAnnotation(j);
            if (!sOut1.equalsIgnoreCase("")) {
                gc.setStroke((Paint)new Color(0.0, 0.0, 0.0, dNoneMoreOpaque));
                gc.setLineWidth(1.0);
                gc.setFont(Font.font((String)"SanSerif", (FontWeight)FontWeight.BLACK, (double)14.0));
                gc.fillText(sOut1, dXLoc + dX + dXHalf, dYLoc + dYHalf);
                gc.strokeLine(dXLoc, dYLoc += 2.0 * dYHalf, dXLoc + dXBar, dYLoc);
                dYLoc += dY;
            }
            int i = 0;
            while (i < iItems) {
                if (this.ltw.getLevel(i) == j) {
                    String sColor = this.ltw.getColor(i);
                    dNoneMoreOpaque = 1.0;
                    String sColorRed = sColor.substring(1, 3);
                    String sColorGreen = sColor.substring(3, 5);
                    String sColorBlue = sColor.substring(5, 7);
                    int iColorRed = Integer.parseInt(sColorRed, 16);
                    int iColorGreen = Integer.parseInt(sColorGreen, 16);
                    int iColorBlue = Integer.parseInt(sColorBlue, 16);
                    Color color = new Color((double)iColorRed / 255.0, (double)iColorGreen / 255.0, (double)iColorBlue / 255.0, dNoneMoreOpaque);
                    if (this.ltw.getDrawLine(i)) {
                        gc.setStroke((Paint)color);
                        gc.setLineWidth(5.0);
                        gc.strokeLine(dXLoc, dYLoc, dXLoc + dX, dYLoc);
                    }
                    String sOut2 = this.ltw.getText(i);
                    gc.setStroke((Paint)new Color(0.25, 0.25, 0.25, dNoneMoreOpaque));
                    gc.setLineWidth(1.0);
                    gc.setFont(Font.font((String)"SanSerif", (double)12.0));
                    gc.fillText(sOut2, dXLoc + dX + dXHalf, dYLoc + dYHalf);
                    dYLoc += dY;
                }
                ++i;
            }
            ++j;
        }
        return cReturn;
    }

    private boolean checkFileType(String sFile, String sTypeToCheck) throws IOException {
        boolean bMatch = false;
        String[] lineArray = new String[]{""};
        FileReader fr = new FileReader(sFile);
        BufferedReader br = new BufferedReader(fr);
        String currentLine = br.readLine();
        lineArray = currentLine.split(",", 0);
        if (lineArray[0].equalsIgnoreCase("Control") && lineArray[1].equalsIgnoreCase(sTypeToCheck)) {
            bMatch = true;
        }
        return bMatch;
    }

    private void modifyColorLimits(ParameterChoices pc, double[] dColorLow, double[] dColorHigh, boolean bUseHighestProbability, double dHighestProbability) {
        ArrayList<String> alTypes = pc.getValue("ColorCoding", 1);
        ArrayList<String> alChoices = pc.getValue("ColorCoding", 2);
        int iSize = alTypes.size();
        String sString = "";
        int i = 0;
        while (i < iSize) {
            sString = alTypes.get(i);
            if (this.s.areTheyEqual("Red-Yellow", sString)) {
                if (this.s.areTheyEqual("Highest Probability", alChoices.get(i))) {
                    if (bUseHighestProbability) {
                        dColorLow[1] = dHighestProbability;
                        dColorHigh[0] = dHighestProbability;
                    }
                } else {
                    try {
                        double dNew;
                        dColorLow[1] = dNew = Double.parseDouble(alChoices.get(i));
                        dColorHigh[0] = dNew;
                    }
                    catch (Exception dNew) {}
                }
            } else if (this.s.areTheyEqual("Yellow-Green", sString)) {
                if (this.s.areTheyEqual("Highest Probability", alChoices.get(i))) {
                    if (bUseHighestProbability) {
                        dColorLow[2] = dHighestProbability;
                        dColorHigh[1] = dHighestProbability;
                    }
                } else {
                    try {
                        double dNew;
                        dColorLow[2] = dNew = Double.parseDouble(alChoices.get(i));
                        dColorHigh[1] = dNew;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    public void setFileAndPathNameStatistics(String s) {
        this.sFilePathAndNameStatistics = s;
    }

    public void setChemical(String s) {
        this.sChosenChemical = s;
    }

    public void setHandlerRepository(Repository repository) {
        this.repository = repository;
    }

    public void setTopLabel(Label lTopLabel) {
        this.lTopLabel = lTopLabel;
    }

    public String getHandlerName() {
        return sHandlerName;
    }
}

