/*
 * Decompiled with CFR 0.152.
 */
package uncertaintyAnalysis;

import numerics.sort.QuickSort;
import uncertaintyAnalysis.RandomNumber;

public class StatisticalDistribution {
    private String sName;
    private String sDistributionType;
    private String sParentName;
    private String sCalculationUnit;
    private int nPts;
    private int iMaxPts;
    private double[] f;
    private double[] c;
    private double cValue;
    private int nSimulation;
    private int[] iOrder;
    private int cLHSInterval;
    private int nLHSInterval;
    private double dCF;
    private double chosenFrequency;
    private int chosenIndex;
    private StatisticalDistribution sdCompanion;
    private double dMiddleValue;
    private QuickSort qs;
    private boolean bActuallyUsed;
    private RandomNumber random;

    public StatisticalDistribution() {
        this.initial();
    }

    public void initial() {
        this.nPts = 0;
        this.iMaxPts = 100;
        this.f = new double[this.iMaxPts];
        this.c = new double[this.iMaxPts];
        this.cValue = 0.0;
        this.qs = new QuickSort();
        this.sDistributionType = "Empirical";
        this.bActuallyUsed = false;
    }

    public void clear() {
        this.initial();
    }

    public void addAPoint(double value, double frequency) {
        this.c[this.nPts] = value;
        this.f[this.nPts] = frequency;
        ++this.nPts;
    }

    public void generateNormalDistribution(double dMean, double dStandardDeviation) {
        this.addAPoint(dMean - 4.0 * dStandardDeviation, 0.0);
        this.addAPoint(dMean - 3.0 * dStandardDeviation, 0.0013);
        this.addAPoint(dMean - 2.0 * dStandardDeviation, 0.0227);
        this.addAPoint(dMean - 1.0 * dStandardDeviation, 0.1587);
        this.addAPoint(dMean - 0.0 * dStandardDeviation, 0.5);
        this.addAPoint(dMean + 1.0 * dStandardDeviation, 0.8413);
        this.addAPoint(dMean + 2.0 * dStandardDeviation, 0.9773);
        this.addAPoint(dMean + 3.0 * dStandardDeviation, 0.9987);
        this.addAPoint(dMean + 4.0 * dStandardDeviation, 1.0);
        this.setDistributionType("Normal");
    }

    public void generateTriangularDistribution(double dMin, double dLikely, double dMax) {
        this.addAPoint(dMin, 0.0);
        int iNpts = this.iMaxPts;
        double dx = (dMax - dMin) / (double)iNpts;
        double dDenom = (dMax - dMin) * (dLikely - dMin);
        int i = 1;
        while (i < iNpts) {
            double x = dMin + dx * (double)i;
            if (x < dLikely) {
                this.addAPoint(x, Math.pow(x - dMin, 2.0) / dDenom);
            } else {
                this.addAPoint(x, 1.0 - Math.pow(dMax - x, 2.0) / dDenom);
            }
            ++i;
        }
        this.addAPoint(dMax, 1.0);
        this.addAPoint(dLikely, Math.pow(dLikely - dMin, 2.0) / dDenom);
        this.setDistributionType("Triangular");
        this.sort();
    }

    private void sort() {
        boolean bNotSwitched = false;
        while (!bNotSwitched) {
            bNotSwitched = true;
            int i = 0;
            while (i < this.nPts - 1) {
                if (this.f[i] > this.f[i + 1]) {
                    double dFtemp = this.f[i];
                    double dCtemp = this.c[i];
                    this.f[i] = this.f[i + 1];
                    this.c[i] = this.c[i + 1];
                    this.f[i + 1] = dFtemp;
                    this.c[i + 1] = dCtemp;
                    bNotSwitched = false;
                }
                ++i;
            }
        }
    }

    public void setValue(double frequency) {
        this.cValue = this.getValue(frequency);
    }

    public void setValue(int interval) {
        this.cValue = this.getValue((double)this.iOrder[interval] * this.dCF + this.random.getRandomNumber() * this.dCF);
    }

    public void overrideStatisticalValue(double cValue) {
        this.cValue = cValue;
    }

    public double getValue(double dFrequency) {
        double cc = 0.0;
        int i = 0;
        while (i < this.nPts - 1) {
            if (this.f[i] <= dFrequency && dFrequency <= this.f[i + 1]) {
                double sl = (this.c[i + 1] - this.c[i]) / (this.f[i + 1] - this.f[i]);
                cc = this.c[i] + sl * (dFrequency - this.f[i]);
                cc = this.getSelectedValue(i, dFrequency);
                this.chosenFrequency = dFrequency;
                this.chosenIndex = i;
            }
            ++i;
        }
        return cc;
    }

    public double getSelectedValue(int i, double frequency) {
        return this.c[i] + (frequency - this.f[i]) * (this.c[i + 1] - this.c[i]) / (this.f[i + 1] - this.f[i]);
    }

    public double getCompanionStatisticalDistributionValue() {
        return this.sdCompanion.getSelectedValue(this.chosenIndex, this.chosenFrequency);
    }

    public void generateOrdering(int nSimulation) {
        double[] order = new double[nSimulation];
        this.iOrder = new int[nSimulation];
        int i = 0;
        while (i < nSimulation) {
            order[i] = this.random.getRandomNumber();
            this.iOrder[i] = i;
            ++i;
        }
        boolean notSwitched = false;
        while (!notSwitched) {
            notSwitched = true;
            i = 0;
            while (i < nSimulation - 1) {
                if (order[i] > order[i + 1]) {
                    double oTemp = order[i];
                    int iTemp = this.iOrder[i];
                    order[i] = order[i + 1];
                    this.iOrder[i] = this.iOrder[i + 1];
                    order[i + 1] = oTemp;
                    this.iOrder[i + 1] = iTemp;
                    notSwitched = false;
                }
                ++i;
            }
        }
    }

    public void setUpIntervals(int nLHSInterval) {
        this.nLHSInterval = nLHSInterval;
        this.dCF = 1.0 / (double)nLHSInterval;
    }

    public double getMiddleValue() {
        double dSumUp = 0.0;
        double dSumDown = 0.0;
        int i = 0;
        while (i < this.nPts - 1) {
            double dfAvg = 0.5 * (this.f[i + 1] - this.f[i]);
            dSumUp += (this.c[i + 1] - this.c[i]) * dfAvg;
            dSumDown += dfAvg;
            ++i;
        }
        this.dMiddleValue = dSumUp / dSumDown;
        return this.dMiddleValue;
    }

    public void removeDuplicateEntries() {
        boolean[] bKeep = new boolean[this.nPts];
        double[] cTemp = new double[this.nPts];
        double[] fTemp = new double[this.nPts];
        int iTemp = 0;
        int i = 0;
        while (i < this.nPts) {
            cTemp[i] = this.c[i];
            fTemp[i] = this.f[i];
            ++i;
        }
        int j = 0;
        while (j < this.nPts) {
            bKeep[j] = true;
            ++j;
        }
        i = 0;
        while (i < this.nPts) {
            if (bKeep[i]) {
                int j2 = 0;
                while (j2 < this.nPts) {
                    if (j2 != i && this.c[j2] == this.c[i] && this.f[j2] == this.f[i]) {
                        bKeep[j2] = false;
                    }
                    ++j2;
                }
            }
            ++i;
        }
        i = 0;
        while (i < bKeep.length) {
            if (bKeep[i]) {
                ++iTemp;
            }
            ++i;
        }
        this.c = new double[iTemp];
        this.f = new double[iTemp];
        iTemp = 0;
        i = 0;
        while (i < this.nPts) {
            if (bKeep[i]) {
                this.c[iTemp] = cTemp[i];
                this.f[iTemp] = fTemp[i];
                ++iTemp;
            }
            ++i;
        }
        this.nPts = iTemp;
    }

    public void setAveragedParameterValue() {
        this.removeDuplicateEntries();
        this.cValue = this.getWeightedAverageValue();
    }

    public double getWeightedAverageValue() {
        double dWeightedAverage = 0.0;
        if (this.nPts > 0) {
            if (this.nPts > 1) {
                double dTotal = this.c[this.nPts - 1] - this.c[0];
                if (dTotal > 0.0) {
                    int i = 1;
                    while (i < this.nPts) {
                        double dIntervalAverage = 0.5 * (this.c[i] + this.c[i - 1]);
                        dWeightedAverage += dIntervalAverage * (this.c[i] - this.c[i - 1]) / dTotal;
                        ++i;
                    }
                } else {
                    dWeightedAverage = this.c[0];
                }
            } else if (this.nPts == 1) {
                dWeightedAverage = this.c[0];
            }
        }
        return dWeightedAverage;
    }

    public void setName(String sName) {
        this.sName = sName;
    }

    public void setParentName(String sParentName) {
        this.sParentName = sParentName;
    }

    public void setNumberOfSimulations(int nSimulation) {
        this.nSimulation = nSimulation;
    }

    public void setCompanionStatisticalDistribution(StatisticalDistribution sdCompanion) {
        this.sdCompanion = sdCompanion;
    }

    public void setCalculationUnit(String sCalculationUnit) {
        this.sCalculationUnit = sCalculationUnit;
    }

    public void reSetNumberOfPointsDefiningStatisticalDistribution(int nPts) {
        this.nPts = nPts;
    }

    public void reSetConcentration(int nPoint, double dConcentration) {
        this.c[nPoint] = dConcentration;
    }

    public void reSetFrequency(int nPoint, double dFrequency) {
        this.f[nPoint] = dFrequency;
    }

    public void setNumberOfPointsDefiningDistribution(int nPts) {
        this.nPts = nPts;
    }

    public void setConcentrationDistribution(double[] c) {
        this.c = c;
    }

    public void setFrequencyDistribution(double[] f) {
        this.f = f;
    }

    public void setCurrentRandomValue(double cValue) {
        this.cValue = cValue;
    }

    public void setChosenFrequency(double chosenFrequency) {
        this.chosenFrequency = chosenFrequency;
    }

    public void setDistributionType(String sDistributionType) {
        this.sDistributionType = sDistributionType;
    }

    public void setIsThisDistributionActuallyUsed(boolean bActuallyUsed) {
        this.bActuallyUsed = bActuallyUsed;
    }

    public void setRandomNumberGenerator(RandomNumber random) {
        this.random = random;
    }

    public String getName() {
        return this.sName;
    }

    public String getParentName() {
        return this.sParentName;
    }

    public String getCalculationUnit() {
        return this.sCalculationUnit;
    }

    public String getDistributionType() {
        return this.sDistributionType;
    }

    public double getCurrentRandomValue() {
        return this.cValue;
    }

    public double getChosenFrequency() {
        return this.chosenFrequency;
    }

    public int getChosenIndex() {
        return this.chosenIndex;
    }

    public int getNumberOfPointsDefiningDistribution() {
        return this.nPts;
    }

    public double getConcentration(int nPoint) {
        return this.c[nPoint];
    }

    public double[] getConcentrationDistribution() {
        return this.c;
    }

    public double getFrequency(int nPoint) {
        return this.f[nPoint];
    }

    public double[] getFrequencyDistribution() {
        return this.f;
    }

    public boolean getIsThisDistributionActuallyUsed() {
        return this.bActuallyUsed;
    }
}

