/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Calendar;

public class CalendarClock {
    Calendar rT;

    public CalendarClock() {
        this.initial();
    }

    void initial() {
        this.rT = Calendar.getInstance();
    }

    public CalendarClock(int year, String threeLetterMonth, int day, int hour, int minute, int second) {
        this.initial();
        this.setAll(year, threeLetterMonth, day, hour, minute, second);
    }

    public void setAll(int year, int month, int day, int hour, int minute, int second) {
        this.rT.set(year, month - 1, day, hour, minute, second);
    }

    public void setAll(int year, String threeLetterMonth, int day, int hour, int minute, int second) {
        int imonth = -1;
        if (threeLetterMonth.toUpperCase().equals("JAN")) {
            imonth = 0;
        } else if (threeLetterMonth.toUpperCase().equals("FEB")) {
            imonth = 1;
        } else if (threeLetterMonth.toUpperCase().equals("MAR")) {
            imonth = 2;
        } else if (threeLetterMonth.toUpperCase().equals("APR")) {
            imonth = 3;
        } else if (threeLetterMonth.toUpperCase().equals("MAY")) {
            imonth = 4;
        } else if (threeLetterMonth.toUpperCase().equals("JUN")) {
            imonth = 5;
        } else if (threeLetterMonth.toUpperCase().equals("JUL")) {
            imonth = 6;
        } else if (threeLetterMonth.toUpperCase().equals("AUG")) {
            imonth = 7;
        } else if (threeLetterMonth.toUpperCase().equals("SEP")) {
            imonth = 8;
        } else if (threeLetterMonth.toUpperCase().equals("OCT")) {
            imonth = 9;
        } else if (threeLetterMonth.toUpperCase().equals("NOV")) {
            imonth = 10;
        } else if (threeLetterMonth.toUpperCase().equals("DEC")) {
            imonth = 11;
        }
        this.rT.set(year, imonth, day, hour, minute, second);
    }

    public void addSeconds(double seconds) {
        this.rT.add(14, (int)(seconds * 1000.0));
    }

    public void addDays(int iDays) {
        this.rT.add(5, iDays);
    }

    public void addMonths(int iMonths) {
        this.rT.add(2, iMonths);
    }

    public void addYears(int iYears) {
        this.rT.add(1, iYears);
    }

    public double timeDifferenceSeconds(CalendarClock cc) {
        long timeCC = cc.getTimeInMilles();
        long timeThis = this.getTimeInMilles();
        return (double)(timeCC - timeThis) / 1000.0;
    }

    public void removeSeconds(double seconds) {
        this.rT.add(14, (int)(seconds * -1000.0));
    }

    public long getTimeInMilles() {
        return this.rT.getTimeInMillis();
    }

    public double getSeconds() {
        return this.rT.get(13);
    }

    public int getMinutes() {
        return this.rT.get(12);
    }

    public int getHours() {
        return this.rT.get(11);
    }

    public int getDay() {
        return this.rT.get(5);
    }

    public int getMonth() {
        return this.rT.get(2) + 1;
    }

    public int getYear() {
        return this.rT.get(1);
    }

    public String getThreeLetterMonth() {
        int imonth = this.rT.get(2);
        if (imonth == 0) {
            return "Jan";
        }
        if (imonth == 1) {
            return "Feb";
        }
        if (imonth == 2) {
            return "Mar";
        }
        if (imonth == 3) {
            return "Apr";
        }
        if (imonth == 4) {
            return "May";
        }
        if (imonth == 5) {
            return "Jun";
        }
        if (imonth == 6) {
            return "Jul";
        }
        if (imonth == 7) {
            return "Aug";
        }
        if (imonth == 8) {
            return "Sep";
        }
        if (imonth == 9) {
            return "Oct";
        }
        if (imonth == 10) {
            return "Nov";
        }
        if (imonth == 11) {
            return "Dec";
        }
        return "";
    }

    public String getDateTimeString() {
        String sOut = "";
        sOut = String.valueOf(sOut) + this.getYear() + "-" + this.getThreeLetterMonth() + "-" + this.getDay() + " " + this.getHours() + "h-" + this.getMinutes() + "m-" + this.getSeconds() + "s";
        return sOut;
    }
}

