/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import util.CalendarClock;

public class FileLogger {
    private CalendarClock cc;
    private String sLogFile;
    private String sShortFileName;
    private String sModelName;
    private String sFileExtension;
    private boolean bUseCalendarInName;
    private boolean bFileAssembled;
    private boolean bWriteFile;
    int iLogCount = 0;
    FileOutputStream fileOutputOver;
    PrintWriter outputStreamOver;

    public FileLogger() {
        this.initial();
    }

    public FileLogger(String fileName) {
        this.initial();
        this.sLogFile = fileName;
        this.bFileAssembled = true;
    }

    public FileLogger(String sModelName, String sShortFileName, String sFileExtension, boolean bUseCalendarInName) {
        this.initial();
        this.sModelName = sModelName;
        this.sFileExtension = sFileExtension;
        this.sShortFileName = sShortFileName;
        this.bUseCalendarInName = bUseCalendarInName;
        this.assembleOutputFile();
    }

    private void initial() {
        this.sLogFile = "";
        this.sShortFileName = "";
        this.sModelName = "";
        this.sFileExtension = "";
        this.bUseCalendarInName = false;
        this.bFileAssembled = false;
        this.bWriteFile = true;
    }

    public void assembleOutputFile() {
        this.sLogFile = "";
        this.sLogFile = this.sShortFileName != "" ? (this.sModelName != "" ? String.valueOf(this.sShortFileName) + "-" + this.sModelName : String.valueOf(this.sShortFileName)) : this.sModelName;
        if (this.bUseCalendarInName) {
            this.cc = new CalendarClock();
            this.sLogFile = String.valueOf(this.sLogFile) + " " + this.cc.getYear() + "-" + this.cc.getThreeLetterMonth() + "-" + this.cc.getDay() + "-" + this.cc.getHours() + " hours " + this.cc.getMinutes() + " min " + this.cc.getSeconds() + " sec";
        }
        if (this.sFileExtension.charAt(0) != '.') {
            this.sFileExtension = String.valueOf('.') + this.sFileExtension;
        }
        this.sLogFile = String.valueOf(this.sLogFile) + this.sFileExtension;
        this.bFileAssembled = true;
    }

    public void setCompleteFileName(String sSimpleFileName) {
        this.sLogFile = sSimpleFileName;
        this.bFileAssembled = true;
    }

    public void logMessageOverWrite(String message) {
        try {
            if (!this.bFileAssembled) {
                this.assembleOutputFile();
            }
            if (this.bWriteFile) {
                if (this.iLogCount == 0) {
                    this.fileOutputOver = new FileOutputStream(this.sLogFile, true);
                    this.outputStreamOver = new PrintWriter(this.fileOutputOver);
                    ++this.iLogCount;
                }
                this.outputStreamOver.println(message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openOverWriteFile() {
        try {
            if (!this.bFileAssembled) {
                this.assembleOutputFile();
            }
            if (this.bWriteFile && this.iLogCount == 0) {
                this.fileOutputOver = new FileOutputStream(this.sLogFile, false);
                this.outputStreamOver = new PrintWriter(this.fileOutputOver);
                ++this.iLogCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeOverWriteFile() {
        try {
            if (!this.bFileAssembled) {
                this.assembleOutputFile();
            }
            if (this.bWriteFile) {
                this.outputStreamOver.close();
                this.fileOutputOver.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void logMessage(String message) {
        try {
            if (!this.bFileAssembled) {
                this.assembleOutputFile();
            }
            if (this.bWriteFile) {
                FileOutputStream fileOutput = new FileOutputStream(this.sLogFile, true);
                PrintWriter outputStream = new PrintWriter(fileOutput);
                outputStream.println(message);
                outputStream.close();
                fileOutput.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void logMessage(String[] mArray) {
        String logMessage = "";
        int i = 0;
        while (i < mArray.length) {
            logMessage = String.valueOf(logMessage) + mArray[i] + ", ";
            ++i;
        }
        this.logMessage(logMessage);
    }

    private String arrayToString(String[] lineArray) {
        String sOut = "";
        int i = 0;
        while (i < lineArray.length) {
            sOut = String.valueOf(sOut) + lineArray[i] + ", ";
            ++i;
        }
        return sOut;
    }

    public void setModelName(String sModelName) {
        this.sModelName = sModelName;
    }

    public void setShortFileName(String sShortFileName) {
        this.sShortFileName = sShortFileName;
    }

    public void setFileExtension(String extension) {
        this.sFileExtension = extension;
    }

    public void setWriteFile(boolean b) {
        this.bWriteFile = b;
    }

    public void useCalendarInName(boolean bUse) {
        this.bUseCalendarInName = bUse;
    }
}

