/*
 * Decompiled with CFR 0.152.
 */
package util;

public class OutputDigits {
    private String sample = "Sample";
    double dValue;
    int iDigits;
    int iLowerSciExp;
    int iUpperSciExp;
    int iLowerDecExp;
    int iUpperDecExp;

    public OutputDigits() {
        this.setParameters(4, -15, 15, -7, 7);
    }

    public OutputDigits(double value) {
        this.dValue = value;
        this.iDigits = 4;
        this.iLowerSciExp = -15;
        this.iUpperSciExp = 15;
        this.iLowerDecExp = -7;
        this.iUpperDecExp = 7;
    }

    public OutputDigits(double value, int digits, int LowerSciExp, int UpperSciExp, int LowerDecExp, int UpperDecExp) {
        this.dValue = value;
        this.iDigits = digits;
        this.iLowerSciExp = LowerSciExp;
        this.iUpperSciExp = UpperSciExp;
        this.iLowerDecExp = LowerDecExp;
        this.iUpperDecExp = UpperDecExp;
    }

    public void setParameters(int iDigits, int iLowerSciExp, int iUpperSciExp, int iLowerDecExp, int iUpperDecExp) {
        this.iDigits = iDigits;
        this.iLowerSciExp = iLowerSciExp;
        this.iUpperSciExp = iUpperSciExp;
        this.iLowerDecExp = iLowerDecExp;
        this.iUpperDecExp = iUpperDecExp;
    }

    public String num2String(double dValue) {
        this.setValue(dValue);
        return this.num2String();
    }

    public String num2String(double dValue, int iDigits, int iLowerSciExp, int iUpperSciExp, int iLowerDecExp, int iUpperDecExp) {
        this.setValue(dValue);
        this.iDigits = iDigits;
        this.iLowerSciExp = iLowerSciExp;
        this.iUpperSciExp = iUpperSciExp;
        this.iLowerDecExp = iLowerDecExp;
        this.iUpperDecExp = iUpperDecExp;
        return this.num2String();
    }

    public String num2String() {
        if (this.dValue == 0.0) {
            String strTemp = "0.";
            return strTemp;
        }
        double dThisLimit = Math.pow(10.0, this.iUpperSciExp);
        if (this.dValue > dThisLimit) {
            return "above range";
        }
        dThisLimit = -Math.pow(10.0, this.iUpperSciExp);
        if (this.dValue < dThisLimit) {
            return "below range";
        }
        boolean bNegativeNum = this.dValue < 0.0;
        double dAbsValue = Math.abs(this.dValue);
        int iMagnitude = this.iUpperSciExp;
        while (iMagnitude >= -500) {
            dThisLimit = Math.pow(10.0, iMagnitude);
            if (dAbsValue >= dThisLimit) {
                ++iMagnitude;
                break;
            }
            --iMagnitude;
        }
        double dMagnifier = Math.pow(10.0, this.iDigits - iMagnitude);
        double dAdjustedVal = dAbsValue * dMagnifier;
        double dRoundedVal = Math.round(dAdjustedVal);
        double dLowerDecLimit = Math.pow(10.0, this.iLowerDecExp);
        double dUpperDecLimit = Math.pow(10.0, this.iUpperDecExp);
        double dInnerLimit = Math.pow(10.0, this.iLowerSciExp);
        if (dAbsValue < dInnerLimit) {
            return this.scientificNotation(dRoundedVal, iMagnitude, bNegativeNum);
        }
        if (dLowerDecLimit <= dAbsValue && dAbsValue <= dUpperDecLimit) {
            return this.regularNotation(dRoundedVal, iMagnitude, dMagnifier, bNegativeNum);
        }
        return this.scientificNotation(dRoundedVal, iMagnitude, bNegativeNum);
    }

    private String regularNotation(double dRoundedVal, int iMagnitude, double dMagnifier, boolean bNegativeNum) {
        String strDot = ".";
        char charDot = strDot.charAt(0);
        String strZero = "0";
        char charZero = strZero.charAt(0);
        double dNewVal = dRoundedVal / dMagnifier;
        String strNewVal = "" + dNewVal;
        int iELoc = strNewVal.indexOf("e");
        if (iELoc > -1) {
            String strTemp = strNewVal.substring(0, iELoc);
            if (strTemp.indexOf(".") == -1) {
                strTemp = String.valueOf(strTemp) + ".";
            }
            int iAddZeros = this.iDigits + 1 - strTemp.length();
            int iPad = 0;
            while (iPad < iAddZeros) {
                strTemp = String.valueOf(strTemp) + "0";
                ++iPad;
            }
            strTemp = String.valueOf(strTemp) + strNewVal.substring(iELoc);
            if (bNegativeNum) {
                strTemp = "-" + strTemp;
            }
            return strTemp;
        }
        if (strNewVal.indexOf(".") == -1) {
            strNewVal = String.valueOf(strNewVal) + ".";
        }
        if (iMagnitude == 0 && charDot == strNewVal.charAt(0)) {
            strNewVal = "0" + strNewVal;
        }
        int iNonZeroLoc = 0;
        while (iNonZeroLoc < strNewVal.length()) {
            if (strNewVal.charAt(iNonZeroLoc) != charZero && strNewVal.charAt(iNonZeroLoc) != charDot) break;
            ++iNonZeroLoc;
        }
        int iDecimalLoc = strNewVal.indexOf(".");
        int iNeedDigits = iDecimalLoc > iNonZeroLoc ? this.iDigits + 1 : this.iDigits;
        int iAddZeros = iNeedDigits + iNonZeroLoc - strNewVal.length();
        int iPad = 0;
        while (iPad < iAddZeros) {
            strNewVal = String.valueOf(strNewVal) + "0";
            ++iPad;
        }
        if (bNegativeNum) {
            strNewVal = "-" + strNewVal;
        }
        return strNewVal;
    }

    private String scientificNotation(double dRoundedVal, int iMagnitude, boolean bNegativeNum) {
        String strTemp;
        double dMantissa = dRoundedVal / Math.pow(10.0, this.iDigits - 1);
        if (dMantissa >= 10.0) {
            dMantissa = dRoundedVal / Math.pow(10.0, this.iDigits);
            ++iMagnitude;
        }
        if ((strTemp = "" + dMantissa).indexOf(".") == -1) {
            strTemp = String.valueOf(strTemp) + ".";
        }
        int iPad = 0;
        while (strTemp.length() < this.iDigits + 1) {
            strTemp = String.valueOf(strTemp) + "0";
            ++iPad;
        }
        String strMantissa = strTemp.substring(0, this.iDigits + 1);
        String strExponent = "e" + (iMagnitude - 1);
        if (bNegativeNum) {
            strMantissa = "-" + strMantissa;
        }
        return String.valueOf(strMantissa) + strExponent;
    }

    public void setSample(String newSample) {
        this.sample = newSample;
    }

    public void setValue(double value) {
        this.dValue = value;
    }

    public String getSample() {
        return this.sample;
    }
}

