/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import util.FileLogger;
import util.Stripper;

public class UnitConverter {
    private FileLogger fl;
    private ArrayList<Unit> alUnit;
    private ArrayList<Unit> alOutputUnit;
    private ArrayList<UnitType> alUnitType;
    private String sModelUnit;
    private boolean bUnsupportedUnit;
    private Stripper stripper;

    public UnitConverter() {
        this.initial();
    }

    public void initial() {
        this.alUnit = new ArrayList();
        this.alOutputUnit = new ArrayList();
        this.alUnitType = new ArrayList();
        this.sModelUnit = "";
        this.bUnsupportedUnit = false;
        this.stripper = new Stripper();
    }

    public double getUCF(String sType, String sName) {
        for (Unit u : this.alUnit) {
            String sTypeT = u.getType();
            String sNameT = u.getName();
            if (!this.stripper.areTheyEqual(sTypeT, sType, ' ') || !this.stripper.areTheyEqual(sNameT, sName, ' ')) continue;
            double ucf = u.getUCF();
            return ucf;
        }
        String out = "unit conversion not found for unit: " + sType + " " + sName + " used for: " + sType;
        this.fl.logMessage(out);
        return 0.0;
    }

    public void readUnits(String sFileName) throws IOException {
        String currentLine;
        FileReader fr = new FileReader(sFileName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        while ((currentLine = br.readLine()) != null) {
            String key2;
            lineArray = currentLine.split(",", 0);
            String key = lineArray[0];
            if (!this.stripper.areTheyEqual(key, "Control") && !this.stripper.areTheyEqual(key, "Controll") || !this.stripper.areTheyEqual(key2 = lineArray[1], "unit")) continue;
            double dUCF = 1.0;
            boolean bInternalCalculationUnit = false;
            String sType = lineArray[2];
            if (this.stripper.areTheyEqual(lineArray[3], "model")) {
                bInternalCalculationUnit = true;
                dUCF = 1.0;
            } else {
                dUCF *= Double.parseDouble(lineArray[4]);
                dUCF *= Double.parseDouble(lineArray[5]);
                dUCF *= Double.parseDouble(lineArray[6]);
                dUCF *= Double.parseDouble(lineArray[7]);
            }
            int i = 8;
            while (i < lineArray.length) {
                String sName = lineArray[i];
                this.addUnit(sType, sName, dUCF, bInternalCalculationUnit);
                ++i;
            }
        }
        fr.close();
    }

    public void readUnitTypes(String sFileName) throws IOException {
        FileReader fr = new FileReader(sFileName);
        BufferedReader br = new BufferedReader(fr);
        String[] lineArray = new String[]{""};
        String currentLine = br.readLine();
        while ((currentLine = br.readLine()) != null) {
            lineArray = currentLine.split(",", 0);
            UnitType ut = new UnitType();
            ut.setUnitType(lineArray[0], lineArray[1]);
            this.alUnitType.add(ut);
        }
        fr.close();
    }

    public void addUnit(String sType, String sName, double uCF, boolean bInternalCalculationUnit) {
        Unit u = new Unit();
        u.setType(sType);
        u.setName(sName);
        u.setUCF(uCF);
        u.setIsUnitInternalCalculationUnit(bInternalCalculationUnit);
        this.alUnit.add(u);
    }

    public void addOutputUnit(String sType, String sOutputName) {
        Unit u = new Unit();
        u.setType(sType);
        u.setName(sOutputName);
        double uCF = this.getUCF(sType, sOutputName);
        u.setUCF(1.0 / uCF);
        this.alOutputUnit.add(u);
    }

    public String getOutputNameFromType(String sType) {
        String sReturn = "";
        for (Unit u : this.alOutputUnit) {
            if (!this.stripper.areTheyEqual(u.getType(), sType, ' ')) continue;
            sReturn = u.getName();
        }
        return sReturn;
    }

    public double getOutputUCFFromType(String sType) {
        double dReturn = 0.0;
        for (Unit u : this.alOutputUnit) {
            if (!this.stripper.areTheyEqual(u.getType(), sType, ' ')) continue;
            dReturn = u.getUCF();
            break;
        }
        return dReturn;
    }

    public void setFileLogger(FileLogger fl) {
        this.fl = fl;
    }

    public String getModelUnit(String sType) {
        String sModelUnit = "";
        for (Unit u : this.alUnit) {
            if (!this.stripper.areTheyEqual(u.getType(), sType, ' ') || !u.getIsUnitInternalCalculationUnit()) continue;
            sModelUnit = u.getName();
            break;
        }
        return sModelUnit;
    }

    public ArrayList<String> getAllUnitNamesForAType(String sUnitType) {
        ArrayList<String> alUnitTypeLocal = new ArrayList<String>();
        for (Unit u : this.alUnit) {
            String sTempUnitName;
            if (!this.stripper.areTheyEqual(u.getType(), sUnitType, ' ') || (sTempUnitName = this.stripper.removeCharacter(' ', u.getName())).equals("")) continue;
            alUnitTypeLocal.add(sTempUnitName);
        }
        return alUnitTypeLocal;
    }

    public boolean getBooleanUnsupportedUnit() {
        return this.bUnsupportedUnit;
    }

    public String getUnitType(String sInputDataName) {
        Stripper s = new Stripper();
        String sReturn = "";
        for (UnitType ut : this.alUnitType) {
            if (!s.areTheyEqual(sInputDataName, ut.getInputType(), ' ')) continue;
            sReturn = ut.getUnitType();
            break;
        }
        return sReturn;
    }

    class Unit {
        private String sType;
        private String sName;
        private double uCF;
        private boolean bInternalCalculationUnit;

        public void setName(String sName) {
            this.sName = sName;
        }

        public void setType(String sType) {
            this.sType = sType;
        }

        public void setUCF(double uCF) {
            this.uCF = uCF;
        }

        public void setIsUnitInternalCalculationUnit(boolean bInternalCalculationUnit) {
            this.bInternalCalculationUnit = bInternalCalculationUnit;
        }

        public String getName() {
            return this.sName;
        }

        public String getType() {
            return this.sType;
        }

        public double getUCF() {
            return this.uCF;
        }

        public boolean getIsUnitInternalCalculationUnit() {
            return this.bInternalCalculationUnit;
        }
    }

    class UnitType {
        private String sInputType;
        private String sUnitType;

        public void setUnitType(String sInputType, String sUnitType) {
            this.sInputType = sInputType;
            this.sUnitType = sUnitType;
        }

        public String getInputType() {
            return this.sInputType;
        }

        public String getUnitType() {
            return this.sUnitType;
        }
    }
}

