package numerics.Bisection;

public class Bisection
{
  double low,high;
  double tolerance;
  double value;
  double result;
  int count;
  int maxIterations;
  boolean boolSolutionFound;


  public Bisection()
  {
    //set default/depreciated number of iterations
    //can change with setMaximumIterations
    maxIterations = 1000;
  }

  public void setTolerance (double tolerance) {this.tolerance = tolerance;}
  public void setLimits (double low, double high) {this.low = low; this.high = high;}
  public void setValueToMatch(double value) {this.value = value;}
  public void setMaximumIterations(int maxIterations) {this.maxIterations = maxIterations;}

  public void bisect(Bisectable bi)
  {

    double a,b;
    double fa,fb,fm;
    double xd,xf;
    double xInterval;


    a = low;
    b = high;
    fm = 10.*(value+tolerance);
    count = 0;
    fa = bi.getFunctionValue(a);
    fb = bi.getFunctionValue(b);
    xInterval = fb*fa;
    if (xInterval<0)
    {
      //fa and fb have different signs, solution is within interval from a to b
      boolSolutionFound = true;
      xf = 1.;
      if (fb<fa) {xf = -1.;}
      xd = 1.;
      if (value!=0.) {xd=value;}

      while (count<maxIterations && Math.abs((fm-value)/xd)>tolerance)
      {
        count = count+1;

        result = 0.5*(a+b);
        fm = bi.getFunctionValue(result);

        if (xf*(fm-value)>0.)
        {
          b = result;
        }
        else
        {
          a = result;
        }

      }
    }
    else
    {
      //fa and fb have the same sign the solution is not within the interval from a to b
      boolSolutionFound = false;
    }
  }

  //if the count is less than 1000 (maxIterations), then the result is correct
  //otherwise the result has not been found to within the tolerance
  public int getCount(){return count;}
  public double getResult() {return result;}
  public double getLowerLimit(){return low;}
  public double getUpperLimit(){return high;}
  public int getMaximumIterations(){return maxIterations;}
  public boolean getSolutionFound(){return boolSolutionFound;}

}
