package numerics.Bisection;

/**
 * DiscreteBisection == bisection search on a set of discrete points 
 *      (rather than a function)
 * @author Jim Weaver
 * 10-30-2012
 *
 */
public class DiscreteBisection 
{
	//array to be checked via bisection
    double[] dBisectableArray;
    //value to be checked and find element (and its index) in array just below this value
    double dValue;
    //value of BisectableArray that is just below the requested value (dValue)
    double dValueOfSolution;
    //maximum number of tries to find solution
    int iMaxIteration;
    //value of index in BisectableArray that is just below requested value (dValue)
    int iIndexOfSolution;
    
    
	public DiscreteBisection()
	{
		iMaxIteration = 1000;
	}
	
	public void bisect()
	{
	  int iCount=0;
	  double dVLow, dVMid, dVHigh;
	  int iLow, iMid, iHigh;
	  
	  iLow = 0;
	  iHigh = dBisectableArray.length;
	  iMid = (iLow + iHigh)/2;
	 

	  //bisection iteration
	  while (iCount < iMaxIteration)
	  {
		 
		 dVMid = this.dBisectableArray[iMid]; 
		  
		 if (iLow + 1 == iHigh)
		 {
			 //solution found
			 //solution is the value just below the requested value
			 iIndexOfSolution = iLow;
			 dValueOfSolution = this.dBisectableArray[iLow];
			 break;
		 }
		 
		 if (dVMid<=dValue)
		 {
			 //midpoint value is below the requested value (thus the iLow can be dropped)
			 iLow = iMid;
			 iMid = (iLow + iHigh)/2;
		 }
		 else if (dVMid>dValue)
		 {
			 //midpoint value is above the requested value (this the iHigh can be dropped)
			 iHigh = iMid;
			 iMid = (iLow + iHigh)/2;
		 }
		  
		 iCount++;
	  }
	}
	
	
	//sets
	public void setDiscreteBisectableArray(double[] dBisectableArray){this.dBisectableArray = dBisectableArray;}
	public void setValue(double dValue){this.dValue = dValue;}
	public void setMaxIteration(int iMaxIteration){this.iMaxIteration = iMaxIteration;}
	
	//gets
	public int getIndexOfSolution(){return this.iIndexOfSolution;}
	public double getValueOfSolution(){return this.dValueOfSolution;}
}
