package pviScreen;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

import uncertaintyAnalysis.StatisticalDistribution;
import util.FileLogger;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class ChemicalDataReader 
{
	private FileLogger flChemicalInput;
	private FileLogger flOutput;
	private UnitConverter uc;
	private Chemical c;
	private ArrayList<Chemical> alChemical;
	private String sErrorOutput;
	private Stripper s;
	
	
	
    public ChemicalDataReader()
    {
    	alChemical = new ArrayList<Chemical>();
    	sErrorOutput = "";
    	s = new Stripper();
    }
    

    
    public void readChemicalData(String sFileName) throws IOException
    {
      String key2;
      String sConvertedOutput;
 
      
      FileReader fr = new FileReader(sFileName);
	  BufferedReader br = new BufferedReader(fr);
		 
		String currentLine;
		String[] lineArray = {""};
		String key;
		
		while ((currentLine = br.readLine()) != null) 
		{
			lineArray = currentLine.split(",",0);

			//read each line and prepare data according to key words
			key = lineArray[0];
    
	        if (s.areTheyEqual("Chemical",key))
	        {
		      key2 = lineArray[1];
	 
		      if (key2.equalsIgnoreCase("Begin")){}
		      if (key2.equalsIgnoreCase("Heading")){}
		      else if (s.areTheyEqual("New Chemical", key2))
		      {
			     //create new chemical instance for the new chemical  
                 c = new Chemical();
                 //set the name of the chemical object (also sets the parent name of each distribution)
			     c.setName(lineArray[3]); 
                 //create the needed statistical distributions
			     //molecular weight
			     c.createNewDistribution("Chemical","MolecularWeight");
			     //solubility
			     c.createNewDistribution("Chemical","Solubility");
			     //density
			     c.createNewDistribution("Chemical","Density");
			     //organic carbon partition coefficient
			     c.createNewDistribution("Chemical","Koc");
                 //henry's constant
    		     //c.createNewDistribution("HenrysConstant");
  	             //utilization factor phi
  	             c.createNewDistribution("Chemical","UtilizationFactor");
  	             //diffusion coefficient in air
  	             c.createNewDistribution("Chemical","DiffusionCoefficientInAir");
  	             //diffusion coefficient in water
  	             c.createNewDistribution("Chemical","DiffusionCoefficientInWater");
  	             //degradation rate
  	             c.createNewDistribution("Chemical","Degradation");
  	             //vapor concentration
  	             c.createNewDistribution("Chemical","AirPhaseConcentration");
  	             //fuel phase concentration by volume
  	             c.createNewDistribution("Chemical","FuelPhaseConcentrationByVolume");
  	             //fuel phase concentration by mass
  	             c.createNewDistribution("Chemical","FuelPhaseConcentrationByMass");
  	             //water phase
  	             c.createNewDistribution("Chemical","WaterPhaseConcentration");
  	             //soil sample
  	             c.createNewDistribution("Chemical","SoilSample");
  	             //by default these are created and are assumed unused
  	             //will be matched with chemicals actually simulated in chemical.setAirPhaseConcentration
  	             //and distributions set
  	             //jww 4-21-2016
  	             c.setIsChemicalUsed(false);
  	    
  	             //add the data
  	             sConvertedOutput = addChemicalData(c,lineArray);
		 
		       }
		       else if (s.areTheyEqual("AddToNewChemical",key2))
		       {
			      //add data to an existing chemical 
			      //only can add in sequence (previous newchemical must be the same chemical as addtonewchemical)
			      //check to make sure chemical in AddToNewChemical is the same as in NewChemical
			      if (lineArray[3].equalsIgnoreCase(c.getName())) {sConvertedOutput = addChemicalData(c,lineArray);}
			      else {sErrorOutput = sErrorOutput +  "Error in AddToNewChemical:  chemical names do not match /n";} 
		       }
		       else if (s.areTheyEqual("EndChemical",key2))
		       {
			     //add chemical data object to the arraylist of chemicals
			     alChemical.add(c);
		       }    
	        }
	      }
		
		//close the input file
		fr.close();
	
      }
    
      public void readHenrysConstantData (String sFileName) throws IOException
      {
    	 
    	      String key2;
    	      String sConvertedOutput;
    	      Stripper s = new Stripper();
 
    	      
    	      FileReader fr = new FileReader(sFileName);
    		  BufferedReader br = new BufferedReader(fr);
    			 
    			String currentLine;
    			String[] lineArray = {""};
    			String key;
    			
    			while ((currentLine = br.readLine()) != null) 
    			{
    				double dValue;
    				lineArray = currentLine.split(",",0);

    				//read each line and prepare data according to key words
    				key = lineArray[0];
    	    
    		        if (key.equalsIgnoreCase("Chemical"))
    		        {  
    		        	key2 = lineArray[1];
    		        	
    		        	
    		        	if (key2.equalsIgnoreCase("HenrysConstantData") || key2.equalsIgnoreCase("Henrys constant data"))
    		        	{		
    		               //find the chemical object with the correct name
    		        	   String sName = lineArray[2];
                           String sTemp;
                           Chemical cMatch = null;
    		    	       for (Chemical chemical:  alChemical)
    		    	       {
    		    	    	  sTemp = chemical.getName();
    		    	    	  if (sName.equalsIgnoreCase("C6Toc7Aliphatic"))
    		    	    	  {	  
    		    	    		  int i=0;
    		    	    		  i++;
    		    	    	  }
    		    	    	  if (s.areTheyEqual(sName, chemical.getName()))
    		    	    	  {
    		    	    		  cMatch = chemical;
    		    	    		  break;
    		    	    	  }
    		    	       } 
    		        	  if(cMatch.equals(null))
    		        	  {
    		        		  //chemical data name mismatch
    		        		  sErrorOutput = sErrorOutput + "Error on Henrys Constant Data input for " + sName + "/n";
    		        	  }
    		        	
    		        	  //continue interpretating input data
    		        	
    		        	  //reference henrys constant
    		        	  dValue = Double.parseDouble(lineArray[3])*uc.getUCF("HenrysConstant",lineArray[4]);
    		        	  cMatch.setReferenceHenrysConstant(dValue);
    		        	
    		        	  //reference henrys constant temperature
    		        	  dValue = Double.parseDouble(lineArray[5])*uc.getUCF("Temperature", lineArray[6]);
    		        	  cMatch.setReferenceHenrysConstantTemp(dValue);
    		        	
    		        	  //critical temperature
    		        	  dValue = Double.parseDouble(lineArray[7])*uc.getUCF("Temperature", lineArray[8]);
    		        	  cMatch.setCritialTemp(dValue);
    		        	
    		        	  //normal boiling temperature
    		        	  dValue =  Double.parseDouble(lineArray[9])*uc.getUCF("Temperature", lineArray[10]);
    		        	  cMatch.setNormalBoilingPoint(dValue);
    		        	
    		        	  //enthalpy at reference temperature
    		        	  dValue =  Double.parseDouble(lineArray[11])*uc.getUCF("Enthalpy", lineArray[12]);
    		        	  cMatch.setEnthalpy(dValue);
    		        	}

    		        }
    			}
    			
    			fr.close();
    			
      }
    
    //read in the chemical risk values from a separate input file
  	public void readChemicalRiskData(String sFileName) throws IOException
  	{
  		 String key2;
  		 double dValue;
  		 double dRfC;
  		 
  		 
         FileReader fr = new FileReader(sFileName);
  		 BufferedReader br = new BufferedReader(fr);
  			 
  		 String currentLine;
  		 String[] lineArray = {""};
  		 String key;
  			
  		 while ((currentLine = br.readLine()) != null) 
  		 {
  				lineArray = currentLine.split(",",0);
  				
  				key=lineArray[0];
  				if (key.equalsIgnoreCase("Chemical"))
  			    {
  					
  					Chemical cMatch = null;
		        	key2 = lineArray[1];
		        	if (key2.equalsIgnoreCase("Inhalation Risk") || key2.equalsIgnoreCase("InhalationRisk"))
		        	{		
		               //find the chemical object with the correct name
		        	   String sName = lineArray[2];
                       String sTemp;
		    	       for (Chemical chemical:  alChemical)
		    	       {
		    	    	  sTemp = chemical.getName();
		    	    	  if (chemical.getName().equalsIgnoreCase(sName))
		    	    	  {
		    	    		  cMatch = chemical;
		    	    		  break;
		    	    	  }
		    	       } 
		        	  if(cMatch.equals(null))
		        	  {
		        		  //chemical data name mismatch
		        		  sErrorOutput = sErrorOutput + "Error on Inhalation Risk input for " + sName + "/n";
		        	  }
		        	  
		        	  //continue interpreting input data
		        	  
		        	  //cancer risk level
		        	  try
		        	  {
		        	    dValue = Double.parseDouble(lineArray[3]);
		        	    cMatch.setRiskLevel(dValue);
		        	    
		        	    //concentration for entered level
			        	  try
			        	  {
			        	    dValue = Double.parseDouble(lineArray[4])*uc.getUCF("RiskConcentration",lineArray[5]);
			        	    cMatch.setRiskConcentration(dValue);
			        	    //set indicator that risk level has been set
			        		//must have both the risk level and concentration set for the
			        		//risk level to have been "set"
			        		cMatch.setRiskLevelSet(true);
			        	  }
			        	  catch(Exception e)
			        	  {
			        		  //set indicator that risk level has been set
			        		  //must have both the risk level and concentration set for the
			        		  //risk level to have been "set"
			        		  cMatch.setRiskLevelSet(false);
			        	  }
		        	  
		        	    }
		        	    catch (Exception e)
		        	    {
		        		   //chemical default is that the risk level isn't set 
		        	    }
		        	  
		        	  //non-cancer risk:  reference concentration
                      try
                      {
                    	  dRfC = Double.parseDouble(lineArray[6])*uc.getUCF("RiskConcentration", lineArray[7]);
                    	  cMatch.setReferenceConcentration(dRfC);
                    	  cMatch.setReferenceConcentrationSet(true);
                      }
  					  catch (Exception e)
  					  {
  						  /*risk level not set*/
  						  cMatch.setReferenceConcentrationSet(false);  
  					  }
  			       }
		           else if (s.areTheyEqual(key2,"ScreeningLevel"))
		           {
		        	   //risk is evaluated through externally-determined screening level concentration
		        	  
		        	   //find the chemical object with the correct name
		        	   String sName = lineArray[2];
                       String sTemp;
		    	       for (Chemical chemical:  alChemical)
		    	       {
		    	    	  sTemp = chemical.getName();
		    	    	  if (chemical.getName().equalsIgnoreCase(sName))
		    	    	  {
		    	    		  cMatch = chemical;
		    	    		  break;
		    	    	  }
		    	       } 
		        	  if(cMatch.equals(null))
		        	  {
		        		  //chemical data name mismatch
		        		  sErrorOutput = sErrorOutput + "Error on Inhalation Risk input for " + sName + "/n";
		        	  }
		        	  
		        	  try
		        	  {
		        	    dValue = Double.parseDouble(lineArray[3]);
		        	    cMatch.setRiskLevel(dValue);
		        	    
		        	    //concentration for entered level
			        	  try
			        	  {
			        	    dValue = Double.parseDouble(lineArray[3])*uc.getUCF("RiskConcentration",lineArray[4]);
			        	    cMatch.setRiskConcentration(dValue);
			        	    //set indicator that risk level has been set
			        		//must have both the risk level and concentration set for the
			        		//risk level to have been "set"
			        		cMatch.setRiskLevelSet(true);
			        	  }
			        	  catch(Exception e)
			        	  {
			        		  //set indicator that risk level has been set
			        		  //must have both the risk level and concentration set for the
			        		  //risk level to have been "set"
			        		  cMatch.setRiskLevelSet(false);
			        	  }
		        	  
		        	    }
		        	    catch (Exception e)
		        	    {
		        		   //chemical default is that the risk level isn't set 
		        	    }		        	  
		        	  
		           }
  		       }
  		 }   //while loop end
  	}     
      
	   //add data for a chemical
	   private String addChemicalData(Chemical c, String[] lineArray)
	   {
		   
		   String sEol = System.getProperty("line.separator");
		   String key3 = lineArray[2];
		   String sOutput;
		   
		   sOutput = sEol;
		  
		  //chemical name 
		
		  //if constant
		  if (key3.equalsIgnoreCase("Constant"))
		  {  
			//molecular weight
		    sOutput = sOutput + ", Molecular Weight " + ", " + lineArray[4] + ", " + lineArray[5];
			sOutput = sOutput + addDataItem(c,"MolecularWeight",lineArray[4],lineArray[5],"MolecularWeight") + sEol;
			  
			//solubility
			sOutput = sOutput + ", Solubility " + ", " + lineArray[6] + ", " + lineArray[7];
			sOutput = sOutput + addDataItem(c,"Solubility",lineArray[6],lineArray[7],"Solubility") + sEol;
			  
			//density
			sOutput = sOutput + ", Density " + ", " + lineArray[8] + ", " + lineArray[9];
			sOutput = sOutput + addDataItem(c,"Density",lineArray[8],lineArray[9],"Density") + sEol;
			  
			//koc 
			sOutput = sOutput + ", Koc " + ", " + lineArray[10] + ", " + lineArray[11];
			sOutput = sOutput + addDataItem(c,"Koc",lineArray[10],lineArray[11],"Koc") + sEol;
			  
			  
		    //dimensionless henry's law coefficient
			/*
			sOutput = sOutput + ", Henrys Constant " + ", " + lineArray[12] + ", " + lineArray[13];
			sOutput = sOutput + addDataItem(c,"HenrysConstant",lineArray[12],lineArray[13],"HenrysConstant") + sEol;
			*/
			
		    //utilization factor phi
			sOutput = sOutput + ", Utilization Factor " + ", " + lineArray[12] + ", " + lineArray[13];
		    sOutput = sOutput + addDataItem(c,"UtilizationFactor",lineArray[12],lineArray[13],"Phi") + sEol;
		    
		    //diffusion coefficient in air
		    sOutput = sOutput + ", Diffusion Coefficient in Air " + ", " + lineArray[14] + ", " + lineArray[15];
		    sOutput = sOutput + addDataItem(c,"DiffusionCoefficientInAir",lineArray[14],lineArray[15],"diffusionCoefficient") + sEol;
		    
		    //diffusion coefficient in water
		    sOutput = sOutput + ", Diffusion Coefficient in Water " + ", " + lineArray[16] + ", " + lineArray[17];
		    sOutput = sOutput + addDataItem(c,"DiffusionCoefficientInWater",lineArray[16],lineArray[17],"diffusionCoefficient") + sEol;
		    
		    //degradation rate
		    sOutput = sOutput + ", Degradation Rate Constant " + ", " + lineArray[18] + ", " + lineArray[19];
		    sOutput = sOutput + addDataItem(c,"Degradation",lineArray[18],lineArray[19],"RateConstant") + sEol;
		    
		    
		  }
		  else if (key3.equalsIgnoreCase("Variable"))
		  {	  
				//molecular weight
			    sOutput = sOutput + ", Molecular Weight " + ", " + lineArray[4] + ", " + lineArray[5];
				sOutput = sOutput + addDataItemVariable(c,"MolecularWeight",lineArray[4],lineArray[5],"MolecularWeight",lineArray[20]) + sEol;
				  
				//solubility
				sOutput = sOutput + ", Solubility " + ", " + lineArray[6] + ", " + lineArray[7];
				sOutput = sOutput + addDataItemVariable(c,"Solubility",lineArray[6],lineArray[7],"Solubility",lineArray[20]) + sEol;
				  
				//density
				sOutput = sOutput + ", Density " + ", " + lineArray[8] + ", " + lineArray[9];
				sOutput = sOutput + addDataItemVariable(c,"Density",lineArray[8],lineArray[9],"Density",lineArray[20]) + sEol;
				  
				//koc 
				sOutput = sOutput + ", Koc " + ", " + lineArray[10] + ", " + lineArray[11];
				sOutput = sOutput + addDataItemVariable(c,"Koc",lineArray[10],lineArray[11],"Koc",lineArray[20]) + sEol;				  
			  
			  
			    //dimensionless henry's law coefficient
				/*
			    sOutput = sOutput + ", Henrys Constant " + ", " + lineArray[12] + ", " + lineArray[13];
			    sOutput = sOutput + addDataItemVariable(c,"HenrysConstant",lineArray[12],lineArray[13],"HenrysConstant",lineArray[22]) + sEol;
                */
				
			    //utilization factor phi
			    sOutput = sOutput + ", Utilization Factor " + ", " + lineArray[12] + ", " + lineArray[13];
			    sOutput = sOutput + addDataItemVariable(c,"UtilizationFactor",lineArray[12],lineArray[13],"Phi",lineArray[20]) + sEol;
	
			    //diffusion coefficient in air
			    sOutput = sOutput + ", Diffusion Coefficient in Air " + ", " + lineArray[14] + ", " + lineArray[15];
			    sOutput = sOutput + addDataItemVariable(c,"DiffusionCoefficientInAir",lineArray[14],lineArray[15],"diffusionCoefficient",lineArray[20]) + sEol;

			    //diffusion coefficient in water
			    sOutput = sOutput + ", Diffusion Coefficient in Water " + ", " + lineArray[16] + ", " + lineArray[17];
			    sOutput = sOutput + addDataItemVariable(c,"DiffusionCoefficientInWater",lineArray[16],lineArray[17],"diffusionCoefficient",lineArray[20]) + sEol;

			    //degradation rate
			    sOutput = sOutput + ", Degradation Rate Constant " + ", " + lineArray[18] + ", " + lineArray[19];
			    sOutput = sOutput + addDataItemVariable(c,"Degradation",lineArray[18],lineArray[19],"RateConstant",lineArray[20]) + sEol;
			 
		  }
		   
		 return sOutput;  
		
	   }    
	   //set individual bit of Variable data
	   private String addDataItemVariable(PVIScreenData bvd, String key2m, String sValue, String sUnit, String sUnitType, String sFrequency)
	   {
		  String sReturn="";;
		  OutputDigits od = new OutputDigits();
		  //key2m = modified key2 (i.e., no spaces included)
		  //sValue = string version of data item value
		  //sUnit = string unit (i.e. cm, cm3/sec, 1/hr, ft, etc)
		  //sUnitType = name for type of unit (i.e., length, mass, concentration)
		  //  (No spaces allowed use "camel case" e.g., RateConstant)
		  //sFrequency = string version of frequency value
		  double value = Double.parseDouble(sValue)*uc.getUCF(sUnitType,sUnit);
		  double frequency = Double.parseDouble(sFrequency);
		  bvd.setCumulativeDistributionValue(key2m, value, frequency);
		  bvd.setCurrentRandomValue(key2m,0.5);
		  bvd.setCalculationUnit(key2m,uc.getModelUnit(sUnitType));
		  //TODO decied if this is needed
		  //if (frequency==1.0){addStatisticalDistribution(bvd.getStatisticalDistribution(key2m,bvd.getName()));}	
		  //limit the number of output digits
		  od.setValue(value);
		  sReturn = ", converted to: " + od.num2String() + " " + uc.getModelUnit(sUnitType);
		  return sReturn;  
	   }   
	   
	   //set individual bit of constant data
	   private String addDataItem(PVIScreenData bvd, String key2m, String sValue, String sUnit, String sUnitType)
	   {
		  String sReturn = "";
		  OutputDigits od = new OutputDigits();
		  //key2m = modified key2 (i.e., no spaces included
		  //sValue = string version of data item value
		  //sUnit = string unit
		  //sUnitTupe = name for type of unit (i.e., length, mass, concentration) 
		  //  (No spaces allowed use "camel case" e.g., RateConstant)
		  double value = Double.parseDouble(sValue)*uc.getUCF(sUnitType,sUnit);
		  bvd.setStatisticalDistributionValue(key2m, value);
		  bvd.setCurrentRandomValue(key2m,0.5);
		  bvd.setCalculationUnit(key2m,uc.getModelUnit(sUnitType));
		  //limit the number of output digits
		  od.setValue(value);
		  sReturn = ", converted to " + od.num2String() + " " + uc.getModelUnit(sUnitType);
		  return sReturn;
	   }
	   
    //sets
    public void setFileLoggerOutput(FileLogger flOutput){this.flOutput = flOutput;}
    public void setUnitConverter(UnitConverter uc){this.uc = uc;}
    
    //get
    public ArrayList<Chemical> getChemicalData(){return alChemical;}
    public String getKnownErrorOutput(){return sErrorOutput;}
}
