package pviScreen;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

import util.OutputDigits;
import util.UnitConverter;
import util.FileLogger;

public class FieldData extends PVIScreenData
{
	private UnitConverter uc;
	private FileLogger fl;
    private ArrayList<CoreDataContainer> alCore;
    private double dDepthToBottom;
	
	public FieldData(){}
	
	public void readFile(String sFieldDataFileName) throws IOException
	{
		String key2;
	    String sConvertedOutput="";
	    String sErrorOutput="";
	      
	    FileReader fr = new FileReader(sFieldDataFileName);
		BufferedReader br = new BufferedReader(fr);
			 
	    String currentLine;
	    String[] lineArray = {""};
		String key;
			
		alCore = new ArrayList<CoreDataContainer>();
		
			while ((currentLine = br.readLine()) != null) 
			{
				lineArray = currentLine.split(",",0);

				//read each line and prepare data according to key words
				key = lineArray[0];
	    
		        if (key.equalsIgnoreCase("Oil Lens") || key.equalsIgnoreCase("OilLens"))
		        {
			      key2 = lineArray[1];
		          sConvertedOutput = "";
		          sErrorOutput = "";
			      if (key2.equalsIgnoreCase("Begin Core") || key2.equalsIgnoreCase("BeginCore")){}
			      if (key2.equalsIgnoreCase("Heading")){}
			      else if (key2.equalsIgnoreCase("CoreData") || key2.equalsIgnoreCase("core data"))
			      {
				    
	  	             CoreDataContainer cdc = new CoreDataContainer();
	  	             
	  	             cdc.setName(lineArray[2]);
	  				 double dDepth = Double.parseDouble(lineArray[3])*uc.getUCF("Length",lineArray[4]);
	  				 cdc.setDepth(dDepth);
	  				 double dConcentration = Double.parseDouble(lineArray[5])*uc.getUCF("MassFraction", lineArray[6]);
	  				 cdc.setConcentration(dConcentration);
	  	             
	  	             //add the data
	  				 OutputDigits od = new OutputDigits();
	  				 od.setValue(dDepth);
	  	             sConvertedOutput  = ", converted to: ," + od.num2String() + " " + uc.getModelUnit("Length"); 
	  	             od.setValue(dConcentration);
	  	             sConvertedOutput = sConvertedOutput + ", " + od.num2String() + " " + uc.getModelUnit("MassFraction");
	  	             alCore.add(cdc);
			 
			       }
			       
			       else if (key2.equalsIgnoreCase("EndCore") || key2.equalsIgnoreCase("End Core"))
			       {
				     //add chemical data object to the arraylist of chemicals
				     //alChemical.add(c);
			    	
			       } 
			       String sOut = arrayToString(lineArray);
				   fl.logMessage(sOut + sConvertedOutput + sErrorOutput); 
		        }
		      }
			
			//close the input file
			fr.close();
			
    }

	/**
	 * arrayToString    Convert a string array to a single string with entries separated by commas
	 * 
	 * @param lineArray    string array
	 * @return             string containing contents of array, separated by commas
	 */
	private String arrayToString(String[] lineArray)
	{
		String sOut="";
		for (int i=0;i<lineArray.length;i++){sOut = sOut + lineArray[i] + ", ";}
		return sOut;
	}
	
	
	/**
	 * setElevations  = sets the elevations for the field data (i.e., elevations corresponding to depths)
	 */
	public void setElevations(double dDepthToBottom)
	{
	   //the depth to the bottom is the depth to the datum at the bottom of the domain
	   this.dDepthToBottom = dDepthToBottom;
	   
	   //set elevations of all core data
	   for (CoreDataContainer cdc: alCore)
	   {
		   cdc.setElevation(dDepthToBottom - cdc.getDepth());
	   }
		
	}
	
	
	//sets
	public void setUnitConverter(UnitConverter uc){this.uc = uc;}
	public void setFileLogger(FileLogger fl){this.fl = fl;}
	
	//gets
	public ArrayList<CoreDataContainer> getCoreData(){return alCore;}
	
	
	

	
}
	

