package pviScreen;

import java.util.ArrayList;

//Container to hold linked parameter definitions
//a dependent parameter is linked to an independent parameter
//the value of the dependent parameter is the multiplier times the independent parameter value
public class LinkedParameters 
{
   private ArrayList<String> alIndependentParameter;
   private ArrayList<String> alDependentParameter;
   private ArrayList<String> alOperator;
   private ArrayList<Double> alMultiplier;
   private boolean bAtLeastOne;
   
   
   public LinkedParameters()
   {
	   //indicate that initially there are no linked parameters
	   bAtLeastOne = false;
	   //initialize the arraylists
	   alIndependentParameter = new ArrayList<String>();
	   alDependentParameter = new ArrayList<String>();
	   alOperator = new ArrayList<String>();
	   alMultiplier = new ArrayList<Double>();
   }
   
   
   //add
   public void addLinkedParameter(String sDependentParameter,
		                          String sIndependentParameter,
		                          String sOperator,
		                          double dMultiplier)
   {
	   this.alIndependentParameter.add(sIndependentParameter);
	   this.alDependentParameter.add(sDependentParameter);
	   this.alOperator.add(sOperator);
	   this.alMultiplier.add(dMultiplier);
	   this.bAtLeastOne = true;
   }
   
   //get
   public String getIndependentParameter(int iIndex){return this.alIndependentParameter.get(iIndex);}
   public String getDependentParameter(int iIndex){return this.alDependentParameter.get(iIndex);}
   public String getOperator(int iIndex){return this.alOperator.get(iIndex);}
   public double getMultiplier(int iIndex){return this.alMultiplier.get(iIndex);}
   public int getLinkedParameterCount()
   {
	   /*
	   if (bAtLeastOne){return this.alDependentParameter.size();}
	   else {return 0;}
	   */
	   return this.alDependentParameter.size();
	   
   }   
}
