package pviScreen;

import java.util.ArrayList;

import numerics.Bisection.Bisection;


/**
 * OilLensField == extends OilLens to implement field-data based calculations of oil saturation and
 *   oil extend
 * @author Jim Weaver
 * 
 * 9-7-2012
 *
 */
public class OilLensField extends OilLens
{
	ArrayList<CoreDataContainer> alCore;
	private int iNumberDataPoints;
	private double[] dC;
	private double[] dZ;
	private double[] dD;
	private String[] sN;
	private double dZMin, dZMax;
	private double dCMin, dCMax;
	private double dSoMin, dSoMax;
    	
	
    OilLensField(){super();}
    
	public void findTopOfOilZone()
	{	 
		//set the elevations relative to the datum
		this.setElevations();
		
		this.dElevTopOilZone = dZMax;
		
		//oil zone thickness
		this.dOilZoneThickness = this.dElevTopOilZone - this.dElevWaterTable;		
		
		//fuel volume per unit area		
		this.dFuelVolumePerUnitArea = this.getFuelVolumePerUnitArea();
	
		//set the maximum oil saturation
		this.dMaxOilSaturation = dSoMax;		
	} 
	
	
	public void setElevations()
	{
	  dElevWaterTable = vz.getDepthToBottom()-vz.getDepthToWaterTable();
	  dElevHistoricWaterTable = vz.getDepthToBottom()-vz.getDepthToHistoricWaterTable();
	  dElevSurface = vz.getDepthToBottom();
	  
	  //set the elevations in the field data object
	  fd.setElevations(vz.getDepthToBottom());
	  
	  //get the core data and sort it
	  iNumberDataPoints = alCore.size();
	  dC = new double[this.iNumberDataPoints];
	  dZ = new double[this.iNumberDataPoints];
	  dD = new double[this.iNumberDataPoints];
	  sN = new String[this.iNumberDataPoints];
	  
	  int ii = 0;
	  for (CoreDataContainer cdc: alCore)
	  {
 
		  dC[ii] = cdc.getConcentration();
		  dZ[ii] = cdc.getElevation();
		  dD[ii] = cdc.getDepth();
		  sN[ii] = cdc.getName();
		  ii++;
	  }
	  
	  double dZTemp;
	  double dDTemp;
	  double dCTemp;
	  String sNTemp;
	  dZMin = 1.0e20;
	  dZMax = -1.0e20;
	  dCMin = 1.0e20;
	  dCMax = -1.0e20;
	  
	  //sort the data
	   boolean bChanged = true;
	   //now the sorting starts:
	   while (bChanged == true) 
	   {
		 bChanged = false;
	     for (int i=0;i<this.iNumberDataPoints-1;i++)
	     {
		    //sort from elevation lowest to highest 
		    if (dZ[i]>dZ[i+1])
		    {
			  dZTemp = this.dZ[i+1];
			  dDTemp = this.dD[i+1];
			  dCTemp = this.dC[i+1];
			  sNTemp = this.sN[i+1];
			  this.dZ[i+1] = this.dZ[i];
			  this.dD[i+1] = this.dD[i];
			  this.dC[i+1] = this.dC[i];		  
			  this.sN[i+1] = this.sN[i];			  
			  this.dZ[i] = dZTemp;
			  this.dD[i] = dDTemp;
			  this.dC[i] = dCTemp;
			  this.sN[i] = sNTemp;
			  bChanged = true;
		    }
	      }
	   }  
	   
	   //find the minimums and maximums
	   for (int i=0;i<this.iNumberDataPoints;i++)
	   {
		   if (dZ[i]<dZMin){dZMin = dZ[i];}
		   if (dZ[i]>dZMax){dZMax = dZ[i];}
		   if (dC[i]<dCMin){dCMin = dC[i];}
		   if (dC[i]>dCMax){dCMax = dC[i];}
	   }
	   //min and max saturation
	   dSoMin = dCMin*(1.0/vz.getBulkDensity())*(1.0/this.getOilDensity())*(1.0/vz.getPorosity());
	   dSoMax = dCMax*(1.0/vz.getBulkDensity())*(1.0/this.getOilDensity())*(1.0/vz.getPorosity());
	   
	  
	}
	
	public double getOilSaturation(double dElevation) 
	{
       double dSo;

       //US EPA lab notebook Ada JWW-01, page 189:  
	   //starting possibility
       dSo = 0.0;
 
       if (dElevation<dElevHistoricWaterTable){dSo = 0.0;}
       else if (dElevHistoricWaterTable<=dElevation && dElevation<=this.dElevTopOilZone)
       {
    	  //search through core data
          for (int i=0;i<this.iNumberDataPoints-1;i++) 
          {
        	  if (dZ[i]<=dElevation && dElevation<=dZ[i+1])
        	  {
        		double dSl = (dC[i+1]-dC[i])/(dZ[i+1]-dZ[i]); 
        		double dCc = dC[i] + (dElevation-dZ[i])*dSl;
        		
        		//convert the concentration to oil saturation
        		dSo = dCc*(1.0/vz.getBulkDensity())*(1.0/this.getOilDensity())*(1.0/vz.getPorosity());
        	  }
          }  
       }
       else if (this.dElevTopOilZone<dElevation)
       {
    	   dSo = 0.0;
       }
       
   
	   return dSo;
	}			
    
	public double getFuelVolumePerUnitArea()
	{
		//James W. Weaver lab notebook JWW ADA-01, page 194
		double dFuelVolumePerUnitArea=0.0;
		
		double dSum = 0.0;
		for (int i=0;i<this.iNumberDataPoints-1;i++)
		{
			dSum = dSum + (dC[i+1]-dC[i])/(dZ[i+1]-dZ[i]);				
		}
		
		//convert to oil saturation
		dSum = dSum*(1.0/vz.getBulkDensity())*(1.0/this.getOilDensity())*(1.0/vz.getPorosity());
		 
		//oil volume per unit area:
		dFuelVolumePerUnitArea = dSum*vz.getPorosity();
		
		return dFuelVolumePerUnitArea;
	}
	
	//sets
	public void setFieldData(){this.fd = fd;}
	public void setCoreData(ArrayList<CoreDataContainer> alCore){this.alCore = alCore;}
}
