package pviScreen;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import util.FileLogger;
import util.NameConstants;
import util.Stripper;
import util.UnitConverter;

public class OutputUnitReader 
{
    private UnitConverter uc;
    
	public OutputUnitReader(){}
	

	public void readOutputUnits(String sFile) throws IOException
	{
		FileReader fr;
		try{ fr = new FileReader(sFile);}
		catch (Exception e)
		{
			//file missing;  generate new file and read again
			fr = new FileReader(generateReplacementOutputUnitsFile());
		}

		BufferedReader br = new BufferedReader(fr);
		Stripper s = new Stripper();

		String currentLine;
		String[] lineArray= {""};

		currentLine = br.readLine();
		lineArray = currentLine.split(",",0);
		//is the file correct?
		if (!s.areTheyEqual("Output Unit File",lineArray[0],' '))
		{
			System.out.println("Incorect Output Unit File");
		}


		//read each line in the file
		while ((currentLine = br.readLine()) != null) 
		{
			String key, key2, key3;

			key = ""; key2 = ""; key3 = "";


			lineArray = currentLine.split(",",0);
			key = lineArray[0];
            key2 = lineArray[1];

			if (s.areTheyEqual(key2,"OutputUnit",' '))
			{
				//output unit choices 
				uc.addOutputUnit(lineArray[2], lineArray[3]);
			}
		

		}

		//close input file
		fr.close();
	}
	
	private String generateReplacementOutputUnitsFile()
	{
		 
			FileLogger fl = new FileLogger("src/systemData/07OutputUnits.csv");
			fl.openOverWriteFile();

			fl.logMessageOverWrite("Output Unit File");
			
			
			fl.logMessageOverWrite("Control,Begin");
			fl.logMessageOverWrite("Control,Output Unit,length,ft");
			fl.logMessageOverWrite("Control,Output Unit,Concentration Air,ug/m3");		
			fl.logMessageOverWrite("Control,Output Unit,RiskConcentration,ug/m3");
			fl.logMessageOverWrite("Control,Output Unit,SoilSample,mg/kg");
			fl.logMessageOverWrite("Control,Output Unit,WaterPhaseConcentration,mg/L");
			fl.logMessageOverWrite("Control,End");	
			
			fl.closeOverWriteFile();
			
			
			return "src/systemData/07OutputUnits.csv";
		
	}

	public void setUnitConverter(UnitConverter uc){this.uc = uc;}
	
}
