package pviScreen;

/**
 * <p>Title: Oxygen (as a Chemical)</p>
 *
 * <p>Description: Oyxgen class to use functions and data from chemical plus a few others</p>
 *
 * <p>Copyright: no copyright claimed</p>
 *
 * <p>Company: US EPA</p>
 *
 * @author Jim Weaver
 * @version 1.0
 *
 * 4-12-2011
 *
 */
public class Oxygen extends Chemical
{
  private double cMin;
  private double cSurface;
  private double jSurface;

  public Oxygen()
  {
	  super();
      sName = "oxygen";
      //super.createNewDistribution("HenrysConstant");
      super.createNewDistribution("Oxygen","DiffusionInAir");
      super.createNewDistribution("Oxygen","DiffusionInWater");
      super.createNewDistribution("Oxygen","MinimumBiodegradationConcentration");
      super.createNewDistribution("Oxygen","SurfaceConcentration");
  }
  
  public void correctHenrysConstantForTemperature()
  {  
	  double dRc = 1.9872;

	  //temperature conversion from USEEPA OSWER 2001
	  
	  double dTempSoil = vz.getSoilTemperature() + 273.15;

	  this.dHReferenceTemp = 25 + 273.15;
	  this.dHReference = 32.1;
	  this.dHCorrected = Math.exp(- 1700.0 * (  1.0/dTempSoil - 1.0/this.dHReferenceTemp))*this.dHReference;
	  this.setHenrysConstant(this.dHCorrected);
  }
  
  
  
  //simple sets
   public void setSurfaceFlux(double jSurface){this.jSurface = jSurface;}
   public void setHenrysConstant(double dValue){this.kh = dValue;} 
   public void setDa(double dValue){this.da = dValue;this.setConstantDistribution(dValue,"DiffusionInAir");}
   public void setDw(double dValue){this.dw = dValue;this.setConstantDistribution(dValue,"DiffusionInWater");}
   public void setMinBiodegradationConcentration(double dValue){this.cMin = dValue;this.setConstantDistribution(dValue,"MinimumBiodegradationConcentration");}
   public void setSurfaceConcentration(double dValue){this.cSurface = dValue;this.setConstantDistribution(dValue,"SurfaceConcentration");}  

   //gets
   public double getNetSurfaceConcentration(){return this.getSurfaceConcentration() - this.getMinBiodegradationConcentration();}
   //gets from StatisticalDistribution objects
   public double getMinBiodegradationConcentration(){return getCurrentRandomValue("MinimumBiodegradationConcentration",this.getName());}
   public double getSurfaceConcentration(){return getCurrentRandomValue("SurfaceConcentration",this.getName());}
   public double getDa(){return getCurrentRandomValue("DiffusionInAir",this.getName());}
   public double getDw(){return getCurrentRandomValue("DiffusionInWater",this.getName());}
  
   //simple gets
   //public double getSurfaceConcentration(){return cSurface;}
   //public double getMinBiodegradationConcentration(){return cMin;}
   public double getSurfaceFlux(){return jSurface;}
   public double getHenrysConstant(){return this.kh;}
}
