package pviScreen;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

 

import util.CalendarClock;


public class PVIScreen 
{
    private static RUNPVIScreen rps;
    
	/**
	 * run multiple PVIScreen input files from a list contained in:
	 * 00InputSetsToRun.csv
	 * 
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException 
	{
		String currentLine;
	       
        String sOutputFileTime;
		CalendarClock cc = new CalendarClock();
		FileReader fr = new FileReader("00InputSetsToRun.csv");
		BufferedReader br = new BufferedReader(fr);
	
        
        
        
        
        //set a common string for the run time to embed in all the output file names 
        sOutputFileTime = cc.getDateTimeString();
       
        //run PVISCREEN for each file listed in 00InputSetsToRun.csv
		while ((currentLine = br.readLine()) != null) 
		{
			 //required function calls to run PVIScreen for an input file:
	         rps = new RUNPVIScreen();
	         rps.setOutputFileTime(sOutputFileTime);
	         rps.setDataFileName(currentLine);
	         rps.runPVIScreen();
		}     
	   
		
	}
	
	//run from the GUI
	//only run a single input file
	public String runOneInputSetFromGUI(String sFile) throws IOException 
	{
		CalendarClock cc = new CalendarClock();
        String sOutputFileTime = cc.getDateTimeString();
        
        rps = new RUNPVIScreen();
        rps.setOutputFileTime(sOutputFileTime);
        rps.setDataFileName(sFile);
        rps.runPVIScreen();
        
        return "Run Completed for " + sFile;
	     
	}
	
	//determine the solution for the average set of parameters
	

	
	//gets
	
	//get output files names from the RUNPVIScreen
	//(really for use with the runOneInputSetFromGUI method)
	public String getOutputFileName(){return rps.getOutputFileName();}
	public String getOutputFileNameStatistics(){return rps.getOutputFileNameStatistics();}
	public ArrayList<Chemical> getChemicals(){return rps.getChemicals();}
}

