package pviScreen;

import java.util.ArrayList;

import uncertaintyAnalysis.StatisticalDistribution;
import util.FileLogger;
import util.UnitConverter;
import util.UnitDefinition;

/**
 * BioVaporControlData   data container for BioVapor control data
 * @author JWEAVER
 * 8-18-2012
 */
public class PVIScreenControlData 
{
	//test for input errors
	private boolean bRun;
	//string containing list of errors
	private String sErrorOutput;
	//file logger for output
	private FileLogger fl;
	//run identifiers
	private RunIdentifier runID;
	//vadose zone data
	private VadoseZone vz;
	//building data
	private Building bld;
	//oxygen data
	private Oxygen oxygen;
	//aquifer data
	private AquiferData ad;
	//oil lens data
	private OilLens old;
	//oil lens field data
	private FieldData fd;
	//other data for dropdown boxes:   risk levels; dirt floor: yes/no; oil distribution types; browsers
	private ParameterChoices pd;
	//chemical data (many can be accomodated)
	private ArrayList<Chemical> vzChemicals;
	//risk level
	private ArrayList<Double> alRiskLevel;
	//hazard quotient
	private ArrayList<Double> alHazardQuotient;
	//statisticalDistribution
	private ArrayList<StatisticalDistribution> sDistribution;
    //Monte Carlo simulation (true) or not (false)
	private boolean bMonteCarlo;
	//number of monte carlo runs
	private int iNumberOfRuns;
	//number of frequency distribution intervals
	private int iNumberOfFrequencyIntervals;
	//type of oil distribution at the water table:  field or capillary
	private String sOilDistributionType;
	//file name for oil distribution type of field
	private String sOilDistributionFileName;
	//maximum exponent for exponential formulas (alternate forms use if above this value)
	private double dMaxAlpha;
	//lower limit for bisection simulation (minimum depth--equals location very near surface)
	private double dBisectionLowerLimit;
	//tolerance for bisection iteration
	private double dBisectionTolerance;
    //maximum number of iterations in bisection
	private int iBisectionMaxIterations;
	//unit definitions for outputs
	private ArrayList <UnitDefinition> alUnitDefinition;
	//unit converter (from BioVaporReader)
	private UnitConverter uc;
	//raw input data (not unit converted, but will all original inputs)
	private RawInput ri;
	//linked parameter definitions
	private LinkedParameters lp;
	//name of the browser
	private String sBrowserName;
	//user-input risk levels (to override defaults in alRiskLevel; alHazardQuotient)
	private Risk risk;
	//groundwater concentration adjustment factor
	private double dGroundWaterAdjustmentFactor;
	//soilsample concentration adjustment factor
	private double dSoilSampleAdjustmentFactor;
	//list of all errors
	private ArrayList<String>alErrorOutput;
	//are screening levels used as input?
	private boolean bScreeningExists;
	
	public PVIScreenControlData()
	{
	  //model will only run if this is set to true by the PVIScreen Readers	
	  bRun = false;
	  //list of errors
	  sErrorOutput = "";
      //monte carlo flag
	  bMonteCarlo = false;
	  //bisection defaults
	  dBisectionLowerLimit = 0.0001;
	  iBisectionMaxIterations = 100;
	  dBisectionTolerance = 1.e-6;
	  //some defaults to be overwritten
	  this.iNumberOfFrequencyIntervals=40;
	  this.sOilDistributionType = "capillary";
	  this.sOilDistributionFileName = "";
	  alRiskLevel = new ArrayList<Double>();
	  alHazardQuotient = new ArrayList<Double>();
	  this.sBrowserName = "";
	  alErrorOutput = new ArrayList<String>();
	  this.bScreeningExists = false;
	}
	
	public void checkData()
	{
		//depth relationships
		if (!(bld.getFoundationDepthBelowGrade() <= vz.getDepthToSample() && vz.getDepthToSample() <= vz.getDepthToWaterTable()))
		{
			//depth relationships not OK
			addToKnownErrorOutput("Contaminant source NOT between bottom of foundation and water table");
		}
	}
	
	
	public void setCanRunModel()
	{
		//model will run only if no errors were found in input
		bRun = true;
		for (String string: this.alErrorOutput)
		{
			if (!string.equals("")){bRun = false;}
		}
	}
	
	//clears
	public void clearRiskLevels()
	{
		alRiskLevel = new ArrayList<Double>();
		alHazardQuotient = new ArrayList<Double>();
	}
	
	
	//adds
	public void addToKnownErrorOutput(String sError)
	{
		if(!sError.equalsIgnoreCase(""))
		{
			this.sErrorOutput = this.sErrorOutput + sError + "\n";
			//accumulate errors in arraylist also
			alErrorOutput.add(sError);
		}
	}
	public void addRiskLevel(double dRisk){this.alRiskLevel.add(dRisk);}
	public void addHazardQuotient(double dHazard){this.alHazardQuotient.add(dHazard);}
	
	
	//simple sets
	public void setFileLogger(FileLogger fl){this.fl = fl;}
	public void setVadoseZone(VadoseZone vz){this.vz = vz;}
	public void setBuilding(Building bld){this.bld = bld;}
	public void setOxygen(Oxygen oxygen){this.oxygen = oxygen;}
	public void setAquiferData(AquiferData aquiferData){this.ad = aquiferData;}
	public void setOilLensData(OilLens old){this.old = old;}
	public void setFieldData(FieldData fd){this.fd = fd;}
	public void setChemicals(ArrayList<Chemical>vzChemicals){this.vzChemicals = vzChemicals;}
	public void setStatisticalDistribution(ArrayList<StatisticalDistribution> sDistribution){this.sDistribution = sDistribution;}
	public void setIsMonteCarlo(boolean bMonteCarlo){this.bMonteCarlo = bMonteCarlo;}
	public void setNumberOfRuns(int iNumberOfRuns){this.iNumberOfRuns = iNumberOfRuns;}
	public void setNumberOfFrequencyDistributionIntervals(int i){this.iNumberOfFrequencyIntervals=i;}
	public void setOilDistributionType(String sType){this.sOilDistributionType=sType;}
	public void setOilDistributionFileName(String sName){this.sOilDistributionFileName = sName;}
	public void setMaxAlpha(double dMaxAlpha){this.dMaxAlpha = dMaxAlpha;}
	public void setBisectionLowerLimit(double dBisectionLowerLimit){this.dBisectionLowerLimit = dBisectionLowerLimit;}
	public void setBisectionTolerance(double dBisectionTolerance){this.dBisectionTolerance = dBisectionTolerance;}
	public void setBisectionMaxIterations(int iBisectionMaxIterations){this.iBisectionMaxIterations =  iBisectionMaxIterations;}
	public void setOutputUnitDefinition(ArrayList<UnitDefinition> alUnitDefinition){this.alUnitDefinition = alUnitDefinition;}
    public void setUnitConverter(UnitConverter uc){this.uc = uc;}
    public void setRawInput(RawInput ri){this.ri = ri;}
    public void setRunIdentifier(RunIdentifier runID){this.runID = runID;}
    public void setLinkedParameters(LinkedParameters lp){this.lp = lp;}
    public void setBrowserName(String s){this.sBrowserName = s;}
    public void setParameterChoices(ParameterChoices pd){this.pd = pd;}
    public void setGroundWaterConcentrationAdjustmentFactor(double dG){this.dGroundWaterAdjustmentFactor = dG;}
    public void setSoilSampleConcentrationAdjustmentFactor(double dSS){this.dSoilSampleAdjustmentFactor = dSS;}
    public void setDoesScreeningExist(boolean bScreeningExists){this.bScreeningExists = bScreeningExists;}
    //public void setRisk(Risk risk){this.risk = risk;}
	
	//simple gets
    public boolean getCanRunModel(){return bRun;}
    public String getKnownErrors(){return this.sErrorOutput;}
	public FileLogger getFileLogger(){return fl;}
	public VadoseZone getVadoseZone(){return vz;}
	public Building getBuilding(){return bld;}
	public Oxygen getOxygen(){return oxygen;}
	public AquiferData getAquiferData(){return ad;}
	public OilLens getOilLens(){return old;}
	public FieldData getFieldData(){return fd;}
	public ArrayList<Chemical> getChemicals(){return vzChemicals;}
	public ArrayList<StatisticalDistribution> getStatisticalDistribution(){return sDistribution;}
	public boolean getIsMonteCarlo(){return bMonteCarlo;}
	public int getNumberOfRuns(){return iNumberOfRuns;}
	public int getNumberOfFrequencyDistributionIntervals(){return this.iNumberOfFrequencyIntervals;}
	public String getOilDistributionType(){return this.sOilDistributionType;}
	public String getOilDistributionFileName(){return this.sOilDistributionFileName;}
	public double getMaxAlpha(){return dMaxAlpha;}
	public double getBisectionLowerLimit(){return dBisectionLowerLimit;}
	public double getBisectionTolerance(){return dBisectionTolerance;}
	public int getBisectionMaxIterations(){return iBisectionMaxIterations;}
	public ArrayList<UnitDefinition> getOutputUnitDefinition(){return alUnitDefinition;}
	public UnitConverter getUnitConverter(){return uc;}
	public RawInput getRawInput(){return this.ri;}
	public ArrayList<Double> getRiskLevels(){return this.alRiskLevel;}
	public ArrayList<Double> getHazardQuotients(){return this.alHazardQuotient;}
	public RunIdentifier getRunIdentifier(){return this.runID;}
	public LinkedParameters getLinkedParameters(){return this.lp;}
	public String getBrowserName(){return this.sBrowserName;}
	public ParameterChoices getParameterChoices(){return this.pd;}
	public double getGroundWaterConcentrationAdjustmentFactor(){return this.dGroundWaterAdjustmentFactor;}
	public double getSoilSampleConcentrationAdjustmentFactor(){return this.dSoilSampleAdjustmentFactor;}
	//public Risk getRisk(){return this.risk;}
	public ArrayList<String> getErrorOutput(){return this.alErrorOutput;}
	public boolean getDoesScreeningExist(){return this.bScreeningExists;}
}
