package pviScreen;

import java.util.ArrayList;
import java.util.Random;

import uncertaintyAnalysis.RandomNumber;
import uncertaintyAnalysis.StatisticalDistribution;

/**
 * PVISCreenDataData -- template data container for PVIScreen data
 * especially handles StatisticalDistributions for LatinHyperCube Monte Carlo simulations
 * @author JWEAVER
 * 8-10-2012
 */
public abstract class PVIScreenData 
{
    protected String sName;
    protected String sCalculationUnit;
    protected ArrayList<StatisticalDistribution>sdPVIScreen;
    protected ArrayList<String[]> alExternalSource;
    protected ArrayList<LinkedParameters> alLinkedParameters;
    protected RandomNumber random;
    
    public PVIScreenData()
    {
    	sdPVIScreen = new ArrayList<StatisticalDistribution>();
    	alExternalSource = new ArrayList<String[]>();
    	alLinkedParameters = new ArrayList<LinkedParameters>();
    	//added 8-13-2018 to make repeated simulations of PVIScreen give the same results
    	random = new RandomNumber(1451);
    }
    
    
    //create new statistical distribution
    public void createNewDistribution(String sType, String sSDName)
    {
      StatisticalDistribution sd;
      sd = new StatisticalDistribution();
      sd.setDistributionType(sType);
      sd.setName(sSDName);
      sd.setParentName(sName);
      sd.setIsThisDistributionActuallyUsed(true);
      sd.setRandomNumberGenerator(random);
      sdPVIScreen.add(sd);
    }
    
    
    public void setStatisticalDistributionValue(String type, double value)
    {
  	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(type))
  		  {
  			  //this is the one needed
  			  sd.addAPoint(value,0.0);
  			  sd.addAPoint(value,1.0);
  			  sd.setValue(0.5);
  		  }
  	  }	  
    }
    
    /**
     * setConstantDistribution -- sets statisticalDistribution to hold a constant value
     *   thus any Monte Carlo run will use the constant value
     *   (used fo no monte carlo-ed parameters)
     *   dValue = constant value
     *   sSDName = name of StatisticalDistribution
     */
    public void setConstantDistribution(double dValue, String sSDName)
    {
       //create constant distribution
    	for (StatisticalDistribution sd: sdPVIScreen)
    	{
    		if (sd.getName().equalsIgnoreCase(sSDName))
    		{
    			//this is the one we need
    			//first remove any data in the statisticalDistribution
    			sd.clear();
    			//add two points that will in fact make the StatisticalDistribution
    			//represent a constant
    			sd.addAPoint(dValue,0.0);
    			sd.addAPoint(dValue,1.0);
    			//set the value of the statistical distribution to the mid point
    			//(although any value would be just as good)
    			sd.setValue(0.5);
    			sd.setDistributionType("Constant");
    			break;
    		}
    	}	
	  
    }
     
    public void setCurrentRandomValue(String type, double frequency)
    {
  	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(type))
  		  {
  			  //this is the one needed
  			  sd.setValue(frequency);
  		  }
  	  }	  
    }
    public void setCumulativeDistributionValue(String type, double value, double frequency)
    {
  	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(type))
  		  {
  			  //this is the one needed
  			  sd.addAPoint(value, frequency);
  		  }
  	  }	    
    }  
    public void setCalculationUnit(String type, String sCalculationUnit)
    {
  	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(type))
  		  {
  			  //this is the one needed
  			  sd.setCalculationUnit(sCalculationUnit);
  		  }
  	  }	  
    }   
    
    public StatisticalDistribution getStatisticalDistribution(String sName, String sParentName)
    {
  	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(sName) && sd.getParentName().equalsIgnoreCase(sParentName)){return sd;}
  	  }
  	  return null;
    }
    
    public double getCurrentRandomValue(String sName, String sParentName)
    {
  	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(sName) && sd.getParentName().equalsIgnoreCase(sParentName))
  		  {
  			  //this is the one needed
  			  return sd.getCurrentRandomValue();
  		  }
  	  }
  	  return 0.0;
    }
    
    public String getCalculationUnit(String sName, String sParentName)
    {
  	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(sName) && sd.getParentName().equalsIgnoreCase(sParentName))
  		  {
  			  //this is the one needed
  			  return sd.getCalculationUnit();
  		  }
  	  }
  	  return "";
    }    
    
    public double getFrequencyWeightedAverageValue(String sName, String sParentName)
    {
    	 for (StatisticalDistribution sd: sdPVIScreen)
     	  {
     		  if (sd.getName().equalsIgnoreCase(sName) && sd.getParentName().equalsIgnoreCase(sParentName))
     		  {
     			  //this is the one needed
     			  return sd.getWeightedAverageValue();
     		  }
     	  }
     	  return 0.0;    	
    }
    
    
    /**
     * getDistributionConcentration   return the array of points defining the concentrations 
     *    defining the cumulative probability distribution
     * @param type  == name of distribution
     * 
     */
    public double[] getConcentrationDistribution(String type)
    {
      double[] dReturn = null;
  	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(type))
  		  {
  			  //this is the one needed
  			  dReturn = sd.getConcentrationDistribution();
  			  break;
  		  }
  	  }
  	  return dReturn;
    }  
    
    
    /**
     * getFrequencyDistribution  return the array of points defining the frequencies
     *   defining the cumulative probability distribution
     * @param type == name of distribution
     * @param sCalculationUnit
     */
    public double[] getFrequencyDistribution(String type)
    {
      double[] dReturn = null;
  	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(type))
  		  {
  			  //this is the one needed
  			  dReturn = sd.getFrequencyDistribution();
  			  break;
  		  }
  	  }	  
  	  return dReturn;
    }  
    
    /**
     * 
     * @param type
     * @return
     */
    public int getDistributionNumberOfPoints(String type)
    {
      int iPts = 0;
  	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(type))
  		  {
  			  //this is the one needed
  			  iPts = sd.getNumberOfPointsDefiningDistribution();
  			  break;
  		  }
  	  }	  
  	  return iPts;
    }    
    
    
    public double getMiddleValue(String sParameterName, String sParentName)
    {
   	  for (StatisticalDistribution sd: sdPVIScreen)
  	  {
  		  if (sd.getName().equalsIgnoreCase(sParameterName) && sd.getParentName().equalsIgnoreCase(sParentName))
  		  {
  			  //this is the one needed
  			  return sd.getMiddleValue();
  		  }
  	  }
  	  return 0.0;    	
    }
    
    //adds
    public void addDataSource(String sParameter, String sSource, String sDistributionName)
    {
    	//save the source of a parameter:  source = distribution file (primarily) of parameter
    	String[] sTemp = {sParameter,sSource,sDistributionName};
    	this.alExternalSource.add(sTemp);
    }
    
    
    
    //simple sets
    public void setName(String sName){this.sName = sName;}
    
    //simple gets
    public String getName(){return sName;}
    //get all statistical distributions
    public ArrayList<StatisticalDistribution> getStatisticalDistribution(){return sdPVIScreen;}
}
