package pviScreen;

import java.util.ArrayList;

import util.Stripper;

/**
 * ParameterDefinitions    parameterDefinitions are used for drop down box parameters
 *                         browser choices
 *                         project file name
 *                         OilDistribution 
 *                         Risk Levels
 *                         Hazard Quotients
 *                         Dirt Floor
 *                         Color Codes for risk presentation
 *                         
 * @author Jim Weaver
 *
 */
public class ParameterChoices extends PVIScreenData
{
    private ArrayList<String[]>alParameters;  
    private Stripper s;
	
	
	public ParameterChoices()
	{
	  //create data container for any type of parameter
	  alParameters = new ArrayList<String[]>();
	  s = new Stripper();
	}
	
	public void add(String[] lineArray)
	{
	  alParameters.add(lineArray);
	}

	//return the first value associated with the parameter
	// sParameterType is the type of parameter choice
    // iCount = 1 for the first element
	// iCount = 2 for the second element
	public ArrayList<String> getValue(String sParameterType,int iCount)
	{
			ArrayList<String>alResults = new ArrayList<String>();
			 
			
			for (String[] string: alParameters)
			{
				 
				if (iCount==1)
				{
					//return the first string value which is stored in element # 2
					if (s.areTheyEqual(sParameterType,string[1]))
					{
					  alResults.add(string[2]);	
					}
				}
				else if (iCount==2)
				{
					//return the second string value which is stored in element # 3
					if (s.areTheyEqual(sParameterType,string[1]))
					{
					  alResults.add(string[3]);	
					}
				}
				
			}
			
			return alResults;
	}
	

}
