package pviScreen;

import java.util.ArrayList;

import util.Stripper;

//container class for unmodified inputs
//used to give the inputs to the ui
//after reading by PVIScreenReader.java
//(which processes input for calculation -- i.e., unit conversions applied)
public class RawInput 
{
   //name of RawInput 
   private String sRawInputName;
   //container for line of input
   private ArrayList<RawInputLine> alRawInputLine;
   
   
   public RawInput()
   {
	   clearAllInput();
   }
   
  
   public void clearAllInput(){alRawInputLine = new ArrayList<RawInputLine>();}
   
   
   //add an entire RawInputLine
   public void add(RawInputLine ril){alRawInputLine.add(ril);}
   
   

   
   
   
   //get raw input lines of a specified name and type (i.e., "aquifer" and  "hydraulic conductivity")
   //(these are key words 1 and 2)
   public ArrayList<RawInputLine> getRawInputLines(String sName, String sType)
   {
	   ArrayList<RawInputLine> rilReturn = new ArrayList<RawInputLine>();
	   Stripper s = new Stripper();
	   
	   for (RawInputLine rilTest:  this.alRawInputLine)
	   {
		   if (s.areTheyEqual(rilTest.getGroupName(),sName,' '))
		   {	   
		     if (s.areTheyEqual(rilTest.getParameterName(),sType,' '))
		     {
			   //if type matches, add to return set
			   rilReturn.add(rilTest);
		     }
		   }  
	   }
	   
	   return rilReturn;
	   
   }
   
   //check for existence of inputs of a specified name (key word 1)
   public boolean checkForInputName(String sName)
   {
	   boolean bFound;
	   bFound = false;
	   Stripper s = new Stripper();
	   
	   for (RawInputLine ril: this.alRawInputLine)
	   {
		   if (s.areTheyEqual(sName,ril.getGroupName(),' '))
		   {
			   bFound = true;
			   break;
		   }
	   }
	   
	   return bFound;
   }
   
   private AquiferData aq;
	//generate required inputs for model from raw inputs
   public void generateModelParameters()
   {
	  //aquifer
	  aq = new AquiferData();
   }
   
   
   
   
   //sets
   public void setName(String sRawInputName){this.sRawInputName = sRawInputName;}
   
   //gets
   public String getName(){return this.sRawInputName;}
   public ArrayList<RawInputLine> getAllRawInputLines(){return this.alRawInputLine;}
}
 