package pviScreen;

import java.util.ArrayList;

import util.FileLogger;
import util.NameConstants;
import util.Stripper;
import util.UnitConverter;


/*
 * container for one line of raw input
 * for use with RawInput class
 * 
 * uses NameConstants class for definition
 * 
 * .s_CONTROLSTRING   "control", followed by one string
 * .s_CONTROL2STRING  "control", followed by two strings
 * .s_CONTROL3STRING  "control", followed by three strings
 * .s_CONTROLSTRINGVALUE "control", followed by one string and one number
 * .s_CONTROL2STRINGVALUE "control", followed by two strings and one number
 * .s_VALUEINPUT      input of a value as input
 * .s_CHEMICALINPUT   input of a chemical value as input
 * .s_CONTROLRISKINPUT input of risk parameters to replace defaults
 * 
 * 
 */

public class RawInputLine
{
	//type of input
	private String sRawInputType;
	//raw input line
	private String[] sRawInputLine;
	//outputToWhat File?
	//if nc.file_SuggestedValueOutput then output to the file chosen by the fileChooser for output
	//if "src/systemData/06SuggestedValues.csv" then to the system data file
	private String sOutputDestination;
	//stripper
	private Stripper s;  
	//NameConstant
	private NameConstants nc;

	//name of input group ('aquifer')	
	private String sGroupName;
	//type of input ('hydraulic conductivity")
	private String sParameterName;
	//second part of the parameter name
	private String sParameterName2;
	//status of input ('constant' or 'variable')
	private String sDistributionType;
	//string value of an input
	private String sValueString;

	//double value of an input
	private Double dValue;
	//unit associated with the value
	private String sUnit;
	//cumulative frequency associated with value
	private Double dFrequency;
	//comment associated with value
	private String sComment;
	//chemical name (for chemical input lines)
	private String sChemicalName;
	//unit converter
	private UnitConverter uc;

	public RawInputLine()
	{
		init();
	}

	public RawInputLine(UnitConverter uc)
	{
		init();
		this.uc = uc;

	}

	private void init()
	{
		sRawInputType = "";
		nc = new NameConstants();
		s = new Stripper();

		sGroupName = "";
		sParameterName = "";
		sParameterName2 = "";
		sDistributionType = "none";
		sValueString = "";
		dValue = 0.0;
		sUnit = "";
		dFrequency = 0.0;
		sComment = "";
		sChemicalName = ""; 

		//set the output type by default
		//"chosen file"
		sOutputDestination = nc.file_UserChosenFileForOutput;
	}

	public void setRawInputLine(String sRawInputType, String[] sRawInputLine)
	{
		this.sRawInputType = sRawInputType;
		this.sRawInputLine = sRawInputLine;
		//split the input line into individual variables, depending on the line type
		splitInputLine();
	}


	private void splitInputLine()
	{
		//a control plus one string input line
		if (s.areTheyEqual(nc.s_CONTROLSTRING,this.sRawInputType))
		{
			sGroupName = this.sRawInputLine[0];
			sParameterName = this.sRawInputLine[1];
		}
		//a control plus two string input lines
		else if (s.areTheyEqual(nc.s_CONTROL2STRING,this.sRawInputType))
		{
			sGroupName = this.sRawInputLine[0];
			sParameterName = this.sRawInputLine[1];
			sValueString = this.sRawInputLine[2];

		}
		//a control plus three string input lines
		else if (s.areTheyEqual(nc.s_CONTROL3STRING,this.sRawInputType))
		{
			sGroupName = this.sRawInputLine[0];
			sParameterName = this.sRawInputLine[1];
			sParameterName2 = this.sRawInputLine[2];
			sValueString = this.sRawInputLine[3];
		}
		//a control plums one string input line and one value input line
		else if (s.areTheyEqual(nc.s_CONTROLSTRINGVALUE,this.sRawInputType))
		{
			sGroupName = this.sRawInputLine[0];
			sParameterName = this.sRawInputLine[1];
			dValue = Double.parseDouble(this.sRawInputLine[2]);
		}
		//a control plus two string input lines and one value input line
		else if (s.areTheyEqual(nc.s_CONTROL2STRINGVALUE,this.sRawInputType))
		{
			sGroupName = this.sRawInputLine[0];
			sParameterName = this.sRawInputLine[1];
			sParameterName2 = this.sRawInputLine[2]; 
			dValue = Double.parseDouble(this.sRawInputLine[3]);
		}
		else if (s.areTheyEqual(nc.s_CONTROLSTRINGCHOICE,this.sRawInputType))
		{
			sGroupName = this.sRawInputLine[0];
			sParameterName = this.sRawInputLine[1];
			sValueString = this.sRawInputLine[2];   
		}
		//a value input line
		else if (s.areTheyEqual(nc.s_VALUEINPUT,this.sRawInputType))
		{
			sGroupName = this.sRawInputLine[0];
			sParameterName = this.sRawInputLine[1];
			sDistributionType = this.sRawInputLine[2];

			try
			{
				dValue = Double.parseDouble(this.sRawInputLine[3]);
				dFrequency = Double.parseDouble(this.sRawInputLine[5]);
			}
			catch(Exception e)
			{
				e.getStackTrace();
			}

			sUnit = this.sRawInputLine[4];

		}
		//a chemical input line
		else if (s.areTheyEqual(nc.s_CHEMICALINPUT,this.sRawInputType))
		{
			sGroupName = this.sRawInputLine[0];
			sParameterName = this.sRawInputLine[3];
			sDistributionType = this.sRawInputLine[2];
			sChemicalName = this.sRawInputLine[1];
			sParameterName2 = this.sRawInputLine[1];

			try
			{
				dValue = Double.parseDouble(this.sRawInputLine[4]);
				dFrequency = Double.parseDouble(this.sRawInputLine[6]);
			}
			catch(Exception e)
			{
				e.getStackTrace();
			}

			sUnit = this.sRawInputLine[5];		   
		}
		else if (s.areTheyEqual(nc.s_CONTROLRISKINPUT, this.sRawInputType))
		{
			sGroupName = this.sRawInputLine[0];
			sParameterName = this.sRawInputLine[1];
			sParameterName2 = this.sRawInputLine[2];
			sChemicalName = this.sRawInputLine[2];
		}
		else if (s.areTheyEqual(nc.s_CONTROLSCREENINGLEVELINPUT,this.sRawInputType))
		{
			sGroupName = this.sRawInputLine[0];
			sParameterName = this.sRawInputLine[1];
			sChemicalName = this.sRawInputLine[1];
			sValueString = this.sRawInputLine[3];
			dValue = Double.parseDouble(sValueString);
			sUnit = this.sRawInputLine[4];
		}
	}

	//string of output for printing, only if the group name matches
	public String getOutputLine(String sGroup)
	{
		String sOutput = "";
		if (s.areTheyEqual(sGroupName, sGroup))
		{
			sOutput = getOutputLine();
		}
		return sOutput;
	}

	//string of output for printing
	public String getOutputLine()
	{
		String sOutput = "";
		//(Start with element 0 outside the for loop, so all commas are between sRawInputLine entries)
		sOutput = sRawInputLine[0];
		for (int i=1;i<sRawInputLine.length;i++)
		{
			sOutput = sOutput + "," + sRawInputLine[i];
		}
		return sOutput;
	}



	//FileLogger fl2 = new FileLogger("UnitConversionTest.csv");
	/**
	 * getUnitType         return the type of unit for the specified input parameter  (i.e., CrackWidth is a "Length")
	 * @param sInputName   name of input parameter ("key2" -- second entry on input line)
	 * @return
	 */
	public String getUnitType(String sInputName,UnitConverter uc)
	{
		String sReturn = " ";

		sReturn = uc.getUnitType(sInputName);



		return sReturn;
	}


	public String getParameterNameForUnits()
	{
		String sReturn="";
		s = new Stripper();

		//normally the parameter name for the unit is the parameter name
		sReturn = this.sParameterName;
		if (s.areTheyEqual(nc.s_CHEMICALINPUT, this.sRawInputType))
		{
			//for chemical input
			//the chemcial name is sParameterName
			//the unit type is related to the sParameterName2
			sReturn = this.sParameterName2;
		}
		return sReturn;
	}

	//sets
	public void setUnitConverter(UnitConverter uc){this.uc = uc;}
	public void setOutputDestination(String sOutput){this.sOutputDestination = sOutput;}

	//gets
	public String getGroupName(){return this.sRawInputLine[0];}
	public String getParameterName(){return this.sParameterName;}
	public String getParameterName2(){return this.sParameterName2;}
	public String getDistributionType(){return this.sDistributionType;}
	public String getValueString(){return this.sValueString;}
	public double getValue(){return this.dValue;}
	public String getUnit(){return this.sUnit;}
	public double getFrequency(){return this.dFrequency;}
	public String getComment(){return this.sComment;}
	public String getChemicalName(){return this.sChemicalName;}
	public String getOutputDestination(){return this.sOutputDestination;}

	public String getRawInputType(){return this.sRawInputType;}
	public String[] getRawInputLine(){return this.sRawInputLine;} 

}
