package pviScreen;

import java.util.ArrayList;

//container for one line of raw input
//for use with RawInput class
public class RawInputLineValue
{
   //name of input group ('aquifer')	
   private String sName;
   //type of input ('hydraulic conductivity")
   private String sType;
   //status of input ('constant' or 'variable')
   private String sStatus;
   //value of input
   private Double dValue;
   //unit associated with the value
   private String sUnit;
   //cumulative frequency associated with value
   private Double dFrequency;
   //comment associated with value
   private String sComment;
   //chemical name (for chemical input lines)
   private String sChemicalName;
   
   public RawInputLineValue()
   {
	   sName = "";
	   sType = "";
	   sStatus = "";
	   dValue = 0.;
	   sUnit = "";
	   dFrequency = 0.;
	   sComment = "";
	   sChemicalName = "";
   }
	
   public void setInput(String sName, String sType, String sStatus, double dValue, String sUnit, double dFrequency, String sComment)
   {
	   this.sName = sName;
	   this.sType = sType;
	   this.sStatus = sStatus;
	   this.dValue = dValue;
	   this.sUnit = sUnit;
	   this.dFrequency = dFrequency;
	   this.sComment = sComment;
   }
   
   public void setChemicalInput(String sName, String sType, String sStatus, String sChemicalName, double dValue, String sUnit, double dFrequency, String sComment)
   {
	   this.sName = sName;
	   this.sType = sType;
	   this.sStatus = sStatus;
	   this.dValue = dValue;
	   this.sUnit = sUnit;
	   this.dFrequency = dFrequency;
	   this.sComment = sComment;
	   this.sChemicalName = sChemicalName;
   }   
   
   
   //string of output for printing
   public String getOutputLine()
   {
	  return this.sName + ","
		   + this.sType + ","
		   + this.sStatus + ","
		   + this.dValue + ","
		   + this.sUnit + ","
		   + this.dFrequency + ","
		   + this.sComment;
   }
   
   //gets
   public String getName(){return this.sName;}
   public String getType(){return this.sType;}
   public String getDistributionType(){return this.sStatus;}
   public double getValue(){return this.dValue;}
   public String getUnit(){return this.sUnit;}
   public double getFrequency(){return this.dFrequency;}
   public String getComment(){return this.sComment;}
   public String getChemicalName(){return this.sChemicalName;}
	
}
