package pviScreen;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

import util.FileLogger;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class SuggestedValueReader 
{
	private PVIScreenControlData pvisCD;
	private NameConstants nc;
	private UnitConverter uc;
	private RawInput ri;
	private Oxygen oxygen;
	private Building bld;
	private VadoseZone vz;
	private FileLogger flOutput;
	private FillDataContainer fdc;
	private String sConvertedOutput;
	private String sErrorOutput;


	public SuggestedValueReader(){}



	public void readSuggestedValues(String sFile) throws IOException
	{
		FileReader fr;
		try{ fr = new FileReader(sFile);}
		catch (Exception e)
		{
			//file missing;  generate new file and read again
			fr = new FileReader(generateReplacementSuggestedValueFile());
		}

		BufferedReader br = new BufferedReader(fr);
		Stripper s = new Stripper();

		String currentLine;
		String[] lineArray= {""};

		currentLine = br.readLine();
		//is the file correct?
		if (!s.areTheyEqual("SuggestedValueFile",currentLine,' '))
		{
			System.out.println("Incorect Suggested Value File");

		}


		//read each line in the file
		while ((currentLine = br.readLine()) != null) 
		{
			String key, key2, key3;

			key = ""; key2 = ""; key3 = "";


			lineArray = currentLine.split(",",0);
			key = lineArray[0];


			//the control parameters
			if (s.areTheyEqual(key,"control") || s.areTheyEqual(key,"controll")) 
			{

				key2 = lineArray[1];

				if (s.areTheyEqual("NumberOfSimulations",key2,' '))
				{
					pvisCD.setNumberOfRuns((int)Double.parseDouble(lineArray[2]));
					this.saveRawInput(nc.s_CONTROLSTRINGVALUE, lineArray);	 
				}
				else if (s.areTheyEqual("NumberOfFrequencyDistributionIntervals",key2,' '))
				{
					pvisCD.setNumberOfFrequencyDistributionIntervals((int)Double.parseDouble(lineArray[2]));
					this.saveRawInput(nc.s_CONTROLSTRINGVALUE,lineArray);
				}
				else if (s.areTheyEqual("MaxAlpha",key2,' '))			
				{
					pvisCD.setMaxAlpha(Double.parseDouble(lineArray[2]));
					this.saveRawInput(nc.s_CONTROLSTRINGVALUE,lineArray);
				}
				else if (key2.equalsIgnoreCase("bisection"))
				{
					//bisection routine limits
					key3 = lineArray[2];
					if (s.areTheyEqual(key3,"lower limit",' '))
					{
						pvisCD.setBisectionLowerLimit(Double.parseDouble(lineArray[3]));
						this.saveRawInput(nc.s_CONTROL2STRINGVALUE,lineArray);
					}
					else if (s.areTheyEqual(key3,"Max Iterations",' ') || s.areTheyEqual(key3,"Maximum Iterations",' '))
					{
						//double dTest = Double.parseDouble(lineArray[3]);
						//int iTest = (int)dTest;
						pvisCD.setBisectionMaxIterations((int)Double.parseDouble(lineArray[3]));
						this.saveRawInput(nc.s_CONTROL2STRINGVALUE,lineArray);
					}
					else if  (s.areTheyEqual(key3, "tolerance",' '))
					{
						pvisCD.setBisectionTolerance(Double.parseDouble(lineArray[3]));
						this.saveRawInput(nc.s_CONTROL2STRINGVALUE,lineArray);
					}

				}
				/*
				else if (s.areTheyEqual("Groundwater Concentration Factor", key2,' '))
				{
					pvisCD.setGroundWaterConcentrationAdjustmentFactor(Double.parseDouble(lineArray[2]));
					this.saveRawInput(nc.s_CONTROLSTRINGVALUE,lineArray);
				}
				else if (s.areTheyEqual("Soil Sample Concentration Factor", key2,' '))
				{
					pvisCD.setSoilSampleConcentrationAdjustmentFactor(Double.parseDouble(lineArray[2]));
					this.saveRawInput(nc.s_CONTROLSTRINGVALUE,lineArray);
				}
                */
			}

			//only Qsoil
			else if (key.equalsIgnoreCase("Building") || key.equalsIgnoreCase("bld"))
			{
				key2 = lineArray[1];
				if (key2.equalsIgnoreCase("Begin")){ /* would have created the building object here, but passed into this object */}
				else if (key2.equalsIgnoreCase("End")){}
				else
				{
					//add building data to the Building Object
					sConvertedOutput = fdc.addData(bld, key2, lineArray);
					sConvertedOutput = addData(bld,key2,lineArray);  
					saveRawInput(nc.s_VALUEINPUT,lineArray);
				}
			}

			//only the soil respiration rate
			else if (s.areTheyEqual(key,"VadoseZone",' ') || s.areTheyEqual(key,"UnsaturatedZone",' '))
			{
				key2 = lineArray[1];
				if (key2.equalsIgnoreCase("Begin")){ /* would have created the vadose object here, but passed into this object */}
				else if (key2.equalsIgnoreCase("End")){}
				else
				{
					//add building data to the Building Object
					sConvertedOutput = fdc.addData(vz, key2, lineArray);
					sConvertedOutput = addData(vz,key2,lineArray);  
					saveRawInput(nc.s_VALUEINPUT,lineArray);
				}

			}

			//all parameters
			else if (key.equalsIgnoreCase("Oxygen"))
			{
				key2 = lineArray[1];
				if (key2.equalsIgnoreCase("Begin")){oxygen = new Oxygen();}
				else if (key2.equalsIgnoreCase("End")){}
				else
				{
					sConvertedOutput = addData(oxygen,key2,lineArray);
					saveRawInput(nc.s_VALUEINPUT,lineArray);
				}

			}

			//echo input data to output file
			String sOut = arrayToString(lineArray);
			flOutput.logMessage(sOut + sConvertedOutput + sErrorOutput); 
			this.addToKnownErrorOutput(sErrorOutput);

		}

		//close input file
		fr.close();
	}

	//save RawInput data to data container
	private void saveRawInput(String sRawInputType, String[] sRawInputLine)
	{
		RawInputLine ril = new RawInputLine();
		//put the raw input into a RawInputLine object
		ril.setRawInputLine(sRawInputType, sRawInputLine);
		ril.setOutputDestination(nc.file_SuggestedValues);
		//add raw input line to RawInputLine collection
		ri.add(ril);
	}

	private String arrayToString(String[] lineArray)
	{
		String sOut="";
		for (int i=0;i<lineArray.length;i++){sOut = sOut + lineArray[i] + ", ";}
		return sOut;
	}

	private String addData(PVIScreenData pvisData, String key2, String[] lineArray)
	{
		String sOutput = "";
		String sOutputError = "";
		String key3 = lineArray[2];

		//add data to RawInput container


		if (key3.equalsIgnoreCase("Constant"))
		{
			sOutput = addDataItem(pvisData,key2,lineArray[3],lineArray[4],getUnitType(key2));
			if (sOutput.equalsIgnoreCase(" "))
			{
				sOutputError = ", Error in Input: " + arrayToString(lineArray);
				System.out.println(sOutputError);
			}

		}
		else if (key3.equalsIgnoreCase("Variable"))
		{
			sOutput = addDataItemVariable(pvisData,key2,lineArray[3],lineArray[4],getUnitType(key2),lineArray[5]);
			if (sOutput.equalsIgnoreCase(" "))
			{
				sOutputError = ", Error in Input: " + arrayToString(lineArray);
				System.out.println(sOutputError);
			} 
		}

		this.addToKnownErrorOutput(sOutputError);		 
		return sOutput + sOutputError;				
	}

	//add	
	public void addToKnownErrorOutput(String sError)
	{
		if (!sError.equalsIgnoreCase(""))
		{
			sErrorOutput = sErrorOutput + sError + "\n";
		}
	}	

	/**
	 * getUnitType         return the type of unit for the specified input parameter  (i.e., CrackWidth is a "Length")
	 * @param sInputName   name of input parameter (lineArray[0] (a.k.a. "key2") -- second entry on input line)
	 * @return
	 */
	private String getUnitType(String sInputName)
	{
		String sReturn;
		RawInputLine ril = new RawInputLine();

		//the unit conversions are in the RawInputLine, use this class for uniformity
		sReturn = ril.getUnitType(sInputName,uc);

		return sReturn;
	}		
	//set individual bit of constant data
	private String addDataItem(PVIScreenData bvd, String key2m, String sValue, String sUnit, String sUnitType)
	{
		String sReturn = "";
		OutputDigits od = new OutputDigits();
		//key2m = modified key2 (i.e., no spaces included
		//sValue = string version of data item value
		//sUnit = string unit
		//sUnitTupe = name for type of unit (i.e., length, mass, concentration) 
		//  (No spaces allowed use "camel case" e.g., RateConstant)
		double value = Double.parseDouble(sValue)*uc.getUCF(sUnitType,sUnit);
		bvd.setStatisticalDistributionValue(key2m, value);
		bvd.setCurrentRandomValue(key2m,0.5);
		bvd.setCalculationUnit(key2m,uc.getModelUnit(sUnitType));
		//limit the number of output digits
		od.setValue(value);
		sReturn = ", converted to " + od.num2String() + " " + uc.getModelUnit(sUnitType);
		return sReturn;
	}	
	//set individual bit of Variable data
	private String addDataItemVariable(PVIScreenData bvd, String key2m, String sValue, String sUnit, String sUnitType, String sFrequency)
	{
		String sReturn="";;
		OutputDigits od = new OutputDigits();
		//key2m = modified key2 (i.e., no spaces included)
		//sValue = string version of data item value
		//sUnit = string unit (i.e. cm, cm3/sec, 1/hr, ft, etc)
		//sUnitType = name for type of unit (i.e., length, mass, concentration)
		//  (No spaces allowed use "camel case" e.g., RateConstant)
		//sFrequency = string version of frequency value
		double value = Double.parseDouble(sValue)*uc.getUCF(sUnitType,sUnit);
		double frequency = Double.parseDouble(sFrequency);
		bvd.setCumulativeDistributionValue(key2m, value, frequency);
		bvd.setCurrentRandomValue(key2m,0.5);
		bvd.setCalculationUnit(key2m,uc.getModelUnit(sUnitType));
		od.setValue(value);
		sReturn = ", converted to: " + od.num2String() + " " + uc.getModelUnit(sUnitType);
		return sReturn;  
	}  	


	//generate replacement suggested value file
	private String generateReplacementSuggestedValueFile()
	{
		FileLogger fl = new FileLogger("src/systemData/06SuggestedValues.csv");
		fl.openOverWriteFile();

		fl.logMessageOverWrite("Suggested Value File");
		
		
		fl.logMessageOverWrite("Control,Begin");
		fl.logMessageOverWrite("Control,Groundwater Concentration Factor,0.1");
		fl.logMessageOverWrite("Control,Soil Sample Concentration Factor,0.1");		
		fl.logMessageOverWrite("Control,Bisection,Lower Limit,1.00E-4");
		fl.logMessageOverWrite("Control,Bisection,Max iterations,5000");
		fl.logMessageOverWrite("Control,Bisection,tolerance,1.00E-12");
		fl.logMessageOverWrite("Control,max alpha,200");
		fl.logMessageOverWrite("Control,Number of Simulations,1000");		
		fl.logMessageOverWrite("Control,Number of frequency distribution intervals,50");
		fl.logMessageOverWrite("Control,End");

		fl.logMessageOverWrite("Oxygen,Begin");
		fl.logMessageOverWrite("Oxygen,DiffusionInAir,Constant,0.175,cm2/s,1");
		fl.logMessageOverWrite("Oxygen,DiffusionInWater,Constant,1.70E-5,cm2/s,1");		
		fl.logMessageOverWrite("Oxygen,SurfaceConcentration,Constant,289000,mg/m3,1");
		fl.logMessageOverWrite("Oxygen,MinimumBiodegradationConcentration,Constant,13800,mg/m3,1");
		fl.logMessageOverWrite("Oxygen,End");

		fl.logMessageOverWrite("Building,Begin");
		fl.logMessageOverWrite("Building,Qsoil,Variable,1,L/m,0");
		fl.logMessageOverWrite("Building,Qsoil,Variable,10,L/m,1");		
		fl.logMessageOverWrite("Building,End");

		fl.logMessageOverWrite("VadoseZone,Begin");
		fl.logMessageOverWrite("VadoseZone,SoilRespirationRate,Constant,1.69,mg/g-d,1");
		fl.logMessageOverWrite("VadoseZone,End");
		
		fl.closeOverWriteFile();
		
		
		return "src/systemData/06SuggestedValues.csv";
	}

	//sets
	public void setPVISControlData(PVIScreenControlData pvisCD){this.pvisCD = pvisCD;}
	public void setNameConstants(NameConstants nc){this.nc = nc;}
	public void setUnitConverter(UnitConverter uc){this.uc = uc;}
	public void setRawInputContainer(RawInput ri){this.ri = ri;}
	public void setBuildingObject(Building bld){this.bld = bld;}
	public void setMainOutputFileLogger(FileLogger flOutput){this.flOutput = flOutput;}
	public void setFillDataContainer(FillDataContainer fdc){this.fdc = fdc;}
	public void setExistingErrorOutput(String s){this.sErrorOutput = s;}
	public void setVadoseZoneObject(VadoseZone vz){this.vz = vz;}

	//gets
	public Oxygen getOxygenObject(){return this.oxygen;}
}
