package statistics;

import java.util.ArrayList;

/**
 * class Interval for storing data for individual intervals of a histogram
 *                (a histogram is a collection of intervals)
 *                developed for use with Histogram class
 *                
 * @author JWEAVER
 *
 */
public class Interval 
{
	private String sName;
	private double dLowPointValue;
	private double dMidPointValue;
	private double dHighPointValue;
	private double dFrequency;
	private double dCumulativeFrequency;
	private int iCount;
	private ArrayList<Integer> alMember;
    private double[] dCoupledValue;
    private int iDCount;
    private Histogram histogram;
	

    public Interval()
	{
	  alMember = new ArrayList<Integer>();
	  iCount = 0; 
	  iDCount = 0;
	  dCoupledValue = new double[50];
	}
		
		
	public void addOneMember(int iIndex)
	{
		iCount++;
		alMember.add(iIndex);
	}
		
		
	public void addCoupledDataPoint(double dValue)
	{
		if (iDCount<dCoupledValue.length)
		{	
		  dCoupledValue[iDCount] = dValue;
		  iDCount++;
		}
		else
		{
			double[] dTemp = new double[dCoupledValue.length];
			//increase the dimensioning
			for (int i=0;i<iDCount;i++)
			{
				dTemp[i] = dCoupledValue[i];
			}
			dCoupledValue = new double[dCoupledValue.length + 25];
			for (int i=0;i<iDCount;i++)
			{
				dCoupledValue[i] = dTemp[i];
			}
			dCoupledValue[iDCount] = dValue;
			iDCount++;
		}
	}
		
	//generate a histogram for the coupled data
	public void generateCoupledHistogram()
	{
		 histogram = new Histogram();
		 histogram.setIntervalFrequency(10);
		 //this histogram is coupled with another data set
		 //no additional coupling:
		 histogram.setCoupledHistogram(false);
		 histogram.generateHistogram(dCoupledValue,iDCount);
	}
		
	//sets
	public void setLowPointValue(double dLowPointValue){this.dLowPointValue = dLowPointValue;}
	public void setMidPointValue(double dMidPointValue){this.dMidPointValue = dMidPointValue;}
	public void setHighPointValue(double dHighPointValue){this.dHighPointValue = dHighPointValue;}
	public void setIntervalCount(int iCount){this.iCount = iCount;}
	public void setFrequency(double dFrequency){this.dFrequency = dFrequency;}
	public void setCumulativeFrequency(double dCumulativeFrequency){this.dCumulativeFrequency = dCumulativeFrequency;}
		
	//gets
	public int getIntervalCount(){return iCount;}
	public double getLowPointValue(){return dLowPointValue;}
	public double getMidPointValue(){return dMidPointValue;}
	public double getHighPointValue(){return dHighPointValue;}
	public double getFrequency(){return this.dFrequency;}
	public double getCumulativeFrequency(){return this.dCumulativeFrequency;}
	public ArrayList<Integer> getIntervalMembers(){return alMember;}
	public Histogram getCoupledHistogram(){return histogram;}

}	  
  
  

