package statistics;

import util.ArrayExpander;
import util.Stripper;

public class RiskContainer 
{
   private Stripper s;
   private String[] sName;
   private double[] dRiskLevel;
   private double[] dRiskConcentration;
   private double[] dRiskPerCent;
   private boolean[] bRiskChemical;
   private int iRisk;
   
   private String[] sHazardName;
   private double[] dHazardQuotient;
   private double[] dHazardConcentration;
   private double[] dHazardPerCent;
   private boolean[] bHazardChemical;
   private int iHazard;
   private int iDem;
   private int iCount;
   
   private String[] sScreeningName;
   private double[] dScreeningConcentration;
   private double[] dScreeningLevel;
   private double[] dScreeningPerCent;
   private boolean[] bScreeningChemical;
   private int iScreening;
   
	
   public RiskContainer()
   {
	 initialize();
   }
   
   //initialize the risk container
   public void initialize()
   {
	 iDem = 100;
	 sName = new String[iDem];
	 dRiskLevel = new double[iDem];
	 dRiskConcentration = new double[iDem];
	 dRiskPerCent = new double[iDem];
	 bRiskChemical = new boolean[iDem];
	 iRisk = 0;
	 sHazardName = new String[iDem];
	 dHazardQuotient = new double[iDem];
	 dHazardConcentration = new double[iDem];
	 dHazardPerCent = new double[iDem];
	 bHazardChemical = new boolean[iDem];
	 iHazard = 0;
	 sScreeningName = new String[iDem];
	 dScreeningConcentration = new double[iDem];
	 //screening levels only have a concentration, dScreeningLevel is used for nominal conformity to cancer risk and hazard quotient
	 dScreeningLevel = new double[iDem];
	 dScreeningPerCent = new double[iDem];
	 bScreeningChemical = new boolean[iDem];
	 iScreening = 0;
	 
	 s = new Stripper();
	 iCount = 0;
   }
	
   
   public void addCancerRisk(String sName, boolean bRiskChemical, double dRiskLevel, double dRiskConcentration, double dRiskPerCent)
   {
	  int iUse;
	  iUse = iRisk;
	  
	  for (int i=0;i<iRisk;i++)
	  {
		  if (s.areTheyEqual(sName, this.sName[i]))
		  {
			  //do not add a chemical, but use new results
			  iUse = i;
		  }
	  }
	  this.sName[iUse] = sName;
	  this.dRiskLevel[iUse] = dRiskLevel;
	  this.dRiskConcentration[iUse] = dRiskConcentration;
	  this.dRiskPerCent[iUse] = dRiskPerCent;
	  this.bRiskChemical[iUse]= bRiskChemical;
	  
	  iRisk++;
   }
   public void addCancerRisk(String sName, boolean bRiskChemical)
   {
	 this.addCancerRisk(sName,bRiskChemical,0.0,0.0,0.0);   
   }
   
   public void addHazard(String sHazardName, boolean bHazardChemical, double dHazardQuotient, double dHazardConcentration, double dHazardPerCent)
   {
		  int iUse;
		  iUse = iHazard;
		  
		  for (int i=0;i<iHazard;i++)
		  {
			  if (s.areTheyEqual(sHazardName, this.sHazardName[i]))
			  {
				  //do not add a chemical, but use new results
				  iUse = i;
			  }
		  }
	   this.sHazardName[iUse] = sHazardName;
	   this.dHazardQuotient[iUse] = dHazardQuotient;
	   this.dHazardConcentration[iUse] = dHazardConcentration;
	   this.dHazardPerCent[iUse] = dHazardPerCent;
	   this.bHazardChemical[iUse] = bHazardChemical;
	   iHazard++;
   }
   public void addHazard(String sName, boolean bRiskChemical)
   {
	   this.addHazard(sName,bRiskChemical,0.0,0.0,0.0);
   }
   
   public void addScreeningRisk(String sScreeningName, boolean bScreeningChemical, double dScreeningConcentration, double dScreeningPerCent)
   {
		  int iUse;
		  iUse = iScreening;
		  
		  for (int i=0;i<iScreening;i++)
		  {
			  if (s.areTheyEqual(sScreeningName, this.sScreeningName[i]))
			  {
				  //do not add a chemical, but use new results
				  iUse = i;
			  }
		  }
	  this.sScreeningName[iUse] = sScreeningName;
	  this.dScreeningLevel[iUse] = 1.0;
	  this.dScreeningConcentration[iUse] = dScreeningConcentration;
	  this.dScreeningPerCent[iUse] = dScreeningPerCent;
	  this.bScreeningChemical[iUse]= bScreeningChemical;
	  
	  iScreening++;
   }
   public void addScreeningRisk(String sScreeningName, boolean bScreeningChemical)
   {
	 this.addCancerRisk(sScreeningName,bScreeningChemical,0.0,0.0,0.0);   
   }
   
   public void sortCancerRiskByPerCentExceeds(){this.sortByPerCent(dRiskPerCent,dRiskLevel,dRiskConcentration,bRiskChemical,sName);}
   public void sortHazardByPerCentExceeds(){this.sortByPerCent(dHazardPerCent,dHazardQuotient,dHazardConcentration,bHazardChemical,sHazardName);}
   public void sortScreeningByPerCentExceeds(){this.sortByPerCent(dScreeningPerCent, dScreeningLevel, dScreeningConcentration, bScreeningChemical, sScreeningName);}
   
   private void sortByPerCent(double[] dPerCent, double[] dLevel, double[] dConcentration, boolean[] bFlag, String[] sName)
   {	   
	   
	  boolean bChanged;
	  int iCount;
	  String sTempName;
	  double dTempLevel;
	  double dTempConcentration;
	  double dTempPerCent;
	  boolean bTempFlag;

	  //sort from high to low
	  iCount = dPerCent.length;
	  
	  bChanged = true;
	  //now the sorting starts:
	  while (bChanged == true) 
	   {
		 bChanged = false;
	     for (int i=0;i<iCount-1;i++)
	     {
		    //sort from highest to lowest 
		    if (dPerCent[i]<dPerCent[i+1])
		    {
		      //save original values
			  dTempPerCent = dPerCent[i+1];
			  dTempLevel = dLevel[i+1];
			  dTempConcentration = dConcentration[i+1];
			  sTempName = sName[i+1];
			  bTempFlag = bFlag[i+1];
			  //swap
			  dPerCent[i+1] = dPerCent[i];
			  dLevel[i+1] = dLevel[i];
			  dConcentration[i+1] = dConcentration[i];
			  sName[i+1] = sName[i];
			  bFlag[i+1] = bFlag[i];
			  //restore original values
			  dPerCent[i] = dTempPerCent;
			  dLevel[i] = dTempLevel;
			  dConcentration[i] = dTempConcentration;
			  sName[i] = sTempName;
			  bFlag[i] = bTempFlag;
			  bChanged = true;
		    }
	      }
	   }	  
	  
	  
   }
   
   
   
   //gets
   public int getRiskCount()
   {
	   int iReturn = 0;
	   for (int i=0;i<iRisk;i++){if (bRiskChemical[i]==true){iReturn++;}}
	   return iReturn;
   }
   public int getHazardCount()
   {
	   int iReturn = 0;
	   for (int i=0;i<iHazard;i++){if(bHazardChemical[i]==true){iReturn++;}}
	   return iReturn;
   }
   public int getScreeningCount()
   {
	   int iReturn = 0;
	   for (int i=0;i<iScreening;i++){if(bScreeningChemical[i]==true){iReturn++;}}
	   return iReturn;
   }
   
   public int getTotalCount()
   {
	   int iReturn = 0;
	   iReturn = Math.max(iRisk,iHazard);
	   iReturn = Math.max(iReturn, iScreening);
	   return iReturn;
   }
 
   
   public String getCancerName(int i){return this.sName[i];}
   public double getRiskLevel(int i){return this.dRiskLevel[i];}
   public double getRiskConcentration(int i){return this.dRiskConcentration[i];}
   public double getRiskPerCent(int i){return this.dRiskPerCent[i];}
   public boolean getIsRiskChemical(int i){return this.bRiskChemical[i];}
    
   public String getHazardName(int i){return this.sHazardName[i];}
   public double getHazardQuotient(int i){return this.dHazardQuotient[i];}
   public double getHazardConcentration(int i){return this.dHazardConcentration[i];}
   public double getHazardPerCent(int i){return this.dHazardPerCent[i];}
   public boolean getIsHazardChemical(int i){return this.bHazardChemical[i];}
   
   public String getScreeningdName(int i){return this.sScreeningName[i];}
   public double getScreeningLevel(int i){return this.dScreeningLevel[i];}
   public double getScreeningConcentration(int i){return this.dScreeningConcentration[i];}
   public double getScreeningPerCent(int i){return this.dScreeningPerCent[i];}
   public boolean getIsScreeningChemical(int i){return this.bScreeningChemical[i];}
   
}
