package statistics;

/**
 * TestResistantStatisticalMeasures
 * 
 * Class for testing the ResistantStatisticalMeasures class
 * 
 * @author Jim Weaver
 *
 */
public class TestResistantStatisticalMeasures 
{
	ResistantStatisticalMeasures rsm;
	
	public TestResistantStatisticalMeasures(){}
	
	
	public void test()
	{
		rsm = new ResistantStatisticalMeasures();
		
	
		this.runMooreMcCabeProblemOnePointFive();
		this.runMooreMcCabeProblemOnePointTwentyFive();
		this.runMooreMcCabeProblemOnePointTwentyThree();
		
		
	}
	
	/**
	 * Moore and McCabe, page 9.  Grocery Shopping Example
	 */
	public void runMooreMcCabeProblemOnePointFive()
	{
	
		double[] dShopping = {2.31, 6.61, 6.90, 8.04, 9.45,
				              10.26, 11.34, 11.63, 12.66, 12.95,
				              13.67, 13.72, 14.35, 14.52, 14.55,
				              15.01, 15.33, 16.55, 17.15, 18.22,
				              18.30, 18.71, 19.54, 19.55, 20.58,
				              20.89, 20.91, 21.13, 23.85, 26.04,
				              27.07, 28.76, 29.15, 30.54, 31.99,
				              32.82, 33.26, 33.80, 34.76, 36.22,
				              37.52, 39.28, 40.80, 43.97, 45.58,
				              52.36, 61.57, 63.85, 64.30, 69.49};
		
		rsm.clear();
		rsm.setData(dShopping);
		rsm.sort();
		rsm.findMinMax();
		rsm.findMedian();
		rsm.findFirstQuartile();
		rsm.findThirdQuartile();
		rsm.find5thPercentile();
		rsm.find95thPercentile();
		
		
	}
	
	/**
	 * Moore and McCabe, page 28  Reading Level Example
	 */
	public void runMooreMcCabeProblemOnePointTwentyThree()
	{
		double[] dReading = {40, 26, 39, 14, 42, 18, 25, 43, 46, 27, 19,
				             47, 19, 26, 35, 34, 15, 44, 40, 38, 31, 46,
				             52, 25, 35, 35, 33, 29, 34, 41, 48, 28, 52,
				             47, 35, 48, 22, 33, 41, 51, 27, 14, 54, 45};
		rsm.clear();
		rsm.setData(dReading);
		rsm.sort();
		rsm.findMinMax();
		rsm.findMedian();
		rsm.findFirstQuartile();
		rsm.findThirdQuartile();
		rsm.find5thPercentile();
		rsm.find95thPercentile();
		
	}
	
	/**
	 * Moore and McCabe, page 28   Density of the Earth example
	 */
	public void runMooreMcCabeProblemOnePointTwentyFive()
	{
		double[] dEarth = {5.50, 5.61, 4.88, 5.07, 5.26, 5.55, 5.36, 5.29, 5.58, 5.65,
				           5.57, 5.53, 5.62, 5.29, 5.44, 5.34, 5.79, 5.10, 5.27, 5.39,
				           5.42, 5.47, 5.63, 5.34, 5.46, 5.30, 5.75, 5.68, 5.85};
		rsm.clear();
		rsm.setData(dEarth);
		rsm.sort();
		rsm.findMinMax();
		rsm.findMedian();
		rsm.findFirstQuartile();
		rsm.findThirdQuartile();
		rsm.find5thPercentile();
		rsm.find95thPercentile();
		
	}
}
