package ui;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;

public class ChartAnnotationOverlay extends Pane
{
    private LineChart<Number, Number> lc;
    private ObservableList<ChartAnnotationNode> olAnnotations;
    
	public ChartAnnotationOverlay(LineChart<Number,Number>lc)
	{
		this.lc = lc;
		olAnnotations = FXCollections.observableArrayList();
		
	    /* This will be our update listener, to be invoked whenever the chart changes or annotations are added */
	    final InvalidationListener listener = new InvalidationListener() {
	        @Override
	        public void invalidated(final Observable observable) {
	            update();
	        }
	    };
	    lc.needsLayoutProperty().addListener(listener);
	    olAnnotations.addListener(listener);
	    
	    
	    /* Add new annotations by shift-clicking */
	    /*
	    setOnMouseClicked(new EventHandler<MouseEvent>() {
	        @Override
	        public void handle(final MouseEvent mouseEvent) {
	            if (mouseEvent.getButton() == MouseButton.PRIMARY  && mouseEvent.isShiftDown())
	                addAnnotation(true, mouseEvent.getX(), mouseEvent.getY(),"");
	        }
	    });		
	    */
	}
	

   public void addAnnotation(boolean bMouseAnnotation, final double displayX, final double displayY, final String sText)
   {
	   final Axis<Number>xAxis = lc.getXAxis();
	   final Axis<Number>yAxis = lc.getYAxis();
	   
	   double x = displayX;
	   double y = displayY;
	   
	   if (bMouseAnnotation)
	   {	   
	     double dValue = xAxis.parentToLocal(displayX,0).getX() - lc.getPadding().getLeft();
	     x = xAxis.getValueForDisplay(dValue).doubleValue();
	     //final double x = xAxis.getValueForDisplay(displayX).doubleValue();
	   
	     double dValueY = yAxis.parentToLocal(0,displayY).getY() - lc.getPadding().getTop();
	     y = yAxis.getValueForDisplay(dValueY).doubleValue();	 
	
	   }
	   
	   
	   if (xAxis.isValueOnAxis(displayX) && xAxis.isValueOnAxis(displayY))
	   {
		   olAnnotations.add(new ChartAnnotationNode(new Label(sText),x,y));
	   }
	   
   }
   
   public void update()
   {
	   this.getChildren().clear();
	   
	   final Axis<Number>xAxis = lc.getXAxis();
	   final Axis<Number>yAxis = lc.getYAxis();
	   
	   for (ChartAnnotationNode can: olAnnotations)
	   {
		   double dX = xAxis.getDisplayPosition(can.getX());
		   double dY = yAxis.getDisplayPosition(can.getY());
		   
		   
		   final double x = xAxis.localToParent(dX,0).getX() + lc.getPadding().getLeft();
		   final double y = yAxis.localToParent(0,dY).getY() + lc.getPadding().getTop();
		   
		
		   final Circle indicator = new Circle(3);
		   indicator.setStroke(Color.BLUEVIOLET);
		   indicator.setCenterX(x);
		   indicator.setCenterY(y);
		   getChildren().add(indicator);
	   
	       final Node node = can.getNode();
	       getChildren().add(node);
	       
	       node.relocate(x+10, y-node.prefHeight(Integer.MAX_VALUE)/2);
	       node.autosize();
	   
	   }
	   
	   
	   
	   
   }
   
  //gets
  public ChartAnnotationOverlay getAnnotations(){return this;}
}


