package ui;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;

public class HandlerAbout implements EventHandler 
{
   private Stage stage;
   private Repository repository;
   
   public HandlerAbout(Stage stage){this.stage = stage;}
	
   public void handle(Event e)
   {
	   
	   BorderPane border = repository.getBorder();
		double dCanvasWidth = 1000;
		double dCanvasHeight = 400;
		Canvas c = new Canvas(dCanvasWidth,dCanvasHeight);
		GraphicsContext gc = c.getGraphicsContext2D();
		
		//water table thickness
		gc.setStroke(Color.BLACK);
		gc.setFill(Color.BLACK);
	 
	    gc.setFont(Font.font("Arial", FontWeight.NORMAL, 20));
	    gc.fillText("PVIScreen   Version 1.0,  February 18, 2018", 5, 20);
	    gc.fillText("United States Environmental Protection Agency", 5, 40);
	    gc.fillText("Robert S. Kerr Enironmental Research Center", 5, 60);
	    gc.fillText("Ada, OK  74820", 5, 80);
	    
	    gc.fillText("PVIScreen is written in Java version 7 and JavaFX version 2.0", 5, 140);
	    gc.fillText("Author:  Jim Weaver, weaver.jim@epa.gov", 5, 160);
	    
	    
	  
	
		border.setCenter(c);
		stage.show();	   
	   
	   
	   
	   
	   
   }
	
	
   //sets
   public void setHandlerRepository(Repository repository){this.repository = repository;}
}
