package ui;

import java.util.ArrayList;

import pviScreen.Chemical;
import pviScreen.PVIScreenControlData;
import pviScreen.RawInputLine;
import util.NameConstants;
import util.Stripper;
import util.UnitConverter;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;


//add or remove a chemical to the input set
public class HandlerChemicalAdder extends HandlerEditControl implements EventHandler
{
	//private Repository repository;
	private PVIScreenControlData pvisCD;
	private UnitConverter uc;
	private ComboBox<String> cbChemical;
	private ArrayList<HBox> alHBox;
	ObservableList<Node> olHBoxKids;
	private NameConstants nc;
	private Stripper s;

	private TabPane tp;
	private Tab tab;

	private boolean bScreeningExists;
	private Tab tabScreening;


	public void handle(Event e)
	{
		super.handle(e);

		//add or remove a chemical


		//chemicals in the input data set
		pvisCD = repository.getPVIScreenControlData();
		uc = pvisCD.getUnitConverter();
		bScreeningExists = pvisCD.getDoesScreeningExist();
		if (this.bScreeningExists){tabScreening = repository.getScreeningTab();}


		//find the selected chemical from the combo box
		String sSelectedChemical = cbChemical.getValue();

		//get all of the hBox input lines
		alHBox = repository.getHBoxList();
		ArrayList<Node> alNodeNew = new ArrayList<Node>();
		ArrayList<Node> alNodeNewScreening = new ArrayList<Node>();

		//name constants
		s = new Stripper();
		nc = new NameConstants();
		String sInputType,sChemicalName;
		boolean isItThere=false;


		//2) gather data from the tab to which the ComboBox is attached:
		ScrollPane sp = (ScrollPane) tab.getContent();
		GridPane gp = (GridPane) sp.getContent();
		ObservableList<Node> olNode = gp.getChildren();
		ObservableList<Node> olHBoxKids; 
		HBox hbox;	
		String sDescription="",sDescription2="",sDataGroup="",sUnitSelected="";
		ComboBox<String>cbUnit;

		for (Node node:  olNode)
		{	
			//children of the hbox:
			hbox = (HBox)node;
			olHBoxKids = hbox.getChildren();

			//type of input
			sInputType = ((Label) olHBoxKids.get(nc.int_INPUTTYPE)).getText();

			//only work on chemical inputs
			if (s.areTheyEqual(sInputType, nc.s_CHEMICALINPUT))
			{
				//get values for future adding of a control
				sDescription2 = ((Label) (olHBoxKids.get(nc.int_DESCRIPTION))).getText();
				sDescription = ((Label) (olHBoxKids.get(nc.int_DESCRIPTION2))).getText();
				cbUnit = (ComboBox<String>) olHBoxKids.get(nc.int_UNIT);
				sUnitSelected = cbUnit.getValue();
				sDataGroup = ((Label) olHBoxKids.get(nc.int_DATAGROUP)).getText();	

				//does an input match the chemical to be added or removed?
				sChemicalName = 	((Label) olHBoxKids.get(nc.int_DESCRIPTION)).getText();
				if (s.areTheyEqual(sChemicalName,sSelectedChemical))
				{
					//remove any chemical that matches the selected name
					//(i.e., the chemical is present so discard it
					((Label) (olHBoxKids.get(nc.int_CHANGETOCOME))).setText("discard"); 
					//remove the selected chemical and any associated screening level from the list of controls
					repository.removePriorControl(sDataGroup, sDescription2, sDescription);
					isItThere = true;
				}
				else
				{
					((Label) (olHBoxKids.get(nc.int_CHANGETOCOME))).setText("keep");   
				}
			}
			alNodeNew.add(hbox);
		}
   
		
		//3) gather data from the tab to which the ScreeningLeve pane:
		if (this.bScreeningExists)
		{	
			ScrollPane spScreening = (ScrollPane) tabScreening.getContent();
			GridPane gpScreening = (GridPane) spScreening.getContent();
			ObservableList<Node> olScreening = gpScreening.getChildren();

			for (Node node:  olScreening)
			{	
				//children of the hbox:
				hbox = (HBox)node;
				olHBoxKids = hbox.getChildren();
				//type of input
				sInputType = ((Label) olHBoxKids.get(nc.int_INPUTTYPE)).getText();
				
				//does an input match the chemical to be added or removed?
				//sChemicalName = 	((Label) olHBoxKids.get(nc.int_DESCRIPTION)).getText();
				sChemicalName = 	((Label) olHBoxKids.get(nc.int_CSLChemical)).getText();
				 
				if (s.areTheyEqual(sChemicalName,sSelectedChemical))
				{
					//remove any chemical that matches the selected name
					//(i.e., the chemical is present so discard it
					((Label) (olHBoxKids.get(nc.int_CHANGETOCOME-2))).setText("discard"); 
					//remove the selected chemical and any associated screening level from the list of controls
					repository.removePriorControl(sDataGroup, sDescription2, sDescription);
					isItThere = true;
				}
				else
				{
					((Label) (olHBoxKids.get(nc.int_CHANGETOCOME-2))).setText("keep");   
				}
				
				
				
				if (s.areTheyEqual(sInputType, nc.s_CONTROLSCREENINGLEVELINPUT))
				{	
					//sChemicalName = ((Label) (olHBoxKids.get(nc.int_DESCRIPTION))).getText();
					//if screening levels are used add the chemical to the screening level tab
					
					alNodeNewScreening.add(hbox);
				}
				
			}
		}
		
		//if the chemical is not present, add it
		if (!isItThere)
		{
			//chemical is not present
			//so add it
			InputControlValue ic = new InputControlValue();

			sDescription2 = cbChemical.getValue();	   

			String[] lineArray = {sDataGroup,sDescription,nc.dist_CONSTANT,sDescription2,""+0.0,sUnitSelected,""+1.0};

			RawInputLine ril = new RawInputLine();
			ril.setRawInputLine(nc.s_CHEMICALINPUT,lineArray);

			ic.setHandlerRepository(repository);
			ic.setTabPane(this.tp);
			ic.setTab(this.tab);
			ic.setTabName(tab.getText());
			ic.setName(sDataGroup);
			ic.setIndex(0);
			ic.setLabel(sDescription2);
			ic.setHeight(nc.int_HEIGHT);
			ic.setRawInputLine(ril);
			ic.setUnitConverter(uc);
			ic.setChangeToCome("keep");


			ic.makeInputControlForAll();
			HBox hb =  ic.getInputControl();	
			alNodeNew.add(hb);	

            //add the screening level
			if (this.bScreeningExists){alNodeNewScreening.add(getNewInputControlForScreening(sDescription2));}
		}


		//set up new tab contents
		sp = new ScrollPane();
		gp = new GridPane();		



		int iCount = 0;
		String sChangeToCome;


		//check through the list of new nodes
		//add the nodes to keep
		for (Node node3: alNodeNew)
		{
			hbox = (HBox)node3;
			try
			{
				olHBoxKids = hbox.getChildren();
				sInputType = ((Label)olHBoxKids.get(nc.int_INPUTTYPE)).getText();
				if (s.equals(sInputType,nc.s_CHEMICALINPUT)) 	
				{	 
					sChangeToCome = ((Label)olHBoxKids.get(nc.int_CHANGETOCOME)).getText(); 
					if (sChangeToCome.equalsIgnoreCase("keep"))
					{
						//(""+iCount) forces type cast to string)
						//first refresh the hidden count number
						((Label)olHBoxKids.get(nc.int_COUNT)).setText((String)(""+iCount));
						//now add to the grid pane
						gp.add(node3, 0, iCount);
						iCount++;
					}
				}  
				else
				{
					if (!s.areTheyEqual(sInputType, "ScreeningLevel",' '))
					{	
						//not a value or chemical input
						//so always add these types to the gridpane
						((Label)olHBoxKids.get(nc.int_COUNT)).setText((String)(""+iCount));
						gp.add(node3, 0, iCount);
						iCount++;
					}
				}

			}
			catch(Exception e2){}
		}



		sp.setContent(gp);
		tab.setContent(sp);

		//correct the screening level pane
		if (this.bScreeningExists)
		{	
            tabScreening = this.repository.getScreeningTab();
			//set up new tab contents
			ScrollPane spTab = new ScrollPane();
			GridPane gpTab = new GridPane();		

			iCount = 0;
			//check through the list of new nodes
			//add the nodes to keep
			for (Node node3: alNodeNewScreening)
			{
				hbox = (HBox)node3;
				try
				{
					olHBoxKids = hbox.getChildren();
					sInputType = ((Label)olHBoxKids.get(nc.int_INPUTTYPE)).getText();
					sChemicalName = 	((Label) olHBoxKids.get(nc.int_CSLChemical)).getText();
					if (s.areTheyEqual(sInputType,"ScreeningLevel",' ')) 	
					{	 
						sChangeToCome = ((Label)olHBoxKids.get(nc.int_CHANGETOCOME-2)).getText(); 
						
						System.out.println("Chemcal:  "+sChemicalName);
						int iNumber = olHBoxKids.size();
						String sTest="";
						for (int j=0;j<iNumber;j++)
						{
							sTest = "";
							try
							{
								sTest = ((Label) olHBoxKids.get(j)).getText();
							}
							catch (Exception eee){}
							try
							{
								sTest =  ((TextField) (olHBoxKids.get(j))).getText(); 
							}
							catch (Exception eee){}
							System.out.println("Count " + j + " Item " + sTest);
						}
						
						if (sChangeToCome.equalsIgnoreCase("keep"))
						{
							//(""+iCount) forces type cast to string)
							//first refresh the hidden count number
							((Label)olHBoxKids.get(nc.int_COUNT)).setText((String)(""+iCount));
							//now add to the grid pane
							gpTab.add(node3, 0, iCount);
							iCount++;
						}
					} 
				}
				catch(Exception e3){}
			}

			spTab.setContent(gpTab);
			tabScreening.setContent(spTab);
		}

	}


	//get control for new screening level
	private HBox getNewInputControlForScreening(String sChemicalName)
	{
		HBox hb = new HBox();
		InputControlValue ic = new InputControlValue();
		Tab tabScreening = repository.getScreeningTab();
		TabPane tpScreening = tabScreening.getTabPane();

		String sDataGroup = "ScreeningLevel";
		String sDescription2 = sChemicalName;
		//determine actual source of units:  (replace what is here now)
		String sUnitSelected = "ug/m3";



		String[] sRawInput={sDataGroup,sChemicalName,"Constant","0.0",sUnitSelected};
		RawInputLine ril = new RawInputLine();
		ril.setRawInputLine(nc.s_CONTROLSCREENINGLEVELINPUT,sRawInput);

		ic.setHandlerRepository(repository);
		ic.setTabPane(tpScreening);
		ic.setTab(tabScreening);
		ic.setTabName(tabScreening.getText());
		ic.setName(sDataGroup);
		ic.setIndex(0);
		ic.setLabel(sDescription2);
		ic.setHeight(nc.int_HEIGHT);
		ic.setRawInputLine(ril);
		ic.setUnitConverter(uc);
		ic.setChangeToCome("keep");

		ic.makeInputControlForAll();
		hb =  ic.getInputControl();	

		return hb;
	}


	//sets
	//public void setRepository(Repository repository){this.repository = repository;}
	public void setChemicalChoices(ComboBox<String> cbChemical){this.cbChemical = cbChemical;}
	public void setTabPane(TabPane tp){this.tp = tp;}
	public void setTab(Tab tab){this.tab = tab;}
}
