package ui;

import java.util.ArrayList;

import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TabPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import pviScreen.RawInputLine;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;

public class HandlerDefaultNameRange implements EventHandler
{
  private double dMin, dMax;
  private String sName;
  private HandlerEdit he;
  private Repository repository;
  private NameConstants nc;
  
  public HandlerDefaultNameRange()
  {
	  nc = new NameConstants();
  }
  public HandlerDefaultNameRange(String sName, double dMin, double dMax)
  {
	  nc = new NameConstants();
	  this.setName(sName);
	  this.setMinimum(dMin);
	  this.setMaximum(dMax);
  }
  
  
  public void handle(Event event)
  {
	  //find the results for air exchange rate
	  Stripper s = new Stripper();
	  OutputDigits od = new OutputDigits();
	  String sQualifier,sDescription;
	  ArrayList<HBox> alHBox = new ArrayList<HBox>();
	  he = repository.getHandlerEdit();
      alHBox = he.getAllHBox();
      
      //find air exchange nodes
      for (HBox hbox: alHBox)
      {	  
  	    ObservableList<Node> olHBoxKids = hbox.getChildren();
  		//most containers value, chemical 
  		//public final   int int_CBDISTRIBUTION = 2;
  		//public final   int int_QUALIFIER = 3;
  		//public final   int int_DESCRIPTION = 4;
  		//public final   int int_DESCRIPTION2 = 5;
  	    //public final   int int_VALUE = 6;
  	    //public final   int int_UNIT = 7; 
  	    
  	    try
  	    {
  	      sDescription = ((Label)(olHBoxKids.get(nc.int_DESCRIPTION))).getText();
  	    
  	    
  	      if (s.areTheyEqual(sDescription, "AirExchangeRate"))
  	      {	
  	        //gets qualifier on value:   min or max  or "one value"
  	        sQualifier = ((Label)(olHBoxKids.get(nc.int_QUALIFIER))).getText();
  	        if (s.areTheyEqual(sQualifier,nc.qual_min))
  	        {
  	    	  ((TextField)(olHBoxKids.get(nc.int_VALUE))).setText(od.num2String(dMin));
  	    	  repository.setEditControlChanged(true);
  	        }
  	        else if (s.areTheyEqual(sQualifier, nc.qual_max))
  	        {
  	    	  ((TextField)(olHBoxKids.get(nc.int_VALUE))).setText(od.num2String(dMax));
  	    	  repository.setEditControlChanged(true);
  	        }
  	        else if (s.areTheyEqual(sQualifier, nc.qual_OneValue)){}
  	      }
  	    
  	    }
  	    catch (Exception e){}
       }  
     
  }
  
  //sets
  public void setName(String sName){this.sName = sName;}
  public void setMinimum(double dMin){this.dMin = dMin;}
  public void setMaximum(double dMax){this.dMax = dMax;}
  public void setRepository(Repository repository){this.repository = repository;}
  
  //gets
  public String getName(){return this.sName;}
  public double getMinimum(){return this.dMin;}
  public double getMaximum(){return this.dMax;}
  
}
