package ui;

import java.util.ArrayList;

import pviScreen.AquiferData;
import pviScreen.Chemical;
import pviScreen.FillDataContainer;
import pviScreen.PVIScreenControlData;
import pviScreen.RawInput;
import pviScreen.RawInputLine;

import util.FileLogger;
import util.NameConstants;
import util.Stripper;
import util.UnitConverter;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Labeled;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TabPane.TabClosingPolicy;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class HandlerEdit implements EventHandler
{
	private Stage stage;
	private Scene scene;
	private Button buttonEdit;
	private Repository repository;
	private Label lTopLabel;
	private UnitConverter uc;
	private PVIScreenControlData pvisControlData;
	private BorderPane border;
	private RawInput ri;
	private TabPane tp;
	private Tab tab;
	private boolean bAllPresent;
	private ArrayList<HBox> alHbox;
	private FillDataContainer fdc;
	private NameConstants nc;
	private Stripper s;
	private ObservableList<Button>olButton;

	private final static String constant_STRING = "Building";

	public HandlerEdit(Stage stage)
	{
		this.stage = stage;
		alHbox = new ArrayList<HBox>();
		nc = new NameConstants();
	}


	public void handle(Event event)
	{
		redisplayData();

	}
	
	
	public void redisplayData()
	{
		//wipe out all existing data and panels
		//then recreate all
		//used when the input data has been edited
		pvisControlData = repository.getPVIScreenControlData();
		//clear previous lists of controls
		repository.clearPreviousControlArrayList();
		//put hbox list into repository
		repository.setHboxList(alHbox);
		uc = pvisControlData.getUnitConverter();
		ri = pvisControlData.getRawInput();
		border = repository.getBorder();
		repository.setInputFileFlagSet(true);

		//refresh list of input lines (HBox controls)
		alHbox = new ArrayList<HBox>();
		//check if all are present
		bAllPresent = true;

		tp = new TabPane();

		//change button statii
		olButton = repository.getButtonList();
		s = new Stripper();

		String sInputType = repository.getInputType();

		if (s.areTheyEqual(sInputType, nc.s_Radio_ExistingInput))
		{	

			for (Button button: olButton)
			{
				String sButton = button.getText();
				if (s.equals(nc.s_ButtonEdit,sButton)){button.requestFocus();}
				//disable run and results buttons
				if (s.equals(nc.s_ButtonRun,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				if (s.equals(nc.s_ButtonResults,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				if (s.equals(nc.s_ButtonRun,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				if (s.equals(nc.s_ButtonReport,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
			}	   	   
		}
		else if (s.areTheyEqual(sInputType, nc.s_Radio_Results))
		{
			for (Button button: olButton)
			{
				String sButton = button.getText();
				//disable buttons
				if (s.areTheyEqual(nc.s_ButtonEdit, sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonRun,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonSave,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				//enable buttons
				else if (s.equals(nc.s_ButtonResults,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}	
				else if (s.equals(nc.s_ButtonReport,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}				
			}	   	 
		}


		//check the collection of raw inputs to make sure each required type is present
		if (ri.checkForInputName("Control"))
		{	
			tab = new Tab();
			tab.setText(nc.tab_IdentificationAndOptions);
			//String[] sItem = {"Site","SiteLocation","City","State","Analyst","Affiliation","RiskLevel","HazardQuotient","OilDistribution"};
			//String[] sDataGroup = {"Control","Control","Control","Control","Control","Control","Control","Control","Control"};
			String[] sItem = {"Site","SiteLocation","City","State","Analyst","Affiliation"};
			String[] sDataGroup = {"Control","Control","Control","Control","Control","Control"};
			tab.setContent(this.addPane("Identification", sDataGroup, sItem)); 
			tab.setClosable(false);
			tp.getTabs().add(tab);
		}
		else {this.bAllPresent=false;}		  	  

		if (ri.checkForInputName("Building"))
		{	
			tab = new Tab();
			tab.setText(nc.tab_BuildingAndFoundation);
			tab.setContent(this.addBuildingPane(nc.tab_BuildingAndFoundation));
			tab.setClosable(false);
			tp.getTabs().add(tab);
		}
		else {this.bAllPresent=false;}

		if (ri.checkForInputName("Vadose Zone"))
		{	
			tab = new Tab();
			tab.setText(nc.tab_VadoseZone);
			tab.setContent(this.addVadoseZoneOnePane(nc.tab_VadoseZone));
			tab.setClosable(false);
			tp.getTabs().add(tab);
		}
		else {this.bAllPresent=false;}



		/*
		if (ri.checkForInputName("Risk"))
		{	
			tab = new Tab();
			tab.setText(nc.tab_Risk);
			tab.setContent(this.addRiskPane(nc.tab_Risk));
			tab.setClosable(false);
			tp.getTabs().add(tab);
		}
		else {this.bAllPresent=false;}
		 */



		if (ri.checkForInputName("Oil Lens"))
		{	
			tab = new Tab();
			tab.setText(nc.tab_OilZone);
			tab.setContent(this.addOilLensPane(nc.tab_OilZone));
			tab.setClosable(false);
			tp.getTabs().add(tab);

			tab = new Tab();
			tab.setText(nc.tab_OilZoneContinuer);
			tab.setContent(this.addOilLensTwoPane(nc.tab_OilZoneContinuer));
			tab.setClosable(false);
			tp.getTabs().add(tab);
		}
		else if (ri.checkForInputName("Soil Gas"))
		{

		}
		else {this.bAllPresent=false;}

		if (ri.checkForInputName("Aquifer"))
		{	
			tab = new Tab();
			tab.setText(nc.tab_Aquifer);
			tab.setContent(this.addAquiferPane(nc.tab_Aquifer));
			tab.setClosable(false);
			tp.getTabs().add(tab);
		}
		else {this.bAllPresent=false;}



		if (ri.checkForInputName("Chemical"))
		{	
			tab = new Tab();
			tab.setText(nc.tab_Chemicals);
			tab.setContent(this.addChemicalPane(nc.tab_Chemicals));
			tab.setClosable(false);
			tp.getTabs().add(tab);
		}
		else {this.bAllPresent=false;}


		if (ri.checkForInputName("ScreeningLevel"))
		{
			tab = new Tab();
			tab.setText(nc.tab_ScreeningLevel);
			tab.setContent(this.addScreeningLevelPane(nc.tab_ScreeningLevel));
			tab.setClosable(false);
			repository.setScreeningTab(tab);
			tp.getTabs().add(tab);
		}		


		//recommended values tab
		Tab tabSuggested = new Tab();
		tabSuggested.setText(nc.tab_SuggestedValues);
		tabSuggested.setClosable(false);
		TabPane tp2 = new TabPane();



		if (ri.checkForInputName("Building"))
		{	
			tab = new Tab();
			tab.setText(nc.tab_AirFlow);
			tab.setContent(this.addFoundationPane(nc.tab_AirFlow));
			tab.setClosable(false);
			tp2.getTabs().add(tab);		
		}



		if (ri.checkForInputName("Control"))
		{	
			tab = new Tab();
			tab.setText(nc.tab_ConcentrationAdjustment);
			tab.setContent(this.addConcentrationAdjustmentPane(nc.tab_ConcentrationAdjustment));
			tab.setClosable(false);
			tp2.getTabs().add(tab);


			tab = new Tab();
			tab.setText(nc.tab_Control);
			tab.setContent(this.addControlPane(nc.tab_Control));
			tab.setClosable(false);
			tp2.getTabs().add(tab);
		}
		else {this.bAllPresent=false;}		


		tabSuggested.setContent(tp2);
		tp.getTabs().add(tabSuggested);


		/*

		//put up tab if all not present
		if (!this.bAllPresent)
		{
			tab = new Tab();
			tab.setText(nc.tab_InputDataError);
			tab.setContent(this.addDataNotPresentPane());
			tp.getTabs().add(tab);
		}

		 */



		border.setCenter(tp); 
		repository.setHboxList(alHbox);

		
		
	}
	

	//condensed adding of inputs to screen
	//this method (addRawInputsToScreenDisplay) is used for each input screen
	public int addRawInputsToScreenDisplay(GridPane grid, int iIndex, String sTabName, String sName, String sType, String sUnitType)
	{
		String sDistributionType;
		String sInputType = "typical";
		int iInvisible;
		double dFrequency;
		HBox hBox;
		InputControlValue ic;


		//default is no invisible input LINEs;
		iInvisible = 0;

		//get the data needed to add
		ArrayList<RawInputLine>riLoad = ri.getRawInputLines(sName, sType);

		int iNumber = riLoad.size();
		for (int i=0;i<iNumber;i++)
		{
			VBox vBox = new VBox();
			RawInputLine ril = riLoad.get(i);

			hBox = this.getInputControl(tp,tab,sTabName,sName,sType,iIndex,true,20,ril);

			//add to the grid
			grid.add(hBox,0,iIndex);

			//add the hBox to the collection of HBoxes
			alHbox.add(hBox);

			iIndex++;
		}


		return iIndex;
	}



	HBox hbox;
	//capture all the input values from the screens
	//and place them in an arrayList of rawInputLines for outputting (alRawOutputLine)
	public ArrayList<RawInputLine> getAllInputs(TabPane tp)
	{
		ArrayList<RawInputLine> alRawOutputLine = new ArrayList<RawInputLine>();
		HBox hBox;

		ObservableList<Tab> olTabs = tp.getTabs();
		ScrollPane sp;
		GridPane gp;
		ObservableList<GridPane> olGrid;
		ObservableList<Node> olHBoxKids;
		//ObservableList<HBox> olHBox2;
		Group olHBox2;
		RawInputLine ril;
		String sWrite="";
		InputControlValue ic;
		int iCount;
		String sTabName="", sName="", sType="", sType2="", sDistributionType="", sUnit="", sComment="";
		String sHiddenIndex="", sQualifier="";
		double dValue, dFrequency;
		String sValue="", sFrequency="";
		Stripper s = new Stripper();
		String sRawInputType;
		String sUnitType;
		String sChoice;
		String sSuggestedValueOutputDestination="";



		for (HBox hb: alHbox)
		{	
			int iCount2 = 0;
			iCount2++;
			ril = new RawInputLine();
			olHBoxKids = hb.getChildren();

			//sTabName = ((Label) olHBoxKids.get(nc.int_TABNAME)).getText();
			sRawInputType = ((Label) olHBoxKids.get(nc.int_INPUTTYPE)).getText();


			if (s.areTheyEqual(this.nc.s_CONTROL2STRING,sRawInputType))
			{
				//control input with two strings (2nd string is changeable, i.e., set in a text box)
				//"3" is subtracted for sName  because there is not a cbDistribution, lQualifier and cbUnit
				//"2" is subtracted for sType and sValue because these do not have cbDistribution, lQualifier
				sName = ((Label) olHBoxKids.get(nc.int_DATAGROUP-3)).getText();
				sType = ((Label) olHBoxKids.get(nc.int_DESCRIPTION-2)).getText();
				sValue = ((TextField) olHBoxKids.get(nc.int_VALUE-2)).getText();
				sSuggestedValueOutputDestination = ((Label) olHBoxKids.get(nc.int_OUTPUTDESTINATION-3)).getText();

				//create a string to add to the RawInputLine object
				String[] sRawInput = {sName,sType,sValue};

				//set values in the RawInputLine object
				ril.setRawInputLine(nc.s_CONTROL2STRING, sRawInput);
				ril.setOutputDestination(sSuggestedValueOutputDestination);
				alRawOutputLine.add(ril);
			}
			else if (s.areTheyEqual(this.nc.s_CONTROLSTRINGVALUE,sRawInputType))
			{
				//control input with one string (2nd string is changeable and a number, i.e., set in a text box)
				//"3" is subtracted for sName  because there is not a cbDistribution, lQualifier and cbUnit
				//"2" is subtracted for sType and sValue because these do not have cbDistribution, lQualifier
				sName = ((Label) olHBoxKids.get(nc.int_DATAGROUP-3)).getText();
				sType = ((Label) olHBoxKids.get(nc.int_DESCRIPTION-2)).getText();
				sValue = ((TextField) olHBoxKids.get(nc.int_VALUE-2)).getText();
				sSuggestedValueOutputDestination = ((Label) olHBoxKids.get(nc.int_OUTPUTDESTINATION-3)).getText();

				//create a string to add to the RawInputLine object
				String[] sRawInput = {sName,sType,sValue};

				//set values in the RawInputLine object
				ril.setRawInputLine(nc.s_CONTROLSTRINGVALUE, sRawInput);
				ril.setOutputDestination(sSuggestedValueOutputDestination);
				alRawOutputLine.add(ril);
			}
			else if (s.areTheyEqual(this.nc.s_CONTROL3STRING,sRawInputType))
			{
				//control input with two strings (2nd string is changeable, i.e., set in a text box)
				//"3" is subtracted for sName  because there is not a cbDistribution, lQualifier and cbUnit
				//"2" is subtracted for sType and sValue because these do not have cbDistribution, lQualifier
				sName = ((Label) olHBoxKids.get(nc.int_DATAGROUP-3)).getText();
				sType = ((Label) olHBoxKids.get(nc.int_DESCRIPTION-2)).getText();
				sType2 = ((Label) olHBoxKids.get(nc.int_DESCRIPTION2-2)).getText();
				sValue = ((TextField) olHBoxKids.get(nc.int_VALUE-2)).getText();
				sSuggestedValueOutputDestination = ((Label) olHBoxKids.get(nc.int_OUTPUTDESTINATION-3)).getText();

				//create a string to add to the RawInputLine object
				String[] sRawInput = {sName,sType,sType2,sValue};

				//set values in the RawInputLine object
				ril.setRawInputLine(nc.s_CONTROL3STRING, sRawInput);
				ril.setOutputDestination(sSuggestedValueOutputDestination);
				alRawOutputLine.add(ril);
			}
			else if (s.areTheyEqual(nc.s_CONTROL2STRINGVALUE,sRawInputType))
			{
				//control input with a string and a value (value is a number and changeable, i.e., 
				//         set in a text box with a number error handler of typeHandlerEditNumber)
				//"3" is subtracted for sName  because there is not a cbDistribution, lQualifier and cbUnit
				//"2" is subtracted for sType, sType2 and sValue because these do not have cbDistribution, lQualifier    	    	   
				sName = ((Label) olHBoxKids.get(nc.int_DATAGROUP-3)).getText();
				sType = ((Label) olHBoxKids.get(nc.int_DESCRIPTION-2)).getText();
				sType2 = ((Label) olHBoxKids.get(nc.int_DESCRIPTION2-2)).getText();
				sValue =  ((TextField) (olHBoxKids.get(nc.int_VALUE-2))).getText();   			 
				sSuggestedValueOutputDestination = ((Label) olHBoxKids.get(nc.int_OUTPUTDESTINATION-3)).getText();

				//create a string to add to the RawInputLine object
				String[] sRawInput = {sName,sType,sType2,sValue};

				//set values in the RawInputLine object
				ril.setRawInputLine(nc.s_CONTROL2STRINGVALUE, sRawInput);
				ril.setOutputDestination(sSuggestedValueOutputDestination);
				alRawOutputLine.add(ril);
			}  
			else if (s.areTheyEqual(nc.s_CONTROLSTRINGCHOICE,sRawInputType))
			{
				sName = ((Label) olHBoxKids.get(nc.int_CHOICEDATAGROUP)).getText();
				sType = ((Label) olHBoxKids.get(nc.int_CHOICEDESCRIPTION)).getText();
				ComboBox<String> cbChoice = ((ComboBox<String>)olHBoxKids.get(nc.int_CHOICECHOICEBOX));
				sChoice =  cbChoice.getValue();
				sSuggestedValueOutputDestination = ((Label) olHBoxKids.get(nc.int_CHOICEOUTPUTDESTINATION-1)).getText();

				String[] sRawInput = {sName,sType,sChoice};
				ril.setRawInputLine(nc.s_CONTROLSTRINGCHOICE,sRawInput);
				ril.setOutputDestination(sSuggestedValueOutputDestination);
				alRawOutputLine.add(ril);


				//not happy about this but

			}
			else if (s.areTheyEqual(nc.s_CONTROLRISKINPUT,sRawInputType))
			{
				/*
    	    	public final int int_RISK_CHEMICAL = 2;
    	    	public final int int_RISK_LEVEL = 3;
    	    	public final int int_RISK_LEVEL_CONC = 4;
    	    	public final int int_RISK_LEVEL_UNIT = 5;
    	    	public final int int_RISK_HQ = 6;
    	    	public final int int_RISK_HQ_CONC = 7;
    	    	public final int int_RISK_HQ_UNIT = 8;
				 */

				sName = ((Label) olHBoxKids.get(nc.int_RISK_CHEMICAL)).getText();
				String sRiskLevel = ((TextField) olHBoxKids.get(nc.int_RISK_LEVEL)).getText();
				String sRiskLevelConc = ((TextField) olHBoxKids.get(nc.int_RISK_LEVEL_CONC)).getText();
				String sUnitLevel = ((ComboBox<String>)olHBoxKids.get(nc.int_RISK_LEVEL_UNIT)).getValue();
				String sRiskHQ = ((TextField) olHBoxKids.get(nc.int_RISK_HQ)).getText();
				String sRiskHQConc = ((TextField) olHBoxKids.get(nc.int_RISK_HQ_CONC)).getText();
				String sUnitHQ = ((ComboBox<String>)olHBoxKids.get(nc.int_RISK_HQ_UNIT)).getValue();    	    	

				String[] sRawInput = {nc.s_CONTROLRISKINPUT,"Inhalation Risk",sName,sRiskLevel,sRiskLevelConc,sUnitLevel,sRiskHQ,sRiskHQConc,sUnitHQ};
				sSuggestedValueOutputDestination = ((Label) olHBoxKids.get(nc.int_OUTPUTDESTINATION)).getText();

				ril.setRawInputLine(nc.s_CONTROLSTRINGCHOICE,sRawInput);
				ril.setOutputDestination(sSuggestedValueOutputDestination);
				alRawOutputLine.add(ril);
			}
			else if (s.areTheyEqual(nc.s_CONTROLSCREENINGLEVELINPUT,sRawInputType))
			{	
				int iNumber = olHBoxKids.size();
				String sTest="";
				for (int j=0;j<iNumber;j++)
				{
					sTest = "";
					try
					{
						sTest = ((Label) olHBoxKids.get(j)).getText();
					}
					catch (Exception e){}
					try
					{
						sTest =  ((TextField) (olHBoxKids.get(j))).getText(); 
					}
					catch (Exception e){}
					System.out.println("Count " + j + " Item " + sTest);
				}
				
				sName = ((Label) olHBoxKids.get(nc.int_CSLType)).getText();
				sType = ((Label) olHBoxKids.get(nc.int_CSLChemical)).getText();
				sValue =  ((TextField) (olHBoxKids.get(nc.int_CCLValue))).getText(); 
				ComboBox<String> cbUnit = ((ComboBox<String>)olHBoxKids.get(nc.int_CCLUnit));
				sUnit =  cbUnit.getValue();
				String[] sRawInput={sName,sType,"Constant",sValue,sUnit};
				sSuggestedValueOutputDestination = ((Label) olHBoxKids.get(nc.int_CSLOUTPUTDESTINATION)).getText();
				//System.out.println("OUtput destination: " + sSuggestedValueOutputDestination );
                int itest = olHBoxKids.size();
				
				ril.setRawInputLine(nc.s_CONTROLSCREENINGLEVELINPUT, sRawInput);
				ril.setOutputDestination(sSuggestedValueOutputDestination);
				alRawOutputLine.add(ril);
			}    	    
			else if (s.areTheyEqual(nc.s_VALUEINPUT,sRawInputType))
			{	
				sQualifier = ((Label) olHBoxKids.get(nc.int_QUALIFIER)).getText();
				sName = ((Label) olHBoxKids.get(nc.int_DATAGROUP)).getText();
				sType = ((Label) olHBoxKids.get(nc.int_DESCRIPTION)).getText();
				ComboBox<String> cbUnit = ((ComboBox<String>)olHBoxKids.get(nc.int_UNIT));
				sUnit =  cbUnit.getValue();
				ComboBox<String> cbDistribution = ((ComboBox<String>)olHBoxKids.get(nc.int_CBDISTRIBUTION));
				sDistributionType = cbDistribution.getValue();
				sValue =  ((TextField) (olHBoxKids.get(nc.int_VALUE))).getText();
				sSuggestedValueOutputDestination = ((Label) olHBoxKids.get(nc.int_OUTPUTDESTINATION)).getText();
			}
			else if (s.areTheyEqual(nc.s_CHEMICALINPUT,sRawInputType))
			{	
				sQualifier = ((Label) olHBoxKids.get(nc.int_QUALIFIER)).getText();
				sName = ((Label) olHBoxKids.get(nc.int_DATAGROUP)).getText();
				sType2 = ((Label) olHBoxKids.get(nc.int_DESCRIPTION)).getText();
				sType = ((Label) olHBoxKids.get(nc.int_DESCRIPTION2)).getText();
				ComboBox<String> cbUnit = ((ComboBox<String>)olHBoxKids.get(nc.int_UNIT));
				sUnit =  cbUnit.getValue();
				ComboBox<String> cbDistribution = ((ComboBox<String>)olHBoxKids.get(nc.int_CBDISTRIBUTION));
				sDistributionType = cbDistribution.getValue();
				sValue =  ((TextField) (olHBoxKids.get(nc.int_VALUE))).getText();   
				sSuggestedValueOutputDestination = ((Label) olHBoxKids.get(nc.int_OUTPUTDESTINATION)).getText();
			}




			dFrequency = 0.0;
			sFrequency = "0.0";   	    
			if (s.areTheyEqual(nc.qual_OneValue, sQualifier))
			{
				dFrequency = 1.0;
				sFrequency = "1.0";
				sDistributionType = "Constant";
			}
			else if (s.areTheyEqual(nc.qual_min,sQualifier))
			{
				dFrequency = 0.0;
				sFrequency = "0.0";
				sDistributionType = "Variable";
			}
			else if (s.areTheyEqual(nc.qual_max, sQualifier))
			{
				dFrequency = 1.0;
				sFrequency = "1.0";
				sDistributionType = "Variable";
			}


			if (s.areTheyEqual(nc.s_CHEMICALINPUT,sRawInputType))
			{	
				//create a string to add to the RawInputLine object
				String[] sRawInput = {sName,sType,sDistributionType,sType2,sValue,sUnit,sFrequency};

				//set values in the RawInputLine object
				ril.setRawInputLine(nc.s_CHEMICALINPUT, sRawInput);
				ril.setOutputDestination(sSuggestedValueOutputDestination);
				alRawOutputLine.add(ril);
			}  
			else if (s.areTheyEqual(nc.s_VALUEINPUT, sRawInputType))
			{
				//create a string to add to the RawInputLine object
				String[] sRawInput = {sName,sType,sDistributionType,sValue,sUnit,sFrequency};

				//set values in the RawInputLine object
				ril.setRawInputLine(nc.s_VALUEINPUT, sRawInput);
				ril.setOutputDestination(sSuggestedValueOutputDestination);
				alRawOutputLine.add(ril);
			}

		}

		return alRawOutputLine;
	}



	public void writeDataFile(FileLogger fl, ArrayList<RawInputLine> alRawOutputLine)
	{
		ArrayList<String>alSuggestedValue = new ArrayList<String>();
		ArrayList<String>alInputData = new ArrayList<String>();

		String sOutput = "";
		int iCount;
		String[] sGroup = {"Control","Building","VadoseZone","Aquifer","OilLens","Oxygen","Chemical","Risk","ScreeningLevel"};

		//cycle through all data groups
		for (int i=0;i<sGroup.length;i++)
		{	
			iCount=0;
			if (sGroup[i].equalsIgnoreCase("ScreeningLevel"))
			{
				int ijj=0;
				ijj++;
			}
			//pretest for existence of group
			for (RawInputLine ril:  alRawOutputLine)
			{
				//find the rawInputLines from the data group (sGroup[i])  
				sOutput = ril.getOutputLine(sGroup[i]);
				if (sOutput!=""){iCount++;}	
			}

			if (iCount>0)
			{	
				//only write if there are entries for this group  
				//fl.logMessageOverWrite(sGroup[i]+",Begin");
				//cycle through all raw input lines
				//find and write only those that are in the data group
				for (RawInputLine ril:  alRawOutputLine)
				{
					//find the rawInputLines from the data group (sGroup[i])  
					sOutput = ril.getOutputLine(sGroup[i]);
					if (sOutput!="")
					{
						//most output goes back to the chosen file
						//some goes to the systemDataFile
						//(any data item read in by the SuggestedValueReader (called in PVIScreenReader) is written out to the
						//suggest value file;  output destination set in PVIScreenReader)
						if(s.areTheyEqual(nc.file_UserChosenFileForOutput,ril.getOutputDestination(),' '))
						{	
							//accumulate the input data for later rewritting
							alInputData.add(sOutput);
						}
						else
						{
							//accumulate output lines for later rewritting
							
							alSuggestedValue.add(sOutput);
						}
					}	
				}
				//fl.logMessageOverWrite(sGroup[i]+",End");
			}  
		}



		String[] arrayList = {""};
		//write input data into the "chosen file"
		String[] sControl = {"Control","Building","VadoseZone","Aquifer","OilLens","Chemical","Risk","ScreeningLevel"};
		for (int i=0;i<sControl.length;i++)
		{	
			fl.logMessageOverWrite(sControl[i]+",Begin");
			for (String sOut: alInputData)
			{
				arrayList = sOut.split(",");
				if (s.areTheyEqual(arrayList[0], sControl[i],' '))
				{
					fl.logMessageOverWrite(sOut);
				}	
			}
			fl.logMessageOverWrite(sControl[i]+",End");
		}
		
		
		//jww 3-15-2017
		//open up system data file for output 
		FileLogger flSystem = new FileLogger(nc.file_SuggestedValues);
		flSystem.openOverWriteFile();
			 
		//write suggested values into nc.file_SuggestedValues
		flSystem.logMessageOverWrite("Suggested Value File");
		String[] sControl2 = {"Control","Building","Oxygen","VadoseZone"};
		for (int i=0;i<sControl2.length;i++)
		{	
			flSystem.logMessageOverWrite(sControl2[i]+",Begin");
			for (String sOut: alSuggestedValue)
			{
				arrayList = sOut.split(",");
				if (s.areTheyEqual(arrayList[0], sControl2[i],' '))
				{
					flSystem.logMessageOverWrite(sOut);
				}	
			}
			flSystem.logMessageOverWrite(sControl2[i]+",End");
		}
		flSystem.closeOverWriteFile();
	}

	public ScrollPane addBuildingPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		iIndex = 0;
		//dirt floor
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Building","DirtFloor");
		//width
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Building","Width","Length");
		//length
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Building","Length","Length");
		//mixing zone height
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Building","CeilingHeight","Length");
		//depth of foundation below grade
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Building","FoundationDepthBelowGrade","Length");
		//foundation thickness
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Building","FoundationThickness","Length");
		//crack width
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Building","CrackWidth","Length"); 
		//air exchange rate (with multiple choices)


		//temp set up for air exchange rates
		repository.removeAirExchangeRates();
		repository.addAirExchange(nc.s_Air_Exchange_Full,0.1,1.5);
		repository.addAirExchange(nc.s_Air_Exchange_High,1.2,1.5);
		repository.addAirExchange(nc.s_Air_Exchange_Mod,0.3,1.3);
		repository.addAirExchange(nc.s_Air_Exchange_Low,0.1,0.4);


		iIndex = addMultipleControlToScreenDisplay(gp,iIndex,sTabName,"Building","AirExchangeRate","AirExchangeRate");

		sp.setContent(gp);
		return sp;		   
	}
	public ScrollPane addFoundationPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		iIndex = 0;
		//air exchange rate
		//air exchange rate moved to building pane (JWW 1-8-2016)
		//iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Building","AirExchangeRate","AirExchangeRate");		   
		//Qsoil
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Building","Qsoil","Discharge");	   
		//Air flow beneath building
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Building","AirFlowBelowBuilding","Discharge");	   

		//soil respiration rate
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","SoilRespirationRate","SoilRespirationRate");

		//oxygen
		//Diffusion in Air
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oxygen","DiffusionInAir","DiffusionCoefficient");		   
		//Diffusion in Water
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oxygen","DiffusionInWater","DiffusionCoefficient");
		//Surface Concentration
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oxygen","SurfaceConcentration","ConcentrationAir");
		//Minimum Concentration for Biodegradation
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oxygen","MinimumBiodegradationConcentration","ConcentrationAir");	   

		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;		   
	}	

	public ScrollPane addScreeningLevelPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");

		ArrayList<Chemical> alChemical = pvisControlData.getChemicals();

		iIndex = 0;		   

		for (Chemical c: alChemical)
		{	   
			iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"ScreeningLevel",c.getName(),"ConcentrationAir");	
		}

		sp.setContent(gp);
		return sp;		   
	}	

	public ScrollPane addVadoseZoneOnePane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		iIndex = 0;
		//depth to sample
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","DepthToSample","Length");
		//depth to water
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","DepthToWater","Length");
		//depth to historic water table
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","DepthToHistoricWaterTable","Length");
		//depth to bottom of aquifer
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","DepthToBottom","Length");
		//moisture content
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","MoistureContent","MoistureContent");
		//depth to water
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","Porosity","Porosity");
		//fraction organic carbon
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","FractionOrganicCarbon","FractionOrganicCarbon");
		//temperature
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","SoilTemperature","Temperature");

		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;

	}

	public ScrollPane addVadoseZoneTwoPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		iIndex = 0;

		//soil respiration rate
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","SoilRespirationRate","SoilRespirationRate");


		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;

	}   



	public ScrollPane addOilLensPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		iIndex = 0;
		//oil distribution type
		//not needed here because it appears on main input screen, jww 1-5-2016
		//iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","OilDistribution");		   
		//fuel volume
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oil Lens","FuelVolume","Volume");
		//lens length
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oil Lens","LensLength","Length");
		//lens width
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oil Lens","LensWidth","Length");
		//max oil saturation
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oil Lens","MaxOilSaturation","Saturation");
		//residual oil saturation
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oil Lens","ResidualOilSaturation","Saturation");
		//oil water interfacial tension
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oil Lens","OilWaterInterfacialTension","InterfacialTension");
		//oil density
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oil Lens","OilDensity","Density");
		//oil molecular weight
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Oil Lens","OilMolecularWeight","MolecularWeight");

		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;

	}	   



	public ScrollPane addOilLensTwoPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		iIndex = 0;
		//air entry head
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","AirEntryHead","Length");
		//residual water saturation
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","ResidualWaterSaturation","Saturation");
		//water surface tension
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","WaterSurfaceTension","InterfacialTension");
		//lambda
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","Lambda","Lambda");
		//trapped air saturation
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Vadose Zone","TrappedAirSaturation","Saturation");

		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;

	}	   


	public ScrollPane addAquiferPane(String sTabName) 
	{
		int iIndex;

		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();

		gp.getStyleClass().add("grid");

		iIndex = 0;
		//add Hydraulic Conductivity
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Aquifer","HydraulicConductivity","HydraulicConductivity");
		//add Gradient
		iIndex = addRawInputsToScreenDisplay(gp,iIndex,sTabName,"Aquifer","Gradient","Gradient");

		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		//grid.setGridLinesVisible(true);


		sp.setContent(gp);
		return sp;
	}



	public ScrollPane addConcentrationAdjustmentPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		iIndex = 0;
		//ground waterconcentration adjustment factors
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","GroundwaterConcentrationFactor");
		//soil sample concentration adjustment factor
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","SoilSampleConcentrationFactor");	

		sp.setContent(gp);
		return sp;		 			   
	}

	public ScrollPane addControlPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		iIndex = 0;
		//concentration adjustment inputs moved to separate tab (3-14-2017)
		//ground waterconcentration adjustment factors
		//iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","GroundwaterConcentrationFactor");
		//soil sample concentration adjustment factor
		//iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","SoilSampleConcentrationFactor");
		//Bisection parameters
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","Bisection");		   
		//output units
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","OutputUnit");  
		//max alpha
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","max Alpha");
		//number of montecarlo runs
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","NumberOfSimulations");  
		//number of frequency intervals
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","NumberOfFrequencyDistributionIntervals");
		//browser
		//iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","Browser");
		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;		   
	}	

	//condense adding inputs to screen
	//this method (addControlInputsToScreenDisplay) is used for each input control entry
	public int addControlInputsToScreenDisplay(GridPane grid, int iIndex, String sTabName, String sName, String sType)
	{
		String sDistributionType;
		String sInputType = "typical";
		int iInvisible;
		double dFrequency;
		HBox hBox;
		InputControlValue ic;


		//default is no invisible input LINEs;
		iInvisible = 0;

		//get the data needed to add
		ArrayList<RawInputLine>riLoad = ri.getRawInputLines(sName, sType);

		int iNumber = riLoad.size();
		for (int i=0;i<iNumber;i++)
		{
			VBox vBox = new VBox();
			RawInputLine ril = riLoad.get(i);

			hBox = this.getInputControl(tp,tab,sTabName,sName,sType,iIndex,true,nc.int_HEIGHT,ril);

			grid.add(hBox,0,iIndex);

			alHbox.add(hBox);
			iIndex++;
		}


		return iIndex;
	}


	//condense adding inputs to screen
	//this method (addControlInputsToScreenDisplay) is used for each input control entry
	//sets up a two-line control, with buttons on the top that control min and max entries of data on the second line 
	public int addMultipleControlToScreenDisplay(GridPane grid, int iIndex, String sTabName, String sName, String sType, String sUnit)
	{
		String sDistributionType;
		String sInputType = "typical";
		int iInvisible;
		double dFrequency;
		HBox hBox,hBox1;
		InputControlValue ic;
		ObservableList<Button> olButton;
		ObservableList<Node> olNodes;

		//first HBox:


		//second HBox values of inputs
		//the buttons will be able to change the data in the input control
		//default is no invisible input LINEs;
		iInvisible = 0;

		//get the data needed to add
		ArrayList<RawInputLine>riLoad = ri.getRawInputLines(sName, sType);

		int iNumber = riLoad.size();
		for (int i=0;i<iNumber;i++)
		{
			VBox vBox = new VBox();
			RawInputLine ril = riLoad.get(i);

			hBox = this.getInputControl(tp,tab,sTabName,sName,sType,iIndex,true,nc.int_HEIGHT,ril);

			grid.add(hBox,0,iIndex);

			alHbox.add(hBox);
			iIndex++;
		}

		//line of buttons with choices
		hBox1 = new HBox();
		hBox1.getStyleClass().add("hbox");
		//create a collection to add controls to for future display	
		olNodes = FXCollections.observableArrayList();
		ArrayList<DefaultNameRange> alAirExchange = repository.getAirExchange();
		olNodes.add(new Text("Insert air exchange rate ranges:"));

		ToggleGroup group = new ToggleGroup();
		for (DefaultNameRange dnr: alAirExchange)
		{
			RadioButton b = new RadioButton(dnr.getName());
			b.setToggleGroup(group);
			//Button b = new Button(dnr.getName());
			HandlerDefaultNameRange hdnr = new HandlerDefaultNameRange(dnr.getName(),dnr.getMinimum(),dnr.getMaximum());
			hdnr.setRepository(repository);
			b.addEventHandler(ActionEvent.ACTION, hdnr);
			olNodes.add(b);
		}
		hBox1.getChildren().addAll(olNodes);	
		grid.add(hBox1, 0, iIndex);

		iIndex++;

		return iIndex;
	}	    



	//streamline the Data Entry
	//abbreviated entry for control parameters
	//sName = name for all controls on page (i.e., Aquifer)
	//sLabel = label to appear with control (i.e., "Hydraulic Conductivity")
	//dValue = value of input parameter
	//sDistributionType = type of distribution
	//sUnitSelected = selected Unit
	//iIndex = index of control on page
	//sTypeUnit = type of unit (i.e., "HydraulicConductivity" name is from UnitConverter input file
	//sQualifier = qualifier (i.e., minimum or maximum)
	//sComment = comment on data 
	private HBox getInputControl(TabPane tp,Tab tab, String sTabName, String sName, String sLabel, int iIndex, boolean bVisible, int iHeight, RawInputLine ril)
	{ 
		InputControlValue ic;
		s = new Stripper();
		if (s.areTheyEqual(nc.s_CONTROLSTRINGCHOICE, ril.getRawInputType()))
		{
			//special control for dropdown boxes
			ic = new InputControlChoice();
		}
		else
		{
			//input control for most input lines
			ic = new InputControlValue();
			ic.setUnitConverter(uc);
		}

		ic.setHandlerRepository(repository);
		ic.setTabPane(this.tp);
		ic.setTab(this.tab);
		ic.setTabName(sTabName);
		ic.setName(sName);
		ic.setIndex(iIndex);
		ic.setLabel(sLabel);
		ic.setHeight(iHeight);
		ic.setRawInputLine(ril);
		ic.setChangeToCome("keep");


		ic.makeInputControlForAll();
		return ic.getInputControl();
	}
	public ScrollPane addIDPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		iIndex = 0;
		//Site
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","Site");
		//site location (address)
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","SiteLocation");
		//city
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","City");
		//state
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","State");
		//analyst
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","Analyst");
		//affiliation
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","Affiliation");
		//risk level
		//iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","RiskLevel");
		//hazard quotient
		//iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","HazardQuotient");
		//lens used
		iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Control","OilDistribution");




		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;		   
	}	

	public ScrollPane addPane(String sTabName, String[] sDataGroup, String[] sItems)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");

		iIndex = 0;

		//add controls for the datagroups and items
		for  (int i=0;i<sDataGroup.length;i++)
		{
			iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,sDataGroup[i],sItems[i]);
		}

		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;		

	}


	public ScrollPane addChemicalPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		ArrayList<Chemical> alChemical = pvisControlData.getChemicals();

		iIndex = 0;

		//add the chemical adder
		iIndex = addChemicalManager(gp,iIndex,sTabName);


		for (Chemical chemical:  alChemical)
		{	   
			String sChemical = chemical.getName();

			//(only one chemical input type is expected:  two of the three should add no controls to the screen)

			System.out.println("Chemical " + sChemical);
			//chemical--fuel phase concentration by volume
			iIndex = addControlInputsToScreenDisplay(gp,iIndex,sTabName,"Chemical",sChemical);

		}



		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;

	}

	public ScrollPane addRiskPane(String sTabName)
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");


		ArrayList<Chemical> alChemical = pvisControlData.getChemicals();

		iIndex = 0;

		//add the chemical adder
		iIndex = addChemicalManager(gp,iIndex,sTabName);


		//get all user's input risks
		//iIndex = addRiskInputsToScreenDisplay(gp,iIndex,sTabName,"Risk","InhalationRisk");


		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;

	}	    



	/*
	 * addChemicalManager   add an input box to manage chemcials (add or remove them)
	 * iIndex               index for the input line
	 * gp                   GridPane to which input line is added
	 */
	private int addChemicalManager(GridPane gp, int iIndex, String sTabName)
	{
		InputControlChemicalManager iccm = new InputControlChemicalManager();  	   
		HBox hBox;

		iccm.setInputType(nc.s_CONTROLCHEMICALMANAGEMENT);
		iccm.setHandlerRepository(repository);
		iccm.setTabPane(this.tp);
		iccm.setTab(this.tab);
		iccm.setTabName(sTabName);
		iccm.setIndex(iIndex);
		iccm.setChangeToCome("keep");

		iccm.makeInputControlForAll();
		hBox =  iccm.getInputControl();
		gp.add(hBox,0,iIndex); 
		alHbox.add(hBox);
		iIndex++;

		return iIndex;
	}



	public int addRiskInputsToScreenDisplay(GridPane gp,int iIndex,String sTabName, String sName, String sType)
	{
		String sDistributionType;
		String sInputType = "typical";
		int iInvisible;
		double dFrequency;
		HBox hBox;
		InputControlValue ic;
		InputControlHeading ich;

		//add risk headings
		String[] sHeadingText = {"Chemical","Risk Level","Concentration","Unit","Hazard Quotient","Concentration","Unit"};
		int[] iHeadingLength = {150,100,125,100,125,125,100};
		ich = new InputControlHeading();
		ich.setHeadingText(sHeadingText);
		ich.setHeadingLength(iHeadingLength);
		ich.setInputType(nc.s_CONTROLHEADING);
		ich.setHandlerRepository(repository);
		ich.setTabPane(this.tp);
		ich.setTab(this.tab);
		ich.setTabName(sTabName);
		ich.setIndex(iIndex);
		ich.setUnitConverter(uc);
		ich.setChangeToCome("keep");

		ich.makeInputControlForAll();
		hBox = ich.getInputControl();
		gp.add(hBox,0,iIndex);	  	  	
		alHbox.add(hBox);
		iIndex++;


		//default is no invisible input LINEs;
		iInvisible = 0;

		//get the data needed to add
		ArrayList<RawInputLine>riLoad = ri.getRawInputLines(sName, sType);

		int iNumber = riLoad.size();
		for (int i=0;i<iNumber;i++)
		{
			VBox vBox = new VBox();
			RawInputLine ril = riLoad.get(i);

			//hBox = this.addRiskInput(gp, iIndex, sTabName, ril);
			InputControlRiskData icrd = new InputControlRiskData();  	   

			icrd.setInputType(nc.s_CONTROLRISKINPUT);
			icrd.setHandlerRepository(repository);
			icrd.setTabPane(this.tp);
			icrd.setTab(this.tab);
			icrd.setTabName(sTabName);
			icrd.setIndex(iIndex);
			icrd.setHeadingLength(iHeadingLength);
			icrd.setUnitConverter(uc);
			icrd.setRawInputLine(ril);
			icrd.setChangeToCome("keep");


			icrd.makeInputControlForAll();
			hBox =  icrd.getInputControl();    	   	             

			gp.add(hBox,0,iIndex);

			alHbox.add(hBox);
			iIndex++;
		}


		return iIndex; 
	}

	public ScrollPane addDataNotPresentPane()
	{
		int iIndex;
		ScrollPane sp = new ScrollPane();
		GridPane gp = new GridPane();
		gp.getStyleClass().add("grid");

		iIndex = 0;

		//iIndex++;
		//gp.add(getNavigationControl(),0,iIndex);

		sp.setContent(gp);
		return sp;		   
	}



	public HBox getNavigationControl()
	{
		HBox hbo = new HBox();
		hbo.getStyleClass().add("hbox");

		Button bPrev = new Button("< Previous");
		bPrev.setPrefSize(100, 20);

		Button bSave = new Button("Save");
		bSave.setPrefSize(100,20);
		bSave.addEventHandler
		(ActionEvent.ACTION,
				new EventHandler<ActionEvent>()
		{
			public void handle(ActionEvent ae)
			{
				//String sFile = repository.getFilePathAndName();
				//test only
				FileLogger fl = new FileLogger("testOutputFileCreation.csv");
				ArrayList<RawInputLine>alRawOutputLine = new ArrayList<RawInputLine>();
				alRawOutputLine = getAllInputs(tp);
				writeDataFile(fl, alRawOutputLine);
			}	    
		}
				);

		Button bNext = new Button("Next >");
		bNext.setPrefSize(100,20);

		hbo.setAlignment(Pos.CENTER);
		hbo.getChildren().addAll(bPrev, bSave, bNext);

		return hbo;
	}

	//remove all tabs from the tabpane    
	public void removeTabs()
	{
		ObservableList<Tab>olTabs = null;

		if (tp!=null){olTabs = tp.getTabs();}
		if (olTabs!=null){for (Tab tab: olTabs){tp.getTabs().remove(tab);}}  

	}


	//sets
	public void setButton(Button buttonEdit){this.buttonEdit = buttonEdit;}
	public void setHandlerRepository(Repository repository){this.repository = repository;}
	public void setUnitConverter(UnitConverter uc){this.uc = uc;}
	public void setTopLabel(Label lTopLabel){this.lTopLabel = lTopLabel;}

	//gets
	public TabPane getTabPane(){return this.tp;}
	public ArrayList<HBox> getAllHBox(){return this.alHbox;}

}
