package ui;

import java.util.ArrayList;

import pviScreen.PVIScreenControlData;
import pviScreen.PVIScreenData;
import pviScreen.RawInputLine;
import util.NameConstants;
import util.Stripper;
import util.UnitConverter;

import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class HandlerEditComboBox extends HandlerEditControl
{
     
    //private HandlerEdit he;
    private TabPane tp;
	private Tab tab;
	private ComboBox<?> cb;
	private String sName, sTabName;
	private Stripper s;
	private InputControlValue ic;
	private NameConstants nc;
	private ArrayList<HBox> alHBox;

	private final   String s_SINGLE = "one value";
	private final   String s_MIN = "min";
	private final   String s_MAX = "max";
	
	public void handle(Event e)
	{

	    super.handle(e);
	    
	    nc = new NameConstants();
	    alHBox = repository.getHBoxList();
		//change the input screen
	
	    
	    
        //2) gather data from the tab to which the ComboBox is attached:
		ScrollPane sp = (ScrollPane) tab.getContent();
		GridPane gp = (GridPane) sp.getContent();
		ObservableList<Node> olNode = gp.getChildren();
		ObservableList<Node> olHBoxKids, olHBoxKidsPlus;
		
		//)clear the saved list of controls
		repository.clearPriorControls();
		
		s = new Stripper();
		HBox hb;
		Label lTabName, lDataGroup, lInputType, lCount, lPreviousDistribution, lChangeToCome, lQualifier, lDescription, lDescription2, lFrequency, lUnitType;
		String sTabName, sDataGroup, sInputType, sCount, sPreviousDistribution, sChangeToCome, sQualifier, sDescription, sDescription2, sFrequency, sUnitType, sUnitSelected;
		String sTabNamePlus, sDataGroupPlus, sDescriptionPlus, sDescription2Plus, sPreviousDistributionPlus;
		
		TextField tfValue, tfComment;
		ComboBox<String> cbDistribution, cbUnit;
		
		
		String sPrev="",sNow="";
		
		int iIndex = 0;
		int iDebugCount=0;
		
		//start a list of new nodes
		ArrayList<Node> alNodeNew = new ArrayList<Node>();
		
		//cycle through all nodes on existing tab
		for (Node node: olNode)
		{
			hb = (HBox)node;
			olHBoxKids = hb.getChildren();
			iDebugCount++;
			
			//items in the HBox from InputControl.makeControl():
			// cbDistribution, lQualifier, lDescription, tfValue, cbUnit, tfComment, lFrequency, lTabName, lDataGroup, lCount, lInputType, lPreviousDistribution, lChangeToCome
			// 0,1,2,3,4,5,6,7,8,9,10,11,12
			
			sInputType = "";
			
			//check for the appropriate type of input (value or chemical)
			try
			{
			  sInputType = ((Label) olHBoxKids.get(nc.int_INPUTTYPE)).getText();
			}
			catch (Exception ee)
			{
				int ij = 0;
				ij++;
			}
			
			
			if (s.equals(nc.s_CHEMICALINPUT,sInputType) || s.equals(nc.s_VALUEINPUT,sInputType))
			{
				//only value or chemical inputs are subject to change between constant and variable distributions
				cbDistribution = (ComboBox<String>) olHBoxKids.get(nc.int_CBDISTRIBUTION);
				sQualifier =  ((Label) (olHBoxKids.get(nc.int_QUALIFIER))).getText();
				sDescription = ((Label) (olHBoxKids.get(nc.int_DESCRIPTION))).getText();
				sDescription2 = ((Label) (olHBoxKids.get(nc.int_DESCRIPTION2))).getText();
				//tfValue = (TextField) olHBoxKids.get(nc.int_VALUE);
				cbUnit = (ComboBox<String>) olHBoxKids.get(nc.int_UNIT);
				//tfComment = (TextField) olHBoxKids.get(nc.int_COMMENT);
				//hidden labels
				lFrequency = (Label) olHBoxKids.get(nc.int_FREQUENCY);
				lTabName = ((Label) olHBoxKids.get(nc.int_TABNAME));
				sTabName = lTabName.getText();
				lDataGroup = ((Label) olHBoxKids.get(nc.int_DATAGROUP));
				sDataGroup = lDataGroup.getText();
				lCount = (Label) olHBoxKids.get(nc.int_COUNT);
				lInputType = (Label) olHBoxKids.get(nc.int_INPUTTYPE);
				lPreviousDistribution = (Label) olHBoxKids.get(nc.int_PREVIOUSDISTRIBUTION);
				lChangeToCome = (Label) olHBoxKids.get(nc.int_CHANGETOCOME);
				lUnitType = (Label) olHBoxKids.get(nc.int_UNITTYPE);
				
				//does the previous distribution from hidden label (lPreviousDistribution) match
				//the selected distribution from cbDistribution?
				sNow = s.removeCharacter(' ',(String)cbDistribution.getValue());
				sPrev = s.removeCharacter(' ',lPreviousDistribution.getText());
				
				//previous distribution was constant
				if (sPrev.equalsIgnoreCase("Constant"))
				{
				  	//two choices (keep as is, expand)
					
					if (sNow.equalsIgnoreCase("Constant"))
					{	
					  //keep as is
					  ((Label) (olHBoxKids.get(nc.int_CHANGETOCOME))).setText("keep");
					  alNodeNew.add(node);	
					  repository.addPriorControl( sDataGroup, sDescription, sDescription2);
					}
					else if (sNow.equalsIgnoreCase("Uniform"))
					{
					  //modify some characteristics of the existing input contol
					  //(it is going from "constant" to the first element of "Uniform")
					  //keep existing
					  ((Label) (olHBoxKids.get(nc.int_CHANGETOCOME))).setText("keep");
					  //qualifier
					  ((Label) (olHBoxKids.get(nc.int_QUALIFIER))).setText(this.s_MIN);
					  //value
					  ((TextField) (olHBoxKids.get(nc.int_VALUE))).setText("");
					  //frequency
					  ((Label) (olHBoxKids.get(nc.int_FREQUENCY))).setText("0.0");
					  //count
					  ((Label) (olHBoxKids.get(nc.int_COUNT))).setText(""+iIndex);
					  //previous distribution (for NEXT evaulation)
					  ((Label) (olHBoxKids.get(nc.int_PREVIOUSDISTRIBUTION))).setText("Uniform");
					  alNodeNew.add(node);	
					  iIndex++;	
					  repository.addPriorControl( sDataGroup, sDescription, sDescription2);
					  
					  //add one	
					  //distribution type
					  
					  //gather inputs
					  String sDistributionType = (String)cbDistribution.getValue();
					  sTabName = lTabName.getText();
					  sDataGroup = lDataGroup.getText();
					  sInputType = lInputType.getText();
					  sUnitType = lUnitType.getText();
					  sUnitSelected = (String)cbUnit.getValue();
					  PVIScreenControlData pvisCD = repository.getPVIScreenControlData();
					  UnitConverter uc = pvisCD.getUnitConverter();
					  
					  RawInputLine ril = new RawInputLine();
					  if (s.areTheyEqual(sInputType, nc.s_VALUEINPUT))
					  {	  
					    String[] lineArray = {sDataGroup,sDescription,sDistributionType,""+0.0,sUnitSelected,""+1.0};
					    ril.setRawInputLine(nc.s_VALUEINPUT,lineArray);
					  }
					  else if (s.areTheyEqual(sInputType,nc.s_CHEMICALINPUT))  
					  {
						  String[] lineArray = {sDataGroup,sDescription2,sDistributionType,sDescription,""+0.0,sUnitSelected,""+1.0};
						  ril.setRawInputLine(nc.s_CHEMICALINPUT,lineArray);  
					  }
					
					  
					  
					  
					  //create input control
					  InputControlValue ic = new InputControlValue();
						ic.setHandlerRepository(repository);
				    	ic.setTabPane(this.tp);
				    	ic.setTab(this.tab);
				    	ic.setTabName(sTabName);
				  	    ic.setName(sName);
				  	    ic.setIndex(iIndex);
				  	    ic.setLabel(sDescription);
				  		ic.setHeight(20);
				  		ic.setRawInputLine(ril);
				  		ic.setChangeToCome("keep");
				  		ic.setUnitConverter(uc);
				  		ic.setUnitChoices(uc.getAllUnitNamesForAType(ril.getUnitType(ril.getParameterNameForUnits(),uc)));
				  		
					 
					  ic.makeInputControlForAll();
					  
					  HBox hb2 = ic.getInputControl();
					  olHBoxKids = hb2.getChildren();
					  //previous distribution (for NEXT evaulation)
					  ((Label) (olHBoxKids.get(nc.int_PREVIOUSDISTRIBUTION))).setText("Uniform");
					  
					  alNodeNew.add(ic.getInputControl());
					  repository.addPriorControl( sDataGroup, sDescription, sDescription2);
					  alHBox.add(hb2);
					  iIndex++;
					}
					else if (sNow.equalsIgnoreCase("Triangular"))
					{
					  //add two	
					}	
					else if (sNow.equalsIgnoreCase("TruncatedNormal"))
					{
						//add three
					}
				}
				
				
				//previous distribution was uniform
				if (sPrev.equalsIgnoreCase("Uniform"))
				{
				  	//two choices (keep as is, contract, expand)
					
					if (sNow.equalsIgnoreCase("Constant"))
					{	
						
						  //modify some characteristics of the existing input contol
						  //(it is going from "uniform" to the first element of "constant")
						  //keep existing
						  ((Label) (olHBoxKids.get(nc.int_CHANGETOCOME))).setText("keep");
						  //qualifier
						  ((Label) (olHBoxKids.get(nc.int_QUALIFIER))).setText(this.s_SINGLE);
						  //value
						  ((TextField) (olHBoxKids.get(nc.int_VALUE))).setText("");
						  //frequency
						  ((Label) (olHBoxKids.get(nc.int_FREQUENCY))).setText("0.0");
						  //count
						  ((Label) (olHBoxKids.get(nc.int_COUNT))).setText(""+iIndex);
						  //previous distribution (for NEXT evaulation)
						  ((Label) (olHBoxKids.get(nc.int_PREVIOUSDISTRIBUTION))).setText("Constant");
						  alNodeNew.add(node);
						  iIndex++;
						  repository.addPriorControl( sDataGroup, sDescription, sDescription2);
						
					      //contract by one
					 
						  sDescription = s.removeCharacter(' ', sDescription);
						  sDescription2 = s.removeCharacter(' ', sDescription2);
						  sTabName = s.removeCharacter(' ', sTabName);
						  sDataGroup = s.removeCharacter(' ',sDataGroup);
						  
						  HBox hb2;
						  //find the companion uniform input control and eliminate it
						  for (Node node2: olNode)
						  {
							  
							  hb2 = (HBox)node2;
							  olHBoxKidsPlus = hb2.getChildren();
							  sInputType = ((Label) (olHBoxKidsPlus.get(nc.int_INPUTTYPE))).getText();
							  
							  if (s.equals(sInputType,nc.s_VALUEINPUT) || s.equals(sInputType,nc.s_CHEMICALINPUT))
							  {	  
								  sDescriptionPlus = ((Label) (olHBoxKidsPlus.get(nc.int_DESCRIPTION))).getText(); 
								  sDescription2Plus = ((Label) (olHBoxKidsPlus.get(nc.int_DESCRIPTION2))).getText(); 
								  sTabNamePlus = ((Label) olHBoxKidsPlus.get(nc.int_TABNAME)).getText();
								  sDataGroupPlus = ((Label) olHBoxKidsPlus.get(nc.int_DATAGROUP)).getText();
								  sPreviousDistributionPlus = ((Label) olHBoxKidsPlus.get(nc.int_PREVIOUSDISTRIBUTION)).getText();
								  
								  sDescriptionPlus = s.removeCharacter(' ',sDescriptionPlus);
								  sDescription2Plus = s.removeCharacter(' ',sDescription2Plus);
								  sTabNamePlus = s.removeCharacter(' ', sTabNamePlus);
								  sDataGroupPlus = s.removeCharacter(' ', sDataGroupPlus);
								  sPreviousDistributionPlus = s.removeCharacter(' ', sPreviousDistributionPlus);
								  
								  if (sDescription.equalsIgnoreCase(sDescriptionPlus)
								   && sDescription2.equalsIgnoreCase(sDescription2Plus)
								   && sTabName.equalsIgnoreCase(sTabNamePlus)
								   && sDataGroup.equalsIgnoreCase(sDataGroupPlus)
								   && sPreviousDistributionPlus.equalsIgnoreCase("Uniform")
										  )
								  {	  
								    //this input control must be elminated
									((Label) (olHBoxKidsPlus.get(nc.int_CHANGETOCOME))).setText("discard"); 
									alNodeNew.add(node2);
									alHBox.remove(hb2);
									iIndex++;
								  }
						      }
						  }					
					 
						
					 
					  
					  
					}
					else if (sNow.equalsIgnoreCase("Uniform"))
					{
					  //keep the same
					
						
						//a discard flag could have been set by another control
						String sTest2 = ((Label) (olHBoxKids.get(nc.int_CHANGETOCOME))).getText();
						
						
						if (!sTest2.equalsIgnoreCase("discard"))
						{
					      ((Label) (olHBoxKids.get(nc.int_CHANGETOCOME))).setText("keep");
					      alNodeNew.add(node);	
						}
						
					}
					else if (sNow.equalsIgnoreCase("Triangular"))
					{
					  //add one
					}	
					else if (sNow.equalsIgnoreCase("TruncatedNormal"))
					{
						//add two
					}
				}
				
				//previous distribution was triangular
				if (sPrev.equalsIgnoreCase("Triangular"))
				{
				  	//two choices (keep as is, contract, expand)
					
					if (sNow.equalsIgnoreCase("Constant"))
					{	
					  //contract by two
					}
					else if (sNow.equalsIgnoreCase("Uniform"))
					{
					  //contract by one
					}
					else if (sNow.equalsIgnoreCase("Triangular"))
					{
					  //keep the same
					  ((Label) (olHBoxKids.get(nc.int_CHANGETOCOME))).setText("keep");
					  alNodeNew.add(node);			
					}	
					else if (sNow.equalsIgnoreCase("TruncatedNormal"))
					{
						//add one
					}
				}
				
				
				//previous distribution was triangular
				if (sPrev.equalsIgnoreCase("TruncatedNormal"))
				{
				  	//two choices (keep as is, contract, expand)
					
					if (sNow.equalsIgnoreCase("Constant"))
					{	
					  //contract by three
					}
					else if (sNow.equalsIgnoreCase("Uniform"))
					{
					  //contract by two
					}
					else if (sNow.equalsIgnoreCase("Triangular"))
					{
					  //contract by one
					}	
					else if (sNow.equalsIgnoreCase("TruncatedNormal"))
					{
					  //keep the same
					  ((Label) (olHBoxKids.get(nc.int_CHANGETOCOME))).setText("keep");
					  alNodeNew.add(node);			
					}
				}			
			
			}
			//parameter choice is made through a choice box and parameters
			//entered in the systemData file "05ParameterChoices.csv"
			else if (s.areTheyEqual(nc.s_CONTROLSTRINGCHOICE,sInputType))
			{
				alNodeNew.add(node);
			}
			else
			{
				//not a value or chemical input
				 alNodeNew.add(node);	
			}
			
		}
		
	
		 
      
		//set up new tab contents
		sp = new ScrollPane();
		gp = new GridPane();
	    ScrollPane spNew = new ScrollPane();
	    GridPane gpNew = new GridPane();
	    int iCount = 0;
	  
	    //ArrayList<Node> alN2 = new ArrayList<Node>();
	    //check through the list of new nodes
	    //add the nodes to keep
		for (Node node3: alNodeNew)
	    {
	       hb = (HBox)node3;
	       try
	       {
	         olHBoxKids = hb.getChildren();
	         sInputType ="";
	         try{sInputType = ((Label)olHBoxKids.get(nc.int_INPUTTYPE)).getText();}
	         catch (Exception ee){}
	         
	         if (s.equals(sInputType,nc.s_CHEMICALINPUT) || s.equals(sInputType,nc.s_VALUEINPUT)) 	
	         {	 
	           sChangeToCome = ((Label)olHBoxKids.get(nc.int_CHANGETOCOME)).getText(); 
	           if (sChangeToCome.equalsIgnoreCase("keep"))
	           {
	    	    //(""+iCount) forces type cast to string)
	    	    //first refresh the hidden count number
	    	    ((Label)olHBoxKids.get(nc.int_COUNT)).setText((String)(""+iCount));
	    	    //now add to the grid pane
	    	    //gpNew.add(node, 0, iCount);
	    	    //alN2.add(node3);
	    	    gp.add(node3, 0, iCount);
	    	    iCount++;
	           }
	         }  
	         else
	         {
	        	 //not a value or chemical input
	        	 //so always add these types to the gridpane
	        	 try{((Label)olHBoxKids.get(nc.int_COUNT)).setText((String)(""+iCount));}
	        	 catch(Exception ee){}
	        	 gp.add(node3, 0, iCount);
		    	 iCount++;
	         }
	         
	       }
	       catch(Exception e2){}
	    }
	 
		
		sp.setContent(gp);
		tab.setContent(sp);
	 
	}
	

	
	//sets
	public void setTabPane(TabPane tp){this.tp = tp;}
	public void setTab(Tab tab){this.tab = tab;}
	public void setComboBox(ComboBox cb){this.cb = cb;}
	public void setNames(String sTabName, String sName){this.sTabName = sTabName; this.sName = sName;}
	
	//gets 
	public String getName(){return this.sName;}
	public String getTabName(){return this.sTabName;}
	
}
