package ui;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;

public class HandlerEditNumber extends HandlerEditControl
{
	private final static String text_POSITIVE = "Pos. Number Required";
	private final static String text_NUMBER = "Number Required";
	private TextField tf;
	
	public HandlerEditNumber(){}
	
	
	public void handle(Event e)
	{
		
	  repository.setEditControlChanged(true);
		
	  //check for value:
	  // input must be a number
	  // number must be > 0.0
	  double dValue;
	  try
	  {
		  dValue = Double.parseDouble(tf.getText());
		  
		  //no parameter can be negative in this model
		  if (dValue<0.0)
		  {
			tf.setText(this.text_POSITIVE);
		  }
	  }
	  catch (Exception ex)
	  {
		if (!tf.getText().equalsIgnoreCase(this.text_POSITIVE) )  
		{	
          //set the error message if the text_POSITIVE message isn't the string	
		  if(!tf.getText().equalsIgnoreCase(""))
		  {
			//only set the error message if the textfield isn't blank ("")  
			tf.setText(this.text_NUMBER);
		  }	
		}  
	  }
	  
		  
		  
	  
	}
	
	//sets
	public void setTextField(TextField tf){this.tf = tf;}
}
