package ui;

import util.NameConstants;
import util.Stripper;

//import com.sun.javafx.scene.layout.region.Border;

import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class HandlerInput implements EventHandler 
{
	private Stage stage;
	private Repository repository;
	private Button b;
	private Label lTopLabel;
	private ComboBox cbChemical;
	private BorderPane border;
	private Scene scene;
	private ObservableList<Button> olButton;
	private Stripper s;
	private NameConstants nc;

	public HandlerInput(Stage stage)
	{
		this.stage = stage;
		s = new Stripper();	
		nc = new NameConstants();
	}

	public void handle(Event event)
	{
		try
		{
			PVIFileChooser pvifc = new PVIFileChooser(stage);
			pvifc.setChemicalComboBox(this.cbChemical);
			border = repository.getBorder();
			border.setCenter(null);

			pvifc.setRepository(repository);
			pvifc.openFile();


			repository.setInputFile(pvifc.getInputFile());
			repository.setInputFileAndPath(pvifc.getInputFileAndPath());
			repository.setInputFileFlagSet(true);
			repository.refreshRiskResults();



			//allow for editing and running the model
			olButton = repository.getButtonList();

			String sInputType = repository.getInputType();

			if (s.areTheyEqual(sInputType,nc.s_Radio_ExistingInput))
			{	  
				//button changes for an input file
				for (Button button: olButton)
				{
					String sButton = button.getText();
					//enable running buttons
					if (s.equals(nc.s_ButtonEdit,sButton))
					{
						button.setDisable(false);
						button.setStyle(nc.s_StyleEnable);
						button.fire();
						button.requestFocus();
					}
					else if (s.equals(nc.s_ButtonSchematic,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}
					else if (s.equals(nc.s_ButtonSave,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}
					//disable results buttons
					else if (s.equals(nc.s_ButtonRun,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
					else if (s.equals(nc.s_ButtonResults,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
					else if (s.equals(nc.s_ButtonReport,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				}
			}
			else if (s.areTheyEqual(sInputType,nc.s_Radio_Results))
			{
				//button changes for a results file
				for (Button button: olButton)
				{
					String sButton = button.getText();
					//enable running buttons

					if (s.equals(nc.s_ButtonResults,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}
					else if (s.equals(nc.s_ButtonReport,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}	
					//disable results buttons
					else if (s.equals(nc.s_ButtonSave,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
					else if (s.equals(nc.s_ButtonEdit,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
					else if (s.equals(nc.s_ButtonSchematic,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
					else if (s.equals(nc.s_ButtonRun,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}

				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

		lTopLabel.setText(repository.getInputType() + " file named: " + repository.getInputFile());






	}


	//sets
	public void setButton(Button b){this.b = b;}
	public void setHandlerRepository(Repository repository){this.repository = repository;}
	public void setTopLabel(Label lTopLabel){this.lTopLabel = lTopLabel;}
	public void setChemicalComboBox(ComboBox cbChemical){this.cbChemical = cbChemical;}

}
