package ui;

import java.util.ArrayList;

import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.stage.Stage;
import util.Stripper;
import util.NameConstants;

public class HandlerInputChoice implements EventHandler
{
   private Stage stage;
   private Repository repository;
   private String sInputType;
   private NameConstants nc;
   private Stripper s;
   ArrayList<RadioButton> alRadioButtons;
   ToggleGroup group;
  
   
   public HandlerInputChoice(Stage stage)
   {
	 alRadioButtons = new ArrayList<RadioButton>();  
	 nc = new NameConstants();
	 s = new Stripper();
   }
   
   public void handle(Event event)
   {
	  RadioButton rb2 =  (RadioButton)group.getSelectedToggle();

	  this.sInputType = rb2.getText();
	  repository.setInputType(this.sInputType);
	  repository.setInputTypeFlagSet(true);
	  System.out.println("toggled button:  " + sInputType);
	  
	  
	  //adjust the button options::only options here are read file, about and exit
	  ObservableList<Button> olButton = repository.getButtonList();
	  
	  
	  if (s.areTheyEqual(this.sInputType,nc.s_Radio_ExistingInput))
	  {
		  for (Button button:  olButton)
		  {
			  String sButton = button.getText();
				//enable running buttons
				
				if (s.equals(nc.s_ButtonAbout,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}
				else if (s.equals(nc.s_ButtonExit,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}
				//disable buttons
				else if (s.equals(nc.s_ButtonEdit,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonSave,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonSchematic,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonRun,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonResults,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonReport,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}  
		  } 
	  }
	  else if (s.areTheyEqual(this.sInputType,nc.s_Radio_Results))
	  {	  
		  for (Button button:  olButton)
		  {
			  String sButton = button.getText();
				//enable running buttons
				if (s.equals(nc.s_ButtonAbout,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}
				else if (s.equals(nc.s_ButtonExit,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}
				
				//}
				//disable buttons
				else if (s.equals(nc.s_ButtonResults,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonResults,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonReport,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);} 
				else if (s.equals(nc.s_ButtonSchematic,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonEdit,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonSave,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonRun,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonResults,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonReport,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}  
		  }
	  }
	  
	//enable running buttons
	  
	  
	 
   }
	
   //sets
  
   public void setInputGroup(ToggleGroup group){this.group = group;}
   public void addRadioButton(RadioButton rb){this.alRadioButtons.add(rb);}
   public void setHandlerRepository(Repository repository){this.repository = repository;}
	
}
